/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBuffer;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.Uint8ClampedArray;
import java.awt.Color;
import java.awt.image.BufferedImage;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.EDGE)})
public class ImageData
extends SimpleScriptable {
    private final BufferedImage image_;
    private final int sx_;
    private final int sy_;
    private final int width_;
    private final int height_;
    private Uint8ClampedArray data_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public ImageData() {
        this(null, 0, 0, 0, 0);
    }

    ImageData(BufferedImage image, int x, int y, int width, int height) {
        this.image_ = image;
        this.sx_ = x;
        this.sy_ = y;
        this.width_ = width;
        this.height_ = height;
    }

    private byte[] getBytes() {
        byte[] array = new byte[this.width_ * this.height_ * 4];
        int index = 0;
        for (int x = 0; x < this.width_; ++x) {
            for (int y = 0; y < this.height_; ++y) {
                Color c = new Color(this.image_.getRGB(this.sx_ + x, this.sy_ + y), true);
                array[index++] = (byte)c.getRed();
                array[index++] = (byte)c.getGreen();
                array[index++] = (byte)c.getBlue();
                array[index++] = (byte)c.getAlpha();
            }
        }
        return array;
    }

    @JsxGetter
    public int getWidth() {
        return this.width_;
    }

    @JsxGetter
    public int getHeight() {
        return this.height_;
    }

    @JsxGetter
    public Uint8ClampedArray getData() {
        if (this.data_ == null) {
            byte[] bytes = this.getBytes();
            ArrayBuffer arrayBuffer = new ArrayBuffer();
            arrayBuffer.constructor(bytes.length);
            arrayBuffer.setBytes(0, bytes);
            this.data_ = new Uint8ClampedArray();
            this.data_.setParentScope(this.getParentScope());
            this.data_.setPrototype(this.getPrototype(this.data_.getClass()));
            this.data_.constructor((Object)arrayBuffer, (Object)0, (Object)bytes.length);
        }
        return this.data_;
    }
}

