/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass(isJSObject=false, isDefinedInStandardsMode=false)
public class AbstractList
extends SimpleScriptable
implements Function {
    private boolean avoidObjectDetection_ = false;
    private String description_;
    private boolean attributeChangeSensitive_ = true;
    private List<Object> cachedElements_;
    private boolean listenerRegistered_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public AbstractList() {
    }

    private AbstractList(ScriptableObject parentScope) {
        if (parentScope != null) {
            this.setParentScope((Scriptable)parentScope);
            this.setPrototype(this.getPrototype(this.getClass()));
        }
    }

    public AbstractList(DomNode parentScope, boolean attributeChangeSensitive, String description) {
        this(parentScope == null ? null : parentScope.getScriptableObject());
        if (parentScope != null) {
            this.setDomNode(parentScope, false);
        }
        this.description_ = description;
        this.attributeChangeSensitive_ = attributeChangeSensitive;
    }

    protected AbstractList(DomNode parentScope, List<?> initialElements) {
        this(parentScope.getScriptableObject());
        this.cachedElements_ = new ArrayList(initialElements);
    }

    public static AbstractList emptyCollection(Window window) {
        final List list = Collections.emptyList();
        return new AbstractList((ScriptableObject)window){

            @Override
            public List<Object> getElements() {
                return list;
            }
        };
    }

    public boolean avoidObjectDetection() {
        return this.avoidObjectDetection_;
    }

    public void setAvoidObjectDetection(boolean newValue) {
        this.avoidObjectDetection_ = newValue;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        Object object = this.getIt(args[0]);
        if (object == NOT_FOUND) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NULL_IF_NOT_FOUND)) {
                return null;
            }
            return Context.getUndefinedValue();
        }
        return object;
    }

    public final Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return null;
    }

    private Object getIt(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    public final Object get(int index, Scriptable start) {
        AbstractList array = (AbstractList)start;
        List<Object> elements = array.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableForElement(elements.get(index));
        }
        return NOT_FOUND;
    }

    @Override
    protected void setDomNode(DomNode domNode, boolean assignScriptObject) {
        DomNode oldDomNode = this.getDomNodeOrNull();
        super.setDomNode(domNode, assignScriptObject);
        if (oldDomNode != domNode) {
            this.listenerRegistered_ = false;
        }
    }

    public List<Object> getElements() {
        List<Object> cachedElements = this.cachedElements_;
        if (cachedElements == null) {
            cachedElements = this.getParentScope() == null ? new ArrayList<Object>() : this.computeElements();
            this.cachedElements_ = cachedElements;
            if (!this.listenerRegistered_) {
                DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl(this);
                DomNode domNode = this.getDomNodeOrNull();
                if (domNode != null) {
                    domNode.addDomChangeListener(listener);
                    if (this.attributeChangeSensitive_) {
                        if (domNode instanceof HtmlElement) {
                            ((HtmlElement)domNode).addHtmlAttributeChangeListener(listener);
                        } else if (domNode instanceof HtmlPage) {
                            ((HtmlPage)domNode).addHtmlAttributeChangeListener(listener);
                        }
                    }
                    this.listenerRegistered_ = true;
                }
            }
        }
        return cachedElements;
    }

    protected List<Object> computeElements() {
        ArrayList<Object> response = new ArrayList<Object>();
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode == null) {
            return response;
        }
        for (DomNode node : this.getCandidates()) {
            boolean commentIncluded;
            boolean bl = commentIncluded = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_COMMENT_IS_ELEMENT) && node instanceof DomComment;
            if (!(node instanceof DomElement) && !commentIncluded || !this.isMatching(node)) continue;
            response.add(node);
        }
        return response;
    }

    protected Iterable<DomNode> getCandidates() {
        DomNode domNode = this.getDomNodeOrNull();
        return domNode.getDescendants();
    }

    protected boolean isMatching(DomNode node) {
        return false;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List<Object> elements = this.getElements();
        ArrayList<Object> matchingElements = new ArrayList<Object>();
        for (Object next : elements) {
            String id;
            if (!(next instanceof DomElement) || !name.equals(id = ((DomElement)next).getAttribute("id"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        if (!matchingElements.isEmpty()) {
            AbstractList collection = new AbstractList(this.getDomNodeOrDie(), matchingElements);
            collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
            return collection;
        }
        for (Object next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !name.equals(nodeName = ((DomElement)next).getAttribute("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        AbstractList collection = new AbstractList(domNode, matchingElements);
        collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
        return collection;
    }

    @JsxGetter
    public final int getLength() {
        return this.getElements().size();
    }

    @JsxFunction
    public Object item(Object index) {
        Object object = this.getIt(index);
        if (object == NOT_FOUND) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NULL_IF_ITEM_NOT_FOUND)) {
                return null;
            }
            return Context.getUndefinedValue();
        }
        return object;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof AbstractList) {
            AbstractList otherArray = (AbstractList)other;
            DomNode domNode = this.getDomNodeOrNull();
            DomNode domNodeOther = otherArray.getDomNodeOrNull();
            if (this.getClass() == other.getClass() && domNode == domNodeOther && this.getElements().equals(otherArray.getElements())) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && index < this.getElements().size();
    }

    public boolean has(String name, Scriptable start) {
        if (this.isPrototype()) {
            return super.has(name, start);
        }
        try {
            return this.has(Integer.parseInt(name), start);
        }
        catch (NumberFormatException numberFormatException) {
            if ("length".equals(name)) {
                return true;
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_NODE_LIST_ENUMERATE_FUNCTIONS)) {
                JavaScriptConfiguration jsConfig = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine().getJavaScriptConfiguration();
                return jsConfig.getClassConfiguration(this.getClassName()).getFunctionKeys().contains(name);
            }
            return this.getWithPreemption(name) != NOT_FOUND;
        }
    }

    public Object[] getIds() {
        if (this.isPrototype()) {
            return super.getIds();
        }
        ArrayList<String> idList = new ArrayList<String>();
        List<Object> elements = this.getElements();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_NODE_LIST_ENUMERATE_FUNCTIONS)) {
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                idList.add(Integer.toString(i));
            }
            idList.add("length");
            JavaScriptConfiguration jsConfig = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine().getJavaScriptConfiguration();
            for (String name : jsConfig.getClassConfiguration(this.getClassName()).getFunctionKeys()) {
                idList.add(name);
            }
        } else {
            idList.add("length");
            this.addElementIds(idList, elements);
        }
        return idList.toArray();
    }

    private boolean isPrototype() {
        return !(this.getPrototype() instanceof AbstractList);
    }

    protected void addElementIds(List<String> idList, List<Object> elements) {
        int index = 0;
        for (Object next : elements) {
            HtmlElement element = (HtmlElement)next;
            String name = element.getAttribute("name");
            if (name != DomElement.ATTRIBUTE_NOT_DEFINED) {
                idList.add(name);
            } else {
                String id = element.getId();
                if (id != DomElement.ATTRIBUTE_NOT_DEFINED) {
                    idList.add(id);
                } else {
                    idList.add(Integer.toString(index));
                }
            }
            ++index;
        }
    }

    protected EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
        return EffectOnCache.RESET;
    }

    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return this.getScriptableFor(object);
    }

    private static final class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private transient WeakReference<AbstractList> nodeList_;

        private DomHtmlAttributeChangeListenerImpl(AbstractList nodeList) {
            this.nodeList_ = new WeakReference<AbstractList>(nodeList);
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            AbstractList nodes = (AbstractList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            if (nodes.attributeChangeSensitive_) {
                this.handleChangeOnCache(event);
            }
        }

        private void handleChangeOnCache(HtmlAttributeChangeEvent event) {
            AbstractList nodes = (AbstractList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            EffectOnCache effectOnCache = nodes.getEffectOnCache(event);
            if (EffectOnCache.NONE == effectOnCache) {
                return;
            }
            if (EffectOnCache.RESET == effectOnCache) {
                this.clearCache();
            }
        }

        private void clearCache() {
            AbstractList nodes = (AbstractList)this.nodeList_.get();
            if (null != nodes) {
                nodes.cachedElements_ = null;
            }
        }
    }

    protected static enum EffectOnCache {
        NONE,
        RESET;

    }
}

