/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSubCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f), @WebBrowser(value=BrowserName.EDGE)}), @JsxClass(isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class HTMLCollection
extends AbstractList {
    private int currentIndex_ = 0;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLCollection() {
    }

    private HTMLCollection(ScriptableObject parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public HTMLCollection(DomNode parentScope, boolean attributeChangeSensitive, String description) {
        super(parentScope, attributeChangeSensitive, description);
    }

    HTMLCollection(DomNode parentScope, List<?> initialElements) {
        super(parentScope, initialElements);
    }

    public static HTMLCollection emptyCollection(Window window) {
        final List list = Collections.emptyList();
        return new HTMLCollection((ScriptableObject)window){

            @Override
            public List<Object> getElements() {
                return list;
            }
        };
    }

    @Override
    protected List<Object> computeElements() {
        ArrayList<Object> response = new ArrayList<Object>();
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode == null) {
            return response;
        }
        boolean commentIsElement = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_COMMENT_IS_ELEMENT);
        for (DomNode node : this.getCandidates()) {
            if (!(node instanceof DomElement) && (!commentIsElement || !(node instanceof DomComment)) || !this.isMatching(node)) continue;
            response.add(node);
        }
        return response;
    }

    @Override
    protected boolean isMatching(DomNode node) {
        return false;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List<Object> elements = this.getElements();
        ArrayList<Object> matchingElements = new ArrayList<Object>();
        for (Object next : elements) {
            String id;
            if (!(next instanceof DomElement) || !name.equals(id = ((DomElement)next).getAttribute("id"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        if (!matchingElements.isEmpty()) {
            HTMLCollection collection = new HTMLCollection(this.getDomNodeOrDie(), matchingElements);
            collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
            return collection;
        }
        boolean searchName = this.isGetWithPreemptionSearchName();
        for (Object next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !searchName && !(next instanceof HtmlInput) && !(next instanceof HtmlForm) || !name.equals(nodeName = ((DomElement)next).getAttribute("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            Object object;
            Double doubleValue;
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_SUPPORTS_DOUBLE_INDEX_ALSO) && ScriptRuntime.NaN != (doubleValue = Double.valueOf(Context.toNumber((Object)name))) && !doubleValue.isNaN() && (object = this.get(doubleValue.intValue(), (Scriptable)this)) != NOT_FOUND) {
                return object;
            }
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection(domNode, matchingElements);
        collection.setAvoidObjectDetection(!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_OBJECT_DETECTION));
        return collection;
    }

    protected boolean isGetWithPreemptionSearchName() {
        return true;
    }

    @Override
    @JsxFunction
    public Object item(Object index) {
        if (index instanceof String && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_SUPPORTS_ID_SEARCH_ALSO)) {
            String name = (String)index;
            Object result = this.namedItem(name);
            return result;
        }
        int idx = 0;
        Double doubleValue = Context.toNumber((Object)index);
        if (ScriptRuntime.NaN != doubleValue && !doubleValue.isNaN()) {
            idx = doubleValue.intValue();
        }
        if (idx < 0 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_EXCEPTION_FOR_NEGATIVE_INDEX)) {
            throw Context.reportRuntimeError((String)"Invalid index.");
        }
        Object object = this.get(idx, (Scriptable)this);
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    @JsxFunction
    public Object namedItem(String name) {
        List<Object> elements = this.getElements();
        for (Object next : elements) {
            if (!(next instanceof DomElement)) continue;
            DomElement elem = (DomElement)next;
            String nodeName = elem.getAttribute("name");
            if (name.equals(nodeName)) {
                return this.getScriptableForElement(elem);
            }
            String id = elem.getAttribute("id");
            if (!name.equals(id)) continue;
            return this.getScriptableForElement(elem);
        }
        return null;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object nextNode() {
        List<Object> elements = this.getElements();
        Object nextNode = this.currentIndex_ >= 0 && this.currentIndex_ < elements.size() ? elements.get(this.currentIndex_) : null;
        ++this.currentIndex_;
        return nextNode;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void reset() {
        this.currentIndex_ = 0;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object tags(final String tagName) {
        HTMLSubCollection collection = new HTMLSubCollection(this, ".tags('" + tagName + "')"){

            @Override
            protected boolean isMatching(DomNode node) {
                return tagName.equalsIgnoreCase(node.getLocalName());
            }
        };
        return collection;
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof HTMLCollection) {
            HTMLCollection otherArray = (HTMLCollection)other;
            DomNode domNode = this.getDomNodeOrNull();
            DomNode domNodeOther = otherArray.getDomNodeOrNull();
            if (this.getClass() == other.getClass() && domNode == domNodeOther && this.getElements().equals(otherArray.getElements())) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    @Override
    public Object[] getIds() {
        if (this.isPrototype()) {
            return super.getIds();
        }
        ArrayList<String> idList = new ArrayList<String>();
        List<Object> elements = this.getElements();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_NODE_LIST_ENUMERATE_FUNCTIONS)) {
            int length = elements.size();
            for (int i = 0; i < length; ++i) {
                idList.add(Integer.toString(i));
            }
            idList.add("length");
            JavaScriptConfiguration jsConfig = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine().getJavaScriptConfiguration();
            for (String name : jsConfig.getClassConfiguration(this.getClassName()).getFunctionKeys()) {
                idList.add(name);
            }
        } else {
            idList.add("length");
            this.addElementIds(idList, elements);
        }
        return idList.toArray();
    }

    private boolean isPrototype() {
        return !(this.getPrototype() instanceof HTMLCollection);
    }

    @Override
    protected void addElementIds(List<String> idList, List<Object> elements) {
        int index = 0;
        for (Object next : elements) {
            HtmlElement element = (HtmlElement)next;
            String name = element.getAttribute("name");
            if (name != DomElement.ATTRIBUTE_NOT_DEFINED) {
                idList.add(name);
            } else {
                String id = element.getId();
                if (id != DomElement.ATTRIBUTE_NOT_DEFINED) {
                    idList.add(id);
                } else {
                    idList.add(Integer.toString(index));
                }
            }
            ++index;
        }
    }

    @Override
    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return this.getScriptableFor(object);
    }
}

