/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DoTypeProcessor;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextSelectionDelegate;
import com.gargoylesoftware.htmlunit.html.impl.SelectionDelegate;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class HtmlTextArea
extends HtmlElement
implements DisabledElement,
SubmittableElement,
SelectableTextInput,
FormFieldWithNameHistory {
    public static final String TAG_NAME = "textarea";
    private String defaultValue_;
    private String valueAtFocus_;
    private String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();
    private final SelectableTextSelectionDelegate selectionDelegate_ = new SelectableTextSelectionDelegate(this);
    private final DoTypeProcessor doTypeProcessor_ = new DoTypeProcessor(this);

    HtmlTextArea(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.originalName_ = this.getNameAttribute();
    }

    private void initDefaultValue() {
        if (this.defaultValue_ == null) {
            this.defaultValue_ = this.readValue();
        }
    }

    @Override
    public final String getText() {
        if (this.hasFeature(BrowserVersionFeatures.HTMLTEXTAREA_USE_ALL_TEXT_CHILDREN)) {
            return this.readValueIE();
        }
        return this.readValue();
    }

    private String readValue() {
        StringBuilder buffer = new StringBuilder();
        for (DomNode node : this.getChildren()) {
            if (!(node instanceof DomText)) continue;
            buffer.append(((DomText)node).getData());
        }
        if (buffer.length() != 0 && buffer.charAt(0) == '\n') {
            buffer.deleteCharAt(0);
        }
        return buffer.toString();
    }

    private String readValueIE() {
        StringBuilder buffer = new StringBuilder();
        for (DomNode node : this.getDescendants()) {
            if (!(node instanceof DomText)) continue;
            buffer.append(((DomText)node).getData());
        }
        if (buffer.length() != 0 && buffer.charAt(0) == '\n') {
            buffer.deleteCharAt(0);
        }
        return buffer.toString();
    }

    @Override
    public final void setText(String newValue) {
        this.setTextInternal(newValue);
        HtmlInput.executeOnChangeHandlerIfAppropriate(this);
    }

    private void setTextInternal(String newValue) {
        DomText newChild;
        this.initDefaultValue();
        DomNode child = this.getFirstChild();
        if (child == null) {
            newChild = new DomText((SgmlPage)this.getPage(), newValue);
            this.appendChild(newChild);
        } else if (this.hasFeature(BrowserVersionFeatures.HTMLTEXTAREA_USE_ALL_TEXT_CHILDREN)) {
            this.removeAllChildren();
            newChild = new DomText((SgmlPage)this.getPage(), newValue);
            this.appendChild(newChild);
        } else {
            DomNode next = child.getNextSibling();
            while (next != null && !(next instanceof DomText)) {
                child = next;
                next = child.getNextSibling();
            }
            if (next == null) {
                this.removeChild(child);
                DomText newChild2 = new DomText((SgmlPage)this.getPage(), newValue);
                this.appendChild(newChild2);
            } else {
                ((DomText)next).setData(newValue);
            }
        }
        int pos = 0;
        if (!this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_MOVE_SELECTION_TO_START)) {
            pos = newValue.length();
        }
        this.setSelectionStart(pos);
        this.setSelectionEnd(pos);
    }

    @Override
    public NameValuePair[] getSubmitKeyValuePairs() {
        String text = this.getText();
        text = text.replace("\r\n", "\n").replace("\n", "\r\n");
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), text)};
    }

    @Override
    public void reset() {
        this.initDefaultValue();
        this.setText(this.defaultValue_);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.initDefaultValue();
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (this.hasFeature(BrowserVersionFeatures.HTMLTEXTAREA_SET_DEFAULT_VALUE_UPDATES_VALUE) && this.getText().equals(this.getDefaultValue())) {
            this.setTextInternal(defaultValue);
        }
        this.defaultValue_ = defaultValue;
    }

    @Override
    public String getDefaultValue() {
        this.initDefaultValue();
        return this.defaultValue_;
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getRowsAttribute() {
        return this.getAttribute("rows");
    }

    public final String getColumnsAttribute() {
        return this.getAttribute("cols");
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttribute("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttribute("readonly");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttribute("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttribute("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttribute("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttribute("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttribute("onchange");
    }

    @Override
    public void select() {
        this.selectionDelegate_.select();
    }

    @Override
    public String getSelectedText() {
        return this.selectionDelegate_.getSelectedText();
    }

    @Override
    public int getSelectionStart() {
        return this.selectionDelegate_.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        this.selectionDelegate_.setSelectionStart(selectionStart);
    }

    @Override
    public int getSelectionEnd() {
        return this.selectionDelegate_.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        this.selectionDelegate_.setSelectionEnd(selectionEnd);
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        printWriter.print(">");
        printWriter.print(StringEscapeUtils.escapeXml10((String)this.getText()));
        printWriter.print("</textarea>");
    }

    @Override
    protected void doType(char c, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        this.doTypeProcessor_.doType(this.getText(), (SelectionDelegate)this.selectionDelegate_, c, shiftKey, ctrlKey, altKey);
    }

    @Override
    protected void doType(int keyCode, boolean shiftKey, boolean ctrlKey, boolean altKey) {
        this.doTypeProcessor_.doType(this.getText(), (SelectionDelegate)this.selectionDelegate_, keyCode, shiftKey, ctrlKey, altKey);
    }

    @Override
    protected void typeDone(String newValue) {
        this.setTextInternal(newValue);
    }

    @Override
    protected boolean acceptChar(char c) {
        return super.acceptChar(c) || c == '\n' || c == '\r';
    }

    @Override
    public void focus() {
        super.focus();
        this.valueAtFocus_ = this.getText();
    }

    @Override
    public void removeFocus() {
        super.removeFocus();
        if (!this.valueAtFocus_.equals(this.getText())) {
            HtmlInput.executeOnChangeHandlerIfAppropriate(this);
        }
        this.valueAtFocus_ = null;
    }

    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.setAttribute("readOnly", "readOnly");
        } else {
            this.removeAttribute("readOnly");
        }
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    protected Object clone() throws CloneNotSupportedException {
        return new HtmlTextArea(this.getQualifiedName(), (SgmlPage)this.getPage(), this.getAttributesMap());
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        if ("name".equals(qualifiedName)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        if (this.hasFeature(BrowserVersionFeatures.CSS_DISPLAY_BLOCK)) {
            return HtmlElement.DisplayStyle.INLINE;
        }
        return HtmlElement.DisplayStyle.INLINE_BLOCK;
    }

    public String getPlaceholder() {
        return this.getAttribute("placeholder");
    }

    public void setPlaceholder(String placeholder) {
        this.setAttribute("placeholder", placeholder);
    }
}

