/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DocumentType;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHeadElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLHtmlElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLTitleElement;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class DOMImplementation
extends SimpleScriptable {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public DOMImplementation() {
    }

    @JsxFunction
    public boolean hasFeature(String feature, String version) {
        if ("Core".equals(feature)) {
            if ("1.0".equals(version)) {
                return true;
            }
            if ("2.0".equals(version)) {
                return true;
            }
            if ("3.0".equals(version)) {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CORE_3);
            }
        } else if ("HTML".equals(feature)) {
            if ("1.0".equals(version) || "2.0".equals(version)) {
                return true;
            }
            if ("3.0".equals(version)) {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_HTML_3);
            }
        } else if ("XHTML".equals(feature)) {
            if ("1.0".equals(version) || "2.0".equals(version)) {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_XHTML_1);
            }
            if ("3.0".equals(version)) {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_XHTML_3);
            }
        } else if ("XML".equals(feature)) {
            if ("1.0".equals(version) || "2.0".equals(version)) {
                return true;
            }
            if ("3.0".equals(version)) {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_XML_3);
            }
        } else if ("Views".equals(feature)) {
            if ("1.0".equals(version)) {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_VIEWS_1);
            }
            if ("2.0".equals(version)) {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_VIEWS_2);
            }
            if ("3.0".equals(version)) {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_VIEWS_3);
            }
        } else {
            if ("StyleSheets".equals(feature)) {
                return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_STYLESHEETS);
            }
            if ("CSS".equals(feature)) {
                if ("1.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS_1);
                }
                if ("2.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS_2);
                }
                if ("3.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS_3);
                }
            } else if ("CSS2".equals(feature)) {
                if ("1.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS2_1);
                }
                if ("2.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS2_2);
                }
                if ("3.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS2_3);
                }
            } else if ("CSS3".equals(feature)) {
                if ("1.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS3_1);
                }
                if ("2.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS3_2);
                }
                if ("3.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_CSS3_3);
                }
            } else if ("Events".equals(feature)) {
                if ("1.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_EVENTS_1);
                }
                if ("2.0".equals(version) || "3.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_EVENTS_3);
                }
            } else if ("HTMLEvents".equals(feature)) {
                if ("1.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_EVENTS_1);
                }
                if ("2.0".equals(version) || "3.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_EVENTS_3);
                }
            } else if ("UIEvents".equals(feature)) {
                if ("1.0".equals(version) || "2.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_UIEVENTS_2);
                }
                if ("3.0".equals(version)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_UIEVENTS_3);
                }
            } else {
                if ("KeyboardEvents".equals(feature)) {
                    return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_KEYBOARDEVENTS);
                }
                if ("MouseEvents".equals(feature)) {
                    if ("1.0".equals(version)) {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_MOUSEEVENTS_1);
                    }
                    if ("2.0".equals(version) || "3.0".equals(version)) {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_MOUSEEVENTS_2);
                    }
                } else if ("MutationEvents".equals(feature)) {
                    if ("1.0".equals(version)) {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_MUTATIONEVENTS_1);
                    }
                    if ("2.0".equals(version) || "3.0".equals(version)) {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_MUTATIONEVENTS_2);
                    }
                } else {
                    if ("MutationNameEvents".equals(feature)) {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_MUTATIONNAMEEVENTS);
                    }
                    if ("TextEvents".equals(feature)) {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_TEXTEVENTS);
                    }
                    if ("LS".equals(feature) || "LS-Async".equals(feature)) {
                        return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_LS);
                    }
                    if ("Range".equals(feature)) {
                        if ("1.0".equals(version)) {
                            return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_RANGE_1);
                        }
                        if ("2.0".equals(version)) {
                            return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_RANGE_2);
                        }
                        if ("3.0".equals(version)) {
                            return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_RANGE_3);
                        }
                    } else if ("Traversal".equals(feature)) {
                        if ("1.0".equals(version)) {
                            return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_TRAVERSAL_1);
                        }
                        if ("2.0".equals(version)) {
                            return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_TRAVERSAL_2);
                        }
                        if ("3.0".equals(version)) {
                            return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_TRAVERSAL_3);
                        }
                    } else {
                        if ("Validation".equals(feature)) {
                            return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_VALIDATION);
                        }
                        if ("XPath".equals(feature)) {
                            return this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_XPATH);
                        }
                        if ("http://www.w3.org/TR/SVG11/feature#BasicStructure".equals(feature)) {
                            if ("1.0".equals(version) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_SVG_BASICSTRUCTURE_1_0)) {
                                return true;
                            }
                            if ("1.1".equals(version)) {
                                return true;
                            }
                            if ("1.2".equals(version) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_SVG_BASICSTRUCTURE_1_2)) {
                                return true;
                            }
                        } else if ("http://www.w3.org/TR/SVG11/feature#Shape".equals(feature)) {
                            if ("1.0".equals(version) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_SVG_SHAPE_1_0)) {
                                return true;
                            }
                            if ("1.1".equals(version)) {
                                return true;
                            }
                            if ("1.2".equals(version) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_FEATURE_SVG_SHAPE_1_2)) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    @JsxFunction
    public XMLDocument createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) {
        XMLDocument document = new XMLDocument(this.getWindow().getWebWindow());
        document.setParentScope(this.getParentScope());
        document.setPrototype(this.getPrototype(document.getClass()));
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            XmlPage page = (XmlPage)document.getDomNodeOrDie();
            page.appendChild(page.createElementNS("".equals(namespaceURI) ? null : namespaceURI, qualifiedName));
        }
        return document;
    }

    @JsxFunction
    public HTMLDocument createHTMLDocument(Object titleObj) throws IOException {
        if (titleObj == Undefined.instance && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMIMPLEMENTATION_CREATE_HTMLDOCOMENT_REQUIRES_TITLE)) {
            throw Context.reportRuntimeError((String)"Title is required");
        }
        HTMLDocument document = new HTMLDocument();
        document.setParentScope(this.getParentScope());
        document.setPrototype(this.getPrototype(document.getClass()));
        StringWebResponse resp = new StringWebResponse("", WebClient.URL_ABOUT_BLANK);
        HtmlPage page = new HtmlPage(resp, this.getWindow().getWebWindow());
        page.setEnclosingWindow(null);
        document.setDomNode(page);
        HTMLHtmlElement html = (HTMLHtmlElement)document.createElement("html");
        page.appendChild(html.getDomNodeOrDie());
        HTMLHeadElement head = (HTMLHeadElement)document.createElement("head");
        html.appendChild(head);
        if (titleObj != Undefined.instance) {
            HTMLTitleElement title = (HTMLTitleElement)document.createElement("title");
            head.appendChild(title);
            title.setTextContent(Context.toString((Object)titleObj));
        }
        HTMLBodyElement body = (HTMLBodyElement)document.createElement("body");
        html.appendChild(body);
        return document;
    }
}

