/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.InteractivePage;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.AbstractDomNodeList;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNamespaceNode;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.NamedAttrNodeMapImpl;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.PointerEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.ElementTraversal;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.TypeInfo;

public class DomElement
extends DomNamespaceNode
implements Element,
ElementTraversal {
    private static final Log LOG = LogFactory.getLog(DomElement.class);
    public static final String ATTRIBUTE_NOT_DEFINED = new String("");
    public static final String ATTRIBUTE_VALUE_EMPTY = new String();
    private NamedAttrNodeMapImpl attributes_ = new NamedAttrNodeMapImpl(this, this.isAttributeCaseSensitive());
    private Map<String, String> namespaces_ = new HashMap<String, String>();
    private boolean mouseOver_;

    public DomElement(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page);
        if (attributes != null && !attributes.isEmpty()) {
            this.attributes_ = new NamedAttrNodeMapImpl(this, this.isAttributeCaseSensitive(), attributes);
            for (DomAttr entry : this.attributes_.values()) {
                entry.setParentNode(this);
                String attrNamespaceURI = entry.getNamespaceURI();
                if (attrNamespaceURI == null) continue;
                this.namespaces_.put(attrNamespaceURI, entry.getPrefix());
            }
        }
    }

    @Override
    public String getNodeName() {
        return this.getQualifiedName();
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    protected Map<String, String> namespaces() {
        return this.namespaces_;
    }

    @Override
    public final String getTagName() {
        return this.getNodeName();
    }

    @Override
    public final boolean hasAttributes() {
        return !this.attributes_.isEmpty();
    }

    @Override
    public boolean hasAttribute(String attributeName) {
        return this.attributes_.containsKey(attributeName);
    }

    protected void printOpeningTagContentAsXml(PrintWriter printWriter) {
        printWriter.print(this.getTagName());
        for (Map.Entry<String, DomAttr> entry : this.attributes_.entrySet()) {
            printWriter.print(" ");
            printWriter.print(entry.getKey());
            printWriter.print("=\"");
            printWriter.print(StringUtils.escapeXmlAttributeValue(entry.getValue().getNodeValue()));
            printWriter.print("\"");
        }
    }

    @Override
    protected void printXml(String indent, PrintWriter printWriter) {
        boolean hasChildren = this.getFirstChild() != null;
        printWriter.print(indent + "<");
        this.printOpeningTagContentAsXml(printWriter);
        if (hasChildren || this.isEmptyXmlTagExpanded()) {
            printWriter.print(">");
            printWriter.print("\r\n");
            this.printChildrenAsXml(indent, printWriter);
            printWriter.print(indent + "</" + this.getTagName() + ">");
            printWriter.print("\r\n");
        } else {
            printWriter.print("/>");
            printWriter.print("\r\n");
        }
    }

    protected boolean isEmptyXmlTagExpanded() {
        return false;
    }

    String getQualifiedName(String namespaceURI, String localName) {
        String prefix;
        Object qualifiedName = namespaceURI == null ? localName : ((prefix = this.namespaces().get(namespaceURI)) == null ? null : prefix + ':' + localName);
        return qualifiedName;
    }

    @Override
    public String getAttribute(String attributeName) {
        DomAttr attr = this.attributes_.get(attributeName);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public void removeAttribute(String attributeName) {
        this.attributes_.remove(attributeName);
    }

    @Override
    public final void removeAttributeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            this.removeAttribute(qualifiedName);
        }
    }

    @Override
    public final Attr removeAttributeNode(Attr attribute) {
        throw new UnsupportedOperationException("DomElement.removeAttributeNode is not yet implemented.");
    }

    @Override
    public final boolean hasAttributeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            return this.attributes_.get(qualifiedName) != null;
        }
        return false;
    }

    public final Map<String, DomAttr> getAttributesMap() {
        return this.attributes_;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.attributes_;
    }

    @Override
    public final void setAttribute(String attributeName, String attributeValue) {
        this.setAttributeNS(null, attributeName, attributeValue);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        String value = attributeValue;
        DomAttr newAttr = new DomAttr(this.getPage(), namespaceURI, qualifiedName, value, true);
        newAttr.setParentNode(this);
        this.attributes_.put(qualifiedName, newAttr);
        if (namespaceURI != null) {
            this.namespaces().put(namespaceURI, newAttr.getPrefix());
        }
    }

    protected boolean isAttributeCaseSensitive() {
        return true;
    }

    @Override
    public final String getAttributeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            return this.getAttribute(qualifiedName);
        }
        return ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public DomAttr getAttributeNode(String name) {
        return this.attributes_.get(name);
    }

    @Override
    public DomAttr getAttributeNodeNS(String namespaceURI, String localName) {
        String qualifiedName = this.getQualifiedName(namespaceURI, localName);
        if (qualifiedName != null) {
            return this.attributes_.get(qualifiedName);
        }
        return null;
    }

    @Override
    public DomNodeList<HtmlElement> getElementsByTagName(String tagName) {
        return this.getElementsByTagNameImpl(tagName);
    }

    <E extends HtmlElement> DomNodeList<E> getElementsByTagNameImpl(final String tagName) {
        return new AbstractDomNodeList<E>(this){

            @Override
            protected List<E> provideElements() {
                LinkedList<HtmlElement> res = new LinkedList<HtmlElement>();
                for (HtmlElement elem : this.getDomNode().getHtmlElementDescendants()) {
                    if (!elem.getLocalName().equalsIgnoreCase(tagName)) continue;
                    res.add(elem);
                }
                return res;
            }
        };
    }

    @Override
    public DomNodeList<HtmlElement> getElementsByTagNameNS(String namespace, String localName) {
        throw new UnsupportedOperationException("DomElement.getElementsByTagNameNS is not yet implemented.");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("DomElement.getSchemaTypeInfo is not yet implemented.");
    }

    @Override
    public void setIdAttribute(String name, boolean isId) {
        throw new UnsupportedOperationException("DomElement.setIdAttribute is not yet implemented.");
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
        throw new UnsupportedOperationException("DomElement.setIdAttributeNS is not yet implemented.");
    }

    @Override
    public Attr setAttributeNode(Attr attribute) {
        this.attributes_.setNamedItem(attribute);
        return null;
    }

    @Override
    public Attr setAttributeNodeNS(Attr attribute) {
        throw new UnsupportedOperationException("DomElement.setAttributeNodeNS is not yet implemented.");
    }

    @Override
    public final void setIdAttributeNode(Attr idAttr, boolean isId) {
        throw new UnsupportedOperationException("DomElement.setIdAttributeNode is not yet implemented.");
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        DomElement clone = (DomElement)super.cloneNode(deep);
        clone.attributes_ = new NamedAttrNodeMapImpl(clone, this.isAttributeCaseSensitive());
        clone.attributes_.putAll(this.attributes_);
        return clone;
    }

    public final String getId() {
        return this.getAttribute("id");
    }

    @Override
    public DomElement getFirstElementChild() {
        Iterator<DomElement> i = this.getChildElements().iterator();
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    @Override
    public DomElement getLastElementChild() {
        DomElement lastChild2 = null;
        for (DomElement lastChild2 : this.getChildElements()) {
        }
        return lastChild2;
    }

    @Override
    public DomElement getPreviousElementSibling() {
        DomNode node;
        for (node = this.getPreviousSibling(); node != null && !(node instanceof DomElement); node = node.getPreviousSibling()) {
        }
        return (DomElement)node;
    }

    @Override
    public DomElement getNextElementSibling() {
        DomNode node;
        for (node = this.getNextSibling(); node != null && !(node instanceof DomElement); node = node.getNextSibling()) {
        }
        return (DomElement)node;
    }

    @Override
    public int getChildElementCount() {
        int counter = 0;
        Iterator<DomElement> i = this.getChildElements().iterator();
        while (i.hasNext()) {
            i.next();
            ++counter;
        }
        return counter;
    }

    public final Iterable<DomElement> getChildElements() {
        return new ChildElementsIterable(this);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.print(this.getClass().getSimpleName());
        printWriter.print("[<");
        this.printOpeningTagContentAsXml(printWriter);
        printWriter.print(">]");
        printWriter.flush();
        return writer.toString();
    }

    public <P extends Page> P click() throws IOException {
        return this.click(false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends Page> P click(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        SgmlPage page = this.getPage();
        page.getWebClient().setCurrentWindow(page.getEnclosingWindow());
        if (!(page instanceof InteractivePage) || this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)page;
        }
        SgmlPage sgmlPage = page;
        synchronized (sgmlPage) {
            this.mouseDown(shiftKey, ctrlKey, altKey, 0);
            DomElement elementToFocus = null;
            if (this instanceof SubmittableElement || this instanceof HtmlAnchor) {
                elementToFocus = this;
            } else if (this instanceof HtmlOption) {
                elementToFocus = ((HtmlOption)this).getEnclosingSelect();
            }
            ((InteractivePage)page).setFocusedElement(elementToFocus);
            this.mouseUp(shiftKey, ctrlKey, altKey, 0);
            MouseEvent event = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(this.getEventTargetElement(), "click", shiftKey, ctrlKey, altKey, 0) : new MouseEvent(this.getEventTargetElement(), "click", shiftKey, ctrlKey, altKey, 0);
            return this.click(event);
        }
    }

    protected DomNode getEventTargetElement() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends Page> P click(Event event) throws IOException {
        SgmlPage page = this.getPage();
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)page;
        }
        Page contentPage = page.getEnclosingWindow().getEnclosedPage();
        boolean stateUpdated = false;
        boolean changed = false;
        if (this.isStateUpdateFirst()) {
            changed = this.doClickStateUpdate();
            stateUpdated = true;
        }
        JavaScriptEngine jsEngine = page.getWebClient().getJavaScriptEngine();
        jsEngine.holdPosponedActions();
        try {
            boolean pageAlreadyChanged;
            ScriptResult scriptResult = this.doClickFireClickEvent(event);
            boolean eventIsAborted = event.isAborted(scriptResult);
            boolean bl = pageAlreadyChanged = contentPage != page.getEnclosingWindow().getEnclosedPage();
            if (!(pageAlreadyChanged || stateUpdated || eventIsAborted)) {
                changed = this.doClickStateUpdate();
            }
        }
        finally {
            jsEngine.processPostponedActions();
        }
        if (changed) {
            this.doClickFireChangeEvent();
        }
        return (P)this.getPage().getWebClient().getCurrentWindow().getEnclosedPage();
    }

    protected boolean doClickStateUpdate() throws IOException {
        DomNode parent;
        if (this.propagateClickStateUpdateToParent() && (parent = this.getParentNode()) instanceof HtmlElement) {
            return ((HtmlElement)parent).doClickStateUpdate();
        }
        return false;
    }

    protected boolean propagateClickStateUpdateToParent() {
        return true;
    }

    protected void doClickFireChangeEvent() {
    }

    protected ScriptResult doClickFireClickEvent(Event event) {
        return this.fireEvent(event);
    }

    public <P extends Page> P dblClick() throws IOException {
        return this.dblClick(false, false, false);
    }

    public <P extends Page> P dblClick(boolean shiftKey, boolean ctrlKey, boolean altKey) throws IOException {
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return (P)this.getPage();
        }
        P clickPage = this.click(shiftKey, ctrlKey, altKey);
        if (clickPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"dblClick() is ignored, as click() loaded a different page.");
            }
            return clickPage;
        }
        clickPage = this.click(shiftKey, ctrlKey, altKey);
        if (clickPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"dblClick() is ignored, as click() loaded a different page.");
            }
            return clickPage;
        }
        MouseEvent event = this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(this, "dblclick", shiftKey, ctrlKey, altKey, 0) : new MouseEvent(this, "dblclick", shiftKey, ctrlKey, altKey, 0);
        ScriptResult scriptResult = this.fireEvent(event);
        if (scriptResult == null) {
            return clickPage;
        }
        return (P)scriptResult.getNewPage();
    }

    public Page mouseOver() {
        return this.mouseOver(false, false, false, 0);
    }

    public Page mouseOver(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseover", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseMove() {
        return this.mouseMove(false, false, false, 0);
    }

    public Page mouseMove(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousemove", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseOut() {
        return this.mouseOut(false, false, false, 0);
    }

    public Page mouseOut(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseout", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseDown() {
        return this.mouseDown(false, false, false, 0);
    }

    public Page mouseDown(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mousedown", shiftKey, ctrlKey, altKey, button);
    }

    public Page mouseUp() {
        return this.mouseUp(false, false, false, 0);
    }

    public Page mouseUp(boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        return this.doMouseEvent("mouseup", shiftKey, ctrlKey, altKey, button);
    }

    public Page rightClick() {
        return this.rightClick(false, false, false);
    }

    public Page rightClick(boolean shiftKey, boolean ctrlKey, boolean altKey) {
        Page mouseDownPage = this.mouseDown(shiftKey, ctrlKey, altKey, 2);
        if (mouseDownPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"rightClick() is incomplete, as mouseDown() loaded a different page.");
            }
            return mouseDownPage;
        }
        Page mouseUpPage = this.mouseUp(shiftKey, ctrlKey, altKey, 2);
        if (mouseUpPage != this.getPage()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"rightClick() is incomplete, as mouseUp() loaded a different page.");
            }
            return mouseUpPage;
        }
        return this.doMouseEvent("contextmenu", shiftKey, ctrlKey, altKey, 2);
    }

    private Page doMouseEvent(String eventType, boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        SgmlPage page = this.getPage();
        MouseEvent event = "contextmenu".equals(eventType) && this.getPage().getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLICK_USES_POINTEREVENT) ? new PointerEvent(this, eventType, shiftKey, ctrlKey, altKey, button) : new MouseEvent(this, eventType, shiftKey, ctrlKey, altKey, button);
        ScriptResult scriptResult = this.fireEvent(event);
        Page currentPage = scriptResult == null ? page : scriptResult.getNewPage();
        this.mouseOver_ = !"mouseout".equals(eventType);
        return currentPage;
    }

    public ScriptResult fireEvent(String eventType) {
        return this.fireEvent(new Event(this, eventType));
    }

    public ScriptResult fireEvent(final Event event) {
        WebClient client = this.getPage().getWebClient();
        if (!client.getOptions().isJavaScriptEnabled()) {
            return null;
        }
        if (!this.handles(event)) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Firing " + event));
        }
        final EventTarget jsElt = (EventTarget)this.getScriptableObject();
        ContextAction action = new ContextAction(){

            public Object run(Context cx) {
                return jsElt.fireEvent(event);
            }
        };
        HtmlUnitContextFactory cf = client.getJavaScriptEngine().getContextFactory();
        ScriptResult result = (ScriptResult)cf.call(action);
        if (event.isAborted(result)) {
            this.preventDefault();
        }
        return result;
    }

    protected void preventDefault() {
    }

    public void focus() {
        InteractivePage page = (InteractivePage)this.getPage();
        page.setFocusedElement(this);
        HTMLElement jsElt = (HTMLElement)this.getScriptableObject();
        jsElt.setActive();
    }

    public void blur() {
        ((InteractivePage)this.getPage()).setFocusedElement(null);
    }

    public void removeFocus() {
    }

    protected boolean isStateUpdateFirst() {
        return false;
    }

    public boolean isMouseOver() {
        return this.mouseOver_;
    }

    protected static class ChildElementsIterator
    implements Iterator<DomElement> {
        private DomElement nextElement_;

        protected ChildElementsIterator(DomNode domNode) {
            DomNode child = domNode.getFirstChild();
            if (child != null) {
                if (child instanceof DomElement) {
                    this.nextElement_ = (DomElement)child;
                } else {
                    this.setNextElement(child);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextElement_ != null;
        }

        @Override
        public DomElement next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (this.nextElement_ == null) {
                throw new IllegalStateException();
            }
            DomNode sibling = this.nextElement_.getPreviousSibling();
            if (sibling != null) {
                sibling.remove();
            }
        }

        public DomElement nextElement() {
            if (this.nextElement_ != null) {
                DomElement result = this.nextElement_;
                this.setNextElement(this.nextElement_);
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextElement(DomNode node) {
            DomNode next;
            for (next = node.getNextSibling(); next != null && !(next instanceof HtmlElement); next = next.getNextSibling()) {
            }
            this.nextElement_ = (DomElement)next;
        }
    }

    private static class ChildElementsIterable
    implements Iterable<DomElement> {
        private final Iterator<DomElement> iterator_;

        protected ChildElementsIterable(DomNode domNode) {
            this.iterator_ = new ChildElementsIterator(domNode);
        }

        @Override
        public Iterator<DomElement> iterator() {
            return this.iterator_;
        }
    }
}

