/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlAbbreviated;
import com.gargoylesoftware.htmlunit.html.HtmlAcronym;
import com.gargoylesoftware.htmlunit.html.HtmlAddress;
import com.gargoylesoftware.htmlunit.html.HtmlArticle;
import com.gargoylesoftware.htmlunit.html.HtmlAside;
import com.gargoylesoftware.htmlunit.html.HtmlBaseFont;
import com.gargoylesoftware.htmlunit.html.HtmlBidirectionalIsolation;
import com.gargoylesoftware.htmlunit.html.HtmlBidirectionalOverride;
import com.gargoylesoftware.htmlunit.html.HtmlBig;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBold;
import com.gargoylesoftware.htmlunit.html.HtmlCenter;
import com.gargoylesoftware.htmlunit.html.HtmlCitation;
import com.gargoylesoftware.htmlunit.html.HtmlCode;
import com.gargoylesoftware.htmlunit.html.HtmlCommand;
import com.gargoylesoftware.htmlunit.html.HtmlDefinition;
import com.gargoylesoftware.htmlunit.html.HtmlDefinitionDescription;
import com.gargoylesoftware.htmlunit.html.HtmlDefinitionTerm;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlEmphasis;
import com.gargoylesoftware.htmlunit.html.HtmlExample;
import com.gargoylesoftware.htmlunit.html.HtmlFigure;
import com.gargoylesoftware.htmlunit.html.HtmlFigureCaption;
import com.gargoylesoftware.htmlunit.html.HtmlFooter;
import com.gargoylesoftware.htmlunit.html.HtmlHeader;
import com.gargoylesoftware.htmlunit.html.HtmlItalic;
import com.gargoylesoftware.htmlunit.html.HtmlKeyboard;
import com.gargoylesoftware.htmlunit.html.HtmlLayer;
import com.gargoylesoftware.htmlunit.html.HtmlListing;
import com.gargoylesoftware.htmlunit.html.HtmlMain;
import com.gargoylesoftware.htmlunit.html.HtmlMark;
import com.gargoylesoftware.htmlunit.html.HtmlNav;
import com.gargoylesoftware.htmlunit.html.HtmlNoBreak;
import com.gargoylesoftware.htmlunit.html.HtmlNoEmbed;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoLayer;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPlainText;
import com.gargoylesoftware.htmlunit.html.HtmlRp;
import com.gargoylesoftware.htmlunit.html.HtmlRt;
import com.gargoylesoftware.htmlunit.html.HtmlRuby;
import com.gargoylesoftware.htmlunit.html.HtmlS;
import com.gargoylesoftware.htmlunit.html.HtmlSample;
import com.gargoylesoftware.htmlunit.html.HtmlSection;
import com.gargoylesoftware.htmlunit.html.HtmlSmall;
import com.gargoylesoftware.htmlunit.html.HtmlStrike;
import com.gargoylesoftware.htmlunit.html.HtmlStrong;
import com.gargoylesoftware.htmlunit.html.HtmlSubscript;
import com.gargoylesoftware.htmlunit.html.HtmlSummary;
import com.gargoylesoftware.htmlunit.html.HtmlSuperscript;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableDataCell;
import com.gargoylesoftware.htmlunit.html.HtmlTeletype;
import com.gargoylesoftware.htmlunit.html.HtmlUnderlined;
import com.gargoylesoftware.htmlunit.html.HtmlVariable;
import com.gargoylesoftware.htmlunit.html.HtmlWordBreak;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRectList;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMStringMap;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.TextRange;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLScriptElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLStyleElement;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@JsxClasses(value={@JsxClass(domClass=HtmlAbbreviated.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlAcronym.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlAddress.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlArticle.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlAside.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlBaseFont.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlBidirectionalIsolation.class, browsers={@WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlBidirectionalOverride.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlBig.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlBold.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlCenter.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)}), @JsxClass(domClass=HtmlCitation.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlCode.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlCommand.class, browsers={@WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlDefinition.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlDefinitionDescription.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlDefinitionTerm.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlElement.class, browsers={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlEmphasis.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlExample.class, browsers={@WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlFigure.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlFigureCaption.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlFooter.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlHeader.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlItalic.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlKeyboard.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlLayer.class, browsers={@WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlListing.class, browsers={@WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlMark.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlNav.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlNoBreak.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlNoEmbed.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlNoFrames.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlNoLayer.class, browsers={@WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlNoScript.class, browsers={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlPlainText.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlRuby.class, browsers={@WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlRp.class, browsers={@WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlRt.class, browsers={@WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlS.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlSample.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlSection.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlSmall.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlStrike.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlStrong.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlSubscript.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlSummary.class, browsers={@WebBrowser(value=BrowserName.CHROME)}), @JsxClass(domClass=HtmlSuperscript.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlTeletype.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlUnderlined.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlWordBreak.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)}), @JsxClass(domClass=HtmlMain.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(domClass=HtmlVariable.class, browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})})
public class HTMLElement
extends Element
implements ScriptableWithFallbackGetter {
    private static final Class<?>[] METHOD_PARAMS_OBJECT = new Class[]{Object.class};
    private static final Pattern PERCENT_VALUE = Pattern.compile("\\d+%");
    private static final Map<String, String> COLORS_MAP_IE = new HashMap<String, String>();
    private static final Log LOG = LogFactory.getLog(HTMLElement.class);
    private static final int BEHAVIOR_ID_UNKNOWN = -1;
    public static final int BEHAVIOR_ID_CLIENT_CAPS = 0;
    public static final int BEHAVIOR_ID_HOMEPAGE = 1;
    public static final int BEHAVIOR_ID_DOWNLOAD = 2;
    private static final String BEHAVIOR_CLIENT_CAPS = "#default#clientCaps";
    private static final String BEHAVIOR_HOMEPAGE = "#default#homePage";
    private static final String BEHAVIOR_DOWNLOAD = "#default#download";
    private static final Pattern CLASS_NAMES_SPLIT_PATTERN = Pattern.compile("\\s");
    private static final Pattern PRINT_NODE_PATTERN = Pattern.compile("  ");
    private static final Pattern PRINT_NODE_QUOTE_PATTERN = Pattern.compile("\"");
    static final String POSITION_BEFORE_BEGIN = "beforebegin";
    static final String POSITION_AFTER_BEGIN = "afterbegin";
    static final String POSITION_BEFORE_END = "beforeend";
    static final String POSITION_AFTER_END = "afterend";
    private static int UniqueID_Counter_ = 1;
    private final Set<String> behaviors_ = new HashSet<String>();
    private int scrollLeft_;
    private int scrollTop_;
    private String uniqueID_;
    private boolean endTagForbidden_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLElement() {
    }

    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if ("wbr".equalsIgnoreCase(domNode.getLocalName())) {
            this.endTagForbidden_ = true;
        } else if ("basefont".equalsIgnoreCase(domNode.getLocalName())) {
            this.endTagForbidden_ = true;
        }
    }

    @JsxGetter
    public String getId() {
        return this.getDomNodeOrDie().getId();
    }

    @JsxSetter
    public void setId(String newId) {
        this.getDomNodeOrDie().setId(newId);
    }

    @JsxGetter
    public String getTitle() {
        return this.getDomNodeOrDie().getAttribute("title");
    }

    @JsxSetter
    public void setTitle(String newTitle) {
        this.getDomNodeOrDie().setAttribute("title", newTitle);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getDisabled() {
        return this.getDomNodeOrDie().hasAttribute("disabled");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setDisabled(boolean disabled) {
        HtmlElement element = this.getDomNodeOrDie();
        if (disabled) {
            element.setAttribute("disabled", "disabled");
        } else {
            element.removeAttribute("disabled");
        }
    }

    @Override
    public String getLocalName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (domNode.getHtmlPageOrNull() != null) {
            String prefix = ((DomNode)domNode).getPrefix();
            if (prefix != null) {
                StringBuilder localName = new StringBuilder(prefix.toLowerCase(Locale.ROOT));
                localName.append(':');
                localName.append(((DomNode)domNode).getLocalName().toLowerCase(Locale.ROOT));
                return localName.toString();
            }
            return ((DomNode)domNode).getLocalName().toLowerCase(Locale.ROOT);
        }
        return ((DomNode)domNode).getLocalName();
    }

    @Override
    public Object getWithFallback(String name) {
        return NOT_FOUND;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void clearAttributes() {
        HtmlElement node = this.getDomNodeOrDie();
        ArrayList<String> removals = new ArrayList<String>();
        for (String attributeName : node.getAttributesMap().keySet()) {
            if (ScriptableObject.hasProperty((Scriptable)this.getPrototype(), (String)attributeName)) continue;
            removals.add(attributeName);
        }
        for (String attributeName : removals) {
            node.removeAttribute(attributeName);
        }
        for (Object id : this.getAllIds()) {
            if (id instanceof Integer) {
                int i = (Integer)id;
                this.delete(i);
                continue;
            }
            if (!(id instanceof String)) continue;
            this.delete((String)id);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void mergeAttributes(HTMLElement source, Object preserveIdentity) {
        HtmlElement src = source.getDomNodeOrDie();
        HtmlElement target = this.getDomNodeOrDie();
        if (preserveIdentity instanceof Boolean && !((Boolean)preserveIdentity).booleanValue()) {
            target.setId(src.getId());
            target.setAttribute("name", src.getAttribute("name"));
        }
    }

    @JsxFunction
    public Object getAttributeNodeNS(String namespaceURI, String localName) {
        return this.getDomNodeOrDie().getAttributeNodeNS(namespaceURI, localName).getScriptableObject();
    }

    @Override
    public void setAttribute(String name, String value) {
        this.getDomNodeOrDie().setAttribute(name, value);
        if (!name.isEmpty() && (name = name.toLowerCase(Locale.ROOT)).startsWith("on")) {
            try {
                name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                Method method = this.getClass().getMethod("set" + name, METHOD_PARAMS_OBJECT);
                method.invoke((Object)this, new Object[]{new EventHandler(this.getDomNodeOrDie(), name.substring(2), value)});
            }
            catch (NoSuchMethodException method) {
            }
            catch (IllegalAccessException method) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    @JsxFunction
    public void removeAttributeNode(Attr attribute) {
        String name = attribute.getName();
        Object namespaceUri = attribute.getNamespaceURI();
        if (namespaceUri instanceof String) {
            this.removeAttributeNS((String)namespaceUri, name);
            return;
        }
        this.removeAttributeNS(null, name);
    }

    protected AttributesImpl readAttributes(HtmlElement element) {
        AttributesImpl attributes = new AttributesImpl();
        for (DomAttr entry : element.getAttributesMap().values()) {
            String name = entry.getName();
            String value = entry.getValue();
            attributes.addAttribute(null, name, name, null, value);
        }
        return attributes;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public HTMLElement removeNode(boolean removeChildren) {
        HTMLElement parent = (HTMLElement)this.getParentElement();
        if (parent != null) {
            parent.removeChild(this);
            if (!removeChildren) {
                NodeList collection = this.getChildNodes();
                int length = collection.getLength();
                for (int i = 0; i < length; ++i) {
                    Node object = (Node)collection.item(0);
                    parent.appendChild(object);
                }
            }
        }
        return this;
    }

    @Override
    public Object getAttributeNode(String attributeName) {
        return this.getAttributes().getNamedItem(attributeName);
    }

    @JsxFunction
    public HTMLCollection getElementsByClassName(String className) {
        HtmlElement elt = this.getDomNodeOrDie();
        final String[] classNames = CLASS_NAMES_SPLIT_PATTERN.split(className, 0);
        HTMLCollection collection = new HTMLCollection(elt, true){

            @Override
            protected boolean isMatching(DomNode node) {
                if (!(node instanceof HtmlElement)) {
                    return false;
                }
                String classAttribute = ((HtmlElement)node).getAttribute("class");
                if (classAttribute == DomElement.ATTRIBUTE_NOT_DEFINED) {
                    return false;
                }
                classAttribute = " " + classAttribute + " ";
                for (String aClassName : classNames) {
                    if (classAttribute.contains(" " + aClassName + " ")) continue;
                    return false;
                }
                return true;
            }
        };
        return collection;
    }

    @JsxGetter(propertyName="className")
    public Object getClassName_js() {
        return this.getDomNodeOrDie().getAttribute("class");
    }

    @JsxGetter
    public int getClientHeight() {
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedHeight(false, true);
    }

    @JsxGetter
    public int getClientWidth() {
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedWidth(false, true);
    }

    @JsxSetter(propertyName="className")
    public void setClassName_js(String className) {
        this.getDomNodeOrDie().setAttribute("class", className);
    }

    @JsxGetter
    public String getInnerHTML() {
        HtmlElement domNode;
        try {
            domNode = this.getDomNodeOrDie();
        }
        catch (IllegalStateException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String tagName = this.getTagName();
        boolean isPlain = "SCRIPT".equals(tagName);
        isPlain = isPlain || "STYLE".equals(tagName);
        this.printChildren(buf, domNode, !isPlain);
        return buf.toString();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=45)})
    public String getInnerText() {
        StringBuilder buf = new StringBuilder();
        this.printChildren(buf, this.getDomNodeOrDie(), false);
        return buf.toString();
    }

    @JsxGetter
    public String getOuterHTML() {
        StringBuilder buf = new StringBuilder();
        this.printNode(buf, this.getDomNodeOrDie(), true);
        return buf.toString();
    }

    private void printChildren(StringBuilder buffer, DomNode node, boolean html) {
        for (DomNode child : node.getChildren()) {
            this.printNode(buffer, child, html);
        }
    }

    private void printNode(StringBuilder buffer, DomNode node, boolean html) {
        if (node instanceof DomComment) {
            if (html) {
                String s = PRINT_NODE_PATTERN.matcher(node.getNodeValue()).replaceAll(" ");
                buffer.append("<!--").append(s).append("-->");
            }
        } else if (node instanceof DomCharacterData) {
            String s = node.getNodeValue();
            if (html) {
                s = StringUtils.escapeXmlChars(s);
            }
            buffer.append(s);
        } else if (html) {
            DomElement element = (DomElement)node;
            Element scriptObject = (Element)node.getScriptableObject();
            String tag = element.getTagName();
            HTMLElement htmlElement = null;
            if (scriptObject instanceof HTMLElement) {
                htmlElement = (HTMLElement)scriptObject;
            }
            buffer.append("<").append(tag);
            for (DomAttr attr : element.getAttributesMap().values()) {
                if (!attr.getSpecified()) continue;
                String name = attr.getName();
                String value = PRINT_NODE_QUOTE_PATTERN.matcher(attr.getValue()).replaceAll("&quot;");
                buffer.append(' ').append(name).append("=");
                buffer.append("\"");
                buffer.append(value);
                buffer.append("\"");
            }
            buffer.append(">");
            boolean isHtml = html && !(scriptObject instanceof HTMLScriptElement) && !(scriptObject instanceof HTMLStyleElement);
            this.printChildren(buffer, node, isHtml);
            if (null == htmlElement || !htmlElement.isEndTagForbidden()) {
                buffer.append("</").append(tag).append(">");
            }
        } else {
            HtmlElement element = (HtmlElement)node;
            if ("p".equals(element.getTagName())) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_CR_NL)) {
                    buffer.append("\r\n");
                } else {
                    int i;
                    for (i = buffer.length() - 1; i >= 0 && Character.isWhitespace(buffer.charAt(i)); --i) {
                    }
                    buffer.setLength(i + 1);
                    buffer.append("\n");
                }
            }
            if (!"script".equals(element.getTagName())) {
                this.printChildren(buffer, node, html);
            }
        }
    }

    @JsxSetter
    public void setInnerHTML(Object value) {
        HtmlElement domNode;
        try {
            domNode = this.getDomNodeOrDie();
        }
        catch (IllegalStateException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
            return;
        }
        domNode.removeAllChildren();
        boolean addChildForNull = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_ADD_CHILD_FOR_NULL_VALUE);
        if (value == null && addChildForNull || value != null && !"".equals(value)) {
            String valueAsString = Context.toString((Object)value);
            HTMLElement.parseHtmlSnippet(domNode, valueAsString);
        }
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=45)})
    public void setInnerText(Object value) {
        String valueString = value == null && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_VALUE_NULL) ? null : Context.toString((Object)value);
        this.setInnerTextImpl(valueString);
    }

    protected void setInnerTextImpl(String value) {
        HtmlElement domNode = this.getDomNodeOrDie();
        domNode.removeAllChildren();
        if (value != null && !value.isEmpty()) {
            domNode.appendChild(new DomText(domNode.getPage(), value));
        }
    }

    @Override
    public void setTextContent(Object value) {
        this.setInnerTextImpl(value == null ? null : Context.toString((Object)value));
    }

    @JsxSetter
    public void setOuterHTML(Object value) {
        boolean append;
        DomNode target;
        HtmlElement domNode = this.getDomNodeOrDie();
        DomNode parent = domNode.getParentNode();
        if (null == parent) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OUTER_HTML_REMOVES_CHILDREN_FOR_DETACHED)) {
                domNode.removeAllChildren();
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OUTER_HTML_THROWS_FOR_DETACHED)) {
                throw Context.reportRuntimeError((String)"outerHTML is readonly for detached nodes");
            }
            return;
        }
        if (value == null && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OUTER_HTML_NULL_AS_STRING)) {
            domNode.remove();
            return;
        }
        String valueStr = Context.toString((Object)value);
        if (valueStr.isEmpty()) {
            domNode.remove();
            return;
        }
        DomNode nextSibling = domNode.getNextSibling();
        domNode.remove();
        if (nextSibling != null) {
            target = nextSibling;
            append = false;
        } else {
            target = parent;
            append = true;
        }
        ProxyDomNode proxyDomNode = new ProxyDomNode(target.getPage(), target, append);
        HTMLElement.parseHtmlSnippet(proxyDomNode, valueStr);
    }

    private static void parseHtmlSnippet(DomNode target, String source) {
        try {
            HTMLParser.parseFragment(target, source);
        }
        catch (IOException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
        }
        catch (SAXException e) {
            LogFactory.getLog(HtmlElement.class).error((Object)"Unexpected exception occurred while parsing HTML snippet", (Throwable)e);
            throw Context.reportRuntimeError((String)("Unexpected exception occurred while parsing HTML snippet: " + e.getMessage()));
        }
    }

    @JsxFunction
    public void insertAdjacentHTML(String position, String text) {
        Object[] values = this.getInsertAdjacentLocation(position);
        DomNode domNode = (DomNode)values[0];
        boolean append = (Boolean)values[1];
        ProxyDomNode proxyDomNode = new ProxyDomNode(domNode.getPage(), domNode, append);
        HTMLElement.parseHtmlSnippet(proxyDomNode, text);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public Object insertAdjacentElement(String where, Object insertedElement) {
        if (insertedElement instanceof Node) {
            DomNode childNode = ((Node)insertedElement).getDomNodeOrDie();
            Object[] values = this.getInsertAdjacentLocation(where);
            DomNode node = (DomNode)values[0];
            boolean append = (Boolean)values[1];
            if (append) {
                node.appendChild(childNode);
            } else {
                node.insertBefore(childNode);
            }
            return insertedElement;
        }
        throw Context.reportRuntimeError((String)("Passed object is not an element: " + insertedElement));
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public void insertAdjacentText(String where, String text) {
        Object[] values = this.getInsertAdjacentLocation(where);
        DomNode node = (DomNode)values[0];
        boolean append = (Boolean)values[1];
        DomText domText = new DomText(node.getPage(), text);
        if (append) {
            node.appendChild(domText);
        } else {
            node.insertBefore(domText);
        }
    }

    private Object[] getInsertAdjacentLocation(String where) {
        boolean append;
        DomNode node;
        HtmlElement currentNode = this.getDomNodeOrDie();
        if (POSITION_AFTER_BEGIN.equalsIgnoreCase(where)) {
            if (currentNode.getFirstChild() == null) {
                node = currentNode;
                append = true;
            } else {
                node = currentNode.getFirstChild();
                append = false;
            }
        } else if (POSITION_BEFORE_BEGIN.equalsIgnoreCase(where)) {
            node = currentNode;
            append = false;
        } else if (POSITION_BEFORE_END.equalsIgnoreCase(where)) {
            node = currentNode;
            append = true;
        } else if (POSITION_AFTER_END.equalsIgnoreCase(where)) {
            if (currentNode.getNextSibling() == null) {
                node = currentNode.getParentNode();
                append = true;
            } else {
                node = currentNode.getNextSibling();
                append = false;
            }
        } else {
            throw Context.reportRuntimeError((String)("Illegal position value: \"" + where + "\""));
        }
        if (append) {
            return new Object[]{node, Boolean.TRUE};
        }
        return new Object[]{node, Boolean.FALSE};
    }

    public int addBehavior(String behavior) {
        if (this.behaviors_.contains(behavior)) {
            return 0;
        }
        Class<?> c = this.getClass();
        if (BEHAVIOR_CLIENT_CAPS.equalsIgnoreCase(behavior)) {
            this.defineProperty("availHeight", c, 0);
            this.defineProperty("availWidth", c, 0);
            this.defineProperty("bufferDepth", c, 0);
            this.defineProperty("colorDepth", c, 0);
            this.defineProperty("connectionType", c, 0);
            this.defineProperty("cookieEnabled", c, 0);
            this.defineProperty("cpuClass", c, 0);
            this.defineProperty("height", c, 0);
            this.defineProperty("javaEnabled", c, 0);
            this.defineProperty("platform", c, 0);
            this.defineProperty("systemLanguage", c, 0);
            this.defineProperty("userLanguage", c, 0);
            this.defineProperty("width", c, 0);
            this.defineFunctionProperties(new String[]{"addComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"clearComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"compareVersions"}, c, 0);
            this.defineFunctionProperties(new String[]{"doComponentRequest"}, c, 0);
            this.defineFunctionProperties(new String[]{"getComponentVersion"}, c, 0);
            this.defineFunctionProperties(new String[]{"isComponentInstalled"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 0;
        }
        if (BEHAVIOR_HOMEPAGE.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"isHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"setHomePage"}, c, 0);
            this.defineFunctionProperties(new String[]{"navigateHomePage"}, c, 0);
            this.behaviors_.add(BEHAVIOR_CLIENT_CAPS);
            return 1;
        }
        if (BEHAVIOR_DOWNLOAD.equalsIgnoreCase(behavior)) {
            this.defineFunctionProperties(new String[]{"startDownload"}, c, 0);
            this.behaviors_.add(BEHAVIOR_DOWNLOAD);
            return 2;
        }
        LOG.warn((Object)("Unimplemented behavior: " + behavior));
        return -1;
    }

    public void removeBehavior(int id) {
        switch (id) {
            case 0: {
                this.delete("availHeight");
                this.delete("availWidth");
                this.delete("bufferDepth");
                this.delete("colorDepth");
                this.delete("connectionType");
                this.delete("cookieEnabled");
                this.delete("cpuClass");
                this.delete("height");
                this.delete("javaEnabled");
                this.delete("platform");
                this.delete("systemLanguage");
                this.delete("userLanguage");
                this.delete("width");
                this.delete("addComponentRequest");
                this.delete("clearComponentRequest");
                this.delete("compareVersions");
                this.delete("doComponentRequest");
                this.delete("getComponentVersion");
                this.delete("isComponentInstalled");
                this.behaviors_.remove(BEHAVIOR_CLIENT_CAPS);
                break;
            }
            case 1: {
                this.delete("isHomePage");
                this.delete("setHomePage");
                this.delete("navigateHomePage");
                this.behaviors_.remove(BEHAVIOR_HOMEPAGE);
                break;
            }
            case 2: {
                this.delete("startDownload");
                this.behaviors_.remove(BEHAVIOR_DOWNLOAD);
                break;
            }
            default: {
                LOG.warn((Object)("Unexpected behavior id: " + id + ". Ignoring."));
            }
        }
    }

    public int getAvailHeight() {
        return this.getWindow().getScreen().getAvailHeight();
    }

    public int getAvailWidth() {
        return this.getWindow().getScreen().getAvailWidth();
    }

    public int getBufferDepth() {
        return this.getWindow().getScreen().getBufferDepth();
    }

    public int getColorDepth() {
        return this.getWindow().getScreen().getColorDepth();
    }

    public String getConnectionType() {
        return "modem";
    }

    public boolean getCookieEnabled() {
        return this.getWindow().getNavigator().getCookieEnabled();
    }

    public String getCpuClass() {
        return this.getWindow().getNavigator().getCpuClass();
    }

    public int getHeight() {
        return this.getWindow().getScreen().getHeight();
    }

    public boolean getJavaEnabled() {
        return this.getWindow().getNavigator().javaEnabled();
    }

    public String getPlatform() {
        return this.getWindow().getNavigator().getPlatform();
    }

    public String getSystemLanguage() {
        return this.getWindow().getNavigator().getSystemLanguage();
    }

    public String getUserLanguage() {
        return this.getWindow().getNavigator().getUserLanguage();
    }

    public int getWidth() {
        return this.getWindow().getScreen().getWidth();
    }

    public void addComponentRequest(String id, String idType, String minVersion) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Call to addComponentRequest(" + id + ", " + idType + ", " + minVersion + ") ignored."));
        }
    }

    public void clearComponentRequest() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Call to clearComponentRequest() ignored.");
        }
    }

    public int compareVersions(String v1, String v2) {
        int i = v1.compareTo(v2);
        if (i == 0) {
            return 0;
        }
        if (i < 0) {
            return -1;
        }
        return 1;
    }

    public boolean doComponentRequest() {
        return false;
    }

    public String getComponentVersion(String id, String idType) {
        if ("{E5D12C4E-7B4F-11D3-B5C9-0050045C3C96}".equals(id)) {
            return "";
        }
        return "1.0";
    }

    public boolean isComponentInstalled(String id, String idType, String minVersion) {
        return false;
    }

    public void startDownload(String uri, Function callback) throws MalformedURLException {
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        URL url = page.getFullyQualifiedUrl(uri);
        if (!page.getUrl().getHost().equals(url.getHost())) {
            throw Context.reportRuntimeError((String)("Not authorized url: " + url));
        }
        JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createDownloadBehaviorJob(url, callback, this.getWindow().getWebWindow().getWebClient());
        page.getEnclosingWindow().getJobManager().addJob(job, page);
    }

    public boolean isHomePage(String url) {
        try {
            URL newUrl = new URL(url);
            URL currentUrl = this.getDomNodeOrDie().getPage().getUrl();
            String home = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().getOptions().getHomePage();
            boolean sameDomains = newUrl.getHost().equalsIgnoreCase(currentUrl.getHost());
            boolean isHomePage = home != null && home.equals(url);
            return sameDomains && isHomePage;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void setHomePage(String url) {
        this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient().getOptions().setHomePage(url);
    }

    public void navigateHomePage() throws IOException {
        WebClient webClient = this.getDomNodeOrDie().getPage().getEnclosingWindow().getWebClient();
        webClient.getPage(webClient.getOptions().getHomePage());
    }

    @JsxGetter
    public int getOffsetHeight() {
        if (this.isDisplayNone() || !this.getDomNodeOrDie().isAttachedToPage()) {
            return 0;
        }
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.getClientY() - this.getPosY() + 50;
        }
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedHeight(true, true);
    }

    protected final boolean isDisplayNone() {
        for (HTMLElement element = this; element != null; element = element.getParentHTMLElement()) {
            CSS2Properties style = element.getWindow().getComputedStyle(element, null);
            String display = ((CSSStyleDeclaration)style).getDisplay();
            if (!HtmlElement.DisplayStyle.NONE.value().equals(display)) continue;
            return true;
        }
        return false;
    }

    @JsxGetter
    public int getOffsetWidth() {
        if (this.isDisplayNone() || !this.getDomNodeOrDie().isAttachedToPage()) {
            return 0;
        }
        MouseEvent event = MouseEvent.getCurrentMouseEvent();
        if (this.isAncestorOfEventTarget(event)) {
            return event.getClientX() - this.getPosX() + 50;
        }
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getCalculatedWidth(true, true);
    }

    protected boolean isAncestorOfEventTarget(MouseEvent event) {
        if (event == null) {
            return false;
        }
        if (!(event.getSrcElement() instanceof HTMLElement)) {
            return false;
        }
        HTMLElement srcElement = (HTMLElement)event.getSrcElement();
        return this.getDomNodeOrDie().isAncestorOf(srcElement.getDomNodeOrDie());
    }

    public String toString() {
        return "HTMLElement for " + this.getDomNodeOrNull();
    }

    @JsxGetter
    public int getScrollTop() {
        CSS2Properties style;
        if (this.scrollTop_ < 0) {
            this.scrollTop_ = 0;
        } else if (this.scrollTop_ > 0 && !(style = this.getWindow().getComputedStyle(this, null)).isScrollable(false)) {
            this.scrollTop_ = 0;
        }
        return this.scrollTop_;
    }

    @JsxSetter
    public void setScrollTop(int scroll) {
        this.scrollTop_ = scroll;
    }

    @JsxGetter
    public int getScrollLeft() {
        CSS2Properties style;
        if (this.scrollLeft_ < 0) {
            this.scrollLeft_ = 0;
        } else if (this.scrollLeft_ > 0 && !(style = this.getWindow().getComputedStyle(this, null)).isScrollable(true)) {
            this.scrollLeft_ = 0;
        }
        return this.scrollLeft_;
    }

    @JsxSetter
    public void setScrollLeft(int scroll) {
        this.scrollLeft_ = scroll;
    }

    @JsxGetter
    public int getScrollHeight() {
        return this.getClientHeight();
    }

    @JsxGetter
    public int getScrollWidth() {
        return this.getClientWidth();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setTagUrn(String tagUrn) {
        throw Context.reportRuntimeError((String)("Error trying to set tagUrn to '" + tagUrn + "'."));
    }

    public HTMLElement getParentHTMLElement() {
        Node parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof HTMLElement); parent = parent.getParent()) {
        }
        return (HTMLElement)parent;
    }

    @JsxFunction
    public void scrollIntoView() {
    }

    @JsxFunction
    public Object getClientRects() {
        ClientRectList rectList = new ClientRectList();
        rectList.setParentScope(this.getWindow());
        rectList.setPrototype(this.getPrototype(rectList.getClass()));
        if (this.getDomNodeOrDie().isAttachedToPage()) {
            ClientRect rect = new ClientRect(0, 0, 1, 1);
            rect.setParentScope(this.getWindow());
            rect.setPrototype(this.getPrototype(rect.getClass()));
            rectList.add(rect);
        }
        return rectList;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getUniqueID() {
        if (this.uniqueID_ == null) {
            this.uniqueID_ = "ms__id" + UniqueID_Counter_++;
        }
        return this.uniqueID_;
    }

    @Override
    public HtmlElement getDomNodeOrDie() {
        return (HtmlElement)super.getDomNodeOrDie();
    }

    @Override
    public HtmlElement getDomNodeOrNull() {
        return (HtmlElement)super.getDomNodeOrNull();
    }

    @Override
    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public void blur() {
        super.blur();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public Object createTextRange() {
        TextRange range = new TextRange(this);
        range.setParentScope(this.getParentScope());
        range.setPrototype(this.getPrototype(range.getClass()));
        return range;
    }

    @JsxFunction
    public void focus() {
        HtmlElement domNode = this.getDomNodeOrDie();
        if (domNode instanceof SubmittableElement) {
            domNode.focus();
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void setActive() {
        Window window = this.getWindow();
        HTMLDocument document = (HTMLDocument)window.getDocument();
        document.setActiveElement(this);
        if (window.getWebWindow() == window.getWebWindow().getWebClient().getCurrentWindow()) {
            HtmlElement element = this.getDomNodeOrDie();
            ((HtmlPage)element.getPage()).setFocusedElement(element);
        }
    }

    @Override
    public String getNodeName() {
        HtmlElement domNode = this.getDomNodeOrDie();
        String nodeName = ((DomNode)domNode).getNodeName();
        if (domNode.getHtmlPageOrNull() != null) {
            nodeName = nodeName.toUpperCase(Locale.ROOT);
        }
        return nodeName;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @JsxFunction
    public void click() throws IOException {
        this.getDomNodeOrDie().click();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public boolean getSpellcheck() {
        return Context.toBoolean((Object)this.getDomNodeOrDie().getAttribute("spellcheck"));
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF)})
    public void setSpellcheck(boolean spellcheck) {
        this.getDomNodeOrDie().setAttribute("spellcheck", Boolean.toString(spellcheck));
    }

    @JsxGetter
    public String getLang() {
        return this.getDomNodeOrDie().getAttribute("lang");
    }

    @JsxSetter
    public void setLang(String lang) {
        this.getDomNodeOrDie().setAttribute("lang", lang);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getLanguage() {
        return this.getDomNodeOrDie().getAttribute("language");
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setLanguage(String language) {
        this.getDomNodeOrDie().setAttribute("language", language);
    }

    @JsxGetter
    public String getDir() {
        return this.getDomNodeOrDie().getAttribute("dir");
    }

    @JsxSetter
    public void setDir(String dir) {
        this.getDomNodeOrDie().setAttribute("dir", dir);
    }

    @JsxGetter
    public int getTabIndex() {
        return (int)Context.toNumber((Object)this.getDomNodeOrDie().getAttribute("tabindex"));
    }

    @JsxSetter
    public void setTabIndex(int tabIndex) {
        this.getDomNodeOrDie().setAttribute("tabindex", Integer.toString(tabIndex));
    }

    @JsxGetter
    public String getAccessKey() {
        return this.getDomNodeOrDie().getAttribute("accesskey");
    }

    @JsxSetter
    public void setAccessKey(String accessKey) {
        this.getDomNodeOrDie().setAttribute("accesskey", accessKey);
    }

    protected String getWidthOrHeight(String attributeName, Boolean returnNegativeValues) {
        String value;
        block4: {
            value = this.getDomNodeOrDie().getAttribute(attributeName);
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WIDTH_HEIGHT_ACCEPTS_ARBITRARY_VALUES)) {
                return value;
            }
            if (!PERCENT_VALUE.matcher(value).matches()) {
                try {
                    Float f = Float.valueOf(value);
                    int i = f.intValue();
                    value = i < 0 ? (returnNegativeValues == null ? "0" : (!returnNegativeValues.booleanValue() ? "" : Integer.toString(i))) : Integer.toString(i);
                }
                catch (NumberFormatException e) {
                    if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WIDTH_HEIGHT_ACCEPTS_ARBITRARY_VALUES)) break block4;
                    value = "";
                }
            }
        }
        return value;
    }

    protected void setWidthOrHeight(String attributeName, String value, boolean allowNegativeValues) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WIDTH_HEIGHT_ACCEPTS_ARBITRARY_VALUES) && !value.isEmpty()) {
            if (value.endsWith("px")) {
                value = value.substring(0, value.length() - 2);
            }
            boolean error = false;
            if (!PERCENT_VALUE.matcher(value).matches()) {
                try {
                    Float f = Float.valueOf(value);
                    int i = f.intValue();
                    if (i < 0 && !allowNegativeValues) {
                        error = true;
                    }
                }
                catch (NumberFormatException e) {
                    error = true;
                }
            }
            if (error) {
                Exception e = new Exception("Cannot set the '" + attributeName + "' property to invalid value: '" + value + "'");
                Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        this.getDomNodeOrDie().setAttribute(attributeName, value);
    }

    protected void setColorAttribute(String name, String value) {
        String s = value;
        if (!s.isEmpty()) {
            boolean restrict = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_RESTRICT);
            boolean isName = false;
            if (restrict) {
                for (String key : COLORS_MAP_IE.keySet()) {
                    if (!key.equalsIgnoreCase(value)) continue;
                    isName = true;
                    break;
                }
            }
            if (!isName && restrict) {
                if (s.charAt(0) == '#') {
                    s = s.substring(1);
                }
                StringBuilder builder = new StringBuilder(7);
                for (int x = 0; x < 6 && x < s.length(); ++x) {
                    char ch = s.charAt(x);
                    if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') {
                        builder.append(ch);
                        continue;
                    }
                    builder.append('0');
                }
                builder.insert(0, '#');
                s = builder.toString();
            }
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_TO_LOWER)) {
                s = s.toLowerCase(Locale.ROOT);
            }
        }
        this.getDomNodeOrDie().setAttribute(name, s);
    }

    protected String getAlign(boolean returnInvalidValues) {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        String align = this.getDomNodeOrDie().getAttribute("align");
        if (returnInvalidValues || acceptArbitraryValues || "center".equals(align) || "justify".equals(align) || "left".equals(align) || "right".equals(align)) {
            return align;
        }
        return "";
    }

    protected void setAlign(String align, boolean ignoreIfNoError) {
        String alignLC = align.toLowerCase(Locale.ROOT);
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ALIGN_ACCEPTS_ARBITRARY_VALUES);
        if (acceptArbitraryValues || "center".equals(alignLC) || "justify".equals(alignLC) || "left".equals(alignLC) || "right".equals(alignLC)) {
            if (!ignoreIfNoError) {
                String newValue = acceptArbitraryValues ? align : alignLC;
                this.getDomNodeOrDie().setAttribute("align", newValue);
            }
            return;
        }
        throw Context.reportRuntimeError((String)("Cannot set the align property to invalid value: '" + align + "'"));
    }

    protected String getVAlign(String[] valid, String defaultValue) {
        String valign = this.getDomNodeOrDie().getAttribute("valign");
        if (valid == null || ArrayUtils.contains((Object[])valid, (Object)valign)) {
            return valign;
        }
        return defaultValue;
    }

    protected void setVAlign(Object vAlign, String[] valid) {
        String s = Context.toString((Object)vAlign).toLowerCase(Locale.ROOT);
        if (valid != null && !ArrayUtils.contains((Object[])valid, (Object)s)) {
            throw Context.reportRuntimeError((String)("Cannot set the vAlign property to invalid value: " + vAlign));
        }
        this.getDomNodeOrDie().setAttribute("valign", s);
    }

    protected String getCh() {
        return this.getDomNodeOrDie().getAttribute("char");
    }

    protected void setCh(String ch) {
        this.getDomNodeOrDie().setAttribute("char", ch);
    }

    protected String getChOff() {
        return this.getDomNodeOrDie().getAttribute("charOff");
    }

    protected void setChOff(String chOff) {
        try {
            float f = Float.parseFloat(chOff);
            int i = (int)f;
            chOff = (float)i == f ? Integer.toString(i) : Float.toString(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.getDomNodeOrDie().setAttribute("charOff", chOff);
    }

    @JsxGetter
    public int getOffsetLeft() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int left = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptableObject();
        CSS2Properties style = element.getWindow().getComputedStyle(element, null);
        left += style.getLeft(true, false, false);
        String position = style.getPositionWithInheritance();
        if ("absolute".equals(position)) {
            return left;
        }
        for (node = node.getParentNode(); node != null && node.getScriptableObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptableObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptableObject();
            style = element.getWindow().getComputedStyle(element, null);
            left += style.getLeft(true, true, true);
        }
        if (offsetParent != null) {
            style = offsetParent.getWindow().getComputedStyle(offsetParent, null);
            left += style.getMarginLeftValue();
            left += style.getPaddingLeftValue();
        }
        return left;
    }

    public int getPosX() {
        int cumulativeOffset = 0;
        for (HTMLElement element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.getOffsetLeft();
            if (element == this) continue;
            CSS2Properties style = element.getWindow().getComputedStyle(element, null);
            cumulativeOffset += style.getBorderLeftValue();
        }
        return cumulativeOffset;
    }

    public int getPosY() {
        int cumulativeOffset = 0;
        for (HTMLElement element = this; element != null; element = element.getOffsetParent()) {
            cumulativeOffset += element.getOffsetTop();
            if (element == this) continue;
            CSS2Properties style = element.getWindow().getComputedStyle(element, null);
            cumulativeOffset += style.getBorderTopValue();
        }
        return cumulativeOffset;
    }

    private HTMLElement getOffsetParent() {
        Object offsetParent = this.getOffsetParentInternal(false);
        if (offsetParent instanceof HTMLElement) {
            return (HTMLElement)offsetParent;
        }
        return null;
    }

    @JsxGetter
    public int getClientLeft() {
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getBorderLeftValue();
    }

    @JsxGetter
    public int getClientTop() {
        CSS2Properties style = this.getWindow().getComputedStyle(this, null);
        return style.getBorderTopValue();
    }

    @JsxGetter
    public int getOffsetTop() {
        if (this instanceof HTMLBodyElement) {
            return 0;
        }
        int top = 0;
        HTMLElement offsetParent = this.getOffsetParent();
        DomNode node = this.getDomNodeOrDie();
        HTMLElement element = (HTMLElement)node.getScriptableObject();
        CSS2Properties style = element.getWindow().getComputedStyle(element, null);
        top += style.getTop(true, false, false);
        String position = style.getPositionWithInheritance();
        if ("absolute".equals(position)) {
            return top;
        }
        for (node = node.getParentNode(); node != null && node.getScriptableObject() != offsetParent; node = node.getParentNode()) {
            if (!(node.getScriptableObject() instanceof HTMLElement)) continue;
            element = (HTMLElement)node.getScriptableObject();
            style = element.getWindow().getComputedStyle(element, null);
            top += style.getTop(false, true, true);
        }
        if (offsetParent != null) {
            HTMLElement thiz = (HTMLElement)this.getDomNodeOrDie().getScriptableObject();
            style = thiz.getWindow().getComputedStyle(thiz, null);
            boolean thisElementHasTopMargin = style.getMarginTopValue() != 0;
            style = offsetParent.getWindow().getComputedStyle(offsetParent, null);
            if (!thisElementHasTopMargin) {
                top += style.getMarginTopValue();
            }
            top += style.getPaddingTopValue();
        }
        return top;
    }

    @JsxGetter(propertyName="offsetParent")
    public Object getOffsetParent_js() {
        return this.getOffsetParentInternal(this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_OFFSET_PARENT_NULL_IF_FIXED));
    }

    private Object getOffsetParentInternal(boolean returnNullIfFixed) {
        boolean staticPos;
        DomNode currentElement = this.getDomNodeOrDie();
        if (currentElement.getParentNode() == null) {
            return null;
        }
        ScriptableObject offsetParent = null;
        HTMLElement htmlElement = (HTMLElement)currentElement.getScriptableObject();
        if (returnNullIfFixed && "fixed".equals(htmlElement.getStyle().getStyleAttribute(StyleAttributes.Definition.POSITION, true))) {
            return null;
        }
        CSS2Properties style = htmlElement.getWindow().getComputedStyle(htmlElement, null);
        String position = style.getPositionWithInheritance();
        boolean useTables = staticPos = "static".equals(position);
        while (currentElement != null) {
            HTMLElement parentElement;
            CSS2Properties parentStyle;
            String parentPosition;
            boolean parentIsStatic;
            DomNode parentNode = currentElement.getParentNode();
            if (parentNode instanceof HtmlBody || useTables && parentNode instanceof HtmlTableDataCell || useTables && parentNode instanceof HtmlTable) {
                offsetParent = parentNode.getScriptableObject();
                break;
            }
            if (parentNode != null && parentNode.getScriptableObject() instanceof HTMLElement && !(parentIsStatic = "static".equals(parentPosition = (parentStyle = (parentElement = (HTMLElement)parentNode.getScriptableObject()).getWindow().getComputedStyle(parentElement, null)).getPositionWithInheritance()))) {
                offsetParent = parentNode.getScriptableObject();
                break;
            }
            currentElement = currentElement.getParentNode();
        }
        return offsetParent;
    }

    @Override
    public ClientRect getBoundingClientRect() {
        ClientRect textRectangle = super.getBoundingClientRect();
        int left = this.getPosX();
        int top = this.getPosY();
        Object parentNode = this.getOffsetParentInternal(false);
        while (parentNode != null && parentNode instanceof HTMLElement && !(parentNode instanceof HTMLBodyElement)) {
            HTMLElement elem = (HTMLElement)parentNode;
            left -= elem.getScrollLeft();
            top -= elem.getScrollTop();
            parentNode = elem.getParentNode();
        }
        textRectangle.setBottom(top + this.getOffsetHeight());
        textRectangle.setLeft(left);
        textRectangle.setRight(left + this.getOffsetWidth());
        textRectangle.setTop(top);
        return textRectangle;
    }

    @Override
    @JsxGetter
    public DOMTokenList getClassList() {
        return new DOMTokenList(this, "class");
    }

    @Override
    @JsxFunction
    public boolean hasAttribute(String name) {
        return super.hasAttribute(name);
    }

    @Override
    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @Override
    @JsxGetter
    public Element getParentElement() {
        return super.getParentElement();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE)})
    public DOMStringMap getDataset() {
        return new DOMStringMap(this);
    }

    protected boolean isEndTagForbidden() {
        return this.endTagForbidden_;
    }

    protected boolean isLowerCaseInOuterHtml() {
        return false;
    }

    @JsxSetter
    public void setOnchange(Object onchange) {
        this.setEventHandlerProp("onchange", onchange);
    }

    @JsxGetter
    public Function getOnchange() {
        return this.getEventHandler("onchange");
    }

    @JsxGetter
    public Object getOnsubmit() {
        return this.getEventHandlerProp("onsubmit");
    }

    @JsxSetter
    public void setOnsubmit(Object onsubmit) {
        this.setEventHandlerProp("onsubmit", onsubmit);
    }

    public final String getDefaultStyleDisplay() {
        HtmlElement htmlElt = this.getDomNodeOrDie();
        return htmlElt.getDefaultStyleDisplay().value();
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public void setCapture(boolean retargetToElement) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public boolean releaseCapture() {
        return true;
    }

    @JsxGetter
    public String getContentEditable() {
        String attribute = this.getDomNodeOrDie().getAttribute("contentEditable");
        if (attribute == DomElement.ATTRIBUTE_NOT_DEFINED) {
            return "inherit";
        }
        if (attribute == DomElement.ATTRIBUTE_VALUE_EMPTY) {
            return "true";
        }
        return attribute;
    }

    @JsxSetter
    public void setContentEditable(String contentEditable) {
        this.getDomNodeOrDie().setAttribute("contentEditable", contentEditable);
    }

    @JsxGetter
    public boolean getIsContentEditable() {
        ScriptableObject parentScriptable;
        DomNode parent;
        String attribute = this.getContentEditable();
        if ("true".equals(attribute)) {
            return true;
        }
        if ("inherit".equals(attribute) && (parent = this.getDomNodeOrDie().getParentNode()) != null && (parentScriptable = parent.getScriptableObject()) instanceof HTMLElement) {
            return ((HTMLElement)parentScriptable).getIsContentEditable();
        }
        return false;
    }

    static {
        COLORS_MAP_IE.put("AliceBlue", "#F0F8FF");
        COLORS_MAP_IE.put("AntiqueWhite", "#FAEBD7");
        COLORS_MAP_IE.put("Aqua", "#00FFFF");
        COLORS_MAP_IE.put("Aquamarine", "#7FFFD4");
        COLORS_MAP_IE.put("Azure", "#F0FFFF");
        COLORS_MAP_IE.put("Beige", "#F5F5DC");
        COLORS_MAP_IE.put("Bisque", "#FFE4C4");
        COLORS_MAP_IE.put("Black", "#000000");
        COLORS_MAP_IE.put("BlanchedAlmond", "#FFEBCD");
        COLORS_MAP_IE.put("Blue", "#0000FF");
        COLORS_MAP_IE.put("BlueViolet", "#8A2BE2");
        COLORS_MAP_IE.put("Brown", "#A52A2A");
        COLORS_MAP_IE.put("BurlyWood", "#DEB887");
        COLORS_MAP_IE.put("CadetBlue", "#5F9EA0");
        COLORS_MAP_IE.put("Chartreuse", "#7FFF00");
        COLORS_MAP_IE.put("Chocolate", "#D2691E");
        COLORS_MAP_IE.put("Coral", "#FF7F50");
        COLORS_MAP_IE.put("CornflowerBlue", "#6495ED");
        COLORS_MAP_IE.put("Cornsilk", "#FFF8DC");
        COLORS_MAP_IE.put("Crimson", "#DC143C");
        COLORS_MAP_IE.put("Cyan", "#00FFFF");
        COLORS_MAP_IE.put("DarkBlue", "#00008B");
        COLORS_MAP_IE.put("DarkCyan", "#008B8B");
        COLORS_MAP_IE.put("DarkGoldenrod", "#B8860B");
        COLORS_MAP_IE.put("DarkGray", "#A9A9A9");
        COLORS_MAP_IE.put("DarkGrey", "#A9A9A9");
        COLORS_MAP_IE.put("DarkGreen", "#006400");
        COLORS_MAP_IE.put("DarkKhaki", "#BDB76B");
        COLORS_MAP_IE.put("DarkMagenta", "#8B008B");
        COLORS_MAP_IE.put("DarkOliveGreen", "#556B2F");
        COLORS_MAP_IE.put("DarkOrange", "#FF8C00");
        COLORS_MAP_IE.put("DarkOrchid", "#9932CC");
        COLORS_MAP_IE.put("DarkRed", "#8B0000");
        COLORS_MAP_IE.put("DarkSalmon", "#E9967A");
        COLORS_MAP_IE.put("DarkSeaGreen", "#8FBC8F");
        COLORS_MAP_IE.put("DarkSlateBlue", "#483D8B");
        COLORS_MAP_IE.put("DarkSlateGray", "#2F4F4F");
        COLORS_MAP_IE.put("DarkSlateGrey", "#2F4F4F");
        COLORS_MAP_IE.put("DarkTurquoise", "#00CED1");
        COLORS_MAP_IE.put("DarkViolet", "#9400D3");
        COLORS_MAP_IE.put("DeepPink", "#FF1493");
        COLORS_MAP_IE.put("DeepSkyBlue", "#00BFFF");
        COLORS_MAP_IE.put("DimGray", "#696969");
        COLORS_MAP_IE.put("DimGrey", "#696969");
        COLORS_MAP_IE.put("DodgerBlue", "#1E90FF");
        COLORS_MAP_IE.put("FireBrick", "#B22222");
        COLORS_MAP_IE.put("FloralWhite", "#FFFAF0");
        COLORS_MAP_IE.put("ForestGreen", "#228B22");
        COLORS_MAP_IE.put("Fuchsia", "#FF00FF");
        COLORS_MAP_IE.put("Gainsboro", "#DCDCDC");
        COLORS_MAP_IE.put("GhostWhite", "#F8F8FF");
        COLORS_MAP_IE.put("Gold", "#FFD700");
        COLORS_MAP_IE.put("Goldenrod", "#DAA520");
        COLORS_MAP_IE.put("Gray", "#808080");
        COLORS_MAP_IE.put("Grey", "#808080");
        COLORS_MAP_IE.put("Green", "#008000");
        COLORS_MAP_IE.put("GreenYellow", "#ADFF2F");
        COLORS_MAP_IE.put("Honeydew", "#F0FFF0");
        COLORS_MAP_IE.put("HotPink", "#FF69B4");
        COLORS_MAP_IE.put("IndianRed", "#CD5C5C");
        COLORS_MAP_IE.put("Indigo", "#4B0082");
        COLORS_MAP_IE.put("Ivory", "#FFFFF0");
        COLORS_MAP_IE.put("Khaki", "#F0E68C");
        COLORS_MAP_IE.put("Lavender", "#E6E6FA");
        COLORS_MAP_IE.put("LavenderBlush", "#FFF0F5");
        COLORS_MAP_IE.put("LawnGreen", "#7CFC00");
        COLORS_MAP_IE.put("LemonChiffon", "#FFFACD");
        COLORS_MAP_IE.put("LightBlue", "#ADD8E6");
        COLORS_MAP_IE.put("LightCoral", "#F08080");
        COLORS_MAP_IE.put("LightCyan", "#E0FFFF");
        COLORS_MAP_IE.put("LightGoldenrodYellow", "#FAFAD2");
        COLORS_MAP_IE.put("LightGreen", "#90EE90");
        COLORS_MAP_IE.put("LightGray", "#D3D3D3");
        COLORS_MAP_IE.put("LightGrey", "#D3D3D3");
        COLORS_MAP_IE.put("LightPink", "#FFB6C1");
        COLORS_MAP_IE.put("LightSalmon", "#FFA07A");
        COLORS_MAP_IE.put("LightSeaGreen", "#20B2AA");
        COLORS_MAP_IE.put("LightSkyBlue", "#87CEFA");
        COLORS_MAP_IE.put("LightSlateGray", "#778899");
        COLORS_MAP_IE.put("LightSlateGrey", "#778899");
        COLORS_MAP_IE.put("LightSteelBlue", "#B0C4DE");
        COLORS_MAP_IE.put("LightYellow", "#FFFFE0");
        COLORS_MAP_IE.put("Lime", "#00FF00");
        COLORS_MAP_IE.put("LimeGreen", "#32CD32");
        COLORS_MAP_IE.put("Linen", "#FAF0E6");
        COLORS_MAP_IE.put("Magenta", "#FF00FF");
        COLORS_MAP_IE.put("Maroon", "#800000");
        COLORS_MAP_IE.put("MediumAquamarine", "#66CDAA");
        COLORS_MAP_IE.put("MediumBlue", "#0000CD");
        COLORS_MAP_IE.put("MediumOrchid", "#BA55D3");
        COLORS_MAP_IE.put("MediumPurple", "#9370DB");
        COLORS_MAP_IE.put("MediumSeaGreen", "#3CB371");
        COLORS_MAP_IE.put("MediumSlateBlue", "#7B68EE");
        COLORS_MAP_IE.put("MediumSpringGreen", "#00FA9A");
        COLORS_MAP_IE.put("MediumTurquoise", "#48D1CC");
        COLORS_MAP_IE.put("MediumVioletRed", "#C71585");
        COLORS_MAP_IE.put("MidnightBlue", "#191970");
        COLORS_MAP_IE.put("MintCream", "#F5FFFA");
        COLORS_MAP_IE.put("MistyRose", "#FFE4E1");
        COLORS_MAP_IE.put("Moccasin", "#FFE4B5");
        COLORS_MAP_IE.put("NavajoWhite", "#FFDEAD");
        COLORS_MAP_IE.put("Navy", "#000080");
        COLORS_MAP_IE.put("OldLace", "#FDF5E6");
        COLORS_MAP_IE.put("Olive", "#808000");
        COLORS_MAP_IE.put("OliveDrab", "#6B8E23");
        COLORS_MAP_IE.put("Orange", "#FFA500");
        COLORS_MAP_IE.put("OrangeRed", "#FF4500");
        COLORS_MAP_IE.put("Orchid", "#DA70D6");
        COLORS_MAP_IE.put("PaleGoldenrod", "#EEE8AA");
        COLORS_MAP_IE.put("PaleGreen", "#98FB98");
        COLORS_MAP_IE.put("PaleTurquoise", "#AFEEEE");
        COLORS_MAP_IE.put("PaleVioletRed", "#DB7093");
        COLORS_MAP_IE.put("PapayaWhip", "#FFEFD5");
        COLORS_MAP_IE.put("PeachPuff", "#FFDAB9");
        COLORS_MAP_IE.put("Peru", "#CD853F");
        COLORS_MAP_IE.put("Pink", "#FFC0CB");
        COLORS_MAP_IE.put("Plum", "#DDA0DD");
        COLORS_MAP_IE.put("PowderBlue", "#B0E0E6");
        COLORS_MAP_IE.put("Purple", "#800080");
        COLORS_MAP_IE.put("Red", "#FF0000");
        COLORS_MAP_IE.put("RosyBrown", "#BC8F8F");
        COLORS_MAP_IE.put("RoyalBlue", "#4169E1");
        COLORS_MAP_IE.put("SaddleBrown", "#8B4513");
        COLORS_MAP_IE.put("Salmon", "#FA8072");
        COLORS_MAP_IE.put("SandyBrown", "#F4A460");
        COLORS_MAP_IE.put("SeaGreen", "#2E8B57");
        COLORS_MAP_IE.put("Seashell", "#FFF5EE");
        COLORS_MAP_IE.put("Sienna", "#A0522D");
        COLORS_MAP_IE.put("Silver", "#C0C0C0");
        COLORS_MAP_IE.put("SkyBlue", "#87CEEB");
        COLORS_MAP_IE.put("SlateBlue", "#6A5ACD");
        COLORS_MAP_IE.put("SlateGray", "#708090");
        COLORS_MAP_IE.put("SlateGrey", "#708090");
        COLORS_MAP_IE.put("Snow", "#FFFAFA");
        COLORS_MAP_IE.put("SpringGreen", "#00FF7F");
        COLORS_MAP_IE.put("SteelBlue", "#4682B4");
        COLORS_MAP_IE.put("Tan", "#D2B48C");
        COLORS_MAP_IE.put("Teal", "#008080");
        COLORS_MAP_IE.put("Thistle", "#D8BFD8");
        COLORS_MAP_IE.put("Tomato", "#FF6347");
        COLORS_MAP_IE.put("Turquoise", "#40E0D0");
        COLORS_MAP_IE.put("Violet", "#EE82EE");
        COLORS_MAP_IE.put("Wheat", "#F5DEB3");
        COLORS_MAP_IE.put("White", "#FFFFFF");
        COLORS_MAP_IE.put("WhiteSmoke", "#F5F5F5");
        COLORS_MAP_IE.put("Yellow", "#FFFF00");
        COLORS_MAP_IE.put("YellowGreen", "#9ACD32");
    }

    public static class ProxyDomNode
    extends HtmlDivision {
        private final DomNode target_;
        private final boolean append_;

        public ProxyDomNode(SgmlPage page, DomNode target, boolean append) {
            super("div", page, null);
            this.target_ = target;
            this.append_ = append;
        }

        @Override
        public DomNode appendChild(org.w3c.dom.Node node) {
            DomNode domNode = (DomNode)node;
            if (this.append_) {
                return this.target_.appendChild(domNode);
            }
            this.target_.insertBefore(domNode);
            return domNode;
        }

        public DomNode getDomNode() {
            return this.target_;
        }

        public boolean isAppend() {
            return this.append_;
        }
    }
}

