/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.htmlunit.corejs.javascript.Context;

public final class ClassConfiguration {
    private Map<String, PropertyInfo> propertyMap_ = new HashMap<String, PropertyInfo>();
    private Map<String, Method> functionMap_ = new HashMap<String, Method>();
    private Map<String, PropertyInfo> staticPropertyMap_ = new HashMap<String, PropertyInfo>();
    private Map<String, Method> staticFunctionMap_ = new HashMap<String, Method>();
    private List<ConstantInfo> constants_ = new ArrayList<ConstantInfo>();
    private String extendedClassName_;
    private final Class<? extends HtmlUnitScriptable> hostClass_;
    private final String hostClassSimpleName_;
    private Member jsConstructor_;
    private final Class<?>[] domClasses_;
    private final boolean jsObject_;
    private final String className_;

    public ClassConfiguration(Class<? extends HtmlUnitScriptable> hostClass, Class<?>[] domClasses, boolean jsObject, String className) {
        Class<? extends HtmlUnitScriptable> superClass = hostClass.getSuperclass();
        this.extendedClassName_ = superClass != SimpleScriptable.class ? superClass.getSimpleName() : "";
        this.hostClass_ = hostClass;
        this.hostClassSimpleName_ = this.hostClass_.getSimpleName();
        this.jsObject_ = jsObject;
        this.domClasses_ = domClasses;
        this.className_ = className == null ? this.getHostClass().getSimpleName() : className;
    }

    void setJSConstructor(Member jsConstructor) {
        if (this.jsConstructor_ != null) {
            throw new IllegalStateException("Can not have two constructors for " + this.jsConstructor_.getDeclaringClass().getName());
        }
        this.jsConstructor_ = jsConstructor;
    }

    public void addProperty(String name, Method getter, Method setter) {
        PropertyInfo info = new PropertyInfo(getter, setter);
        this.propertyMap_.put(name, info);
    }

    public void addStaticProperty(String name, Method getter, Method setter) {
        PropertyInfo info = new PropertyInfo(getter, setter);
        this.staticPropertyMap_.put(name, info);
    }

    public void addConstant(String name) {
        try {
            Object value = this.getHostClass().getField(name).get(null);
            int flag = 5;
            if (this.getClassName().endsWith("Array")) {
                flag |= 2;
            }
            this.constants_.add(new ConstantInfo(name, value, flag));
        }
        catch (Exception e) {
            throw Context.reportRuntimeError((String)("Cannot get field '" + name + "' for type: " + this.getHostClass().getName()));
        }
    }

    public Map<String, PropertyInfo> getPropertyMap() {
        return this.propertyMap_;
    }

    public Set<Map.Entry<String, PropertyInfo>> getStaticPropertyEntries() {
        return this.staticPropertyMap_.entrySet();
    }

    public Set<Map.Entry<String, Method>> getFunctionEntries() {
        return this.functionMap_.entrySet();
    }

    public Set<Map.Entry<String, Method>> getStaticFunctionEntries() {
        return this.staticFunctionMap_.entrySet();
    }

    public Set<String> getFunctionKeys() {
        return this.functionMap_.keySet();
    }

    public List<ConstantInfo> getConstants() {
        return this.constants_;
    }

    public void addFunction(String name, Method method) {
        this.functionMap_.put(name, method);
    }

    public void addStaticFunction(String name, Method method) {
        this.staticFunctionMap_.put(name, method);
    }

    public String getExtendedClassName() {
        return this.extendedClassName_;
    }

    public Class<? extends HtmlUnitScriptable> getHostClass() {
        return this.hostClass_;
    }

    public String getHostClassSimpleName() {
        return this.hostClassSimpleName_;
    }

    public Member getJsConstructor() {
        return this.jsConstructor_;
    }

    public Class<?>[] getDomClasses() {
        return this.domClasses_;
    }

    public boolean isJsObject() {
        return this.jsObject_;
    }

    public String getClassName() {
        return this.className_;
    }

    public static class ConstantInfo {
        private final String name_;
        private final Object value_;
        private final int flag_;

        public ConstantInfo(String name, Object value, int flag) {
            this.name_ = name;
            this.value_ = value;
            this.flag_ = flag;
        }

        public String getName() {
            return this.name_;
        }

        public Object getValue() {
            return this.value_;
        }

        public int getFlag() {
            return this.flag_;
        }
    }

    public static class PropertyInfo {
        private final Method readMethod_;
        private final Method writeMethod_;

        public PropertyInfo(Method readMethod, Method writeMethod) {
            this.readMethod_ = readMethod;
            this.writeMethod_ = writeMethod;
        }

        public Method getReadMethod() {
            return this.readMethod_;
        }

        public Method getWriteMethod() {
            return this.writeMethod_;
        }
    }
}

