/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.arrays;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class ArrayBuffer
extends SimpleScriptable {
    private byte[] bytes_;

    @JsxConstructor
    public void constructor(int length) {
        this.bytes_ = new byte[length];
    }

    @JsxGetter
    public int getByteLength() {
        return this.bytes_.length;
    }

    @JsxFunction
    public ArrayBuffer slice(int begin, Object end) {
        double endNumber = end == Undefined.instance ? (double)this.getByteLength() : Context.toNumber((Object)end);
        if (Double.isNaN(endNumber) || Double.isInfinite(endNumber) || endNumber < (double)begin) {
            endNumber = begin;
        }
        byte[] byteArray = new byte[(int)endNumber - begin];
        System.arraycopy(this.bytes_, begin, byteArray, 0, byteArray.length);
        ArrayBuffer arrayBuffer = new ArrayBuffer();
        arrayBuffer.bytes_ = byteArray;
        return arrayBuffer;
    }

    byte getByte(int index) {
        return this.bytes_[index];
    }

    public void setBytes(int index, byte[] array) {
        int i = array.length - 1;
        if (index + i >= this.bytes_.length) {
            i = this.bytes_.length - index - 1;
        }
        while (i >= 0) {
            this.bytes_[index + i] = array[i];
            --i;
        }
    }

    public byte[] getBytes() {
        return this.bytes_;
    }
}

