/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOptionGroup;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLFormElement;
import org.xml.sax.helpers.AttributesImpl;

@JsxClass(domClass=HtmlOption.class)
public class HTMLOptionElement
extends HTMLElement {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public void jsConstructor(String newText, String newValue, boolean defaultSelected, boolean selected) {
        HtmlPage page = (HtmlPage)this.getWindow().getWebWindow().getEnclosedPage();
        AttributesImpl attributes = null;
        if (defaultSelected) {
            attributes = new AttributesImpl();
            attributes.addAttribute(null, "selected", "selected", null, "selected");
        }
        HtmlOption htmlOption = (HtmlOption)HTMLParser.getFactory("option").createElement(page, "option", attributes);
        htmlOption.setSelected(selected);
        this.setDomNode(htmlOption);
        if (!"undefined".equals(newText)) {
            htmlOption.appendChild(new DomText(page, newText));
            htmlOption.setLabelAttribute(newText);
        }
        if (!"undefined".equals(newValue)) {
            htmlOption.setValueAttribute(newValue);
        }
    }

    @JsxGetter
    public String getValue() {
        String value = this.getDomNodeOrNull().getAttribute("value");
        if (value == DomElement.ATTRIBUTE_NOT_DEFINED) {
            value = ((HtmlOption)this.getDomNodeOrNull()).getText();
        }
        return value;
    }

    @JsxSetter
    public void setValue(String newValue) {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            ((HtmlOption)dom).setValueAttribute(newValue);
        }
    }

    @JsxGetter
    public String getText() {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            return ((HtmlOption)dom).getText();
        }
        return null;
    }

    @JsxSetter
    public void setText(String newText) {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            ((HtmlOption)dom).setText(newText);
            if (!this.hasAttribute("label")) {
                this.setLabel(newText);
            }
        }
    }

    @JsxGetter
    public boolean getSelected() {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            return ((HtmlOption)dom).isSelected();
        }
        return false;
    }

    @JsxSetter
    public void setSelected(boolean selected) {
        HtmlOption optionNode = (HtmlOption)this.getDomNodeOrNull();
        HtmlSelect enclosingSelect = optionNode.getEnclosingSelect();
        if (!selected && optionNode.isSelected() && enclosingSelect != null && !enclosingSelect.isMultipleSelectEnabled()) {
            enclosingSelect.getOption(0).setSelected(true, false);
        } else {
            optionNode.setSelected(selected, false);
        }
    }

    @JsxGetter
    public boolean getDefaultSelected() {
        HtmlElement dom = this.getDomNodeOrNull();
        if (dom instanceof HtmlOption) {
            return ((HtmlOption)dom).isDefaultSelected();
        }
        return false;
    }

    @JsxGetter
    public String getLabel() {
        HtmlElement domNode = this.getDomNodeOrNull();
        if (domNode instanceof HtmlOption) {
            return ((HtmlOption)domNode).getLabelAttribute();
        }
        return ((HtmlOptionGroup)domNode).getLabelAttribute();
    }

    @JsxSetter
    public void setLabel(String label) {
        HtmlElement domNode = this.getDomNodeOrNull();
        if (domNode instanceof HtmlOption) {
            ((HtmlOption)domNode).setLabelAttribute(label);
        } else {
            ((HtmlOptionGroup)domNode).setLabelAttribute(label);
        }
    }

    @Override
    @JsxGetter
    public boolean getDisabled() {
        return super.getDisabled();
    }

    @Override
    @JsxSetter
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
    }

    @JsxGetter
    public int getIndex() {
        HtmlSelect enclosingSelect;
        HtmlOption optionNode = (HtmlOption)this.getDomNodeOrNull();
        if (optionNode != null && (enclosingSelect = optionNode.getEnclosingSelect()) != null) {
            return enclosingSelect.indexOf(optionNode);
        }
        return 0;
    }

    @Override
    public void setAttribute(String name, String value) {
        super.setAttribute(name, value);
        if ("selected".equals(name)) {
            this.setSelected(true);
        }
    }

    @Override
    public void removeAttribute(String name) {
        super.removeAttribute(name);
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLOPTION_REMOVE_SELECTED_ATTRIB_DESELECTS) && "selected".equals(name)) {
            this.setSelected(false);
        }
    }

    @JsxGetter
    public HTMLFormElement getForm() {
        HtmlForm form = this.getDomNodeOrDie().getEnclosingForm();
        if (form == null) {
            return null;
        }
        return (HTMLFormElement)this.getScriptableFor(form);
    }
}

