/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.intl;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class DateTimeFormat
extends SimpleScriptable {
    private static Map<String, String> FF_38_FORMATS_ = new HashMap<String, String>();
    private static Map<String, String> FF_45_FORMATS_ = new HashMap<String, String>();
    private static Map<String, String> CHROME_FORMATS_ = new HashMap<String, String>();
    private static Map<String, String> IE_FORMATS_ = new HashMap<String, String>();
    private DateFormat format_;

    public DateTimeFormat() {
    }

    private DateTimeFormat(String locale, BrowserVersion browserVersion) {
        Map<String, String> formats = browserVersion.isChrome() ? CHROME_FORMATS_ : (browserVersion.isIE() ? IE_FORMATS_ : (browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() == 45 ? FF_45_FORMATS_ : FF_38_FORMATS_));
        String pattern = formats.get(locale);
        if (pattern == null && locale.indexOf(45) != -1) {
            pattern = formats.get(locale.substring(0, locale.indexOf(45)));
        }
        if (pattern == null) {
            pattern = formats.get("");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK) && !locale.startsWith("ar")) {
            pattern = pattern.replace("\u200e", "");
        }
        this.format_ = new SimpleDateFormat(pattern);
        if (!(!locale.startsWith("ar") || browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_AR_DZ_ASCII_DIGITS) && ("ar-DZ".equals(locale) || "ar-LY".equals(locale) || "ar-MA".equals(locale) || "ar-TN".equals(locale)))) {
            this.setZeroDigit('\u0660');
        }
    }

    private void setZeroDigit(char zeroDigit) {
        DecimalFormat df = (DecimalFormat)this.format_.getNumberFormat();
        DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
        dfs.setZeroDigit(zeroDigit);
        df.setDecimalFormatSymbols(dfs);
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        String locale = args.length != 0 ? Context.toString((Object)args[0]) : "";
        Window window = DateTimeFormat.getWindow((Scriptable)ctorObj);
        DateTimeFormat format = new DateTimeFormat(locale, window.getBrowserVersion());
        format.setParentScope(window);
        format.setPrototype(window.getPrototype(format.getClass()));
        return format;
    }

    @JsxFunction
    public String format(Object object) {
        Date date = (Date)Context.jsToJava((Object)object, Date.class);
        return this.format_.format(date);
    }

    static {
        String ddSlash = "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY";
        String ddDash = "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY";
        String ddDot = "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY";
        String ddDotDot = "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.";
        String ddDotBlank = "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY";
        String ddDotBlankDot = "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.";
        String mmSlash = "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY";
        String yyyySlash = "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd";
        String yyyyDash = "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd";
        String yyyyDot = "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd";
        String yyyyDotBlankDot = "\u200eYYYY\u200e. \u200eMM\u200e. \u200edd.";
        String yyyyDotDot = "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd\u200e.";
        String rightToLeft = "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY";
        FF_38_FORMATS_.put("", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("ar", "dd\u200f/MM\u200f/YYYY");
        FF_38_FORMATS_.put("be", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("bg", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e \u0433.");
        FF_38_FORMATS_.put("ca", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("cs", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        FF_38_FORMATS_.put("da", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("de", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("el", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-NZ", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-PA", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-PR", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-AU", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-GB", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-IE", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-IN", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-MT", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-SG", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("en-ZA", "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd");
        FF_38_FORMATS_.put("es", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("es-CL", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        FF_38_FORMATS_.put("es-PA", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("es-PR", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("es-US", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("et", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("fi", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("fr", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("fr-CA", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        FF_38_FORMATS_.put("ga", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        FF_38_FORMATS_.put("hi", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("hr", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        FF_38_FORMATS_.put("hu", "\u200eYYYY\u200e. \u200eMM\u200e. \u200edd.");
        FF_38_FORMATS_.put("in", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("is", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("it", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("iw", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("ja", "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd");
        FF_38_FORMATS_.put("ko", "\u200eYYYY\u200e. \u200eMM\u200e. \u200edd.");
        FF_38_FORMATS_.put("lt", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        FF_38_FORMATS_.put("lv", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        FF_38_FORMATS_.put("mk", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("ms", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("mt", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        FF_38_FORMATS_.put("nl", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        FF_38_FORMATS_.put("pl", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("pt", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("ro", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("ru", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("sk", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("sl", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        FF_38_FORMATS_.put("sq", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("sr", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        FF_38_FORMATS_.put("sv", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        FF_38_FORMATS_.put("tr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("uk", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_38_FORMATS_.put("vi", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("zh", "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd");
        FF_38_FORMATS_.put("zh-HK", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_38_FORMATS_.put("zh-SG", "\u200eYYYY\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
        FF_45_FORMATS_.putAll(FF_38_FORMATS_);
        CHROME_FORMATS_.putAll(FF_38_FORMATS_);
        IE_FORMATS_.putAll(FF_38_FORMATS_);
        FF_45_FORMATS_.putAll(FF_38_FORMATS_);
        FF_38_FORMATS_.put("sr-BA", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        FF_38_FORMATS_.put("sr-CS", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        FF_38_FORMATS_.put("sr-ME", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        FF_38_FORMATS_.put("sr-RS", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        FF_45_FORMATS_.put("en-CA", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        FF_45_FORMATS_.put("en-PH", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_45_FORMATS_.put("es-US", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_45_FORMATS_.put("ga", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        FF_45_FORMATS_.put("hr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        FF_45_FORMATS_.put("sk", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        FF_45_FORMATS_.put("sr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        FF_45_FORMATS_.put("sq", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        CHROME_FORMATS_.put("be", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        CHROME_FORMATS_.put("en-CA", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        CHROME_FORMATS_.put("en-IE", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("en-MT", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("en-SG", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("es-CL", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("es-PA", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("es-PR", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("es-US", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("hr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        CHROME_FORMATS_.put("in", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        CHROME_FORMATS_.put("in-ID", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("is", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        CHROME_FORMATS_.put("sk", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        CHROME_FORMATS_.put("sq", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        CHROME_FORMATS_.put("sr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        CHROME_FORMATS_.put("mk", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        IE_FORMATS_.put("ar-AE", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-BH", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-DZ", "\u200fdd\u200f-\u200fMM\u200f-\u200fYYYY");
        IE_FORMATS_.put("ar-LY", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-MA", "\u200fdd\u200f-\u200fMM\u200f-\u200fYYYY");
        IE_FORMATS_.put("ar-TN", "\u200fdd\u200f-\u200fMM\u200f-\u200fYYYY");
        IE_FORMATS_.put("ar-EG", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-IQ", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-JO", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-KW", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-LB", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-OM", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-QA", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-SY", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-YE", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("cs", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("da", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        IE_FORMATS_.put("en-IN", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        IE_FORMATS_.put("en-MT", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        IE_FORMATS_.put("en-CA", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("es-PR", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("es-US", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        IE_FORMATS_.put("fr-CH", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("ga", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("hi", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        IE_FORMATS_.put("hr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        IE_FORMATS_.put("hu", "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd\u200e.");
        IE_FORMATS_.put("iw", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("it-CH", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("ja", "\u200eYYYY\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
        IE_FORMATS_.put("ko", "\u200eYYYY\u200e\ub144 \u200eMM\u200e\uc6d4 \u200edd\u200e\uc77c");
        IE_FORMATS_.put("lt", "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd");
        IE_FORMATS_.put("lv", "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd\u200e.");
        IE_FORMATS_.put("mt", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("nl-BE", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("no", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("pl", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        IE_FORMATS_.put("pt-PT", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        IE_FORMATS_.put("sk", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        IE_FORMATS_.put("sl", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("sq", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        IE_FORMATS_.put("sr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("sr-BA", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("sr-CS", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("sr-ME", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("sr-RS", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("zh", "\u200eYYYY\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
        IE_FORMATS_.put("zh-HK", "\u200eYYYY\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
    }
}

