/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlMenu;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLListElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;

@JsxClass(domClass=HtmlMenu.class)
public class HTMLMenuElement
extends HTMLListElement {
    private String label_ = "";

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public HTMLMenuElement() {
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.IE})
    public String getType() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_EMPTY)) {
            return "";
        }
        String type = this.getDomNodeOrDie().getAttributeDirect("type");
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_PASS)) {
            return type;
        }
        if ("context".equalsIgnoreCase(type)) {
            return "context";
        }
        if ("toolbar".equalsIgnoreCase(type)) {
            return "toolbar";
        }
        return "list";
    }

    @Override
    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.IE})
    public void setType(String type) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_EMPTY)) {
            if (StringUtils.isEmpty((CharSequence)type)) {
                return;
            }
            throw Context.reportRuntimeError((String)("Cannot set the type property to invalid value: '" + type + "'"));
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MENU_TYPE_PASS)) {
            this.getDomNodeOrDie().setAttribute("type", type);
            return;
        }
        if ("context".equalsIgnoreCase(type)) {
            this.getDomNodeOrDie().setAttribute("type", "context");
            return;
        }
        if ("toolbar".equalsIgnoreCase(type)) {
            this.getDomNodeOrDie().setAttribute("type", "toolbar");
            return;
        }
        this.getDomNodeOrDie().setAttribute("type", "list");
    }

    @JsxGetter(value={SupportedBrowser.FF})
    public String getLabel() {
        return this.label_;
    }

    @JsxSetter(value={SupportedBrowser.FF})
    public void setLabel(String label) {
        this.label_ = label;
    }
}

