/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.intl;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import java.text.BreakIterator;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(value={SupportedBrowser.CHROME})
public class V8BreakIterator
extends SimpleScriptable {
    private transient BreakIterator breakIterator_;
    private String text_;
    private boolean typeAlwaysNone_;

    public V8BreakIterator() {
    }

    @JsxConstructor
    public V8BreakIterator(Object locales, Object types) {
        Locale locale = new Locale("en", "US");
        if (locales instanceof NativeArray) {
            if (((NativeArray)locales).getLength() != 0L) {
                locale = new Locale(((NativeArray)locales).get(0).toString());
            }
        } else if (locales instanceof String) {
            locale = new Locale(locales.toString());
        } else if (locales != Undefined.instance) {
            throw Context.throwAsScriptRuntimeEx((Throwable)new Exception("Unknown type " + locales.getClass().getName()));
        }
        if (types instanceof NativeObject) {
            Object obj = ((NativeObject)types).get("type", (Scriptable)((NativeObject)types));
            if ("character".equals(obj)) {
                this.breakIterator_ = BreakIterator.getCharacterInstance(locale);
                this.typeAlwaysNone_ = true;
            } else if ("line".equals(obj)) {
                this.breakIterator_ = BreakIterator.getLineInstance(locale);
                this.typeAlwaysNone_ = true;
            } else if ("sentence".equals(obj)) {
                this.breakIterator_ = BreakIterator.getSentenceInstance(locale);
                this.typeAlwaysNone_ = true;
            }
        }
        if (this.breakIterator_ == null) {
            this.breakIterator_ = BreakIterator.getWordInstance(locale);
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        return this.getClassName();
    }

    @JsxFunction
    public Object resolvedOptions() {
        return Context.getCurrentContext().evaluateString(this.getParentScope(), "var x = {locale: 'en-US'}; x", "", -1, null);
    }

    @JsxFunction
    public int first() {
        return this.breakIterator_.first();
    }

    @JsxFunction
    public int next() {
        return this.breakIterator_.next();
    }

    @JsxFunction
    public int current() {
        return this.breakIterator_.current();
    }

    @JsxFunction
    public void adoptText(String text) {
        this.text_ = text;
        this.breakIterator_.setText(text);
    }

    @JsxFunction
    public String breakType() {
        if (!this.typeAlwaysNone_) {
            int current = this.current();
            int previous = this.breakIterator_.previous();
            if (previous == -1) {
                this.first();
            } else {
                this.next();
            }
            if (current != -1 && previous != -1) {
                String token = this.text_.substring(previous, current);
                if (token.matches(".*[a-zA-Z]+.*")) {
                    return "letter";
                }
                if (token.matches("[0-9]+")) {
                    return "number";
                }
            }
        }
        return "none";
    }
}

