/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.file;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.file.File;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class FileReader
extends EventTarget {
    private static final Log LOG = LogFactory.getLog(FileReader.class);
    @JsxConstant
    public static final short EMPTY = 0;
    @JsxConstant
    public static final short LOADING = 1;
    @JsxConstant
    public static final short DONE = 2;
    private int readyState_ = 0;
    private Object result_;

    @JsxConstructor
    public FileReader() {
    }

    @JsxGetter
    public int getReadyState() {
        return this.readyState_;
    }

    @JsxGetter
    public Object getResult() {
        return this.result_;
    }

    @JsxFunction
    public void readAsDataURL(Object object) throws IOException {
        this.readyState_ = 1;
        java.io.File file = ((File)object).getFile();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            FileUtils.copyFile((java.io.File)file, (OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            String value = new String(new Base64().encode(bytes), StandardCharsets.US_ASCII);
            BrowserVersion browserVersion = this.getBrowserVersion();
            this.result_ = "data:";
            String contentType = value.isEmpty() ? URLConnection.guessContentTypeFromName(file.getName()) : Files.probeContentType(file.toPath());
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FILEREADER_EMPTY_NULL)) {
                if (value.isEmpty()) {
                    this.result_ = "null";
                } else {
                    if (contentType != null) {
                        this.result_ = this.result_ + contentType;
                    }
                    this.result_ = this.result_ + ";base64," + value;
                }
            } else {
                boolean includeConentType = browserVersion.hasFeature(BrowserVersionFeatures.JS_FILEREADER_CONTENT_TYPE);
                if (!value.isEmpty() || includeConentType) {
                    if (contentType == null) {
                        contentType = "application/octet-stream";
                    }
                    this.result_ = this.result_ + contentType + ";base64," + value;
                }
            }
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxFunction
    public void readAsArrayBuffer(Object object) throws IOException {
        this.readyState_ = 1;
        java.io.File file = ((File)object).getFile();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            FileUtils.copyFile((java.io.File)file, (OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            NativeArrayBuffer buffer = new NativeArrayBuffer((double)bytes.length);
            System.arraycopy(bytes, 0, buffer.getBuffer(), 0, bytes.length);
            buffer.setParentScope(this.getParentScope());
            buffer.setPrototype(ScriptableObject.getClassPrototype((Scriptable)this.getWindow(), (String)buffer.getClassName()));
            this.result_ = buffer;
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxFunction
    public void readAsText(Object object, Object encoding) throws IOException {
        Charset charset;
        java.io.File file;
        block5: {
            String encAsString;
            this.readyState_ = 1;
            file = ((File)object).getFile();
            charset = StandardCharsets.UTF_8;
            if (encoding != null && !Undefined.isUndefined((Object)encoding) && StringUtils.isNotBlank((CharSequence)(encAsString = Context.toString((Object)encoding)))) {
                try {
                    charset = Charsets.toCharset((String)encAsString.trim().toLowerCase());
                }
                catch (UnsupportedCharsetException e) {
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)("FileReader readAsText was called with an unsupported encoding '" + encoding + "'. Using UTF-8 instead."));
                }
            }
        }
        try {
            this.result_ = FileUtils.readFileToString((java.io.File)file, (Charset)charset);
        }
        catch (IOException e) {
            LOG.warn((Object)"FileReader readAsText can't read the file.", (Throwable)e);
        }
        this.readyState_ = 2;
        Event event = new Event(this, "load");
        this.fireEvent(event);
    }

    @JsxGetter
    public Function getOnload() {
        return this.getEventHandler("load");
    }

    @JsxSetter
    public void setOnload(Object onload) {
        this.setEventHandler("load", onload);
    }

    @JsxGetter
    public Function getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxSetter
    public void setOnerror(Object onerror) {
        this.setEventHandler("error", onerror);
    }
}

