/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.DownloadedContent;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitCookieSpecProvider;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitCookieStore;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitRedirectStrategie;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitSSLConnectionSocketFactory;
import com.gargoylesoftware.htmlunit.httpclient.SocksConnectionSocketFactory;
import com.gargoylesoftware.htmlunit.util.KeyDataPair;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.RequestAuthCache;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.client.protocol.RequestExpectContinue;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.TextUtils;

public class HttpWebConnection
implements WebConnection {
    private static final Log LOG = LogFactory.getLog(HttpWebConnection.class);
    private static final String HACKED_COOKIE_POLICY = "mine";
    private final Map<Thread, HttpClientBuilder> httpClientBuilder_ = new WeakHashMap<Thread, HttpClientBuilder>();
    private final WebClient webClient_;
    private String virtualHost_;
    private final CookieSpecProvider htmlUnitCookieSpecProvider_;
    private final WebClientOptions usedOptions_;
    private PoolingHttpClientConnectionManager connectionManager_;
    private final AuthCache sharedAuthCache_ = new SynchronizedAuthCache();
    private final Map<Thread, HttpClientContext> httpClientContextByThread_ = new WeakHashMap<Thread, HttpClientContext>();

    public HttpWebConnection(WebClient webClient) {
        this.webClient_ = webClient;
        this.htmlUnitCookieSpecProvider_ = new HtmlUnitCookieSpecProvider(webClient.getBrowserVersion());
        this.usedOptions_ = new WebClientOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResponse getResponse(WebRequest request) throws IOException {
        HttpClientBuilder builder = this.reconfigureHttpClientIfNeeded(this.getHttpClientBuilder());
        HttpUriRequest httpMethod = null;
        try {
            try {
                httpMethod = this.makeHttpMethod(request, builder);
            }
            catch (URISyntaxException e) {
                throw new IOException("Unable to create URI from URL: " + request.getUrl().toExternalForm() + " (reason: " + e.getMessage() + ")", e);
            }
            HttpHost hostConfiguration = HttpWebConnection.getHostConfiguration(request);
            long startTime = System.currentTimeMillis();
            HttpContext httpContext = this.getHttpContext();
            CloseableHttpResponse httpResponse = null;
            try (CloseableHttpClient closeableHttpClient = builder.build();){
                httpResponse = closeableHttpClient.execute(hostConfiguration, (HttpRequest)httpMethod, httpContext);
            }
            catch (SSLPeerUnverifiedException s) {
                if (this.webClient_.getOptions().isUseInsecureSSL()) {
                    HtmlUnitSSLConnectionSocketFactory.setUseSSL3Only(httpContext, true);
                    try (CloseableHttpClient closeableHttpClient2 = builder.build();){
                        httpResponse = closeableHttpClient2.execute(hostConfiguration, (HttpRequest)httpMethod, httpContext);
                    }
                }
                throw s;
            }
            catch (Error e) {
                this.httpClientBuilder_.remove(Thread.currentThread());
                throw e;
            }
            DownloadedContent downloadedBody = this.downloadResponseBody((HttpResponse)httpResponse);
            long endTime = System.currentTimeMillis();
            WebResponse webResponse = this.makeWebResponse((HttpResponse)httpResponse, request, downloadedBody, endTime - startTime);
            return webResponse;
        }
        finally {
            if (httpMethod != null) {
                this.onResponseGenerated(httpMethod);
            }
        }
    }

    protected void onResponseGenerated(HttpUriRequest httpMethod) {
    }

    private static HttpHost getHostConfiguration(WebRequest webRequest) {
        URL url = webRequest.getUrl();
        return new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
    }

    private synchronized HttpContext getHttpContext() {
        HttpClientContext httpClientContext = this.httpClientContextByThread_.get(Thread.currentThread());
        if (httpClientContext == null) {
            httpClientContext = new HttpClientContext();
            httpClientContext.setAttribute("http.auth.auth-cache", (Object)this.sharedAuthCache_);
            this.httpClientContextByThread_.put(Thread.currentThread(), httpClientContext);
        }
        return httpClientContext;
    }

    private void setProxy(HttpRequestBase httpRequest, WebRequest webRequest) {
        InetAddress localAddress = this.webClient_.getOptions().getLocalAddress();
        RequestConfig.Builder requestBuilder = HttpWebConnection.createRequestConfigBuilder(this.getTimeout(), localAddress);
        if (webRequest.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(webRequest.getProxyHost(), webRequest.getProxyPort());
            if (webRequest.isSocksProxy()) {
                SocksConnectionSocketFactory.setSocksProxy(this.getHttpContext(), proxy);
            } else {
                requestBuilder.setProxy(proxy);
                httpRequest.setConfig(requestBuilder.build());
            }
        } else {
            requestBuilder.setProxy(null);
            httpRequest.setConfig(requestBuilder.build());
        }
    }

    private HttpUriRequest makeHttpMethod(WebRequest webRequest, HttpClientBuilder httpClientBuilder) throws URISyntaxException {
        Credentials requestCredentials;
        HttpContext httpContext = this.getHttpContext();
        Charset charset = webRequest.getCharset();
        URL url = UrlUtils.encodeUrl(webRequest.getUrl(), false, charset);
        URI uri = UrlUtils.toURI(url, HttpWebConnection.escapeQuery(url.getQuery()));
        if (this.getVirtualHost() != null) {
            uri = URI.create(this.getVirtualHost());
        }
        HttpRequestBase httpMethod = HttpWebConnection.buildHttpMethod(webRequest.getHttpMethod(), uri);
        this.setProxy(httpMethod, webRequest);
        if (!(httpMethod instanceof HttpEntityEnclosingRequest)) {
            if (!webRequest.getRequestParameters().isEmpty()) {
                List<NameValuePair> pairs = webRequest.getRequestParameters();
                org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (Charset)charset);
                uri = UrlUtils.toURI(url, query);
                httpMethod.setURI(uri);
            }
        } else {
            CharSequence body;
            HttpPost postMethod;
            HttpEntityEnclosingRequest method = (HttpEntityEnclosingRequest)httpMethod;
            if (webRequest.getEncodingType() == FormEncodingType.URL_ENCODED && method instanceof HttpPost) {
                postMethod = (HttpPost)method;
                if (webRequest.getRequestBody() == null) {
                    StringEntity urlEncodedEntity;
                    List<NameValuePair> pairs = webRequest.getRequestParameters();
                    org.apache.http.NameValuePair[] httpClientPairs = NameValuePair.toHttpClient(pairs);
                    String query = URLEncodedUtils.format(Arrays.asList(httpClientPairs), (Charset)charset);
                    if (webRequest.hasHint(WebRequest.HttpHint.IncludeCharsetInContentTypeHeader)) {
                        urlEncodedEntity = new StringEntity(query, ContentType.create((String)"application/x-www-form-urlencoded", (Charset)charset));
                    } else {
                        urlEncodedEntity = new StringEntity(query, charset);
                        urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    }
                    postMethod.setEntity((HttpEntity)urlEncodedEntity);
                } else {
                    body = StringUtils.defaultString((String)webRequest.getRequestBody());
                    StringEntity urlEncodedEntity = new StringEntity((String)body, charset);
                    urlEncodedEntity.setContentType("application/x-www-form-urlencoded");
                    postMethod.setEntity((HttpEntity)urlEncodedEntity);
                }
            } else if (webRequest.getEncodingType() == FormEncodingType.TEXT_PLAIN && method instanceof HttpPost) {
                StringEntity bodyEntity;
                postMethod = (HttpPost)method;
                if (webRequest.getRequestBody() == null) {
                    body = new StringBuilder();
                    for (NameValuePair pair : webRequest.getRequestParameters()) {
                        ((StringBuilder)body).append(StringUtils.remove((String)StringUtils.remove((String)pair.getName(), (char)'\r'), (char)'\n')).append("=").append(StringUtils.remove((String)StringUtils.remove((String)pair.getValue(), (char)'\r'), (char)'\n')).append("\r\n");
                    }
                    bodyEntity = new StringEntity(((StringBuilder)body).toString(), charset);
                    bodyEntity.setContentType("text/plain");
                    postMethod.setEntity((HttpEntity)bodyEntity);
                } else {
                    body = StringUtils.defaultString((String)webRequest.getRequestBody());
                    bodyEntity = new StringEntity((String)body, ContentType.create((String)"text/plain", (Charset)charset));
                    postMethod.setEntity((HttpEntity)bodyEntity);
                }
            } else if (FormEncodingType.MULTIPART == webRequest.getEncodingType()) {
                Charset c = HttpWebConnection.getCharset(charset, webRequest.getRequestParameters());
                MultipartEntityBuilder builder = MultipartEntityBuilder.create().setLaxMode();
                builder.setCharset(c);
                for (NameValuePair pair : webRequest.getRequestParameters()) {
                    if (pair instanceof KeyDataPair) {
                        this.buildFilePart((KeyDataPair)pair, builder);
                        continue;
                    }
                    builder.addTextBody(pair.getName(), pair.getValue(), ContentType.create((String)"text/plain", (Charset)charset));
                }
                method.setEntity(builder.build());
            } else {
                String body2 = webRequest.getRequestBody();
                if (body2 != null) {
                    method.setEntity((HttpEntity)new StringEntity(body2, charset));
                }
            }
        }
        this.configureHttpProcessorBuilder(httpClientBuilder, webRequest);
        CredentialsProvider credentialsProvider = this.webClient_.getCredentialsProvider();
        Credentials requestUrlCredentials = webRequest.getUrlCredentials();
        if (null != requestUrlCredentials && this.webClient_.getBrowserVersion().hasFeature(BrowserVersionFeatures.URL_AUTH_CREDENTIALS)) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestUrlCredentials);
        }
        if (null != (requestCredentials = webRequest.getCredentials())) {
            URL requestUrl = webRequest.getUrl();
            AuthScope authScope = new AuthScope(requestUrl.getHost(), requestUrl.getPort());
            credentialsProvider.setCredentials(authScope, requestCredentials);
        }
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        httpContext.removeAttribute("http.auth.credentials-provider");
        httpContext.removeAttribute("http.auth.target-scope");
        return httpMethod;
    }

    private static String escapeQuery(String query) {
        if (query == null) {
            return null;
        }
        return query.replace("%%", "%25%25");
    }

    private static Charset getCharset(Charset charset, List<NameValuePair> pairs) {
        for (NameValuePair pair : pairs) {
            KeyDataPair pairWithFile;
            if (!(pair instanceof KeyDataPair) || (pairWithFile = (KeyDataPair)pair).getData() != null || pairWithFile.getFile() == null) continue;
            String fileName = pairWithFile.getFile().getName();
            for (int i = 0; i < fileName.length(); ++i) {
                if (fileName.codePointAt(i) <= 127) continue;
                return charset;
            }
        }
        return null;
    }

    void buildFilePart(KeyDataPair pairWithFile, MultipartEntityBuilder builder) {
        String mimeType = pairWithFile.getMimeType();
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        ContentType contentType = ContentType.create((String)mimeType);
        File file = pairWithFile.getFile();
        if (pairWithFile.getData() != null) {
            String filename = file == null ? pairWithFile.getValue() : (pairWithFile.getFileName() != null ? pairWithFile.getFileName() : file.getName());
            builder.addBinaryBody(pairWithFile.getName(), (InputStream)new ByteArrayInputStream(pairWithFile.getData()), contentType, filename);
            return;
        }
        if (file == null) {
            builder.addPart(pairWithFile.getName(), (ContentBody)new InputStreamBody(new ByteArrayInputStream(new byte[0]), contentType, pairWithFile.getValue()){

                public long getContentLength() {
                    return 0L;
                }
            });
            return;
        }
        String filename = pairWithFile.getFile() == null ? pairWithFile.getValue() : (pairWithFile.getFileName() != null ? pairWithFile.getFileName() : pairWithFile.getFile().getName());
        builder.addBinaryBody(pairWithFile.getName(), pairWithFile.getFile(), contentType, filename);
    }

    private static HttpRequestBase buildHttpMethod(HttpMethod submitMethod, URI uri) {
        HttpGet method;
        switch (submitMethod) {
            case GET: {
                method = new HttpGet(uri);
                break;
            }
            case POST: {
                method = new HttpPost(uri);
                break;
            }
            case PUT: {
                method = new HttpPut(uri);
                break;
            }
            case DELETE: {
                method = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                method = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                method = new HttpHead(uri);
                break;
            }
            case TRACE: {
                method = new HttpTrace(uri);
                break;
            }
            case PATCH: {
                method = new HttpPatch(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Submit method not yet supported: " + (Object)((Object)submitMethod));
            }
        }
        return method;
    }

    protected HttpClientBuilder getHttpClientBuilder() {
        Thread currentThread = Thread.currentThread();
        HttpClientBuilder builder = this.httpClientBuilder_.get(currentThread);
        if (builder == null) {
            builder = this.createHttpClientBuilder();
            RegistryBuilder registeryBuilder = RegistryBuilder.create().register(HACKED_COOKIE_POLICY, (Object)this.htmlUnitCookieSpecProvider_);
            builder.setDefaultCookieSpecRegistry((Lookup)registeryBuilder.build());
            builder.setDefaultCookieStore((CookieStore)new HtmlUnitCookieStore(this.webClient_.getCookieManager()));
            builder.setUserAgent(this.webClient_.getBrowserVersion().getUserAgent());
            this.httpClientBuilder_.put(currentThread, builder);
        }
        return builder;
    }

    protected int getTimeout() {
        return this.webClient_.getOptions().getTimeout();
    }

    protected HttpClientBuilder createHttpClientBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setRedirectStrategy((RedirectStrategy)new HtmlUnitRedirectStrategie());
        this.configureTimeout(builder, this.getTimeout());
        this.configureHttpsScheme(builder);
        builder.setMaxConnPerRoute(6);
        builder.setConnectionManagerShared(true);
        return builder;
    }

    private void configureTimeout(HttpClientBuilder builder, int timeout) {
        InetAddress localAddress = this.webClient_.getOptions().getLocalAddress();
        RequestConfig.Builder requestBuilder = HttpWebConnection.createRequestConfigBuilder(timeout, localAddress);
        builder.setDefaultRequestConfig(requestBuilder.build());
        builder.setDefaultSocketConfig(HttpWebConnection.createSocketConfigBuilder(timeout).build());
        this.getHttpContext().removeAttribute("http.request-config");
        this.usedOptions_.setTimeout(timeout);
    }

    private static RequestConfig.Builder createRequestConfigBuilder(int timeout, InetAddress localAddress) {
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setCookieSpec(HACKED_COOKIE_POLICY).setRedirectsEnabled(false).setLocalAddress(localAddress).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout);
        return requestBuilder;
    }

    private static SocketConfig.Builder createSocketConfigBuilder(int timeout) {
        SocketConfig.Builder socketBuilder = SocketConfig.custom().setSoTimeout(timeout);
        return socketBuilder;
    }

    private HttpClientBuilder reconfigureHttpClientIfNeeded(HttpClientBuilder httpClientBuilder) {
        int timeout;
        WebClientOptions options = this.webClient_.getOptions();
        if (options.isUseInsecureSSL() != this.usedOptions_.isUseInsecureSSL() || options.getSSLClientCertificateStore() != this.usedOptions_.getSSLClientCertificateStore() || options.getSSLTrustStore() != this.usedOptions_.getSSLTrustStore() || options.getSSLClientCipherSuites() != this.usedOptions_.getSSLClientCipherSuites() || options.getSSLClientProtocols() != this.usedOptions_.getSSLClientProtocols() || options.getProxyConfig() != this.usedOptions_.getProxyConfig()) {
            this.configureHttpsScheme(httpClientBuilder);
            if (this.connectionManager_ != null) {
                this.connectionManager_.shutdown();
                this.connectionManager_ = null;
            }
        }
        if ((timeout = this.getTimeout()) != this.usedOptions_.getTimeout()) {
            this.configureTimeout(httpClientBuilder, timeout);
        }
        if (this.connectionManager_ == null) {
            this.connectionManager_ = HttpWebConnection.createConnectionManager(httpClientBuilder);
        }
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.connectionManager_);
        return httpClientBuilder;
    }

    private void configureHttpsScheme(HttpClientBuilder builder) {
        WebClientOptions options = this.webClient_.getOptions();
        SSLConnectionSocketFactory socketFactory = HtmlUnitSSLConnectionSocketFactory.buildSSLSocketFactory(options);
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory);
        this.usedOptions_.setUseInsecureSSL(options.isUseInsecureSSL());
        this.usedOptions_.setSSLClientCertificateStore(options.getSSLClientCertificateStore());
        this.usedOptions_.setSSLTrustStore(options.getSSLTrustStore());
        this.usedOptions_.setSSLClientCipherSuites(options.getSSLClientCipherSuites());
        this.usedOptions_.setSSLClientProtocols(options.getSSLClientProtocols());
        this.usedOptions_.setProxyConfig(options.getProxyConfig());
    }

    private void configureHttpProcessorBuilder(HttpClientBuilder builder, WebRequest webRequest) {
        HttpProcessorBuilder b = HttpProcessorBuilder.create();
        for (HttpRequestInterceptor i : this.getHttpRequestInterceptors(webRequest)) {
            b.add(i);
        }
        b.addAll(new HttpRequestInterceptor[]{new RequestDefaultHeaders(null), new RequestContent(), new RequestTargetHost(), new RequestExpectContinue()});
        b.add((HttpRequestInterceptor)new RequestAcceptEncoding());
        b.add((HttpRequestInterceptor)new RequestAuthCache());
        b.add((HttpResponseInterceptor)new ResponseProcessCookies());
        builder.setHttpProcessor(b.build());
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost_ = virtualHost;
    }

    public String getVirtualHost() {
        return this.virtualHost_;
    }

    private WebResponse makeWebResponse(HttpResponse httpResponse, WebRequest request, DownloadedContent responseBody, long loadTime) {
        String statusMessage = httpResponse.getStatusLine().getReasonPhrase();
        if (statusMessage == null) {
            statusMessage = "Unknown status message";
        }
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        for (Header header : httpResponse.getAllHeaders()) {
            headers.add(new NameValuePair(header.getName(), header.getValue()));
        }
        WebResponseData responseData = new WebResponseData(responseBody, statusCode, statusMessage, headers);
        return this.newWebResponseInstance(responseData, loadTime, request);
    }

    protected DownloadedContent downloadResponseBody(HttpResponse httpResponse) throws IOException {
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity == null) {
            return new DownloadedContent.InMemory(null);
        }
        try (InputStream is = httpEntity.getContent();){
            DownloadedContent downloadedContent = HttpWebConnection.downloadContent(is, this.webClient_.getOptions().getMaxInMemory());
            return downloadedContent;
        }
    }

    /*
     * Loose catch block
     */
    public static DownloadedContent downloadContent(InputStream is, int maxInMemory) throws IOException {
        if (is == null) {
            return new DownloadedContent.InMemory(null);
        }
        Throwable throwable = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] buffer = new byte[1024];
            try {
                int nbRead;
                while ((nbRead = is.read(buffer)) != -1) {
                    bos.write(buffer, 0, nbRead);
                    if (bos.size() <= maxInMemory) continue;
                    File file = File.createTempFile("htmlunit", ".tmp");
                    file.deleteOnExit();
                    try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                        bos.writeTo(fos);
                        IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
                    }
                    DownloadedContent.OnFile onFile = new DownloadedContent.OnFile(file, true);
                    return onFile;
                }
            }
            catch (ConnectionClosedException e) {
                LOG.warn((Object)"Connection was closed while reading from stream.", (Throwable)e);
                DownloadedContent.InMemory inMemory = new DownloadedContent.InMemory(bos.toByteArray());
                return inMemory;
            }
            catch (EOFException e) {
                DownloadedContent.InMemory inMemory;
                block39: {
                    block40: {
                        LOG.warn((Object)"EOFException while reading from stream.", (Throwable)e);
                        inMemory = new DownloadedContent.InMemory(bos.toByteArray());
                        if (bos == null) break block39;
                        if (throwable == null) break block40;
                        try {
                            bos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block39;
                    }
                    bos.close();
                }
                return inMemory;
            }
            DownloadedContent.InMemory inMemory = new DownloadedContent.InMemory(bos.toByteArray());
            return inMemory;
            {
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    protected WebResponse newWebResponseInstance(WebResponseData responseData, long loadTime, WebRequest request) {
        return new WebResponse(responseData, request, loadTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HttpRequestInterceptor> getHttpRequestInterceptors(WebRequest webRequest) {
        ArrayList<HttpRequestInterceptor> list = new ArrayList<HttpRequestInterceptor>();
        Map<String, String> requestHeaders = webRequest.getAdditionalHeaders();
        URL url = webRequest.getUrl();
        StringBuilder host = new StringBuilder(url.getHost());
        int port = url.getPort();
        if (port > 0 && port != url.getDefaultPort()) {
            host.append(':');
            host.append(Integer.toString(port));
        }
        String userAgent = this.webClient_.getBrowserVersion().getUserAgent();
        String[] headerNames = this.webClient_.getBrowserVersion().getHeaderNamesOrdered();
        if (headerNames != null) {
            for (String header : headerNames) {
                String headerValue;
                if ("Host".equals(header)) {
                    list.add(new HostHeaderHttpRequestInterceptor(host.toString()));
                    continue;
                }
                if ("User-Agent".equals(header)) {
                    list.add(new UserAgentHeaderHttpRequestInterceptor(userAgent));
                    continue;
                }
                if ("Accept".equals(header)) {
                    headerValue = webRequest.getAdditionalHeader(header);
                    if (headerValue == null) continue;
                    list.add(new AcceptHeaderHttpRequestInterceptor(headerValue));
                    continue;
                }
                if ("Accept-Language".equals(header)) {
                    headerValue = webRequest.getAdditionalHeader(header);
                    if (headerValue == null) continue;
                    list.add(new AcceptLanguageHeaderHttpRequestInterceptor(headerValue));
                    continue;
                }
                if ("Accept-Encoding".equals(header)) {
                    headerValue = webRequest.getAdditionalHeader(header);
                    if (headerValue == null) continue;
                    list.add(new AcceptEncodingHeaderHttpRequestInterceptor(headerValue));
                    continue;
                }
                if ("Sec-Fetch-Dest".equals(header)) {
                    headerValue = webRequest.getAdditionalHeader(header);
                    if (headerValue == null) continue;
                    list.add(new SecFetchDestHeaderHttpRequestInterceptor(headerValue));
                    continue;
                }
                if ("Sec-Fetch-Mode".equals(header)) {
                    headerValue = webRequest.getAdditionalHeader(header);
                    if (headerValue == null) continue;
                    list.add(new SecFetchModeHeaderHttpRequestInterceptor(headerValue));
                    continue;
                }
                if ("Sec-Fetch-Site".equals(header)) {
                    headerValue = webRequest.getAdditionalHeader(header);
                    if (headerValue == null) continue;
                    list.add(new SecFetchSiteHeaderHttpRequestInterceptor(headerValue));
                    continue;
                }
                if ("Sec-Fetch-User".equals(header)) {
                    headerValue = webRequest.getAdditionalHeader(header);
                    if (headerValue == null) continue;
                    list.add(new SecFetchUserHeaderHttpRequestInterceptor(headerValue));
                    continue;
                }
                if ("Upgrade-Insecure-Requests".equals(header)) {
                    headerValue = webRequest.getAdditionalHeader(header);
                    if (headerValue == null) continue;
                    list.add(new UpgradeInsecureRequestHeaderHttpRequestInterceptor(headerValue));
                    continue;
                }
                if ("Referer".equals(header)) {
                    headerValue = webRequest.getAdditionalHeader(header);
                    if (headerValue == null) continue;
                    list.add(new RefererHeaderHttpRequestInterceptor(headerValue));
                    continue;
                }
                if ("Connection".equals(header)) {
                    list.add((HttpRequestInterceptor)new RequestClientConnControl());
                    continue;
                }
                if ("Cookie".equals(header)) {
                    list.add((HttpRequestInterceptor)new RequestAddCookies());
                    continue;
                }
                if (!"DNT".equals(header) || !this.webClient_.getOptions().isDoNotTrackEnabled()) continue;
                list.add(new DntHeaderHttpRequestInterceptor("1"));
            }
        } else {
            list.add(new UserAgentHeaderHttpRequestInterceptor(userAgent));
            list.add((HttpRequestInterceptor)new RequestAddCookies());
            list.add((HttpRequestInterceptor)new RequestClientConnControl());
        }
        if (this.webClient_.getOptions().isDoNotTrackEnabled()) {
            list.add(new DntHeaderHttpRequestInterceptor("1"));
        }
        Map<String, String> map = requestHeaders;
        synchronized (map) {
            list.add(new MultiHttpRequestInterceptor(new HashMap<String, String>(requestHeaders)));
        }
        return list;
    }

    @Override
    public void close() {
        this.httpClientBuilder_.clear();
        if (this.connectionManager_ != null) {
            this.connectionManager_.shutdown();
            this.connectionManager_ = null;
        }
    }

    private static PoolingHttpClientConnectionManager createConnectionManager(HttpClientBuilder builder) {
        try {
            String s;
            PublicSuffixMatcher publicSuffixMatcher = (PublicSuffixMatcher)HttpWebConnection.getField(builder, "publicSuffixMatcher");
            if (publicSuffixMatcher == null) {
                publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
            }
            LayeredConnectionSocketFactory sslSocketFactory = (LayeredConnectionSocketFactory)HttpWebConnection.getField(builder, "sslSocketFactory");
            SocketConfig defaultSocketConfig = (SocketConfig)HttpWebConnection.getField(builder, "defaultSocketConfig");
            ConnectionConfig defaultConnectionConfig = (ConnectionConfig)HttpWebConnection.getField(builder, "defaultConnectionConfig");
            boolean systemProperties = (Boolean)HttpWebConnection.getField(builder, "systemProperties");
            int maxConnTotal = (Integer)HttpWebConnection.getField(builder, "maxConnTotal");
            int maxConnPerRoute = (Integer)HttpWebConnection.getField(builder, "maxConnPerRoute");
            HostnameVerifier hostnameVerifier = (HostnameVerifier)HttpWebConnection.getField(builder, "hostnameVerifier");
            SSLContext sslcontext = (SSLContext)HttpWebConnection.getField(builder, "sslContext");
            DnsResolver dnsResolver = (DnsResolver)HttpWebConnection.getField(builder, "dnsResolver");
            long connTimeToLive = (Long)HttpWebConnection.getField(builder, "connTimeToLive");
            TimeUnit connTimeToLiveTimeUnit = (TimeUnit)((Object)HttpWebConnection.getField(builder, "connTimeToLiveTimeUnit"));
            if (sslSocketFactory == null) {
                String[] supportedCipherSuites;
                String[] supportedProtocols = systemProperties ? HttpWebConnection.split(System.getProperty("https.protocols")) : null;
                String[] stringArray = supportedCipherSuites = systemProperties ? HttpWebConnection.split(System.getProperty("https.cipherSuites")) : null;
                if (hostnameVerifier == null) {
                    hostnameVerifier = new DefaultHostnameVerifier(publicSuffixMatcher);
                }
                sslSocketFactory = sslcontext != null ? new SSLConnectionSocketFactory(sslcontext, supportedProtocols, supportedCipherSuites, hostnameVerifier) : (systemProperties ? new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), supportedProtocols, supportedCipherSuites, hostnameVerifier) : new SSLConnectionSocketFactory(SSLContexts.createDefault(), hostnameVerifier));
            }
            PoolingHttpClientConnectionManager poolingmgr = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)new SocksConnectionSocketFactory()).register("https", (Object)sslSocketFactory).build(), null, null, dnsResolver, connTimeToLive, connTimeToLiveTimeUnit != null ? connTimeToLiveTimeUnit : TimeUnit.MILLISECONDS);
            if (defaultSocketConfig != null) {
                poolingmgr.setDefaultSocketConfig(defaultSocketConfig);
            }
            if (defaultConnectionConfig != null) {
                poolingmgr.setDefaultConnectionConfig(defaultConnectionConfig);
            }
            if (systemProperties && "true".equalsIgnoreCase(s = System.getProperty("http.keepAlive", "true"))) {
                s = System.getProperty("http.maxConnections", "5");
                int max = Integer.parseInt(s);
                poolingmgr.setDefaultMaxPerRoute(max);
                poolingmgr.setMaxTotal(2 * max);
            }
            if (maxConnTotal > 0) {
                poolingmgr.setMaxTotal(maxConnTotal);
            }
            if (maxConnPerRoute > 0) {
                poolingmgr.setDefaultMaxPerRoute(maxConnPerRoute);
            }
            return poolingmgr;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(" *, *");
    }

    private static <T> T getField(Object target, String fieldName) throws IllegalAccessException {
        return (T)FieldUtils.readDeclaredField((Object)target, (String)fieldName, (boolean)true);
    }

    private static final class SynchronizedAuthCache
    extends BasicAuthCache {
        private SynchronizedAuthCache() {
        }

        public synchronized void put(HttpHost host, AuthScheme authScheme) {
            super.put(host, authScheme);
        }

        public synchronized AuthScheme get(HttpHost host) {
            return super.get(host);
        }

        public synchronized void remove(HttpHost host) {
            super.remove(host);
        }

        public synchronized void clear() {
            super.clear();
        }

        public synchronized String toString() {
            return super.toString();
        }
    }

    private static class MultiHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private final Map<String, String> map_;

        MultiHttpRequestInterceptor(Map<String, String> map) {
            this.map_ = map;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            for (Map.Entry<String, String> entry : this.map_.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private static final class SecFetchDestHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        SecFetchDestHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Sec-Fetch-Dest", this.value_);
        }
    }

    private static final class SecFetchUserHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        SecFetchUserHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Sec-Fetch-User", this.value_);
        }
    }

    private static final class SecFetchSiteHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        SecFetchSiteHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Sec-Fetch-Site", this.value_);
        }
    }

    private static final class SecFetchModeHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        SecFetchModeHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Sec-Fetch-Mode", this.value_);
        }
    }

    private static final class DntHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        DntHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("DNT", this.value_);
        }
    }

    private static final class RefererHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        RefererHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Referer", this.value_);
        }
    }

    private static final class AcceptEncodingHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        AcceptEncodingHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Accept-Encoding", this.value_);
        }
    }

    private static final class UpgradeInsecureRequestHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        UpgradeInsecureRequestHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Upgrade-Insecure-Requests", this.value_);
        }
    }

    private static final class AcceptLanguageHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        AcceptLanguageHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Accept-Language", this.value_);
        }
    }

    private static final class AcceptHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        AcceptHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Accept", this.value_);
        }
    }

    private static final class UserAgentHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        UserAgentHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("User-Agent", this.value_);
        }
    }

    private static final class HostHeaderHttpRequestInterceptor
    implements HttpRequestInterceptor {
        private String value_;

        HostHeaderHttpRequestInterceptor(String value) {
            this.value_ = value;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.setHeader("Host", this.value_);
        }
    }
}

