/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering;

import com.gargoylesoftware.htmlunit.javascript.host.canvas.ImageData;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.Path2D;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.RenderingBackend;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwtRenderingBackend
implements RenderingBackend {
    private static final Log LOG = LogFactory.getLog(AwtRenderingBackend.class);
    private static final Map<String, Color> knownColors = new HashMap<String, Color>();
    private final BufferedImage image_;
    private final Graphics2D graphics2D_;
    private AffineTransform transformation_;
    private float globalAlpha_;
    private int lineWidth_;
    private Color fillColor_;
    private Color strokeColor_;
    private List<java.awt.geom.Path2D> subPaths_;
    private Deque<SaveState> savedStates_;

    public AwtRenderingBackend(int imageWidth, int imageHeight) {
        this.image_ = new BufferedImage(imageWidth, imageHeight, 2);
        this.graphics2D_ = this.image_.createGraphics();
        this.graphics2D_.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics2D_.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics2D_.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.reset();
        this.graphics2D_.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.graphics2D_.setColor(Color.black);
        this.graphics2D_.clearRect(0, 0, imageWidth, imageHeight);
        this.subPaths_ = new ArrayList<java.awt.geom.Path2D>();
        this.savedStates_ = new ArrayDeque<SaveState>();
    }

    private void reset() {
        this.fillColor_ = Color.black;
        this.strokeColor_ = Color.black;
        this.lineWidth_ = 1;
        this.transformation_ = new AffineTransform();
        this.setGlobalAlpha(1.0);
    }

    @Override
    public double getGlobalAlpha() {
        return this.globalAlpha_;
    }

    @Override
    public void setGlobalAlpha(double globalAlpha) {
        if (globalAlpha >= 0.0 && globalAlpha <= 1.0) {
            this.globalAlpha_ = (float)globalAlpha;
            AlphaComposite composite = AlphaComposite.getInstance(3, this.globalAlpha_);
            this.graphics2D_.setComposite(composite);
        }
    }

    @Override
    public void beginPath() {
        this.subPaths_.clear();
    }

    @Override
    public void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        java.awt.geom.Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            double startAngleDegree = 360.0 - startAngle * 180.0 / Math.PI;
            double endAngleDegree = 360.0 - endAngle * 180.0 / Math.PI;
            double extendAngle = startAngleDegree - endAngleDegree;
            extendAngle = Math.min(360.0, Math.abs(extendAngle));
            if (anticlockwise && extendAngle < 360.0) {
                extendAngle -= 360.0;
            }
            AffineTransform transformation = new AffineTransform();
            transformation.rotate(rotation, p.getX(), p.getY());
            Arc2D.Double arc = new Arc2D.Double(p.getX() - radiusX, p.getY() - radiusY, radiusX * 2.0, radiusY * 2.0, startAngleDegree, extendAngle * -1.0, 0);
            subPath.append(transformation.createTransformedShape(arc), false);
        }
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        java.awt.geom.Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D cp1 = this.transformation_.transform(new Point2D.Double(cp1x, cp1y), null);
            Point2D cp2 = this.transformation_.transform(new Point2D.Double(cp2x, cp2y), null);
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            subPath.curveTo(cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), p.getX(), p.getY());
        }
    }

    @Override
    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        java.awt.geom.Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            double startAngleDegree = 360.0 - startAngle * 180.0 / Math.PI;
            double endAngleDegree = 360.0 - endAngle * 180.0 / Math.PI;
            double extendAngle = startAngleDegree - endAngleDegree;
            extendAngle = Math.min(360.0, Math.abs(extendAngle));
            if (anticlockwise && extendAngle < 360.0) {
                extendAngle -= 360.0;
            }
            Arc2D.Double arc = new Arc2D.Double(p.getX() - radius, p.getY() - radius, radius * 2.0, radius * 2.0, startAngleDegree, extendAngle * -1.0, 0);
            subPath.append(arc, false);
        }
    }

    @Override
    public void clearRect(int x, int y, int w, int h) {
        this.graphics2D_.setTransform(this.transformation_);
        this.graphics2D_.setColor(this.fillColor_);
        this.graphics2D_.clearRect(x, y, w, h);
    }

    @Override
    public void drawImage(ImageReader imageReader, int dxI, int dyI) throws IOException {
        if (imageReader.getNumImages(true) != 0) {
            BufferedImage img = imageReader.read(0);
            this.graphics2D_.setTransform(this.transformation_);
            this.graphics2D_.setColor(this.fillColor_);
            this.graphics2D_.drawImage(img, dxI, dyI, this.image_.getWidth(), this.image_.getHeight(), null);
        }
    }

    @Override
    public String encodeToString(String type) throws IOException {
        String imageType = type;
        if (imageType != null && imageType.startsWith("image/")) {
            imageType = imageType.substring(6);
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)this.image_, imageType, bos);
            byte[] imageBytes = bos.toByteArray();
            String string = new String(new Base64().encode(imageBytes), StandardCharsets.US_ASCII);
            return string;
        }
    }

    @Override
    public void fill() {
        this.graphics2D_.setTransform(new AffineTransform());
        this.graphics2D_.setStroke(new BasicStroke(this.getLineWidth()));
        this.graphics2D_.setColor(this.fillColor_);
        for (java.awt.geom.Path2D path2d : this.subPaths_) {
            this.graphics2D_.fill(path2d);
        }
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        this.graphics2D_.setTransform(this.transformation_);
        this.graphics2D_.setColor(this.fillColor_);
        this.graphics2D_.fillRect(x, y, w, h);
    }

    @Override
    public void fillText(String text, int x, int y) {
        this.graphics2D_.setTransform(new AffineTransform());
        FontMetrics metrics = this.graphics2D_.getFontMetrics();
        int width = metrics.stringWidth(text);
        int ascent = metrics.getAscent();
        float posX = x - width / 2;
        float posY = y + ascent / 2;
        this.graphics2D_.setTransform(this.transformation_);
        this.graphics2D_.setColor(this.fillColor_);
        this.graphics2D_.drawString(text, posX, posY);
    }

    @Override
    public byte[] getBytes(int width, int height, int sx, int sy) {
        byte[] array = new byte[width * height * 4];
        int index = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = this.image_.getRGB(sx + x, sy + y);
                array[index++] = (byte)((color & 0xFF0000) >> 16);
                array[index++] = (byte)((color & 0xFF00) >> 8);
                array[index++] = (byte)(color & 0xFF);
                array[index++] = (byte)((color & 0xFF000000) >>> 24);
            }
        }
        return array;
    }

    @Override
    public void lineTo(double x, double y) {
        java.awt.geom.Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            subPath.lineTo(p.getX(), p.getY());
        }
    }

    @Override
    public void moveTo(double x, double y) {
        Path2D.Double subPath = new Path2D.Double();
        Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
        ((java.awt.geom.Path2D)subPath).moveTo(p.getX(), p.getY());
        this.subPaths_.add(subPath);
    }

    @Override
    public void putImageData(ImageData imageData, int dx, int dy, int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
        Color orgColor = this.graphics2D_.getColor();
        int width = dx + imageData.getWidth();
        int height = dy + imageData.getHeight();
        int imageWidth = dirtyX + dirtyWidth;
        int imageHeight = dirtyY + dirtyHeight;
        byte[] bytes = imageData.getData().getBuffer().getBuffer();
        int byteIdx = 0;
        int imageX = 0;
        int imageY = 0;
        for (int insertY = dy; insertY < height; ++insertY) {
            for (int insertX = dx; insertX < width; ++insertX) {
                if (0 <= insertX && insertX < this.image_.getWidth() && 0 <= insertY && insertY < this.image_.getHeight() && dirtyX <= imageX && imageX < imageWidth && dirtyY <= imageY && imageY < imageHeight) {
                    int r = bytes[byteIdx++] & 0xFF;
                    int g = bytes[byteIdx++] & 0xFF;
                    int b = bytes[byteIdx++] & 0xFF;
                    int a = bytes[byteIdx++] & 0xFF;
                    Color color = new Color(r, g, b, a);
                    this.graphics2D_.setColor(color);
                    this.graphics2D_.drawLine(insertX, insertY, insertX, insertY);
                } else {
                    byteIdx += 4;
                }
                if (++imageX != imageData.getWidth()) continue;
                imageX = 0;
                ++imageY;
            }
        }
        this.graphics2D_.setColor(orgColor);
    }

    @Override
    public void quadraticCurveTo(double cpx, double cpy, double x, double y) {
        java.awt.geom.Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D cp = this.transformation_.transform(new Point2D.Double(cpx, cpy), null);
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            subPath.quadTo(cp.getX(), cp.getY(), p.getX(), p.getY());
        }
    }

    @Override
    public void rect(double x, double y, double w, double h) {
        java.awt.geom.Path2D subPath = this.getCurrentSubPath();
        if (subPath != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            Rectangle2D.Double rect = new Rectangle2D.Double(p.getX(), p.getY(), w, h);
            subPath.append(rect, false);
        }
    }

    @Override
    public void setFillStyle(String fillStyle) {
        this.fillColor_ = this.extractColor(fillStyle);
    }

    @Override
    public void setStrokeStyle(String strokeStyle) {
        this.strokeColor_ = this.extractColor(strokeStyle);
    }

    private Color extractColor(String style) {
        String tmpStyle = style.replaceAll("\\s", "");
        Color color = StringUtils.findColorRGB(tmpStyle);
        if (color == null) {
            color = StringUtils.findColorRGBA(tmpStyle);
        }
        if (color == null) {
            color = StringUtils.findColorHSL(tmpStyle);
        }
        if (color == null) {
            if (tmpStyle.length() > 0 && tmpStyle.charAt(0) == '#') {
                color = StringUtils.asColorHexadecimal(tmpStyle);
            } else {
                color = knownColors.get(tmpStyle.toLowerCase(Locale.ROOT));
                if (color == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Can not find color '" + tmpStyle + '\''));
                    }
                    color = Color.black;
                }
            }
        }
        return color;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth_;
    }

    @Override
    public void restore() {
        if (this.savedStates_.isEmpty()) {
            return;
        }
        this.savedStates_.pop().applyOn(this);
    }

    @Override
    public void rotate(double angle) {
        this.transformation_.rotate(angle);
    }

    @Override
    public void save() {
        this.savedStates_.push(new SaveState(this));
        this.reset();
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.lineWidth_ = lineWidth;
    }

    @Override
    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.transformation_ = new AffineTransform(m11, m12, m21, m22, dx, dy);
    }

    @Override
    public void stroke() {
        this.graphics2D_.setTransform(new AffineTransform());
        this.graphics2D_.setStroke(new BasicStroke(this.getLineWidth()));
        this.graphics2D_.setColor(this.strokeColor_);
        for (java.awt.geom.Path2D path2d : this.subPaths_) {
            this.graphics2D_.draw(path2d);
        }
    }

    @Override
    public void strokeRect(int x, int y, int w, int h) {
        this.graphics2D_.setTransform(this.transformation_);
        this.graphics2D_.setColor(this.strokeColor_);
        this.graphics2D_.drawRect(x, y, w, h);
    }

    @Override
    public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.transformation_.concatenate(new AffineTransform(m11, m12, m21, m22, dx, dy));
    }

    @Override
    public void translate(int x, int y) {
        this.transformation_.translate(x, y);
    }

    @Override
    public void clip(RenderingBackend.WindingRule windingRule, Path2D path) {
        if (path == null && this.subPaths_.isEmpty()) {
            this.graphics2D_.setClip(null);
            return;
        }
        java.awt.geom.Path2D currentPath = path == null ? this.subPaths_.get(this.subPaths_.size() - 1) : null;
        currentPath.closePath();
        switch (windingRule) {
            case NON_ZERO: {
                currentPath.setWindingRule(1);
                break;
            }
            default: {
                currentPath.setWindingRule(0);
            }
        }
        this.graphics2D_.clip(currentPath);
    }

    @Override
    public void closePath() {
        if (this.subPaths_.isEmpty()) {
            return;
        }
        this.subPaths_.get(this.subPaths_.size() - 1).closePath();
    }

    private java.awt.geom.Path2D getCurrentSubPath() {
        if (this.subPaths_.isEmpty()) {
            Path2D.Double subPath = new Path2D.Double();
            this.subPaths_.add(subPath);
            return subPath;
        }
        return this.subPaths_.get(this.subPaths_.size() - 1);
    }

    static {
        knownColors.put("black", Color.decode("#000000"));
        knownColors.put("silver", Color.decode("#c0c0c0"));
        knownColors.put("gray", Color.decode("#808080"));
        knownColors.put("white", Color.decode("#ffffff"));
        knownColors.put("maroon", Color.decode("#800000"));
        knownColors.put("red", Color.decode("#ff0000"));
        knownColors.put("purple", Color.decode("#800080"));
        knownColors.put("fuchsia", Color.decode("#ff00ff"));
        knownColors.put("green", Color.decode("#008000"));
        knownColors.put("lime", Color.decode("#00ff00"));
        knownColors.put("olive", Color.decode("#808000"));
        knownColors.put("yellow", Color.decode("#ffff00"));
        knownColors.put("navy", Color.decode("#000080"));
        knownColors.put("blue", Color.decode("#0000ff"));
        knownColors.put("teal", Color.decode("#008080"));
        knownColors.put("aqua", Color.decode("#00ffff"));
        knownColors.put("orange", Color.decode("#ffa500"));
        knownColors.put("aliceblue", Color.decode("#f0f8ff"));
        knownColors.put("antiquewhite", Color.decode("#faebd7"));
        knownColors.put("aquamarine", Color.decode("#7fffd4"));
        knownColors.put("azure", Color.decode("#f0ffff"));
        knownColors.put("beige", Color.decode("#f5f5dc"));
        knownColors.put("bisque", Color.decode("#ffe4c4"));
        knownColors.put("blanchedalmond", Color.decode("#ffebcd"));
        knownColors.put("blueviolet", Color.decode("#8a2be2"));
        knownColors.put("brown", Color.decode("#a52a2a"));
        knownColors.put("burlywood", Color.decode("#deb887"));
        knownColors.put("cadetblue", Color.decode("#5f9ea0"));
        knownColors.put("chartreuse", Color.decode("#7fff00"));
        knownColors.put("chocolate", Color.decode("#d2691e"));
        knownColors.put("coral", Color.decode("#ff7f50"));
        knownColors.put("cornflowerblue", Color.decode("#6495ed"));
        knownColors.put("cornsilk", Color.decode("#fff8dc"));
        knownColors.put("crimson", Color.decode("#dc143c"));
        knownColors.put("cyan", Color.decode("#00ffff"));
        knownColors.put("darkblue", Color.decode("#00008b"));
        knownColors.put("darkcyan", Color.decode("#008b8b"));
        knownColors.put("darkgoldenrod", Color.decode("#b8860b"));
        knownColors.put("darkgray", Color.decode("#a9a9a9"));
        knownColors.put("darkgreen", Color.decode("#006400"));
        knownColors.put("darkgrey", Color.decode("#a9a9a9"));
        knownColors.put("darkkhaki", Color.decode("#bdb76b"));
        knownColors.put("darkmagenta", Color.decode("#8b008b"));
        knownColors.put("darkolivegreen", Color.decode("#556b2f"));
        knownColors.put("darkorange", Color.decode("#ff8c00"));
        knownColors.put("darkorchid", Color.decode("#9932cc"));
        knownColors.put("darkred", Color.decode("#8b0000"));
        knownColors.put("darksalmon", Color.decode("#e9967a"));
        knownColors.put("darkseagreen", Color.decode("#8fbc8f"));
        knownColors.put("darkslateblue", Color.decode("#483d8b"));
        knownColors.put("darkslategray", Color.decode("#2f4f4f"));
        knownColors.put("darkslategrey", Color.decode("#2f4f4f"));
        knownColors.put("darkturquoise", Color.decode("#00ced1"));
        knownColors.put("darkviolet", Color.decode("#9400d3"));
        knownColors.put("deeppink", Color.decode("#ff1493"));
        knownColors.put("deepskyblue", Color.decode("#00bfff"));
        knownColors.put("dimgray", Color.decode("#696969"));
        knownColors.put("dimgrey", Color.decode("#696969"));
        knownColors.put("dodgerblue", Color.decode("#1e90ff"));
        knownColors.put("firebrick", Color.decode("#b22222"));
        knownColors.put("floralwhite", Color.decode("#fffaf0"));
        knownColors.put("forestgreen", Color.decode("#228b22"));
        knownColors.put("gainsboro", Color.decode("#dcdcdc"));
        knownColors.put("ghostwhite", Color.decode("#f8f8ff"));
        knownColors.put("gold", Color.decode("#ffd700"));
        knownColors.put("goldenrod", Color.decode("#daa520"));
        knownColors.put("greenyellow", Color.decode("#adff2f"));
        knownColors.put("grey", Color.decode("#808080"));
        knownColors.put("honeydew", Color.decode("#f0fff0"));
        knownColors.put("hotpink", Color.decode("#ff69b4"));
        knownColors.put("indianred", Color.decode("#cd5c5c"));
        knownColors.put("indigo", Color.decode("#4b0082"));
        knownColors.put("ivory", Color.decode("#fffff0"));
        knownColors.put("khaki", Color.decode("#f0e68c"));
        knownColors.put("lavender", Color.decode("#e6e6fa"));
        knownColors.put("lavenderblush", Color.decode("#fff0f5"));
        knownColors.put("lawngreen", Color.decode("#7cfc00"));
        knownColors.put("lemonchiffon", Color.decode("#fffacd"));
        knownColors.put("lightblue", Color.decode("#add8e6"));
        knownColors.put("lightcoral", Color.decode("#f08080"));
        knownColors.put("lightcyan", Color.decode("#e0ffff"));
        knownColors.put("lightgoldenrodyellow", Color.decode("#fafad2"));
        knownColors.put("lightgray", Color.decode("#d3d3d3"));
        knownColors.put("lightgreen", Color.decode("#90ee90"));
        knownColors.put("lightgrey", Color.decode("#d3d3d3"));
        knownColors.put("lightpink", Color.decode("#ffb6c1"));
        knownColors.put("lightsalmon", Color.decode("#ffa07a"));
        knownColors.put("lightseagreen", Color.decode("#20b2aa"));
        knownColors.put("lightskyblue", Color.decode("#87cefa"));
        knownColors.put("lightslategray", Color.decode("#778899"));
        knownColors.put("lightslategrey", Color.decode("#778899"));
        knownColors.put("lightsteelblue", Color.decode("#b0c4de"));
        knownColors.put("lightyellow", Color.decode("#ffffe0"));
        knownColors.put("limegreen", Color.decode("#32cd32"));
        knownColors.put("linen", Color.decode("#faf0e6"));
        knownColors.put("magenta", Color.decode("#ff00ff"));
        knownColors.put("mediumaquamarine", Color.decode("#66cdaa"));
        knownColors.put("mediumblue", Color.decode("#0000cd"));
        knownColors.put("mediumorchid", Color.decode("#ba55d3"));
        knownColors.put("mediumpurple", Color.decode("#9370db"));
        knownColors.put("mediumseagreen", Color.decode("#3cb371"));
        knownColors.put("mediumslateblue", Color.decode("#7b68ee"));
        knownColors.put("mediumspringgreen", Color.decode("#00fa9a"));
        knownColors.put("mediumturquoise", Color.decode("#48d1cc"));
        knownColors.put("mediumvioletred", Color.decode("#c71585"));
        knownColors.put("midnightblue", Color.decode("#191970"));
        knownColors.put("mintcream", Color.decode("#f5fffa"));
        knownColors.put("mistyrose", Color.decode("#ffe4e1"));
        knownColors.put("moccasin", Color.decode("#ffe4b5"));
        knownColors.put("navajowhite", Color.decode("#ffdead"));
        knownColors.put("oldlace", Color.decode("#fdf5e6"));
        knownColors.put("olivedrab", Color.decode("#6b8e23"));
        knownColors.put("orangered", Color.decode("#ff4500"));
        knownColors.put("orchid", Color.decode("#da70d6"));
        knownColors.put("palegoldenrod", Color.decode("#eee8aa"));
        knownColors.put("palegreen", Color.decode("#98fb98"));
        knownColors.put("paleturquoise", Color.decode("#afeeee"));
        knownColors.put("palevioletred", Color.decode("#db7093"));
        knownColors.put("papayawhip", Color.decode("#ffefd5"));
        knownColors.put("peachpuff", Color.decode("#ffdab9"));
        knownColors.put("peru", Color.decode("#cd853f"));
        knownColors.put("pink", Color.decode("#ffc0cb"));
        knownColors.put("plum", Color.decode("#dda0dd"));
        knownColors.put("powderblue", Color.decode("#b0e0e6"));
        knownColors.put("rosybrown", Color.decode("#bc8f8f"));
        knownColors.put("royalblue", Color.decode("#4169e1"));
        knownColors.put("saddlebrown", Color.decode("#8b4513"));
        knownColors.put("salmon", Color.decode("#fa8072"));
        knownColors.put("sandybrown", Color.decode("#f4a460"));
        knownColors.put("seagreen", Color.decode("#2e8b57"));
        knownColors.put("seashell", Color.decode("#fff5ee"));
        knownColors.put("sienna", Color.decode("#a0522d"));
        knownColors.put("skyblue", Color.decode("#87ceeb"));
        knownColors.put("slateblue", Color.decode("#6a5acd"));
        knownColors.put("slategray", Color.decode("#708090"));
        knownColors.put("slategrey", Color.decode("#708090"));
        knownColors.put("snow", Color.decode("#fffafa"));
        knownColors.put("springgreen", Color.decode("#00ff7f"));
        knownColors.put("steelblue", Color.decode("#4682b4"));
        knownColors.put("tan", Color.decode("#d2b48c"));
        knownColors.put("thistle", Color.decode("#d8bfd8"));
        knownColors.put("tomato", Color.decode("#ff6347"));
        knownColors.put("turquoise", Color.decode("#40e0d0"));
        knownColors.put("violet", Color.decode("#ee82ee"));
        knownColors.put("wheat", Color.decode("#f5deb3"));
        knownColors.put("whitesmoke", Color.decode("#f5f5f5"));
        knownColors.put("yellowgreen", Color.decode("#9acd32"));
        knownColors.put("rebeccapurple", Color.decode("#663399"));
    }

    private static final class SaveState {
        private AffineTransform transformation_;
        private float globalAlpha_;
        private int lineWidth_;
        private Color fillColor_;
        private Color strokeColor_;

        private SaveState(AwtRenderingBackend backend) {
            this.transformation_ = backend.transformation_;
            this.globalAlpha_ = backend.globalAlpha_;
            this.lineWidth_ = backend.lineWidth_;
            this.fillColor_ = backend.fillColor_;
            this.strokeColor_ = backend.strokeColor_;
        }

        private void applyOn(AwtRenderingBackend backend) {
            backend.transformation_ = this.transformation_;
            backend.globalAlpha_ = this.globalAlpha_;
            backend.lineWidth_ = this.lineWidth_;
            backend.fillColor_ = this.fillColor_;
            backend.strokeColor_ = this.strokeColor_;
        }
    }
}

