/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class BeforeUnloadEvent
extends Event {
    private Object returnValue_;

    public BeforeUnloadEvent() {
        this.setType("");
        this.returnValue_ = "";
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void jConstructor() {
        Context.throwAsScriptRuntimeEx((Throwable)new IllegalArgumentException("Illegal Constructor"));
    }

    public BeforeUnloadEvent(DomNode domNode, String type) {
        super(domNode, type);
        this.setBubbles(false);
        this.setReturnValue(BeforeUnloadEvent.getReturnValueDefault(this.getBrowserVersion()));
    }

    @Override
    public void initEvent(String type, boolean bubbles, boolean cancelable) {
        super.initEvent(type, bubbles, cancelable);
        this.setReturnValue(BeforeUnloadEvent.getReturnValueDefault(this.getBrowserVersion()));
    }

    private static Object getReturnValueDefault(BrowserVersion browserVersion) {
        if (browserVersion.hasFeature(BrowserVersionFeatures.EVENT_BEFORE_UNLOAD_RETURN_VALUE_IS_HTML5_LIKE)) {
            return "";
        }
        return Undefined.instance;
    }

    public boolean isBeforeUnloadMessageSet() {
        return !BeforeUnloadEvent.getReturnValueDefault(this.getBrowserVersion()).equals(this.getReturnValue());
    }

    @Override
    @JsxGetter
    public Object getReturnValue() {
        return this.returnValue_;
    }

    @Override
    @JsxSetter
    public void setReturnValue(Object returnValue) {
        this.returnValue_ = returnValue;
    }

    @Override
    void handlePropertyHandlerReturnValue(Object returnValue) {
        super.handlePropertyHandlerReturnValue(returnValue);
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (!(returnValue == null && !browserVersion.hasFeature(BrowserVersionFeatures.EVENT_HANDLER_NULL_RETURN_IS_MEANINGFUL) || browserVersion.hasFeature(BrowserVersionFeatures.EVENT_BEFORE_UNLOAD_RETURN_VALUE_IS_HTML5_LIKE) && !BeforeUnloadEvent.getReturnValueDefault(browserVersion).equals(this.getReturnValue()))) {
            this.setReturnValue(returnValue);
        }
    }
}

