/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.DOMTokenList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLAnchorElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlArea.class)
public class HTMLAreaElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public HTMLAreaElement() {
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        HtmlElement element = this.getDomNodeOrNull();
        if (element == null) {
            return super.getDefaultValue(null);
        }
        return HTMLAnchorElement.getDefaultValue(element);
    }

    @JsxGetter
    public String getAlt() {
        return this.getDomNodeOrDie().getAttributeDirect("alt");
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }

    @JsxGetter
    public String getRel() {
        return this.getDomNodeOrDie().getAttributeDirect("rel");
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getDomNodeOrDie().setAttribute("rel", rel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public DOMTokenList getRelList() {
        return new DOMTokenList(this, "rel");
    }

    @Override
    public void focus() {
        HtmlArea area = (HtmlArea)this.getDomNodeOrDie();
        String hrefAttr = area.getHrefAttribute();
        if (hrefAttr != DomElement.ATTRIBUTE_NOT_DEFINED) {
            area.focus();
        }
    }

    @JsxGetter
    public String getCoords() {
        return this.getDomNodeOrDie().getAttributeDirect("coords");
    }

    @JsxSetter
    public void setCoords(String coords) {
        this.getDomNodeOrDie().setAttribute("coords", coords);
    }
}

