/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.intl;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.time.ZoneId;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Chronology;
import java.time.chrono.HijrahChronology;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.ThaiBuddhistChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DecimalStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class DateTimeFormat
extends SimpleScriptable {
    private static Map<String, String> FF_68_FORMATS_ = new HashMap<String, String>();
    private static Map<String, String> FF_60_FORMATS_ = new HashMap<String, String>();
    private static Map<String, String> CHROME_FORMATS_ = new HashMap<String, String>();
    private static Map<String, String> IE_FORMATS_ = new HashMap<String, String>();
    private transient DateTimeFormatHelper formatter_;

    public DateTimeFormat() {
    }

    private DateTimeFormat(String[] locales, BrowserVersion browserVersion) {
        Map<String, String> formats = browserVersion.isChrome() ? CHROME_FORMATS_ : (browserVersion.isIE() ? IE_FORMATS_ : (browserVersion.isFirefox60() ? FF_60_FORMATS_ : FF_68_FORMATS_));
        String locale = "";
        String pattern = null;
        for (String l : locales) {
            pattern = DateTimeFormat.getPattern(formats, l);
            if (pattern == null) continue;
            locale = l;
        }
        if (pattern == null) {
            pattern = formats.get("");
        }
        if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK) && !locale.startsWith("ar")) {
            pattern = pattern.replace("\u200e", "");
        }
        this.formatter_ = new DateTimeFormatHelper(locale, browserVersion, pattern);
    }

    private static String getPattern(Map<String, String> formats, String locale) {
        if ("no-NO-NY".equals(locale)) {
            throw ScriptRuntime.rangeError((String)("Invalid language tag: " + locale));
        }
        String pattern = formats.get(locale);
        if (pattern == null && locale.indexOf(45) != -1) {
            pattern = formats.get(locale.substring(0, locale.indexOf(45)));
        }
        return pattern;
    }

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        String[] locales;
        if (args.length != 0) {
            if (args[0] instanceof NativeArray) {
                NativeArray array = (NativeArray)args[0];
                locales = new String[(int)array.getLength()];
                for (int i = 0; i < locales.length; ++i) {
                    locales[i] = Context.toString((Object)array.get(i));
                }
            } else {
                locales = new String[]{Context.toString((Object)args[0])};
            }
        } else {
            locales = new String[]{""};
        }
        Window window = DateTimeFormat.getWindow((Scriptable)ctorObj);
        DateTimeFormat format = new DateTimeFormat(locales, window.getBrowserVersion());
        format.setParentScope((Scriptable)window);
        format.setPrototype(window.getPrototype(format.getClass()));
        return format;
    }

    @JsxFunction
    public String format(Object object) {
        Date date = (Date)Context.jsToJava((Object)object, Date.class);
        return this.formatter_.format(date);
    }

    @JsxFunction
    public Scriptable resolvedOptions() {
        Scriptable object = Context.getCurrentContext().newObject(this.getParentScope());
        return object;
    }

    static {
        String ddSlash = "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY";
        String ddDash = "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY";
        String ddDot = "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY";
        String ddDotDot = "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.";
        String ddDotBlank = "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY";
        String ddDotBlankDot = "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.";
        String mmSlash = "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY";
        String yyyySlash = "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd";
        String yyyyDash = "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd";
        String yyyyDot = "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd";
        String yyyyDotBlankDot = "\u200eYYYY\u200e. \u200eMM\u200e. \u200edd.";
        String yyyyDotDot = "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd\u200e.";
        String rightToLeft = "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY";
        HashMap<String, String> commonFormats = new HashMap<String, String>();
        commonFormats.put("", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("ar", "dd\u200f/MM\u200f/YYYY");
        commonFormats.put("ar-SA", "d\u200f/M\u200f/YYYY \u0647\u0640");
        commonFormats.put("ban", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("be", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("bg", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e \u0433.");
        commonFormats.put("ca", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("cs", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        commonFormats.put("da", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("de", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("el", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-NZ", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-PA", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-PR", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-AU", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-GB", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-IE", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-IN", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-MT", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-SG", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("en-ZA", "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd");
        commonFormats.put("es", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("es-CL", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        commonFormats.put("es-PA", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("es-PR", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("es-US", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("et", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("fi", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("fr", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("fr-CA", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        commonFormats.put("ga", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        commonFormats.put("hi", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("hr", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        commonFormats.put("hu", "\u200eYYYY\u200e. \u200eMM\u200e. \u200edd.");
        commonFormats.put("id", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("in", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("is", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("it", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("iw", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("ja", "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd");
        commonFormats.put("ko", "\u200eYYYY\u200e. \u200eMM\u200e. \u200edd.");
        commonFormats.put("lt", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        commonFormats.put("lv", "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd\u200e.");
        commonFormats.put("mk", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("ms", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("mt", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        commonFormats.put("nl", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        commonFormats.put("pl", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("pt", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("ro", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("ru", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("sk", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("sl", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        commonFormats.put("sq", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("sr", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        commonFormats.put("sv", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        commonFormats.put("th", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("tr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("uk", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("vi", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("zh", "\u200eYYYY\u200e/\u200eMM\u200e/\u200edd");
        commonFormats.put("zh-HK", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("zh-SG", "\u200eYYYY\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
        CHROME_FORMATS_.putAll(commonFormats);
        commonFormats.put("ja-JP-u-ca-japanese", "yy/MM/dd");
        IE_FORMATS_.putAll(commonFormats);
        commonFormats.put("en-CA", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        commonFormats.put("en-PH", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("es-US", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("ga", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("fr-CH", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        commonFormats.put("nl-BE", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        commonFormats.put("sk", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        commonFormats.put("sr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        commonFormats.put("sq", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_68_FORMATS_.putAll(commonFormats);
        FF_68_FORMATS_.put("da", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        FF_60_FORMATS_.putAll(commonFormats);
        FF_60_FORMATS_.put("mt", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("be", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("da", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        CHROME_FORMATS_.put("en-CA", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        CHROME_FORMATS_.put("en-IE", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("en-MT", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("en-PH", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("es-US", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("fr-CH", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        CHROME_FORMATS_.put("ga", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("hr", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY.");
        CHROME_FORMATS_.put("in-ID", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("is", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("iw", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        CHROME_FORMATS_.put("ja-JP-u-ca-japanese", "'H'yy/MM/dd");
        CHROME_FORMATS_.put("mk", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("nl-BE", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("sk", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        CHROME_FORMATS_.put("sq", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        CHROME_FORMATS_.put("sr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        IE_FORMATS_.put("ar", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-AE", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-BH", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-DZ", "\u200fdd\u200f-\u200fMM\u200f-\u200fYYYY");
        IE_FORMATS_.put("ar-LY", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-MA", "\u200fdd\u200f-\u200fMM\u200f-\u200fYYYY");
        IE_FORMATS_.put("ar-TN", "\u200fdd\u200f-\u200fMM\u200f-\u200fYYYY");
        IE_FORMATS_.put("ar-EG", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-IQ", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-JO", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-KW", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-LB", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-OM", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-QA", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-SA", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-SD", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-SY", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ar-YE", "\u200fdd\u200f/\u200fMM\u200f/\u200fYYYY");
        IE_FORMATS_.put("ban", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("cs", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("da", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        IE_FORMATS_.put("en-IN", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        IE_FORMATS_.put("en-MT", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        IE_FORMATS_.put("en-CA", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("es-PR", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("es-US", "\u200eMM\u200e/\u200edd\u200e/\u200eYYYY");
        IE_FORMATS_.put("fr-CH", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("ga", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("hi", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        IE_FORMATS_.put("hr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY\u200e.");
        IE_FORMATS_.put("hu", "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd\u200e.");
        IE_FORMATS_.put("iw", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("it-CH", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("ja", "\u200eYYYY\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
        IE_FORMATS_.put("ja-JP-u-ca-japanese", "\u200e\u5e73\u6210\u200e \u200eyy\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
        IE_FORMATS_.put("ko", "\u200eYYYY\u200e\ub144 \u200eMM\u200e\uc6d4 \u200edd\u200e\uc77c");
        IE_FORMATS_.put("lt", "\u200eYYYY\u200e.\u200eMM\u200e.\u200edd");
        IE_FORMATS_.put("mt", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("nl-BE", "\u200edd\u200e/\u200eMM\u200e/\u200eYYYY");
        IE_FORMATS_.put("no", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("pl", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        IE_FORMATS_.put("pt-PT", "\u200edd\u200e-\u200eMM\u200e-\u200eYYYY");
        IE_FORMATS_.put("sk", "\u200edd\u200e. \u200eMM\u200e. \u200eYYYY");
        IE_FORMATS_.put("sl", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("sq", "\u200eYYYY\u200e-\u200eMM\u200e-\u200edd");
        IE_FORMATS_.put("sr", "\u200edd\u200e.\u200eMM\u200e.\u200eYYYY");
        IE_FORMATS_.put("zh", "\u200eYYYY\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
        IE_FORMATS_.put("zh-HK", "\u200eYYYY\u200e\u5e74\u200eMM\u200e\u6708\u200edd\u200e\u65e5");
    }

    static final class DateTimeFormatHelper {
        private final DateTimeFormatter formatter_;
        private Chronology chronology_;

        DateTimeFormatHelper(String locale, BrowserVersion browserVersion, String pattern) {
            if (!(!locale.startsWith("ar") || "ar-DZ".equals(locale) || "ar-LY".equals(locale) || "ar-MA".equals(locale) || "ar-TN".equals(locale))) {
                DecimalStyle decimalStyle = DecimalStyle.STANDARD.withZeroDigit('\u0660');
                this.formatter_ = DateTimeFormatter.ofPattern(pattern).withDecimalStyle(decimalStyle);
            } else {
                this.formatter_ = DateTimeFormatter.ofPattern(pattern);
            }
            switch (locale) {
                case "ja-JP-u-ca-japanese": {
                    this.chronology_ = JapaneseChronology.INSTANCE;
                    break;
                }
                case "ar": {
                    if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK)) break;
                    this.chronology_ = HijrahChronology.INSTANCE;
                    break;
                }
                case "ar-SA": {
                    this.chronology_ = HijrahChronology.INSTANCE;
                    break;
                }
                case "ar-SD": {
                    if (!browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK)) break;
                    this.chronology_ = HijrahChronology.INSTANCE;
                    break;
                }
                case "th": 
                case "th-TH": {
                    this.chronology_ = ThaiBuddhistChronology.INSTANCE;
                    break;
                }
            }
        }

        String format(Date date) {
            Comparable<ChronoZonedDateTime<?>> zonedDateTime = date.toInstant().atZone(ZoneId.systemDefault());
            if (this.chronology_ != null) {
                zonedDateTime = this.chronology_.date((TemporalAccessor)((Object)zonedDateTime));
            }
            return this.formatter_.format((TemporalAccessor)((Object)zonedDateTime));
        }
    }
}

