/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJavaScriptConfiguration {
    private static final Log LOG = LogFactory.getLog(AbstractJavaScriptConfiguration.class);
    private static final Map<String, String> CLASS_NAME_MAP_ = new HashMap<String, String>();
    private Map<Class<?>, Class<? extends HtmlUnitScriptable>> domJavaScriptMap_;
    private final Map<String, ClassConfiguration> configuration_;

    protected AbstractJavaScriptConfiguration(BrowserVersion browser) {
        this.configuration_ = this.buildUsageMap(browser);
    }

    protected abstract Class<? extends SimpleScriptable>[] getClasses();

    public Iterable<ClassConfiguration> getAll() {
        return this.configuration_.values();
    }

    private Map<String, ClassConfiguration> buildUsageMap(BrowserVersion browser) {
        HashMap<String, ClassConfiguration> classMap = new HashMap<String, ClassConfiguration>(this.getClasses().length);
        for (Class<? extends SimpleScriptable> klass : this.getClasses()) {
            ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(klass, browser);
            if (config == null) continue;
            classMap.put(config.getClassName(), config);
        }
        return Collections.unmodifiableMap(classMap);
    }

    public static ClassConfiguration getClassConfiguration(Class<? extends HtmlUnitScriptable> klass, BrowserVersion browser) {
        if (browser != null) {
            SupportedBrowser expectedBrowser = browser.isChrome() ? SupportedBrowser.CHROME : (browser.isIE() ? SupportedBrowser.IE : (browser.isFirefox60() ? SupportedBrowser.FF60 : (browser.isFirefox68() ? SupportedBrowser.FF68 : (browser.isFirefox() ? SupportedBrowser.FF : SupportedBrowser.CHROME))));
            String hostClassName = klass.getName();
            JsxClasses jsxClasses = klass.getAnnotation(JsxClasses.class);
            if (jsxClasses != null) {
                if (klass.getAnnotation(JsxClass.class) != null) {
                    throw new RuntimeException("Invalid JsxClasses/JsxClass annotation; class '" + hostClassName + "' has both.");
                }
                JsxClass[] jsxClassValues = jsxClasses.value();
                if (jsxClassValues.length == 1) {
                    throw new RuntimeException("No need to specify JsxClasses with a single JsxClass for " + hostClassName);
                }
                HashSet domClasses = new HashSet();
                boolean isJsObject = false;
                String className = null;
                String extendedClassName = "";
                Class<? extends HtmlUnitScriptable> superClass = klass.getSuperclass();
                extendedClassName = superClass == SimpleScriptable.class ? "" : superClass.getSimpleName();
                for (JsxClass jsxClass : jsxClassValues) {
                    if (jsxClass == null || !AbstractJavaScriptConfiguration.isSupported(jsxClass.value(), expectedBrowser)) continue;
                    domClasses.add(jsxClass.domClass());
                    if (jsxClass.isJSObject()) {
                        isJsObject = true;
                    }
                    if (!jsxClass.className().isEmpty()) {
                        className = jsxClass.className();
                    }
                    if (jsxClass.extendedClass() == Object.class) continue;
                    extendedClassName = jsxClass.extendedClass() == SimpleScriptable.class ? "" : jsxClass.extendedClass().getSimpleName();
                }
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), isJsObject, className, extendedClassName);
                AbstractJavaScriptConfiguration.process(classConfiguration, hostClassName, expectedBrowser);
                return classConfiguration;
            }
            JsxClass jsxClass = klass.getAnnotation(JsxClass.class);
            if (jsxClass != null && AbstractJavaScriptConfiguration.isSupported(jsxClass.value(), expectedBrowser)) {
                String className;
                HashSet domClasses = new HashSet();
                Class<?> domClass = jsxClass.domClass();
                if (domClass != null && domClass != Object.class) {
                    domClasses.add(domClass);
                }
                if ((className = jsxClass.className()).isEmpty()) {
                    className = null;
                }
                String extendedClassName = "";
                Class<? extends HtmlUnitScriptable> superClass = klass.getSuperclass();
                extendedClassName = superClass != SimpleScriptable.class ? superClass.getSimpleName() : "";
                if (jsxClass.extendedClass() != Object.class) {
                    extendedClassName = jsxClass.extendedClass().getSimpleName();
                }
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), jsxClass.isJSObject(), className, extendedClassName);
                AbstractJavaScriptConfiguration.process(classConfiguration, hostClassName, expectedBrowser);
                return classConfiguration;
            }
        }
        return null;
    }

    private static void process(ClassConfiguration classConfiguration, String hostClassName, SupportedBrowser expectedBrowser) {
        String simpleClassName = hostClassName.substring(hostClassName.lastIndexOf(46) + 1);
        CLASS_NAME_MAP_.put(hostClassName, simpleClassName);
        HashMap<String, Executable> allGetters = new HashMap<String, Executable>();
        HashMap<String, Executable> allSetters = new HashMap<String, Executable>();
        for (Constructor<?> constructor : classConfiguration.getHostClass().getDeclaredConstructors()) {
            for (Annotation annotation : constructor.getAnnotations()) {
                if (!(annotation instanceof JsxConstructor) || !AbstractJavaScriptConfiguration.isSupported(((JsxConstructor)annotation).value(), expectedBrowser)) continue;
                classConfiguration.setJSConstructor(constructor);
            }
        }
        for (Executable executable : classConfiguration.getHostClass().getDeclaredMethods()) {
            for (Annotation annotation : executable.getAnnotations()) {
                if (annotation instanceof JsxGetter) {
                    String property;
                    JsxGetter jsxGetter = (JsxGetter)annotation;
                    if (!AbstractJavaScriptConfiguration.isSupported(jsxGetter.value(), expectedBrowser)) continue;
                    if (jsxGetter.propertyName().isEmpty()) {
                        int prefix = ((Method)executable).getName().startsWith("is") ? 2 : 3;
                        property = ((Method)executable).getName().substring(prefix);
                        property = Character.toLowerCase(property.charAt(0)) + property.substring(1);
                    } else {
                        property = jsxGetter.propertyName();
                    }
                    allGetters.put(property, executable);
                    continue;
                }
                if (annotation instanceof JsxSetter) {
                    String property;
                    JsxSetter jsxSetter = (JsxSetter)annotation;
                    if (!AbstractJavaScriptConfiguration.isSupported(jsxSetter.value(), expectedBrowser)) continue;
                    if (jsxSetter.propertyName().isEmpty()) {
                        property = ((Method)executable).getName().substring(3);
                        property = Character.toLowerCase(property.charAt(0)) + property.substring(1);
                    } else {
                        property = jsxSetter.propertyName();
                    }
                    allSetters.put(property, executable);
                    continue;
                }
                if (annotation instanceof JsxFunction) {
                    JsxFunction jsxFunction = (JsxFunction)annotation;
                    if (!AbstractJavaScriptConfiguration.isSupported(jsxFunction.value(), expectedBrowser)) continue;
                    String name = jsxFunction.functionName().isEmpty() ? ((Method)executable).getName() : jsxFunction.functionName();
                    classConfiguration.addFunction(name, (Method)executable);
                    continue;
                }
                if (annotation instanceof JsxStaticGetter) {
                    JsxStaticGetter jsxStaticGetter = (JsxStaticGetter)annotation;
                    if (!AbstractJavaScriptConfiguration.isSupported(jsxStaticGetter.value(), expectedBrowser)) continue;
                    int prefix = ((Method)executable).getName().startsWith("is") ? 2 : 3;
                    String property = ((Method)executable).getName().substring(prefix);
                    property = Character.toLowerCase(property.charAt(0)) + property.substring(1);
                    classConfiguration.addStaticProperty(property, (Method)executable, null);
                    continue;
                }
                if (annotation instanceof JsxStaticFunction) {
                    JsxStaticFunction jsxStaticFunction = (JsxStaticFunction)annotation;
                    if (!AbstractJavaScriptConfiguration.isSupported(jsxStaticFunction.value(), expectedBrowser)) continue;
                    String name = jsxStaticFunction.functionName().isEmpty() ? ((Method)executable).getName() : jsxStaticFunction.functionName();
                    classConfiguration.addStaticFunction(name, (Method)executable);
                    continue;
                }
                if (!(annotation instanceof JsxConstructor) || !AbstractJavaScriptConfiguration.isSupported(((JsxConstructor)annotation).value(), expectedBrowser)) continue;
                classConfiguration.setJSConstructor(executable);
            }
        }
        for (AccessibleObject accessibleObject : classConfiguration.getHostClass().getDeclaredFields()) {
            JsxConstant jsxConstant = ((Field)accessibleObject).getAnnotation(JsxConstant.class);
            if (jsxConstant == null || !AbstractJavaScriptConfiguration.isSupported(jsxConstant.value(), expectedBrowser)) continue;
            classConfiguration.addConstant(((Field)accessibleObject).getName());
        }
        for (Map.Entry entry : allGetters.entrySet()) {
            String property = (String)entry.getKey();
            classConfiguration.addProperty(property, (Method)entry.getValue(), (Method)allSetters.get(property));
        }
    }

    private static boolean isSupported(SupportedBrowser[] browsers, SupportedBrowser expectedBrowser) {
        for (SupportedBrowser browser : browsers) {
            if (!AbstractJavaScriptConfiguration.isCompatible(browser, expectedBrowser)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompatible(SupportedBrowser browser1, SupportedBrowser browser2) {
        return browser1 == browser2;
    }

    public ClassConfiguration getClassConfiguration(String hostClassName) {
        return this.configuration_.get(hostClassName);
    }

    public Map<Class<?>, Class<? extends HtmlUnitScriptable>> getDomJavaScriptMapping() {
        if (this.domJavaScriptMap_ != null) {
            return this.domJavaScriptMap_;
        }
        HashMap map = new HashMap(this.configuration_.size());
        boolean debug = LOG.isDebugEnabled();
        for (String hostClassName : this.configuration_.keySet()) {
            ClassConfiguration classConfig = this.getClassConfiguration(hostClassName);
            for (Class<?> domClass : classConfig.getDomClasses()) {
                if (debug) {
                    LOG.debug((Object)("Mapping " + domClass.getName() + " to " + hostClassName));
                }
                map.put(domClass, classConfig.getHostClass());
            }
        }
        this.domJavaScriptMap_ = Collections.unmodifiableMap(map);
        return this.domJavaScriptMap_;
    }
}

