/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.NativeFunctionPrefixResolver;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.javascript.host.dom.XPathNSResolver;
import com.gargoylesoftware.htmlunit.javascript.host.dom.XPathResult;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeFunction;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.xml.utils.PrefixResolver;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
public class XPathEvaluator
extends SimpleScriptable {
    @JsxConstructor
    public XPathEvaluator() {
    }

    @JsxFunction
    public XPathNSResolver createNSResolver(Node nodeResolver) {
        XPathNSResolver resolver = new XPathNSResolver();
        resolver.setElement(nodeResolver);
        resolver.setParentScope((Scriptable)this.getWindow());
        resolver.setPrototype(this.getPrototype(resolver.getClass()));
        return resolver;
    }

    @JsxFunction
    public XPathResult evaluate(String expression, Object contextNodeObj, Object resolver, int type, Object result) {
        XPathResult xPathResult = (XPathResult)result;
        if (xPathResult == null) {
            xPathResult = new XPathResult();
            xPathResult.setParentScope(this.getParentScope());
            xPathResult.setPrototype(this.getPrototype(xPathResult.getClass()));
        }
        Node contextNode = null;
        if (!(contextNodeObj instanceof Node)) {
            throw Context.reportRuntimeError((String)"Illegal value for parameter 'context'");
        }
        contextNode = (Node)contextNodeObj;
        PrefixResolver prefixResolver = null;
        if (resolver instanceof PrefixResolver) {
            prefixResolver = (PrefixResolver)resolver;
        } else if (resolver instanceof NativeFunction) {
            prefixResolver = new NativeFunctionPrefixResolver((NativeFunction)resolver, contextNode.getParentScope());
        }
        xPathResult.init(contextNode.getDomNodeOrDie().getByXPath(expression, prefixResolver), type);
        return xPathResult;
    }
}

