/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.file;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.file.Blob;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

@JsxClass
public class File
extends Blob {
    private static final String LAST_MODIFIED_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)";
    private static final String LAST_MODIFIED_DATE_FORMAT_FF = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    private java.io.File file_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public File() {
    }

    File(String pathname) {
        this.file_ = new java.io.File(pathname);
    }

    @JsxGetter
    public String getName() {
        return this.file_.getName();
    }

    @JsxGetter
    public String getLastModifiedDate() {
        Date date = new Date(this.getLastModified());
        BrowserVersion browser = this.getBrowserVersion();
        Locale locale = new Locale(browser.getSystemLanguage());
        TimeZone timezone = browser.getSystemTimezone();
        if (browser.hasFeature(BrowserVersionFeatures.JS_FILE_SHORT_DATE_FORMAT)) {
            FastDateFormat format = FastDateFormat.getInstance((String)LAST_MODIFIED_DATE_FORMAT_FF, (TimeZone)timezone, (Locale)locale);
            return format.format(date);
        }
        FastDateFormat format = FastDateFormat.getInstance((String)LAST_MODIFIED_DATE_FORMAT, (TimeZone)timezone, (Locale)locale);
        return format.format(date);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public long getLastModified() {
        return this.file_.lastModified();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public String getWebkitRelativePath() {
        return "";
    }

    @JsxGetter
    public long getSize() {
        return this.file_.length();
    }

    @JsxGetter
    public String getType() {
        return this.getBrowserVersion().getUploadMimeType(this.file_);
    }

    @JsxFunction
    public void slice() {
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void msClose() {
    }

    public java.io.File getFile() {
        return this.file_;
    }
}

