/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.worker;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.AbstractJavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.WindowOrWorkerGlobalScope;
import com.gargoylesoftware.htmlunit.javascript.host.WindowOrWorkerGlobalScopeMixin;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import com.gargoylesoftware.htmlunit.javascript.host.worker.Worker;
import com.gargoylesoftware.htmlunit.javascript.host.worker.WorkerJob;
import com.gargoylesoftware.htmlunit.util.MimeType;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClasses(value={@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60}), @JsxClass(className="WorkerGlobalScope", value={SupportedBrowser.IE})})
public class DedicatedWorkerGlobalScope
extends EventTarget
implements WindowOrWorkerGlobalScope {
    private static final Log LOG = LogFactory.getLog(DedicatedWorkerGlobalScope.class);
    private final Window owningWindow_;
    private final String origin_;
    private final Worker worker_;

    public DedicatedWorkerGlobalScope() {
        this.owningWindow_ = null;
        this.origin_ = null;
        this.worker_ = null;
    }

    DedicatedWorkerGlobalScope(Window owningWindow, Context context, BrowserVersion browserVersion, Worker worker) throws Exception {
        context.initSafeStandardObjects((ScriptableObject)this);
        ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(DedicatedWorkerGlobalScope.class.getSuperclass(), browserVersion);
        HtmlUnitScriptable parentPrototype = JavaScriptEngine.configureClass(config, null, browserVersion);
        config = AbstractJavaScriptConfiguration.getClassConfiguration(DedicatedWorkerGlobalScope.class, browserVersion);
        HtmlUnitScriptable prototype = JavaScriptEngine.configureClass(config, null, browserVersion);
        prototype.setPrototype((Scriptable)parentPrototype);
        this.setPrototype((Scriptable)prototype);
        this.owningWindow_ = owningWindow;
        URL currentURL = owningWindow.getWebWindow().getEnclosedPage().getUrl();
        this.origin_ = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
        this.worker_ = worker;
    }

    @JsxGetter
    public Object getSelf() {
        return this;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.getEventHandler("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setEventHandler("message", onmessage);
    }

    @Override
    @JsxFunction
    public String btoa(String stringToEncode) {
        return WindowOrWorkerGlobalScopeMixin.btoa(stringToEncode);
    }

    @Override
    @JsxFunction
    public String atob(String encodedData) {
        return WindowOrWorkerGlobalScopeMixin.atob(encodedData);
    }

    @JsxFunction
    public void postMessage(Object message) {
        final MessageEvent event = new MessageEvent();
        event.initMessageEvent("message", false, false, message, this.origin_, "", this.owningWindow_, Undefined.instance);
        event.setParentScope((Scriptable)this.owningWindow_);
        event.setPrototype(this.owningWindow_.getPrototype(event.getClass()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[DedicatedWorker] postMessage: {}" + message));
        }
        JavaScriptEngine jsEngine = (JavaScriptEngine)this.owningWindow_.getWebWindow().getWebClient().getJavaScriptEngine();
        ContextAction<Object> action = new ContextAction<Object>(){

            public Object run(Context cx) {
                DedicatedWorkerGlobalScope.this.worker_.getEventListenersContainer().executeCapturingListeners(event, null);
                Object[] args = new Object[]{event};
                DedicatedWorkerGlobalScope.this.worker_.getEventListenersContainer().executeBubblingListeners(event, args);
                return null;
            }
        };
        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
        WorkerJob job = new WorkerJob(cf, action, "postMessage: " + Context.toString((Object)message));
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
    }

    void messagePosted(Object message) {
        final MessageEvent event = new MessageEvent();
        event.initMessageEvent("message", false, false, message, this.origin_, "", this.owningWindow_, Undefined.instance);
        event.setParentScope((Scriptable)this.owningWindow_);
        event.setPrototype(this.owningWindow_.getPrototype(event.getClass()));
        JavaScriptEngine jsEngine = (JavaScriptEngine)this.owningWindow_.getWebWindow().getWebClient().getJavaScriptEngine();
        ContextAction<Object> action = new ContextAction<Object>(){

            public Object run(Context cx) {
                DedicatedWorkerGlobalScope.this.executeEvent(cx, event);
                return null;
            }
        };
        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
        WorkerJob job = new WorkerJob(cf, action, "messagePosted: " + Context.toString((Object)message));
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
    }

    private void executeEvent(Context cx, MessageEvent event) {
        Function handler;
        List<Scriptable> handlers = this.getEventListenersContainer().getListeners("message", false);
        if (handlers != null) {
            for (Scriptable scriptable : handlers) {
                if (!(scriptable instanceof Function)) continue;
                Function handlerFunction = (Function)scriptable;
                Object[] args = new Object[]{event};
                handlerFunction.call(cx, (Scriptable)this, (Scriptable)this, args);
            }
        }
        if ((handler = this.getEventHandler("message")) != null && handler instanceof Function) {
            Function handlerFunction = handler;
            Object[] args = new Object[]{event};
            handlerFunction.call(cx, (Scriptable)this, (Scriptable)this, args);
        }
    }

    @JsxFunction
    public static void importScripts(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        DedicatedWorkerGlobalScope scope = (DedicatedWorkerGlobalScope)thisObj;
        WebClient webClient = scope.owningWindow_.getWebWindow().getWebClient();
        boolean checkContentType = !webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WORKER_IMPORT_SCRIPTS_ACCEPTS_ALL);
        for (Object arg : args) {
            String url = Context.toString((Object)arg);
            scope.loadAndExecute(webClient, url, cx, checkContentType);
        }
    }

    void loadAndExecute(WebClient webClient, String url, Context context, boolean checkMimeType) throws IOException {
        final HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        final URL fullUrl = page.getFullyQualifiedUrl(url);
        WebRequest webRequest = new WebRequest(fullUrl);
        WebResponse response = webClient.loadWebResponse(webRequest);
        if (checkMimeType && !MimeType.isJavascriptMimeType(response.getContentType())) {
            throw Context.reportRuntimeError((String)"NetworkError: importScripts response is not a javascript response");
        }
        final String scriptCode = response.getContentAsString();
        final JavaScriptEngine javaScriptEngine = (JavaScriptEngine)webClient.getJavaScriptEngine();
        final DedicatedWorkerGlobalScope thisScope = this;
        ContextAction<Object> action = new ContextAction<Object>(){

            public Object run(Context cx) {
                Script script = javaScriptEngine.compile(page, (Scriptable)thisScope, scriptCode, fullUrl.toExternalForm(), 1);
                return javaScriptEngine.execute(page, (Scriptable)thisScope, script);
            }
        };
        HtmlUnitContextFactory cf = javaScriptEngine.getContextFactory();
        if (context != null) {
            action.run(context);
        } else {
            WorkerJob job = new WorkerJob(cf, action, "loadAndExecute " + url);
            this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
        }
    }
}

