/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Iterator;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.TopLevel;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
public class URLSearchParams
extends SimpleScriptable {
    private static final String ITERATOR_NAME = "URLSearchParams Iterator";
    private static Iterator ITERATOR_PROTOTYPE_ = new Iterator("URLSearchParams Iterator", null);
    private final List<Map.Entry<String, String>> params_ = new LinkedList<Map.Entry<String, String>>();

    public URLSearchParams() {
    }

    @JsxConstructor
    public URLSearchParams(Object params) {
        if (params == null || Undefined.isUndefined((Object)params)) {
            return;
        }
        this.splitQuery(Context.toString((Object)params));
    }

    private void splitQuery(String params) {
        String[] parts;
        if (StringUtils.isEmpty((CharSequence)(params = StringUtils.stripStart((String)params, (String)"?")))) {
            return;
        }
        for (String part : parts = StringUtils.split((String)params, (char)'&')) {
            this.params_.add(URLSearchParams.splitQueryParameter(part));
        }
    }

    private static Map.Entry<String, String> splitQueryParameter(String singleParam) {
        int idx = singleParam.indexOf(61);
        if (idx > -1) {
            String key = singleParam.substring(0, idx);
            String value = null;
            if (idx < singleParam.length()) {
                value = singleParam.substring(idx + 1);
            }
            return new AbstractMap.SimpleEntry<String, Object>(key, value);
        }
        String key = singleParam;
        Object value = null;
        return new AbstractMap.SimpleEntry<String, Object>(key, value);
    }

    @JsxFunction
    public void append(String name, String value) {
        this.params_.add(new AbstractMap.SimpleEntry<String, String>(name, value));
    }

    @JsxFunction
    public void delete(String name) {
        java.util.Iterator<Map.Entry<String, String>> iter = this.params_.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().equals(name)) continue;
            iter.remove();
        }
    }

    @JsxFunction
    public String get(String name) {
        for (Map.Entry<String, String> param : this.params_) {
            if (!param.getKey().equals(name)) continue;
            return param.getValue();
        }
        return null;
    }

    @JsxFunction
    public NativeArray getAll(String name) {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, String> param : this.params_) {
            if (!param.getKey().equals(name)) continue;
            result.add(param.getValue());
        }
        NativeArray jsValues = new NativeArray(result.toArray());
        ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)jsValues, (Scriptable)URLSearchParams.getWindow((Scriptable)this), (TopLevel.Builtins)TopLevel.Builtins.Array);
        return jsValues;
    }

    @JsxFunction
    public void set(String name, String value) {
        java.util.Iterator<Map.Entry<String, String>> iter = this.params_.iterator();
        boolean change = true;
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().equals(name)) continue;
            if (change) {
                entry.setValue(value);
                change = false;
                continue;
            }
            iter.remove();
        }
        if (change) {
            this.append(name, value);
        }
    }

    @JsxFunction
    public boolean has(String name) {
        for (Map.Entry<String, String> param : this.params_) {
            if (!param.getKey().equals(name)) continue;
            return true;
        }
        return false;
    }

    @JsxFunction
    public Object entries() {
        Iterator object = new Iterator(ITERATOR_NAME, this.params_.iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        object.setPrototype((Scriptable)ITERATOR_PROTOTYPE_);
        return object;
    }

    @JsxFunction
    public Object keys() {
        ArrayList<String> keys = new ArrayList<String>(this.params_.size());
        for (Map.Entry<String, String> entry : this.params_) {
            keys.add(entry.getKey());
        }
        Iterator object = new Iterator(ITERATOR_NAME, keys.iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        object.setPrototype((Scriptable)ITERATOR_PROTOTYPE_);
        return object;
    }

    @JsxFunction
    public Object values() {
        ArrayList<String> values = new ArrayList<String>(this.params_.size());
        for (Map.Entry<String, String> entry : this.params_) {
            values.add(entry.getValue());
        }
        Iterator object = new Iterator(ITERATOR_NAME, values.iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        object.setPrototype((Scriptable)ITERATOR_PROTOTYPE_);
        return object;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        StringBuilder paramStr = new StringBuilder();
        String delim = "";
        for (Map.Entry<String, String> param : this.params_) {
            paramStr.append(delim);
            delim = "&";
            paramStr.append(param.getKey());
            paramStr.append('=');
            String value = param.getValue();
            if (value == null) continue;
            paramStr.append(param.getValue());
        }
        return paramStr.toString();
    }

    public void fillRequest(WebRequest webRequest) {
        webRequest.setRequestBody(null);
        webRequest.setEncodingType(FormEncodingType.URL_ENCODED);
        if (this.params_.size() > 0) {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            for (Map.Entry<String, String> entry : this.params_) {
                params.add(new NameValuePair(entry.getKey(), entry.getValue()));
            }
            webRequest.setRequestParameters(params);
        }
    }
}

