/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
public class XPathResult
extends SimpleScriptable {
    @JsxConstant
    public static final int ANY_TYPE = 0;
    @JsxConstant
    public static final int NUMBER_TYPE = 1;
    @JsxConstant
    public static final int STRING_TYPE = 2;
    @JsxConstant
    public static final int BOOLEAN_TYPE = 3;
    @JsxConstant
    public static final int UNORDERED_NODE_ITERATOR_TYPE = 4;
    @JsxConstant
    public static final int ORDERED_NODE_ITERATOR_TYPE = 5;
    @JsxConstant
    public static final int UNORDERED_NODE_SNAPSHOT_TYPE = 6;
    @JsxConstant
    public static final int ORDERED_NODE_SNAPSHOT_TYPE = 7;
    @JsxConstant
    public static final int ANY_UNORDERED_NODE_TYPE = 8;
    @JsxConstant
    public static final int FIRST_ORDERED_NODE_TYPE = 9;
    private List<?> result_;
    private int resultType_;
    private int iteratorIndex_;

    @JsxConstructor
    public XPathResult() {
    }

    void init(List<?> result, int type) {
        this.result_ = result;
        this.resultType_ = -1;
        if (this.result_.size() == 1) {
            Object o = this.result_.get(0);
            if (o instanceof Number) {
                this.resultType_ = 1;
            } else if (o instanceof String) {
                this.resultType_ = 2;
            } else if (o instanceof Boolean) {
                this.resultType_ = 3;
            }
        }
        if (this.resultType_ == -1) {
            this.resultType_ = type != 0 ? type : 4;
        }
        this.iteratorIndex_ = 0;
    }

    @JsxGetter
    public int getResultType() {
        return this.resultType_;
    }

    @JsxGetter
    public int getSnapshotLength() {
        if (this.resultType_ != 6 && this.resultType_ != 7) {
            throw Context.reportRuntimeError((String)("Cannot get snapshotLength for type: " + this.resultType_));
        }
        return this.result_.size();
    }

    @JsxGetter
    public Node getSingleNodeValue() {
        if (this.resultType_ != 8 && this.resultType_ != 9) {
            throw Context.reportRuntimeError((String)("Cannot get singleNodeValue for type: " + this.resultType_));
        }
        if (!this.result_.isEmpty()) {
            return (Node)((DomNode)this.result_.get(0)).getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Node iterateNext() {
        if (this.resultType_ != 4 && this.resultType_ != 5) {
            throw Context.reportRuntimeError((String)("Cannot get iterateNext for type: " + this.resultType_));
        }
        if (this.iteratorIndex_ < this.result_.size()) {
            return (Node)((DomNode)this.result_.get(this.iteratorIndex_++)).getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Node snapshotItem(int index) {
        if (this.resultType_ != 6 && this.resultType_ != 7) {
            throw Context.reportRuntimeError((String)("Cannot get snapshotLength for type: " + this.resultType_));
        }
        if (index >= 0 && index < this.result_.size()) {
            return (Node)((DomNode)this.result_.get(index)).getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public double getNumberValue() {
        Double answer;
        if (this.resultType_ != 1) {
            throw Context.reportRuntimeError((String)("Cannot get numberValue for type: " + this.resultType_));
        }
        String asString = this.asString();
        try {
            answer = Double.parseDouble(asString);
        }
        catch (NumberFormatException e) {
            answer = Double.NaN;
        }
        return answer;
    }

    @JsxGetter
    public boolean isBooleanValue() {
        if (this.resultType_ != 3) {
            throw Context.reportRuntimeError((String)("Cannot get booleanValue for type: " + this.resultType_));
        }
        return !this.result_.isEmpty();
    }

    @JsxGetter
    public String getStringValue() {
        if (this.resultType_ != 2) {
            throw Context.reportRuntimeError((String)("Cannot get stringValue for type: " + this.resultType_));
        }
        return this.asString();
    }

    private String asString() {
        Object resultObj = this.result_.get(0);
        if (resultObj instanceof DomAttr) {
            return ((DomAttr)resultObj).getValue();
        }
        if (resultObj instanceof DomNode) {
            return ((DomNode)resultObj).asText();
        }
        return resultObj.toString();
    }
}

