/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;

abstract class BrowserConfiguration {
    private String defaultValue_;

    BrowserConfiguration(String defaultValue) {
        this.defaultValue_ = defaultValue;
    }

    String getDefaultValue() {
        return this.defaultValue_;
    }

    abstract boolean matches(BrowserVersion var1);

    public boolean isIteratable() {
        return true;
    }

    static BrowserConfiguration getMatchingConfiguration(BrowserVersion browserVersion, BrowserConfiguration[] browserConfigurations) {
        for (BrowserConfiguration browserConfiguration : browserConfigurations) {
            if (!browserConfiguration.matches(browserVersion)) continue;
            return browserConfiguration;
        }
        return null;
    }

    static BrowserConfiguration chrome(String defaultValue) {
        return new Chrome(defaultValue);
    }

    static BrowserConfiguration chromeAndFirefox(String defaultValue) {
        return new ChromeAndFirefox(defaultValue);
    }

    static BrowserConfiguration chromeNotIterable(String defaultValue) {
        return new ChromeNotIterable(defaultValue);
    }

    static BrowserConfiguration ff(String defaultValue) {
        return new FF(defaultValue);
    }

    static BrowserConfiguration ffNotIterable(String defaultValue) {
        return new FFNotIterable(defaultValue);
    }

    static BrowserConfiguration ff60(String defaultValue) {
        return new FF60(defaultValue);
    }

    static BrowserConfiguration ff60And68(String defaultValue) {
        return new FF60And68(defaultValue);
    }

    static BrowserConfiguration ff68(String defaultValue) {
        return new FF68(defaultValue);
    }

    static BrowserConfiguration ff68AndUp(String defaultValue) {
        return new FF68AndUp(defaultValue);
    }

    static BrowserConfiguration ffLatest(String defaultValue) {
        return new FFLatest(defaultValue);
    }

    static BrowserConfiguration ie(String defaultValue) {
        return new IE(defaultValue);
    }

    static BrowserConfiguration ieNotIterable(String defaultValue) {
        return new IENotIterable(defaultValue);
    }

    private static class IENotIterable
    extends BrowserConfiguration {
        IENotIterable(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isIE();
        }

        @Override
        public boolean isIteratable() {
            return false;
        }
    }

    private static class IE
    extends BrowserConfiguration {
        IE(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isIE();
        }
    }

    private static class FFLatest
    extends BrowserConfiguration {
        FFLatest(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() > 68;
        }
    }

    private static class FF68AndUp
    extends BrowserConfiguration {
        FF68AndUp(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() >= 68;
        }
    }

    private static class FF60And68
    extends BrowserConfiguration {
        FF60And68(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() <= 68;
        }
    }

    private static class FF68
    extends BrowserConfiguration {
        FF68(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() == 68;
        }
    }

    private static class FF60
    extends BrowserConfiguration {
        FF60(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() == 60;
        }
    }

    private static class FFNotIterable
    extends BrowserConfiguration {
        FFNotIterable(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox();
        }

        @Override
        public boolean isIteratable() {
            return false;
        }
    }

    private static class FF
    extends BrowserConfiguration {
        FF(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox();
        }
    }

    private static class ChromeAndFirefox
    extends BrowserConfiguration {
        ChromeAndFirefox(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome() || browserVersion.isFirefox();
        }
    }

    static class ChromeNotIterable
    extends BrowserConfiguration {
        ChromeNotIterable(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome();
        }

        @Override
        public boolean isIteratable() {
            return false;
        }
    }

    private static class Chrome
    extends BrowserConfiguration {
        Chrome(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome();
        }
    }
}

