/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Iterator;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass
public class NodeList
extends AbstractList {
    private static final String ITERATOR_NAME = "Iterator";
    private static Iterator ITERATOR_PROTOTYPE_ = new Iterator("Iterator", null);

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public NodeList() {
    }

    public NodeList(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive);
    }

    public NodeList(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, initialElements);
    }

    private NodeList(ScriptableObject parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public static NodeList staticNodeList(HtmlUnitScriptable parentScope, final List<DomNode> elements) {
        return new NodeList((ScriptableObject)parentScope){

            @Override
            public List<DomNode> getElements() {
                return elements;
            }
        };
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public Iterator keys() {
        int length = this.getElements().size();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < length; ++i) {
            list.add(i);
        }
        Iterator object = new Iterator(ITERATOR_NAME, list.iterator());
        object.setParentScope(this.getParentScope());
        object.setPrototype((Scriptable)ITERATOR_PROTOTYPE_);
        return object;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public Iterator values() {
        List<DomNode> list = this.getElements();
        Iterator object = new Iterator(ITERATOR_NAME, list.iterator());
        object.setParentScope(this.getParentScope());
        object.setPrototype((Scriptable)ITERATOR_PROTOTYPE_);
        return object;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public Iterator entries() {
        List<DomNode> elements = this.getElements();
        Context context = Context.getCurrentContext();
        Scriptable scope = this.getParentScope();
        ArrayList<Scriptable> list = new ArrayList<Scriptable>();
        for (int i = 0; i < elements.size(); ++i) {
            Object[] array = new Object[]{i, elements.get(i).getScriptableObject()};
            list.add(context.newArray(scope, array));
        }
        Iterator object = new Iterator(ITERATOR_NAME, list.iterator());
        object.setParentScope(scope);
        object.setPrototype((Scriptable)ITERATOR_PROTOTYPE_);
        return object;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void forEach(final Object callback) {
        final List<DomNode> nodes = this.getElements();
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        HtmlUnitContextFactory cf = ((JavaScriptEngine)client.getJavaScriptEngine()).getContextFactory();
        ContextAction<Object> contextAction = new ContextAction<Object>(){

            public Object run(Context cx) {
                Function function = (Function)callback;
                Scriptable scope = NodeList.this.getParentScope();
                for (int i = 0; i < nodes.size(); ++i) {
                    function.call(cx, scope, (Scriptable)NodeList.this, new Object[]{((DomNode)nodes.get(i)).getScriptableObject(), i, NodeList.this});
                }
                return null;
            }
        };
        cf.call((ContextAction)contextAction);
    }
}

