/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.WindowProxy;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClass=HtmlInlineFrame.class)
public class HTMLIFrameElement
extends HTMLElement {
    private boolean isAttachedToPageDuringOnload_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public HTMLIFrameElement() {
    }

    @JsxGetter
    public String getSrc() {
        return this.getFrame().getSrcAttribute();
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getFrame().setSrcAttribute(src);
        this.isAttachedToPageDuringOnload_ = false;
    }

    @JsxGetter
    public DocumentProxy getContentDocument() {
        FrameWindow frameWindow = this.getFrame().getEnclosedWindow();
        if (FrameWindow.PageDenied.NONE != frameWindow.getPageDenied()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FRAME_CONTENT_DOCUMENT_ACCESS_DENIED_THROWS)) {
                throw Context.reportRuntimeError((String)"Error access denied");
            }
            return null;
        }
        return ((Window)frameWindow.getScriptableObject()).getDocument_js();
    }

    @JsxGetter
    public WindowProxy getContentWindow() {
        return Window.getProxy(this.getFrame().getEnclosedWindow());
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getFrame().getNameAttribute();
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getFrame().setNameAttribute(name);
    }

    private BaseFrameElement getFrame() {
        return (BaseFrameElement)this.getDomNodeOrDie();
    }

    @Override
    public void setOnload(Object eventHandler) {
        super.setOnload(eventHandler);
        this.isAttachedToPageDuringOnload_ = this.getDomNodeOrDie().isAttachedToPage();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorder() {
        String border = this.getDomNodeOrDie().getAttributeDirect("border");
        return border;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getWidthOrHeight("width", Boolean.TRUE);
    }

    @JsxSetter
    public void setWidth(String width) {
        this.setWidthOrHeight("width", width, true);
    }

    @JsxGetter(propertyName="height")
    public String getHeight_js() {
        return this.getWidthOrHeight("height", Boolean.TRUE);
    }

    @JsxSetter
    public void setHeight(String height) {
        this.setWidthOrHeight("height", height, true);
    }

    @Override
    public void executeEventLocally(Event event) {
        if ("load" != event.getType() || !this.isAttachedToPageDuringOnload_ || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_IFRAME_ALWAYS_EXECUTE_ONLOAD)) {
            super.executeEventLocally(event);
        }
    }

    public void onRefresh() {
        this.isAttachedToPageDuringOnload_ = false;
    }
}

