/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLFormElement;

@JsxClass(domClass=HtmlLabel.class)
public class HTMLLabelElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public HTMLLabelElement() {
    }

    @JsxGetter
    public String getHtmlFor() {
        return ((HtmlLabel)this.getDomNodeOrDie()).getForAttribute();
    }

    @JsxSetter
    public void setHtmlFor(String id) {
        ((HtmlLabel)this.getDomNodeOrDie()).setAttribute("for", id);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public HTMLElement getControl() {
        HtmlLabel label = (HtmlLabel)this.getDomNodeOrDie();
        HtmlElement labeledElement = label.getLabeledElement();
        if (labeledElement == null) {
            return null;
        }
        return (HTMLElement)this.getScriptableFor(labeledElement);
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.FF60})
    public void setControl(HTMLElement control) {
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_LABEL_FORM_OF_SELF)) {
            HtmlForm form = this.getDomNodeOrDie().getEnclosingForm();
            if (form == null) {
                return null;
            }
            return (HTMLFormElement)this.getScriptableFor(form);
        }
        HtmlLabel label = (HtmlLabel)this.getDomNodeOrDie();
        HtmlElement labeledElement = label.getLabeledElement();
        if (labeledElement == null) {
            return null;
        }
        HtmlForm form = labeledElement.getEnclosingForm();
        if (form == null) {
            return null;
        }
        return (HTMLFormElement)this.getScriptableFor(form);
    }

    @JsxSetter
    public void setForm(HTMLFormElement form) {
    }
}

