/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class HtmlImageInput
extends HtmlInput
implements LabelableElement {
    private boolean wasPositionSpecified_;
    private int xPosition_;
    private int yPosition_;
    private WebResponse imageWebResponse_;
    private boolean downloaded_;

    HtmlImageInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        String name = this.getNameAttribute();
        String prefix = StringUtils.isEmpty((CharSequence)name) ? "" : name + ".";
        if (this.wasPositionSpecified_) {
            NameValuePair valueX = new NameValuePair(prefix + 'x', Integer.toString(this.xPosition_));
            NameValuePair valueY = new NameValuePair(prefix + 'y', Integer.toString(this.yPosition_));
            if (!prefix.isEmpty() && this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_NAME_VALUE_PARAMS) && !this.getValueAttribute().isEmpty()) {
                return new NameValuePair[]{valueX, valueY, new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
            }
            return new NameValuePair[]{valueX, valueY};
        }
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValueAttribute())};
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            form.submit(this);
            return false;
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    public <P extends Page> P click(int x, int y) throws IOException, ElementNotFoundException {
        this.wasPositionSpecified_ = true;
        this.xPosition_ = x;
        this.yPosition_ = y;
        return super.click();
    }

    @Override
    public <P extends Page> P click(Event event, boolean shiftKey, boolean ctrlKey, boolean altKey, boolean ignoreVisibility) throws IOException {
        this.wasPositionSpecified_ = true;
        return super.click(event, shiftKey, ctrlKey, altKey, ignoreVisibility);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setValueAttribute(defaultValue);
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        if ("value".equals(qualifiedName)) {
            this.setDefaultValue(attributeValue, false);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }

    private void downloadImageIfNeeded() throws IOException {
        if (!this.downloaded_) {
            String src = this.getSrcAttribute();
            if (!("".equals(src) || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY) && StringUtils.isBlank((CharSequence)src))) {
                HtmlPage page = (HtmlPage)this.getPage();
                WebClient webClient = page.getWebClient();
                URL url = page.getFullyQualifiedUrl(src);
                BrowserVersion browser = webClient.getBrowserVersion();
                WebRequest request = new WebRequest(url, browser.getImgAcceptHeader(), browser.getAcceptEncodingHeader());
                request.setCharset(page.getCharset());
                request.setAdditionalHeader("Referer", page.getUrl().toExternalForm());
                this.imageWebResponse_ = webClient.loadWebResponse(request);
            }
            this.downloaded_ = this.hasFeature(BrowserVersionFeatures.JS_IMAGE_COMPLETE_RETURNS_TRUE_FOR_NO_REQUEST) || this.imageWebResponse_ != null && this.imageWebResponse_.getContentType().contains("image");
        }
    }

    public void saveAs(File file) throws IOException {
        this.downloadImageIfNeeded();
        if (null != this.imageWebResponse_) {
            try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                 InputStream inputStream = this.imageWebResponse_.getContentAsStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
            }
        }
    }
}

