/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ConfirmHandler;
import com.gargoylesoftware.htmlunit.DialogWindow;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.PromptHandler;
import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.StatusHandler;
import com.gargoylesoftware.htmlunit.StorageHolder;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlEmbed;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrame;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlMap;
import com.gargoylesoftware.htmlunit.html.HtmlObject;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.ApplicationCache;
import com.gargoylesoftware.htmlunit.javascript.host.Console;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.External;
import com.gargoylesoftware.htmlunit.javascript.host.HTMLCollectionFrames;
import com.gargoylesoftware.htmlunit.javascript.host.History;
import com.gargoylesoftware.htmlunit.javascript.host.Location;
import com.gargoylesoftware.htmlunit.javascript.host.Navigator;
import com.gargoylesoftware.htmlunit.javascript.host.Netscape;
import com.gargoylesoftware.htmlunit.javascript.host.Screen;
import com.gargoylesoftware.htmlunit.javascript.host.Storage;
import com.gargoylesoftware.htmlunit.javascript.host.WindowOrWorkerGlobalScope;
import com.gargoylesoftware.htmlunit.javascript.host.WindowOrWorkerGlobalScopeMixin;
import com.gargoylesoftware.htmlunit.javascript.host.WindowProxy;
import com.gargoylesoftware.htmlunit.javascript.host.crypto.Crypto;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSS2Properties;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.css.MediaQueryList;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleMedia;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheetList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.DataTransfer;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.performance.Performance;
import com.gargoylesoftware.htmlunit.javascript.host.speech.SpeechSynthesis;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.EcmaError;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class Window
extends EventTarget
implements WindowOrWorkerGlobalScope,
Function,
AutoCloseable {
    private static final Log LOG = LogFactory.getLog(Window.class);
    private static final Set<String> ATTRIBUTES_AFFECTING_PARENT = new HashSet<String>(Arrays.asList("style", "class", "height", "width"));
    @JsxConstant(value={SupportedBrowser.CHROME})
    public static final short TEMPORARY = 0;
    @JsxConstant(value={SupportedBrowser.CHROME})
    public static final short PERSISTENT = 1;
    private Document document_;
    private DocumentProxy documentProxy_;
    private Navigator navigator_;
    private WebWindow webWindow_;
    private WindowProxy windowProxy_;
    private Screen screen_;
    private History history_;
    private Location location_;
    private ScriptableObject console_;
    private ApplicationCache applicationCache_;
    private Selection selection_;
    private Event currentEvent_;
    private String status_ = "";
    private Map<Class<? extends Scriptable>, Scriptable> prototypes_ = new HashMap<Class<? extends Scriptable>, Scriptable>();
    private Map<String, Scriptable> prototypesPerJSName_ = new HashMap<String, Scriptable>();
    private Object controllers_;
    private Object opener_;
    private Object top_ = NOT_FOUND;
    private Crypto crypto_;
    private CSSPropertiesCache cssPropertiesCache_ = new CSSPropertiesCache();
    private final EnumMap<StorageHolder.Type, Storage> storages_ = new EnumMap(StorageHolder.Type.class);
    private transient List<AnimationFrame> animationFrames_ = new ArrayList<AnimationFrame>();

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        throw ScriptRuntime.typeError((String)"Illegal constructor");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.cssPropertiesCache_ = new CSSPropertiesCache();
        this.animationFrames_ = new ArrayList<AnimationFrame>();
    }

    @Override
    public Scriptable getPrototype(Class<? extends SimpleScriptable> jsClass) {
        return this.prototypes_.get(jsClass);
    }

    public Scriptable getPrototype(String className) {
        return this.prototypesPerJSName_.get(className);
    }

    public void setPrototypes(Map<Class<? extends Scriptable>, Scriptable> map, Map<String, Scriptable> prototypesPerJSName) {
        this.prototypes_ = map;
        this.prototypesPerJSName_ = prototypesPerJSName;
    }

    @JsxFunction
    public void alert(Object message) {
        String stringMessage = Context.toString((Object)message);
        AlertHandler handler = this.getWebWindow().getWebClient().getAlertHandler();
        if (handler == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("window.alert(\"" + stringMessage + "\") no alert handler installed"));
            }
        } else {
            handler.handleAlert(this.document_.getPage(), stringMessage);
        }
    }

    @Override
    @JsxFunction
    public String btoa(String stringToEncode) {
        return WindowOrWorkerGlobalScopeMixin.btoa(stringToEncode);
    }

    @Override
    @JsxFunction
    public String atob(String encodedData) {
        return WindowOrWorkerGlobalScopeMixin.atob(encodedData);
    }

    @JsxFunction
    public boolean confirm(String message) {
        ConfirmHandler handler = this.getWebWindow().getWebClient().getConfirmHandler();
        if (handler == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("window.confirm(\"" + message + "\") no confirm handler installed, simulating the OK button"));
            }
            return true;
        }
        return handler.handleConfirm(this.document_.getPage(), message);
    }

    @JsxFunction
    public String prompt(String message, Object defaultValue) {
        PromptHandler handler = this.getWebWindow().getWebClient().getPromptHandler();
        if (handler == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("window.prompt(\"" + message + "\") no prompt handler installed"));
            }
            return null;
        }
        defaultValue = Undefined.isUndefined((Object)defaultValue) ? null : Context.toString((Object)defaultValue);
        return handler.handlePrompt(this.document_.getPage(), message, (String)defaultValue);
    }

    @JsxGetter(propertyName="document")
    public DocumentProxy getDocument_js() {
        return this.documentProxy_;
    }

    public Document getDocument() {
        return this.document_;
    }

    @JsxGetter
    public ApplicationCache getApplicationCache() {
        return this.applicationCache_;
    }

    @JsxGetter(value={SupportedBrowser.IE, SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public Object getEvent() {
        return this.currentEvent_;
    }

    public Event getCurrentEvent() {
        return this.currentEvent_;
    }

    public void setCurrentEvent(Event event) {
        this.currentEvent_ = event;
    }

    @JsxFunction
    public WindowProxy open(Object url, Object name, Object features, Object replace) {
        WebClient webClient;
        String urlString = null;
        if (!Undefined.isUndefined((Object)url)) {
            urlString = Context.toString((Object)url);
        }
        String windowName = "";
        if (!Undefined.isUndefined((Object)name)) {
            windowName = Context.toString((Object)name);
        }
        String featuresString = null;
        if (!Undefined.isUndefined((Object)features)) {
            featuresString = Context.toString((Object)features);
        }
        if ((webClient = this.getWebWindow().getWebClient()).getOptions().isPopupBlockerEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Ignoring window.open() invocation because popups are blocked.");
            }
            return null;
        }
        boolean replaceCurrentEntryInBrowsingHistory = false;
        if (!Undefined.isUndefined((Object)replace)) {
            replaceCurrentEntryInBrowsingHistory = Context.toBoolean((Object)replace);
        }
        if ((featuresString != null || replaceCurrentEntryInBrowsingHistory) && LOG.isDebugEnabled()) {
            LOG.debug((Object)("window.open: features and replaceCurrentEntryInBrowsingHistory not implemented: url=[" + urlString + "] windowName=[" + windowName + "] features=[" + featuresString + "] replaceCurrentEntry=[" + replaceCurrentEntryInBrowsingHistory + "]"));
        }
        if (StringUtils.isEmpty((CharSequence)urlString) && !"".equals(windowName)) {
            try {
                WebWindow webWindow = webClient.getWebWindowByName(windowName);
                return Window.getProxy(webWindow);
            }
            catch (WebWindowNotFoundException webWindow) {
                // empty catch block
            }
        }
        URL newUrl = this.makeUrlForOpenWindow(urlString);
        WebWindow newWebWindow = webClient.openWindow(newUrl, windowName, this.webWindow_);
        return Window.getProxy(newWebWindow);
    }

    private URL makeUrlForOpenWindow(String urlString) {
        if (urlString.isEmpty()) {
            return WebClient.URL_ABOUT_BLANK;
        }
        try {
            Page page = this.getWebWindow().getEnclosedPage();
            if (page != null && page.isHtmlPage()) {
                return ((HtmlPage)page).getFullyQualifiedUrl(urlString);
            }
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            if (LOG.isWarnEnabled()) {
                LOG.error((Object)("Unable to create URL for openWindow: relativeUrl=[" + urlString + "]"), (Throwable)e);
            }
            return null;
        }
    }

    @JsxFunction
    public static Object setTimeout(Context context, Scriptable thisObj, Object[] args, Function function) {
        return WindowOrWorkerGlobalScopeMixin.setTimeout(context, thisObj, args, function);
    }

    @JsxFunction
    public static Object setInterval(Context context, Scriptable thisObj, Object[] args, Function function) {
        return WindowOrWorkerGlobalScopeMixin.setInterval(context, thisObj, args, function);
    }

    @JsxFunction
    public void clearTimeout(int timeoutId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("clearTimeout(" + timeoutId + ")"));
        }
        this.getWebWindow().getJobManager().removeJob(timeoutId);
    }

    @JsxFunction
    public void clearInterval(int intervalID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("clearInterval(" + intervalID + ")"));
        }
        this.getWebWindow().getJobManager().removeJob(intervalID);
    }

    @JsxGetter
    public Navigator getNavigator() {
        return this.navigator_;
    }

    @JsxGetter(value={SupportedBrowser.IE, SupportedBrowser.CHROME})
    public Navigator getClientInformation() {
        return this.navigator_;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setClientInformation(Object ignore) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public DataTransfer getClipboardData() {
        DataTransfer dataTransfer = new DataTransfer();
        dataTransfer.setParentScope((Scriptable)this);
        dataTransfer.setPrototype(this.getPrototype(dataTransfer.getClass()));
        return dataTransfer;
    }

    @JsxGetter(propertyName="window")
    public Window getWindow_js() {
        return this;
    }

    @JsxGetter
    public Window getSelf() {
        return this;
    }

    @JsxGetter
    public Storage getLocalStorage() {
        return this.getStorage(StorageHolder.Type.LOCAL_STORAGE);
    }

    @JsxGetter
    public Storage getSessionStorage() {
        return this.getStorage(StorageHolder.Type.SESSION_STORAGE);
    }

    public Storage getStorage(StorageHolder.Type storageType) {
        return this.storages_.computeIfAbsent(storageType, k -> {
            WebWindow webWindow = this.getWebWindow();
            Map<String, String> store = webWindow.getWebClient().getStorageHolder().getStore(storageType, webWindow.getEnclosedPage());
            return new Storage(this, store);
        });
    }

    @JsxGetter
    public Location getLocation() {
        return this.location_;
    }

    @JsxSetter
    public void setLocation(String newLocation) throws IOException {
        this.location_.setHref(newLocation);
    }

    @JsxGetter
    public ScriptableObject getConsole() {
        return this.console_;
    }

    @JsxSetter
    public void setConsole(ScriptableObject console) {
        this.console_ = console;
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public void dump(String message) {
        if (this.console_ instanceof Console) {
            Console.log(null, (Scriptable)this.console_, new Object[]{message}, null);
        }
    }

    public int animateAnimationsFrames() {
        ArrayList<AnimationFrame> animationFrames = new ArrayList<AnimationFrame>(this.animationFrames_);
        this.animationFrames_.clear();
        double now = (double)System.nanoTime() / 1000000.0;
        Object[] args = new Object[]{now};
        WebWindow ww = this.getWindow().getWebWindow();
        JavaScriptEngine jsEngine = (JavaScriptEngine)ww.getWebClient().getJavaScriptEngine();
        for (AnimationFrame animationFrame : animationFrames) {
            jsEngine.callFunction((HtmlPage)ww.getEnclosedPage(), animationFrame.callback_, (Scriptable)this, this.getParentScope(), args);
        }
        return this.animationFrames_.size();
    }

    @JsxFunction
    public int requestAnimationFrame(Object callback) {
        if (callback instanceof Function) {
            int id = this.animationFrames_.size();
            AnimationFrame animationFrame = new AnimationFrame(id, (Function)callback);
            this.animationFrames_.add(animationFrame);
            return id;
        }
        return -1;
    }

    @JsxFunction
    public void cancelAnimationFrame(Object requestId) {
        int id = (int)Context.toNumber((Object)requestId);
        Iterator<AnimationFrame> frames = this.animationFrames_.iterator();
        while (frames.hasNext()) {
            AnimationFrame animationFrame = frames.next();
            if (animationFrame.id_ != (long)id) continue;
            frames.remove();
        }
    }

    @JsxGetter
    public Screen getScreen() {
        return this.screen_;
    }

    @JsxGetter
    public History getHistory() {
        return this.history_;
    }

    @JsxGetter
    public External getExternal() {
        External external = new External();
        external.setParentScope((Scriptable)this);
        external.setPrototype(this.getPrototype(external.getClass()));
        return external;
    }

    public void initialize(WebWindow webWindow) {
        WebWindow opener;
        this.webWindow_ = webWindow;
        this.webWindow_.setScriptableObject(this);
        this.windowProxy_ = new WindowProxy(this.webWindow_);
        Page enclosedPage = webWindow.getEnclosedPage();
        this.document_ = enclosedPage instanceof XmlPage ? new XMLDocument() : new HTMLDocument();
        this.document_.setParentScope((Scriptable)this);
        this.document_.setPrototype(this.getPrototype(this.document_.getClass()));
        this.document_.setWindow(this);
        if (enclosedPage instanceof SgmlPage) {
            SgmlPage page = (SgmlPage)enclosedPage;
            this.document_.setDomNode(page);
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            page.addDomChangeListener(listener);
            if (page.isHtmlPage()) {
                ((HtmlPage)page).addHtmlAttributeChangeListener(listener);
                ((HtmlPage)page).addAutoCloseable(this);
            }
        }
        this.documentProxy_ = new DocumentProxy(this.webWindow_);
        this.navigator_ = new Navigator();
        this.navigator_.setParentScope((Scriptable)this);
        this.navigator_.setPrototype(this.getPrototype(this.navigator_.getClass()));
        this.screen_ = new Screen();
        this.screen_.setParentScope((Scriptable)this);
        this.screen_.setPrototype(this.getPrototype(this.screen_.getClass()));
        this.history_ = new History();
        this.history_.setParentScope((Scriptable)this);
        this.history_.setPrototype(this.getPrototype(this.history_.getClass()));
        this.location_ = new Location();
        this.location_.setParentScope((Scriptable)this);
        this.location_.setPrototype(this.getPrototype(this.location_.getClass()));
        this.location_.initialize(this);
        this.console_ = new Console();
        ((Console)this.console_).setWebWindow(this.webWindow_);
        this.console_.setParentScope((Scriptable)this);
        ((Console)this.console_).setPrototype(this.getPrototype(((SimpleScriptable)this.console_).getClass()));
        this.applicationCache_ = new ApplicationCache();
        this.applicationCache_.setParentScope((Scriptable)this);
        this.applicationCache_.setPrototype(this.getPrototype(this.applicationCache_.getClass()));
        Context ctx = Context.getCurrentContext();
        this.controllers_ = ctx.newObject((Scriptable)this);
        if (this.webWindow_ instanceof TopLevelWindow && (opener = ((TopLevelWindow)this.webWindow_).getOpener()) != null) {
            this.opener_ = opener.getScriptableObject();
        }
    }

    public void initialize(Page enclosedPage) {
        if (enclosedPage != null && enclosedPage.isHtmlPage()) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            this.setDomNode(htmlPage);
            this.clearEventListenersContainer();
            WebAssert.notNull("document_", this.document_);
            this.document_.setDomNode(htmlPage);
        }
    }

    public void initialize() {
    }

    @JsxGetter
    public Object getTop() {
        if (this.top_ != NOT_FOUND) {
            return this.top_;
        }
        WebWindow top = this.getWebWindow().getTopWindow();
        return top.getScriptableObject();
    }

    @JsxSetter
    public void setTop(Object o) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_TOP_WRITABLE)) {
            this.top_ = o;
        }
    }

    @JsxGetter
    public ScriptableObject getParent() {
        WebWindow parent = this.getWebWindow().getParentWindow();
        return (ScriptableObject)parent.getScriptableObject();
    }

    @JsxGetter
    public Object getOpener() {
        Object opener = this.opener_;
        if (opener instanceof Window) {
            opener = ((Window)opener).windowProxy_;
        }
        return opener;
    }

    @JsxSetter
    public void setOpener(Object newValue) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_CHANGE_OPENER_ONLY_WINDOW_OBJECT) && newValue != null && !Undefined.isUndefined((Object)newValue) && !(newValue instanceof Window)) {
            throw Context.reportRuntimeError((String)"Can't set opener to something other than a window!");
        }
        this.opener_ = newValue;
    }

    @JsxGetter
    public Object getFrameElement() {
        WebWindow window = this.getWebWindow();
        if (window instanceof FrameWindow) {
            return ((FrameWindow)window).getFrameElement().getScriptableObject();
        }
        return null;
    }

    @JsxGetter(propertyName="frames")
    public Window getFrames_js() {
        return this;
    }

    @JsxGetter
    public int getLength() {
        HTMLCollection frames = this.getFrames();
        if (frames != null) {
            return frames.getLength();
        }
        return 0;
    }

    private HTMLCollection getFrames() {
        Page page = this.getWebWindow().getEnclosedPage();
        if (page instanceof HtmlPage) {
            return new HTMLCollectionFrames((HtmlPage)page);
        }
        return null;
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    @JsxFunction
    public void focus() {
        WebWindow window = this.getWebWindow();
        window.getWebClient().setCurrentWindow(window);
    }

    @JsxFunction
    public void blur() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"window.blur() not implemented");
        }
    }

    @JsxFunction(functionName="close")
    public void close_js() {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof TopLevelWindow) {
            ((TopLevelWindow)webWindow).close();
        } else {
            webWindow.getWebClient().deregisterWebWindow(webWindow);
        }
    }

    @JsxGetter
    public boolean isClosed() {
        WebWindow webWindow = this.getWebWindow();
        return !webWindow.getWebClient().containsWebWindow(webWindow);
    }

    @JsxFunction
    public void moveTo(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"window.moveTo() not implemented");
        }
    }

    @JsxFunction
    public void moveBy(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"window.moveBy() not implemented");
        }
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void navigate(String url) throws IOException {
        this.getLocation().assign(url);
    }

    @JsxFunction
    public void resizeBy(int width, int height) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"window.resizeBy() not implemented");
        }
    }

    @JsxFunction
    public void resizeTo(int width, int height) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"window.resizeTo() not implemented");
        }
    }

    @JsxFunction
    public void scroll(int x, int y) {
        this.scrollTo(x, y);
    }

    @JsxFunction
    public void scrollBy(int x, int y) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollLeft(body.getScrollLeft() + x);
            body.setScrollTop(body.getScrollTop() + y);
        }
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public void scrollByLines(int lines) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollTop(body.getScrollTop() + 19 * lines);
        }
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public void scrollByPages(int pages) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollTop(body.getScrollTop() + this.getInnerHeight() * pages);
        }
    }

    @JsxFunction
    public void scrollTo(int x, int y) {
        HTMLElement body = ((HTMLDocument)this.document_).getBody();
        if (body != null) {
            body.setScrollLeft(x);
            body.setScrollTop(y);
        }
    }

    @JsxGetter
    public Object getOnload() {
        Function onload = this.getEventHandler("load");
        if (onload == null) {
            HtmlPage page = (HtmlPage)this.getWebWindow().getEnclosedPage();
            HtmlElement body = page.getBody();
            if (body != null) {
                HTMLBodyElement b = (HTMLBodyElement)body.getScriptableObject();
                return b.getEventHandler("onload");
            }
            return null;
        }
        return onload;
    }

    @JsxSetter
    public void setOnload(Object onload) {
        this.setHandlerForJavaScript("load", onload);
    }

    @JsxSetter
    public void setOnblur(Object onblur) {
        this.setHandlerForJavaScript("blur", onblur);
    }

    @JsxGetter
    public Object getOnblur() {
        return this.getEventHandler("blur");
    }

    @JsxGetter
    public Object getOnclick() {
        return this.getEventHandler("click");
    }

    @JsxSetter
    public void setOnclick(Object onclick) {
        this.setHandlerForJavaScript("click", onclick);
    }

    @JsxGetter
    public Object getOndblclick() {
        return this.getEventHandler("dblclick");
    }

    @JsxSetter
    public void setOndblclick(Object ondblclick) {
        this.setHandlerForJavaScript("dblclick", ondblclick);
    }

    @JsxGetter
    public Object getOnhashchange() {
        return this.getEventHandler("hashchange");
    }

    @JsxSetter
    public void setOnhashchange(Object onhashchange) {
        this.setHandlerForJavaScript("hashchange", onhashchange);
    }

    @JsxGetter
    public String getName() {
        return this.getWebWindow().getName();
    }

    @JsxSetter
    public void setName(String name) {
        this.getWebWindow().setName(name);
    }

    @JsxGetter
    public Object getOnbeforeunload() {
        return this.getEventHandler("beforeunload");
    }

    @JsxSetter
    public void setOnbeforeunload(Object onbeforeunload) {
        this.setHandlerForJavaScript("beforeunload", onbeforeunload);
    }

    @JsxGetter
    public Object getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxSetter
    public void setOnerror(Object onerror) {
        this.setHandlerForJavaScript("error", onerror);
    }

    @JsxGetter
    public Object getOnmessage() {
        return this.getEventHandler("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setHandlerForJavaScript("message", onmessage);
    }

    public void triggerOnError(ScriptException e) {
        Object o = this.getOnerror();
        if (o instanceof Function) {
            Function f = (Function)o;
            String msg = e.getMessage();
            String url = e.getPage().getUrl().toExternalForm();
            int line = e.getFailingLineNumber();
            int column = e.getFailingColumnNumber();
            Object jsError = e.getMessage();
            if (e.getCause() instanceof JavaScriptException) {
                msg = "uncaught exception: " + e.getCause().getMessage();
                jsError = ((JavaScriptException)e.getCause()).getValue();
            } else if (e.getCause() instanceof EcmaError) {
                msg = "uncaught " + e.getCause().getMessage();
                EcmaError ecmaError = (EcmaError)e.getCause();
                Scriptable err = Context.getCurrentContext().newObject((Scriptable)this, "Error");
                ScriptableObject.putProperty((Scriptable)err, (String)"message", (Object)ecmaError.getMessage());
                ScriptableObject.putProperty((Scriptable)err, (String)"fileName", (Object)ecmaError.sourceName());
                ScriptableObject.putProperty((Scriptable)err, (String)"lineNumber", (Object)ecmaError.lineNumber());
                jsError = err;
            }
            Object[] args = new Object[]{msg, url, line, column, jsError};
            f.call(Context.getCurrentContext(), (Scriptable)this, (Scriptable)this, args);
        }
    }

    private void setHandlerForJavaScript(String eventName, Object handler) {
        this.getEventListenersContainer().setEventHandler(eventName, handler);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        throw Context.reportRuntimeError((String)"Window is not a function.");
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw Context.reportRuntimeError((String)"Window is not a function.");
    }

    public Object getWithFallback(String name) {
        Object result = NOT_FOUND;
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode != null) {
            HtmlPage page = (HtmlPage)domNode.getPage();
            result = Window.getFrameWindowByName(page, name);
            if (result == NOT_FOUND && (result = this.getElementsByName(page, name)) == NOT_FOUND) {
                try {
                    Object htmlElement = page.getHtmlElementById(name);
                    if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_FRAME_BY_ID_RETURNS_WINDOW) && htmlElement instanceof HtmlFrame) {
                        HtmlFrame frame = (HtmlFrame)htmlElement;
                        result = this.getScriptableFor(frame.getEnclosedWindow());
                    } else {
                        result = this.getScriptableFor(htmlElement);
                    }
                }
                catch (ElementNotFoundException e) {
                    result = NOT_FOUND;
                }
            }
            if (result instanceof Window) {
                WebWindow webWindow = ((Window)result).getWebWindow();
                result = Window.getProxy(webWindow);
            }
        }
        return result;
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || this.getWebWindow() == null) {
            return Undefined.instance;
        }
        HTMLCollection frames = this.getFrames();
        if (frames == null || index >= frames.getLength()) {
            return Undefined.instance;
        }
        return frames.item(index);
    }

    private static Object getFrameWindowByName(HtmlPage page, String name) {
        try {
            return page.getFrameByName(name).getScriptableObject();
        }
        catch (ElementNotFoundException e) {
            return NOT_FOUND;
        }
    }

    private Object getElementsByName(final HtmlPage page, String name) {
        List<DomElement> elements = page.getElementsByName(name);
        boolean includeFormFields = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_FORMFIELDS_ACCESSIBLE_BY_NAME);
        final Filter filter = new Filter(includeFormFields);
        Iterator<DomElement> it = elements.iterator();
        while (it.hasNext()) {
            if (filter.matches(it.next())) continue;
            it.remove();
        }
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            return this.getScriptableFor(elements.get(0));
        }
        final String expElementName = "null".equals(name) ? "" : name;
        return new HTMLCollection(page, true){

            @Override
            protected List<DomNode> computeElements() {
                List<DomElement> expElements = page.getElementsByName(expElementName);
                ArrayList<DomNode> result = new ArrayList<DomNode>(expElements.size());
                for (DomElement domElement : expElements) {
                    if (!filter.matches(domElement)) continue;
                    result.add(domElement);
                }
                return result;
            }

            @Override
            protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                if ("name".equals(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            }
        };
    }

    public static WindowProxy getProxy(WebWindow w) {
        return ((Window)w.getScriptableObject()).windowProxy_;
    }

    @JsxGetter
    public String getStatus() {
        return this.status_;
    }

    @JsxSetter
    public void setStatus(String message) {
        this.status_ = message;
        StatusHandler statusHandler = this.webWindow_.getWebClient().getStatusHandler();
        if (statusHandler != null) {
            statusHandler.statusMessageChanged(this.webWindow_.getEnclosedPage(), message);
        }
    }

    @JsxGetter
    public int getInnerWidth() {
        return this.getWebWindow().getInnerWidth();
    }

    @JsxSetter
    public void setInnerWidth(int width) {
        this.getWebWindow().setInnerWidth(width);
    }

    @JsxGetter
    public int getOuterWidth() {
        return this.getWebWindow().getOuterWidth();
    }

    @JsxSetter
    public void setOuterWidth(int width) {
        this.getWebWindow().setOuterWidth(width);
    }

    @JsxGetter
    public int getInnerHeight() {
        return this.getWebWindow().getInnerHeight();
    }

    @JsxSetter
    public void setInneHeight(int height) {
        this.getWebWindow().setInnerHeight(height);
    }

    @JsxGetter
    public int getOuterHeight() {
        return this.getWebWindow().getOuterHeight();
    }

    @JsxSetter
    public void setOuterHeight(int height) {
        this.getWebWindow().setOuterHeight(height);
    }

    @JsxFunction
    public void print() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"window.print() not implemented");
        }
    }

    @JsxFunction
    public void captureEvents(String type) {
    }

    @JsxFunction
    public void releaseEvents(String type) {
    }

    @JsxFunction(value={SupportedBrowser.IE}, functionName="CollectGarbage")
    public void collectGarbage() {
    }

    @JsxFunction
    public CSS2Properties getComputedStyle(Object element, String pseudoElement) {
        CSS2Properties styleFromCache;
        if (!(element instanceof Element)) {
            throw ScriptRuntime.typeError((String)"parameter 1 is not of type 'Element'");
        }
        Element e = (Element)element;
        String normalizedPseudo = pseudoElement;
        if (normalizedPseudo != null) {
            if (normalizedPseudo.startsWith("::")) {
                normalizedPseudo = normalizedPseudo.substring(1);
            } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_COMPUTED_STYLE_PSEUDO_ACCEPT_WITHOUT_COLON) && normalizedPseudo.length() > 0 && normalizedPseudo.charAt(0) != ':') {
                normalizedPseudo = ":" + normalizedPseudo;
            }
        }
        if ((styleFromCache = this.cssPropertiesCache_.get(e, normalizedPseudo)) != null) {
            return styleFromCache;
        }
        CSS2Properties style = new CSS2Properties(e.getStyle());
        Object ownerDocument = e.getOwnerDocument();
        if (ownerDocument instanceof HTMLDocument) {
            StyleSheetList sheets = ((HTMLDocument)ownerDocument).getStyleSheets();
            boolean trace = LOG.isTraceEnabled();
            for (int i = 0; i < sheets.getLength(); ++i) {
                CSSStyleSheet sheet = (CSSStyleSheet)sheets.item(i);
                if (!sheet.isActive() || !sheet.isEnabled()) continue;
                if (trace) {
                    LOG.trace((Object)("modifyIfNecessary: " + sheet + ", " + style + ", " + e));
                }
                sheet.modifyIfNecessary(style, e, normalizedPseudo);
            }
            this.cssPropertiesCache_.put(e, normalizedPseudo, style);
        }
        return style;
    }

    @JsxFunction
    public Selection getSelection() {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof FrameWindow) {
            FrameWindow frameWindow = (FrameWindow)webWindow;
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_SELECTION_NULL_IF_INVISIBLE) && !frameWindow.getFrameElement().isDisplayed()) {
                return null;
            }
        }
        return this.getSelectionImpl();
    }

    public Selection getSelectionImpl() {
        if (this.selection_ == null) {
            this.selection_ = new Selection();
            this.selection_.setParentScope((Scriptable)this);
            this.selection_.setPrototype(this.getPrototype(this.selection_.getClass()));
        }
        return this.selection_;
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object showModalDialog(String url, Object arguments, String features) {
        WebWindow webWindow = this.getWebWindow();
        WebClient client = webWindow.getWebClient();
        try {
            URL completeUrl = ((HtmlPage)this.getDomNodeOrDie()).getFullyQualifiedUrl(url);
            DialogWindow dialog = client.openDialogWindow(completeUrl, webWindow, arguments);
            ScriptableObject jsDialog = (ScriptableObject)dialog.getScriptableObject();
            return jsDialog.get("returnValue", (Scriptable)jsDialog);
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public Object showModelessDialog(String url, Object arguments, String features) {
        WebWindow webWindow = this.getWebWindow();
        WebClient client = webWindow.getWebClient();
        try {
            URL completeUrl = ((HtmlPage)this.getDomNodeOrDie()).getFullyQualifiedUrl(url);
            DialogWindow dialog = client.openDialogWindow(completeUrl, webWindow, arguments);
            return dialog.getScriptableObject();
        }
        catch (IOException e) {
            throw Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public Object getControllers() {
        return this.controllers_;
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setControllers(Object value) {
        this.controllers_ = value;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public int getMozInnerScreenX() {
        return 10;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public int getMozInnerScreenY() {
        return 79;
    }

    @JsxGetter(value={SupportedBrowser.FF68})
    public int getMozPaintCount() {
        return 0;
    }

    public void clearComputedStyles() {
        this.cssPropertiesCache_.clear();
    }

    public void clearComputedStyles(Element element) {
        this.cssPropertiesCache_.remove(element);
    }

    public void clearComputedStylesUpToRoot(Element element) {
        this.cssPropertiesCache_.remove(element);
        for (Element parent = element.getParentElement(); parent != null; parent = parent.getParentElement()) {
            this.cssPropertiesCache_.remove(parent);
        }
    }

    @JsxFunction(value={SupportedBrowser.IE}, functionName="ScriptEngine")
    public String scriptEngine() {
        return "JScript";
    }

    @JsxFunction(value={SupportedBrowser.IE}, functionName="ScriptEngineBuildVersion")
    public int scriptEngineBuildVersion() {
        return 12345;
    }

    @JsxFunction(value={SupportedBrowser.IE}, functionName="ScriptEngineMajorVersion")
    public int scriptEngineMajorVersion() {
        return this.getBrowserVersion().getBrowserVersionNumeric();
    }

    @JsxFunction(value={SupportedBrowser.IE}, functionName="ScriptEngineMinorVersion")
    public int scriptEngineMinorVersion() {
        return 0;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public void stop() {
    }

    @JsxGetter
    public int getPageXOffset() {
        return 0;
    }

    @JsxGetter
    public int getPageYOffset() {
        return 0;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public int getScrollX() {
        return 0;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public int getScrollY() {
        return 0;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public Netscape getNetscape() {
        return new Netscape(this);
    }

    public boolean isConst(String name) {
        if ("undefined".equals(name) || "Infinity".equals(name) || "NaN".equals(name)) {
            return false;
        }
        return super.isConst(name);
    }

    @Override
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        ScriptResult result = this.fireEvent(event);
        return !event.isAborted(result);
    }

    @JsxGetter
    public Object getOnchange() {
        return this.getEventHandler("change");
    }

    @JsxSetter
    public void setOnchange(Object onchange) {
        this.setHandlerForJavaScript("change", onchange);
    }

    @JsxGetter
    public Object getOnsubmit() {
        return this.getEventHandler("submit");
    }

    @JsxSetter
    public void setOnsubmit(Object onsubmit) {
        this.setHandlerForJavaScript("submit", onsubmit);
    }

    @JsxFunction
    public void postMessage(String message, String targetOrigin, Object transfer) {
        Page page = this.getWebWindow().getEnclosedPage();
        URL currentURL = page.getUrl();
        if (!"*".equals(targetOrigin) && !"/".equals(targetOrigin)) {
            URL targetURL = null;
            try {
                targetURL = new URL(targetOrigin);
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)new Exception("SyntaxError: Failed to execute 'postMessage' on 'Window': Invalid target origin '" + targetOrigin + "' was specified (reason: " + e.getMessage() + "."));
            }
            if (Window.getPort(targetURL) != Window.getPort(currentURL)) {
                return;
            }
            if (!targetURL.getHost().equals(currentURL.getHost())) {
                return;
            }
            if (!targetURL.getProtocol().equals(currentURL.getProtocol())) {
                return;
            }
        }
        final MessageEvent event = new MessageEvent();
        String origin = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
        event.initMessageEvent("message", false, false, message, origin, "", this, transfer);
        event.setParentScope((Scriptable)this);
        event.setPrototype(this.getPrototype(event.getClass()));
        final JavaScriptEngine jsEngine = (JavaScriptEngine)this.getWebWindow().getWebClient().getJavaScriptEngine();
        PostponedAction action = new PostponedAction(page){

            @Override
            public void execute() throws Exception {
                ContextAction<Object> contextAction = new ContextAction<Object>(){

                    public Object run(Context cx) {
                        return Window.this.dispatchEvent(event);
                    }
                };
                HtmlUnitContextFactory cf = jsEngine.getContextFactory();
                cf.call((ContextAction)contextAction);
            }
        };
        jsEngine.addPostponedAction(action);
    }

    public static int getPort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = "http".equals(url.getProtocol()) ? 80 : 443;
        }
        return port;
    }

    @JsxGetter
    public Performance getPerformance() {
        Performance performance = new Performance();
        performance.setParentScope((Scriptable)this);
        performance.setPrototype(this.getPrototype(performance.getClass()));
        return performance;
    }

    @JsxGetter
    public int getDevicePixelRatio() {
        return 1;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public StyleMedia getStyleMedia() {
        StyleMedia styleMedia = new StyleMedia();
        styleMedia.setParentScope((Scriptable)this);
        styleMedia.setPrototype(this.getPrototype(styleMedia.getClass()));
        return styleMedia;
    }

    @JsxFunction
    public MediaQueryList matchMedia(String mediaQueryString) {
        MediaQueryList mediaQueryList = new MediaQueryList(mediaQueryString);
        mediaQueryList.setParentScope((Scriptable)this);
        mediaQueryList.setPrototype(this.getPrototype(mediaQueryList.getClass()));
        return mediaQueryList;
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public boolean find(String search, boolean caseSensitive, boolean backwards, boolean wrapAround, boolean wholeWord, boolean searchInFrames, boolean showDialog) {
        return false;
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public SpeechSynthesis getSpeechSynthesis() {
        SpeechSynthesis speechSynthesis = new SpeechSynthesis();
        speechSynthesis.setParentScope((Scriptable)this);
        speechSynthesis.setPrototype(this.getPrototype(speechSynthesis.getClass()));
        return speechSynthesis;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Object getOffscreenBuffering() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_FRAMES_ACCESSIBLE_BY_ID)) {
            return "auto";
        }
        return true;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public Crypto getCrypto() {
        if (this.crypto_ == null) {
            this.crypto_ = new Crypto(this);
        }
        return this.crypto_;
    }

    @Override
    public void close() {
    }

    @Override
    public void setParentScope(Scriptable parent) {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnfocusin() {
        return this.getEventHandler("focusin");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnfocusin(Object onfocusin) {
        this.setHandlerForJavaScript("focusin", onfocusin);
    }

    @JsxGetter
    public Function getOnfocus() {
        return this.getEventHandler("focus");
    }

    @JsxSetter
    public void setOnfocus(Object onfocus) {
        this.setHandlerForJavaScript("focus", onfocus);
    }

    @JsxGetter
    public Function getOndragend() {
        return this.getEventHandler("dragend");
    }

    @JsxSetter
    public void setOndragend(Object ondragend) {
        this.setHandlerForJavaScript("dragend", ondragend);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOninvalid() {
        return this.getEventHandler("invalid");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOninvalid(Object oninvalid) {
        this.setHandlerForJavaScript("invalid", oninvalid);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Function getOnpointerout() {
        return this.getEventHandler("pointerout");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOnpointerout(Object onpointerout) {
        this.setHandlerForJavaScript("pointerout", onpointerout);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnhelp() {
        return this.getEventHandler("help");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnhelp(Object onhelp) {
        this.setHandlerForJavaScript("help", onhelp);
    }

    @JsxGetter
    public Function getOnratechange() {
        return this.getEventHandler("ratechange");
    }

    @JsxSetter
    public void setOnratechange(Object onratechange) {
        this.setHandlerForJavaScript("ratechange", onratechange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnanimationiteration() {
        return this.getEventHandler("animationiteration");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnanimationiteration(Object onanimationiteration) {
        this.setHandlerForJavaScript("animationiteration", onanimationiteration);
    }

    @JsxGetter
    public Function getOncanplaythrough() {
        return this.getEventHandler("canplaythrough");
    }

    @JsxSetter
    public void setOncanplaythrough(Object oncanplaythrough) {
        this.setHandlerForJavaScript("canplaythrough", oncanplaythrough);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOncancel() {
        return this.getEventHandler("cancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOncancel(Object oncancel) {
        this.setHandlerForJavaScript("cancel", oncancel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Function getOnpointerenter() {
        return this.getEventHandler("pointerenter");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOnpointerenter(Object onpointerenter) {
        this.setHandlerForJavaScript("pointerenter", onpointerenter);
    }

    @JsxGetter
    public Function getOnselect() {
        return this.getEventHandler("select");
    }

    @JsxSetter
    public void setOnselect(Object onselect) {
        this.setHandlerForJavaScript("select", onselect);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnauxclick() {
        return this.getEventHandler("auxclick");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnauxclick(Object onauxclick) {
        this.setHandlerForJavaScript("auxclick", onauxclick);
    }

    @JsxGetter
    public Function getOnscroll() {
        return this.getEventHandler("scroll");
    }

    @JsxSetter
    public void setOnscroll(Object onscroll) {
        this.setHandlerForJavaScript("scroll", onscroll);
    }

    @JsxGetter
    public Function getOnkeydown() {
        return this.getEventHandler("keydown");
    }

    @JsxSetter
    public void setOnkeydown(Object onkeydown) {
        this.setHandlerForJavaScript("keydown", onkeydown);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerleave() {
        return this.getEventHandler("mspointerleave");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerleave(Object onmspointerleave) {
        this.setHandlerForJavaScript("mspointerleave", onmspointerleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnwebkitanimationstart() {
        return this.getEventHandler("webkitanimationstart");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnwebkitanimationstart(Object onwebkitanimationstart) {
        this.setHandlerForJavaScript("webkitanimationstart", onwebkitanimationstart);
    }

    @JsxGetter
    public Function getOnkeyup() {
        return this.getEventHandler("keyup");
    }

    @JsxSetter
    public void setOnkeyup(Object onkeyup) {
        this.setHandlerForJavaScript("keyup", onkeyup);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturestart() {
        return this.getEventHandler("msgesturestart");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturestart(Object onmsgesturestart) {
        this.setHandlerForJavaScript("msgesturestart", onmsgesturestart);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOndeviceproximity() {
        return this.getEventHandler("deviceproximity");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOndeviceproximity(Object ondeviceproximity) {
        this.setHandlerForJavaScript("deviceproximity", ondeviceproximity);
    }

    @JsxGetter
    public Function getOnreset() {
        return this.getEventHandler("reset");
    }

    @JsxSetter
    public void setOnreset(Object onreset) {
        this.setHandlerForJavaScript("reset", onreset);
    }

    @JsxGetter
    public Function getOnkeypress() {
        return this.getEventHandler("keypress");
    }

    @JsxSetter
    public void setOnkeypress(Object onkeypress) {
        this.setHandlerForJavaScript("keypress", onkeypress);
    }

    @JsxGetter
    public Function getOndrag() {
        return this.getEventHandler("drag");
    }

    @JsxSetter
    public void setOndrag(Object ondrag) {
        this.setHandlerForJavaScript("drag", ondrag);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnfocusout() {
        return this.getEventHandler("focusout");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnfocusout(Object onfocusout) {
        this.setHandlerForJavaScript("focusout", onfocusout);
    }

    @JsxGetter
    public Function getOnseeked() {
        return this.getEventHandler("seeked");
    }

    @JsxSetter
    public void setOnseeked(Object onseeked) {
        this.setHandlerForJavaScript("seeked", onseeked);
    }

    @JsxGetter
    public Function getOnoffline() {
        return this.getEventHandler("offline");
    }

    @JsxSetter
    public void setOnoffline(Object onoffline) {
        this.setHandlerForJavaScript("offline", onoffline);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOndeviceorientation() {
        return this.getEventHandler("deviceorientation");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOndeviceorientation(Object ondeviceorientation) {
        this.setHandlerForJavaScript("deviceorientation", ondeviceorientation);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOntoggle() {
        return this.getEventHandler("toggle");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOntoggle(Object ontoggle) {
        this.setHandlerForJavaScript("toggle", ontoggle);
    }

    @JsxGetter
    public Function getOnplay() {
        return this.getEventHandler("play");
    }

    @JsxSetter
    public void setOnplay(Object onplay) {
        this.setHandlerForJavaScript("play", onplay);
    }

    @JsxGetter
    public Function getOncontextmenu() {
        return this.getEventHandler("contextmenu");
    }

    @JsxSetter
    public void setOncontextmenu(Object oncontextmenu) {
        this.setHandlerForJavaScript("contextmenu", oncontextmenu);
    }

    @JsxGetter
    public Function getOnmousemove() {
        return this.getEventHandler("mousemove");
    }

    @JsxSetter
    public void setOnmousemove(Object onmousemove) {
        this.setHandlerForJavaScript("mousemove", onmousemove);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnreadystatechange() {
        return this.getEventHandler("readystatechange");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnreadystatechange(Object onreadystatechange) {
        this.setHandlerForJavaScript("readystatechange", onreadystatechange);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerover() {
        return this.getEventHandler("mspointerover");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerover(Object onmspointerover) {
        this.setHandlerForJavaScript("mspointerover", onmspointerover);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Function getOnpointermove() {
        return this.getEventHandler("pointermove");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOnpointermove(Object onpointermove) {
        this.setHandlerForJavaScript("pointermove", onpointermove);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointermove() {
        return this.getEventHandler("mspointermove");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointermove(Object onmspointermove) {
        this.setHandlerForJavaScript("mspointermove", onmspointermove);
    }

    @JsxGetter
    public Function getOnmouseover() {
        return this.getEventHandler("mouseover");
    }

    @JsxSetter
    public void setOnmouseover(Object onmouseover) {
        this.setHandlerForJavaScript("mouseover", onmouseover);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOnuserproximity() {
        return this.getEventHandler("userproximity");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOnuserproximity(Object onuserproximity) {
        this.setHandlerForJavaScript("userproximity", onuserproximity);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnlostpointercapture() {
        return this.getEventHandler("lostpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnlostpointercapture(Object onlostpointercapture) {
        this.setHandlerForJavaScript("lostpointercapture", onlostpointercapture);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Function getOnpointerover() {
        return this.getEventHandler("pointerover");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOnpointerover(Object onpointerover) {
        this.setHandlerForJavaScript("pointerover", onpointerover);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnclose() {
        return this.getEventHandler("close");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnclose(Object onclose) {
        this.setHandlerForJavaScript("close", onclose);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnanimationend() {
        return this.getEventHandler("animationend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnanimationend(Object onanimationend) {
        this.setHandlerForJavaScript("animationend", onanimationend);
    }

    @JsxGetter
    public Function getOndragenter() {
        return this.getEventHandler("dragenter");
    }

    @JsxSetter
    public void setOndragenter(Object ondragenter) {
        this.setHandlerForJavaScript("dragenter", ondragenter);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.IE})
    public Function getOnafterprint() {
        return this.getEventHandler("afterprint");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.IE})
    public void setOnafterprint(Object onafterprint) {
        this.setHandlerForJavaScript("afterprint", onafterprint);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOnmozfullscreenerror() {
        return this.getEventHandler("mozfullscreenerror");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOnmozfullscreenerror(Object onmozfullscreenerror) {
        this.setHandlerForJavaScript("mozfullscreenerror", onmozfullscreenerror);
    }

    @JsxGetter
    public Function getOnmouseleave() {
        return this.getEventHandler("mouseleave");
    }

    @JsxSetter
    public void setOnmouseleave(Object onmouseleave) {
        this.setHandlerForJavaScript("mouseleave", onmouseleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Function getOnmousewheel() {
        return this.getEventHandler("mousewheel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOnmousewheel(Object onmousewheel) {
        this.setHandlerForJavaScript("mousewheel", onmousewheel);
    }

    @JsxGetter
    public Function getOnseeking() {
        return this.getEventHandler("seeking");
    }

    @JsxSetter
    public void setOnseeking(Object onseeking) {
        this.setHandlerForJavaScript("seeking", onseeking);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOncuechange() {
        return this.getEventHandler("cuechange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOncuechange(Object oncuechange) {
        this.setHandlerForJavaScript("cuechange", oncuechange);
    }

    @JsxGetter
    public Function getOnpageshow() {
        return this.getEventHandler("pageshow");
    }

    @JsxSetter
    public void setOnpageshow(Object onpageshow) {
        this.setHandlerForJavaScript("pageshow", onpageshow);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerenter() {
        return this.getEventHandler("mspointerenter");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerenter(Object onmspointerenter) {
        this.setHandlerForJavaScript("mspointerenter", onmspointerenter);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOnmozfullscreenchange() {
        return this.getEventHandler("mozfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOnmozfullscreenchange(Object onmozfullscreenchange) {
        this.setHandlerForJavaScript("mozfullscreenchange", onmozfullscreenchange);
    }

    @JsxGetter
    public Function getOndurationchange() {
        return this.getEventHandler("durationchange");
    }

    @JsxSetter
    public void setOndurationchange(Object ondurationchange) {
        this.setHandlerForJavaScript("durationchange", ondurationchange);
    }

    @JsxGetter
    public Function getOnplaying() {
        return this.getEventHandler("playing");
    }

    @JsxSetter
    public void setOnplaying(Object onplaying) {
        this.setHandlerForJavaScript("playing", onplaying);
    }

    @JsxGetter
    public Function getOnended() {
        return this.getEventHandler("ended");
    }

    @JsxSetter
    public void setOnended(Object onended) {
        this.setHandlerForJavaScript("ended", onended);
    }

    @JsxGetter
    public Function getOnloadeddata() {
        return this.getEventHandler("loadeddata");
    }

    @JsxSetter
    public void setOnloadeddata(Object onloadeddata) {
        this.setHandlerForJavaScript("loadeddata", onloadeddata);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnunhandledrejection() {
        return this.getEventHandler("unhandledrejection");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnunhandledrejection(Object onunhandledrejection) {
        this.setHandlerForJavaScript("unhandledrejection", onunhandledrejection);
    }

    @JsxGetter
    public Function getOnmouseout() {
        return this.getEventHandler("mouseout");
    }

    @JsxSetter
    public void setOnmouseout(Object onmouseout) {
        this.setHandlerForJavaScript("mouseout", onmouseout);
    }

    @JsxGetter
    public Function getOnsuspend() {
        return this.getEventHandler("suspend");
    }

    @JsxSetter
    public void setOnsuspend(Object onsuspend) {
        this.setHandlerForJavaScript("suspend", onsuspend);
    }

    @JsxGetter
    public Function getOnwaiting() {
        return this.getEventHandler("waiting");
    }

    @JsxSetter
    public void setOnwaiting(Object onwaiting) {
        this.setHandlerForJavaScript("waiting", onwaiting);
    }

    @JsxGetter
    public Function getOncanplay() {
        return this.getEventHandler("canplay");
    }

    @JsxSetter
    public void setOncanplay(Object oncanplay) {
        this.setHandlerForJavaScript("canplay", oncanplay);
    }

    @JsxGetter
    public Function getOnmousedown() {
        return this.getEventHandler("mousedown");
    }

    @JsxSetter
    public void setOnmousedown(Object onmousedown) {
        this.setHandlerForJavaScript("mousedown", onmousedown);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOnlanguagechange() {
        return this.getEventHandler("languagechange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOnlanguagechange(Object onlanguagechange) {
        this.setHandlerForJavaScript("languagechange", onlanguagechange);
    }

    @JsxGetter
    public Function getOnemptied() {
        return this.getEventHandler("emptied");
    }

    @JsxSetter
    public void setOnemptied(Object onemptied) {
        this.setHandlerForJavaScript("emptied", onemptied);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnrejectionhandled() {
        return this.getEventHandler("rejectionhandled");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnrejectionhandled(Object onrejectionhandled) {
        this.setHandlerForJavaScript("rejectionhandled", onrejectionhandled);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Function getOnpointercancel() {
        return this.getEventHandler("pointercancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOnpointercancel(Object onpointercancel) {
        this.setHandlerForJavaScript("pointercancel", onpointercancel);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgestureend() {
        return this.getEventHandler("msgestureend");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgestureend(Object onmsgestureend) {
        this.setHandlerForJavaScript("msgestureend", onmsgestureend);
    }

    @JsxGetter
    public Function getOnresize() {
        return this.getEventHandler("resize");
    }

    @JsxSetter
    public void setOnresize(Object onresize) {
        this.setHandlerForJavaScript("resize", onresize);
    }

    @JsxGetter
    public Function getOnpause() {
        return this.getEventHandler("pause");
    }

    @JsxSetter
    public void setOnpause(Object onpause) {
        this.setHandlerForJavaScript("pause", onpause);
    }

    @JsxGetter
    public Function getOnloadstart() {
        return this.getEventHandler("loadstart");
    }

    @JsxSetter
    public void setOnloadstart(Object onloadstart) {
        this.setHandlerForJavaScript("loadstart", onloadstart);
    }

    @JsxGetter
    public Function getOnprogress() {
        return this.getEventHandler("progress");
    }

    @JsxSetter
    public void setOnprogress(Object onprogress) {
        this.setHandlerForJavaScript("progress", onprogress);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Function getOnpointerup() {
        return this.getEventHandler("pointerup");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOnpointerup(Object onpointerup) {
        this.setHandlerForJavaScript("pointerup", onpointerup);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOnwheel() {
        return this.getEventHandler("wheel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOnwheel(Object onwheel) {
        this.setHandlerForJavaScript("wheel", onwheel);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerdown() {
        return this.getEventHandler("mspointerdown");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerdown(Object onmspointerdown) {
        this.setHandlerForJavaScript("mspointerdown", onmspointerdown);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Function getOnpointerleave() {
        return this.getEventHandler("pointerleave");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOnpointerleave(Object onpointerleave) {
        this.setHandlerForJavaScript("pointerleave", onpointerleave);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.IE})
    public Function getOnbeforeprint() {
        return this.getEventHandler("beforeprint");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF68, SupportedBrowser.IE})
    public void setOnbeforeprint(Object onbeforeprint) {
        this.setHandlerForJavaScript("beforeprint", onbeforeprint);
    }

    @JsxGetter
    public Function getOnstorage() {
        return this.getEventHandler("storage");
    }

    @JsxSetter
    public void setOnstorage(Object onstorage) {
        this.setHandlerForJavaScript("storage", onstorage);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOndevicelight() {
        return this.getEventHandler("devicelight");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOndevicelight(Object ondevicelight) {
        this.setHandlerForJavaScript("devicelight", ondevicelight);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnanimationstart() {
        return this.getEventHandler("animationstart");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnanimationstart(Object onanimationstart) {
        this.setHandlerForJavaScript("animationstart", onanimationstart);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointercancel() {
        return this.getEventHandler("mspointercancel");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointercancel(Object onmspointercancel) {
        this.setHandlerForJavaScript("mspointercancel", onmspointercancel);
    }

    @JsxGetter
    public Function getOntimeupdate() {
        return this.getEventHandler("timeupdate");
    }

    @JsxSetter
    public void setOntimeupdate(Object ontimeupdate) {
        this.setHandlerForJavaScript("timeupdate", ontimeupdate);
    }

    @JsxGetter
    public Function getOnpagehide() {
        return this.getEventHandler("pagehide");
    }

    @JsxSetter
    public void setOnpagehide(Object onpagehide) {
        this.setHandlerForJavaScript("pagehide", onpagehide);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnwebkitanimationiteration() {
        return this.getEventHandler("webkitanimationiteration");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnwebkitanimationiteration(Object onwebkitanimationiteration) {
        this.setHandlerForJavaScript("webkitanimationiteration", onwebkitanimationiteration);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerup() {
        return this.getEventHandler("mspointerup");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerup(Object onmspointerup) {
        this.setHandlerForJavaScript("mspointerup", onmspointerup);
    }

    @JsxGetter
    public Function getOnabort() {
        return this.getEventHandler("abort");
    }

    @JsxSetter
    public void setOnabort(Object onabort) {
        this.setHandlerForJavaScript("abort", onabort);
    }

    @JsxGetter
    public Function getOnloadedmetadata() {
        return this.getEventHandler("loadedmetadata");
    }

    @JsxSetter
    public void setOnloadedmetadata(Object onloadedmetadata) {
        this.setHandlerForJavaScript("loadedmetadata", onloadedmetadata);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsinertiastart() {
        return this.getEventHandler("msinertiastart");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsinertiastart(Object onmsinertiastart) {
        this.setHandlerForJavaScript("msinertiastart", onmsinertiastart);
    }

    @JsxGetter
    public Function getOnmouseup() {
        return this.getEventHandler("mouseup");
    }

    @JsxSetter
    public void setOnmouseup(Object onmouseup) {
        this.setHandlerForJavaScript("mouseup", onmouseup);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturetap() {
        return this.getEventHandler("msgesturetap");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturetap(Object onmsgesturetap) {
        this.setHandlerForJavaScript("msgesturetap", onmsgesturetap);
    }

    @JsxGetter
    public Function getOndragover() {
        return this.getEventHandler("dragover");
    }

    @JsxSetter
    public void setOndragover(Object ondragover) {
        this.setHandlerForJavaScript("dragover", ondragover);
    }

    @JsxGetter
    public Function getOnonline() {
        return this.getEventHandler("online");
    }

    @JsxSetter
    public void setOnonline(Object ononline) {
        this.setHandlerForJavaScript("online", ononline);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturedoubletap() {
        return this.getEventHandler("msgesturedoubletap");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturedoubletap(Object onmsgesturedoubletap) {
        this.setHandlerForJavaScript("msgesturedoubletap", onmsgesturedoubletap);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnsearch() {
        return this.getEventHandler("search");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnsearch(Object onsearch) {
        this.setHandlerForJavaScript("search", onsearch);
    }

    @JsxGetter
    public Function getOninput() {
        return this.getEventHandler("input");
    }

    @JsxSetter
    public void setOninput(Object oninput) {
        this.setHandlerForJavaScript("input", oninput);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnwebkittransitionend() {
        return this.getEventHandler("webkittransitionend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnwebkittransitionend(Object onwebkittransitionend) {
        this.setHandlerForJavaScript("webkittransitionend", onwebkittransitionend);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmspointerout() {
        return this.getEventHandler("mspointerout");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmspointerout(Object onmspointerout) {
        this.setHandlerForJavaScript("mspointerout", onmspointerout);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOndevicemotion() {
        return this.getEventHandler("devicemotion");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOndevicemotion(Object ondevicemotion) {
        this.setHandlerForJavaScript("devicemotion", ondevicemotion);
    }

    @JsxGetter
    public Function getOnstalled() {
        return this.getEventHandler("stalled");
    }

    @JsxSetter
    public void setOnstalled(Object onstalled) {
        this.setHandlerForJavaScript("stalled", onstalled);
    }

    @JsxGetter
    public Function getOnmouseenter() {
        return this.getEventHandler("mouseenter");
    }

    @JsxSetter
    public void setOnmouseenter(Object onmouseenter) {
        this.setHandlerForJavaScript("mouseenter", onmouseenter);
    }

    @JsxGetter
    public Function getOndragleave() {
        return this.getEventHandler("dragleave");
    }

    @JsxSetter
    public void setOndragleave(Object ondragleave) {
        this.setHandlerForJavaScript("dragleave", ondragleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public Function getOnpointerdown() {
        return this.getEventHandler("pointerdown");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public void setOnpointerdown(Object onpointerdown) {
        this.setHandlerForJavaScript("pointerdown", onpointerdown);
    }

    @JsxGetter
    public Function getOndrop() {
        return this.getEventHandler("drop");
    }

    @JsxSetter
    public void setOndrop(Object ondrop) {
        this.setHandlerForJavaScript("drop", ondrop);
    }

    @JsxGetter
    public Function getOnunload() {
        return this.getEventHandler("unload");
    }

    @JsxSetter
    public void setOnunload(Object onunload) {
        this.setHandlerForJavaScript("unload", onunload);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOnwebkitanimationend() {
        return this.getEventHandler("webkitanimationend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOnwebkitanimationend(Object onwebkitanimationend) {
        this.setHandlerForJavaScript("webkitanimationend", onwebkitanimationend);
    }

    @JsxGetter
    public Function getOndragstart() {
        return this.getEventHandler("dragstart");
    }

    @JsxSetter
    public void setOndragstart(Object ondragstart) {
        this.setHandlerForJavaScript("dragstart", ondragstart);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOntransitionend() {
        return this.getEventHandler("transitionend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOntransitionend(Object ontransitionend) {
        this.setHandlerForJavaScript("transitionend", ontransitionend);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturehold() {
        return this.getEventHandler("msgesturehold");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturehold(Object onmsgesturehold) {
        this.setHandlerForJavaScript("msgesturehold", onmsgesturehold);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOndeviceorientationabsolute() {
        return this.getEventHandler("deviceorientationabsolute");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOndeviceorientationabsolute(Object ondeviceorientationabsolute) {
        this.setHandlerForJavaScript("deviceorientationabsolute", ondeviceorientationabsolute);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public Function getOnshow() {
        return this.getEventHandler("show");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public void setOnshow(Object onshow) {
        this.setHandlerForJavaScript("show", onshow);
    }

    @JsxGetter
    public Function getOnvolumechange() {
        return this.getEventHandler("volumechange");
    }

    @JsxSetter
    public void setOnvolumechange(Object onvolumechange) {
        this.setHandlerForJavaScript("volumechange", onvolumechange);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Function getOnmsgesturechange() {
        return this.getEventHandler("msgesturechange");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setOnmsgesturechange(Object onmsgesturechange) {
        this.setHandlerForJavaScript("msgesturechange", onmsgesturechange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME})
    public Function getOngotpointercapture() {
        return this.getEventHandler("gotpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.CHROME})
    public void setOngotpointercapture(Object ongotpointercapture) {
        this.setHandlerForJavaScript("gotpointercapture", ongotpointercapture);
    }

    @JsxGetter
    public Function getOnpopstate() {
        return this.getEventHandler("popstate");
    }

    @JsxSetter
    public void setOnpopstate(Object onpopstate) {
        this.setHandlerForJavaScript("popstate", onpopstate);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Object getDoNotTrack() {
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        if (client.getOptions().isDoNotTrackEnabled()) {
            return 1;
        }
        return null;
    }

    protected boolean isReadOnlySettable(String name, Object value) {
        if ("closed".equals(name)) {
            return false;
        }
        return super.isReadOnlySettable(name, value);
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private DomHtmlAttributeChangeListenerImpl() {
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode(), null);
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.nodeChanged(event.getChangedNode(), null);
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement(), event.getName());
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement(), event.getName());
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            this.nodeChanged(event.getHtmlElement(), event.getName());
        }

        private void nodeChanged(DomNode changed, String attribName) {
            String rel;
            if (changed instanceof HtmlStyle) {
                Window.this.clearComputedStyles();
                return;
            }
            if (changed instanceof HtmlLink && "stylesheet".equals(rel = ((HtmlLink)changed).getRelAttribute().toLowerCase(Locale.ROOT))) {
                Window.this.clearComputedStyles();
                return;
            }
            boolean clearParents = ATTRIBUTES_AFFECTING_PARENT.contains(attribName);
            Window.this.cssPropertiesCache_.nodeChanged(changed, clearParents);
        }
    }

    private static final class Filter {
        private final boolean includeFormFields_;

        private Filter(boolean includeFormFields) {
            this.includeFormFields_ = includeFormFields;
        }

        private boolean matches(Object object) {
            if (object instanceof HtmlEmbed || object instanceof HtmlForm || object instanceof HtmlImage || object instanceof HtmlObject) {
                return true;
            }
            return this.includeFormFields_ && (object instanceof HtmlAnchor || object instanceof HtmlButton || object instanceof HtmlInput || object instanceof HtmlMap || object instanceof HtmlSelect || object instanceof HtmlTextArea);
        }
    }

    private static final class CSSPropertiesCache
    implements Serializable {
        private transient WeakHashMap<Element, Map<String, CSS2Properties>> computedStyles_ = new WeakHashMap();

        private CSSPropertiesCache() {
        }

        public synchronized CSS2Properties get(Element element, String normalizedPseudo) {
            Map<String, CSS2Properties> elementMap = this.computedStyles_.get(element);
            if (elementMap != null) {
                return elementMap.get(normalizedPseudo);
            }
            return null;
        }

        public synchronized void put(Element element, String normalizedPseudo, CSS2Properties style) {
            Map<String, CSS2Properties> elementMap = this.computedStyles_.get(element);
            if (elementMap == null) {
                elementMap = new WeakHashMap<String, CSS2Properties>();
                this.computedStyles_.put(element, elementMap);
            }
            elementMap.put(normalizedPseudo, style);
        }

        public synchronized void nodeChanged(DomNode changed, boolean clearParents) {
            Iterator<Map.Entry<Element, Map<String, CSS2Properties>>> i = this.computedStyles_.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Element, Map<String, CSS2Properties>> entry = i.next();
                DomElement node = entry.getKey().getDomNodeOrDie();
                if (changed != node && changed.getParentNode() != node.getParentNode() && !changed.isAncestorOf(node) && (!clearParents || !node.isAncestorOf(changed))) continue;
                i.remove();
            }
        }

        public synchronized void clear() {
            this.computedStyles_.clear();
        }

        public synchronized Map<String, CSS2Properties> remove(Element element) {
            return this.computedStyles_.remove(element);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.computedStyles_ = new WeakHashMap();
        }
    }

    private static final class AnimationFrame {
        private long id_;
        private Function callback_;

        private AnimationFrame(long id, Function callback) {
            this.id_ = id;
            this.callback_ = callback;
        }
    }
}

