/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.file;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Promise;
import com.gargoylesoftware.htmlunit.javascript.host.file.Blob;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.FastDateFormat;

@JsxClass
public class File
extends Blob {
    private static final String LAST_MODIFIED_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)";
    private static final String OPTIONS_TYPE_NAME = "type";
    private static final String OPTIONS_TYPE_DEFAULT = "";
    private static final String OPTIONS_LASTMODIFIED = "lastModified";
    private Backend backend_;

    public File() {
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public File(NativeArray fileBits, String fileName, ScriptableObject properties) {
        if (fileBits == null || Undefined.isUndefined((Object)fileBits) || fileName == null || Undefined.isUndefined((Object)fileName)) {
            throw ScriptRuntime.typeError((String)"Failed to construct 'File': 2 arguments required.");
        }
        this.backend_ = new InMemoryBackend(fileBits, fileName, this.extractFileTypeOrDefault(properties), this.extractLastModifiedOrDefault(properties));
    }

    private String extractFileTypeOrDefault(ScriptableObject properties) {
        if (properties == null || Undefined.isUndefined((Object)properties)) {
            return OPTIONS_TYPE_DEFAULT;
        }
        Object optionsType = properties.get(OPTIONS_TYPE_NAME, (Scriptable)properties);
        if (optionsType != null && properties != Scriptable.NOT_FOUND && !Undefined.isUndefined((Object)optionsType)) {
            return Context.toString((Object)optionsType);
        }
        return OPTIONS_TYPE_DEFAULT;
    }

    private long extractLastModifiedOrDefault(ScriptableObject properties) {
        if (properties == null || Undefined.isUndefined((Object)properties)) {
            return System.currentTimeMillis();
        }
        Object optionsType = properties.get(OPTIONS_LASTMODIFIED, (Scriptable)properties);
        if (optionsType != null && properties != Scriptable.NOT_FOUND && !Undefined.isUndefined((Object)optionsType)) {
            try {
                return Long.parseLong(Context.toString((Object)optionsType));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    File(String pathname) {
        this.backend_ = new FileBackend(pathname);
    }

    @JsxGetter
    public String getName() {
        return this.backend_.getName();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.IE})
    public String getLastModifiedDate() {
        Date date = new Date(this.getLastModified());
        BrowserVersion browser = this.getBrowserVersion();
        Locale locale = new Locale(browser.getSystemLanguage());
        TimeZone timezone = browser.getSystemTimezone();
        FastDateFormat format = FastDateFormat.getInstance((String)LAST_MODIFIED_DATE_FORMAT, (TimeZone)timezone, (Locale)locale);
        return format.format(date);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public long getLastModified() {
        return this.backend_.getLastModified();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
    public String getWebkitRelativePath() {
        return OPTIONS_TYPE_DEFAULT;
    }

    @JsxGetter
    public long getSize() {
        return this.backend_.getSize();
    }

    @JsxGetter
    public String getType() {
        return this.backend_.getType(this.getBrowserVersion());
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public Promise text() {
        try {
            return Promise.resolve(null, (Scriptable)this, new Object[]{this.backend_.getText()}, null);
        }
        catch (IOException e) {
            return Promise.reject(null, (Scriptable)this, new Object[]{e.getMessage()}, null);
        }
    }

    @JsxFunction
    public void slice() {
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void msClose() {
    }

    public java.io.File getFile() {
        return this.backend_.getFile();
    }

    private static class InMemoryBackend
    extends Backend {
        private final String fileName_;
        private final String type_;
        private final long lastModified_;
        private final byte[] bytes_;

        InMemoryBackend(NativeArray fileBits, String fileName, String type, long lastModified) {
            this.fileName_ = fileName;
            this.type_ = type;
            this.lastModified_ = lastModified;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (long i = 0L; i < fileBits.getLength(); ++i) {
                byte[] bytes;
                Object fileBit = fileBits.get(i);
                if (fileBit instanceof NativeArrayBuffer) {
                    bytes = ((NativeArrayBuffer)fileBit).getBuffer();
                    out.write(bytes, 0, bytes.length);
                    continue;
                }
                if (fileBit instanceof NativeArrayBufferView) {
                    bytes = ((NativeArrayBufferView)fileBit).getBuffer().getBuffer();
                    out.write(bytes, 0, bytes.length);
                    continue;
                }
                String bits = Context.toString((Object)fileBits.get(i));
                byte[] bytes2 = bits.getBytes(StandardCharsets.UTF_8);
                out.write(bytes2, 0, bytes2.length);
            }
            this.bytes_ = out.toByteArray();
        }

        @Override
        public String getName() {
            return this.fileName_;
        }

        @Override
        public long getLastModified() {
            return this.lastModified_;
        }

        @Override
        public long getSize() {
            return this.bytes_.length;
        }

        @Override
        public String getType(BrowserVersion browserVersion) {
            return this.type_;
        }

        @Override
        public String getText() throws IOException {
            return new String(this.bytes_, StandardCharsets.UTF_8);
        }

        @Override
        public java.io.File getFile() {
            throw new UnsupportedOperationException("com.gargoylesoftware.htmlunit.javascript.host.file.File.InMemoryBackend.getFile()");
        }
    }

    private static class FileBackend
    extends Backend
    implements Serializable {
        private java.io.File file_;

        FileBackend(String pathname) {
            this.file_ = new java.io.File(pathname);
        }

        @Override
        public String getName() {
            return this.file_.getName();
        }

        @Override
        public long getLastModified() {
            return this.file_.lastModified();
        }

        @Override
        public long getSize() {
            return this.file_.length();
        }

        @Override
        public String getType(BrowserVersion browserVersion) {
            return browserVersion.getUploadMimeType(this.file_);
        }

        @Override
        public String getText() throws IOException {
            return FileUtils.readFileToString((java.io.File)this.file_, (Charset)StandardCharsets.UTF_8);
        }

        @Override
        public java.io.File getFile() {
            return this.file_;
        }
    }

    private static abstract class Backend {
        private Backend() {
        }

        abstract String getName();

        abstract long getLastModified();

        abstract long getSize();

        abstract String getType(BrowserVersion var1);

        abstract String getText() throws IOException;

        abstract java.io.File getFile();
    }
}

