/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.media;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Promise;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.media.AudioBufferSourceNode;
import com.gargoylesoftware.htmlunit.javascript.host.media.BaseAudioContext;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.FF68})
public class AudioContext
extends BaseAudioContext {
    @JsxConstructor
    public AudioContext() {
    }

    @JsxFunction
    public AudioBufferSourceNode createBufferSource() {
        AudioBufferSourceNode node = new AudioBufferSourceNode();
        node.setParentScope(this.getParentScope());
        node.setPrototype(this.getPrototype(node.getClass()));
        return node;
    }

    @JsxFunction
    public Promise decodeAudioData(NativeArrayBuffer buffer, Function success, final Function error) {
        Window window = this.getWindow();
        final HtmlPage owningPage = (HtmlPage)window.getDocument().getPage();
        final JavaScriptEngine jsEngine = (JavaScriptEngine)window.getWebWindow().getWebClient().getJavaScriptEngine();
        if (error != null) {
            jsEngine.addPostponedAction(new PostponedAction(owningPage){

                @Override
                public void execute() throws Exception {
                    jsEngine.callFunction(owningPage, error, AudioContext.this.getParentScope(), (Scriptable)AudioContext.this, new Object[0]);
                }
            });
            return null;
        }
        Promise promise = Promise.reject(Context.getCurrentContext(), (Scriptable)this, new Object[0], null);
        return promise;
    }
}

