/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass(domClass=DomAttr.class)
public class Attr
extends Node {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF68})
    public Attr() {
    }

    public void detachFromParent() {
        DomAttr domNode = this.getDomNodeOrDie();
        DomElement parent = (DomElement)domNode.getParentNode();
        if (parent != null) {
            domNode.setValue(parent.getAttribute(this.getName()));
        }
        domNode.remove();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public boolean isExpando() {
        Object owner = this.getOwnerElement();
        if (null == owner) {
            return false;
        }
        return !ScriptableObject.hasProperty((Scriptable)((Scriptable)owner), (String)this.getName());
    }

    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getName();
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @JsxGetter
    public Object getOwnerElement() {
        DomElement parent = this.getDomNodeOrDie().getOwnerElement();
        if (parent != null) {
            return parent.getScriptableObject();
        }
        return null;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @JsxGetter
    public boolean isSpecified() {
        return this.getDomNodeOrDie().getSpecified();
    }

    @JsxGetter
    public String getValue() {
        return this.getDomNodeOrDie().getValue();
    }

    @JsxSetter
    public void setValue(String value) {
        this.getDomNodeOrDie().setValue(value);
    }

    @Override
    public Node getFirstChild() {
        return this.getLastChild();
    }

    @Override
    public Node getLastChild() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_ATTR_FIRST_LAST_CHILD_RETURNS_NULL)) {
            return null;
        }
        DomText text = new DomText(this.getDomNodeOrDie().getPage(), this.getNodeValue());
        return (Node)text.getScriptableObject();
    }

    @Override
    public DomAttr getDomNodeOrDie() {
        return (DomAttr)super.getDomNodeOrDie();
    }

    @Override
    @JsxGetter
    public Object getPrefix() {
        return super.getPrefix();
    }

    @Override
    @JsxGetter
    public Object getLocalName() {
        return super.getLocalName();
    }

    @Override
    @JsxGetter
    public Object getNamespaceURI() {
        return super.getNamespaceURI();
    }
}

