/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.HtmlExample;
import com.gargoylesoftware.htmlunit.html.HtmlListing;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.ArrayUtils;

@JsxClasses(value={@JsxClass(domClass=HtmlExample.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF68}), @JsxClass(domClass=HtmlPreformattedText.class), @JsxClass(domClass=HtmlListing.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF68})})
public class HTMLPreElement
extends HTMLElement {
    private static final String[] VALID_CLEAR_VALUES = new String[]{"left", "right", "all", "none"};

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF68})
    public HTMLPreElement() {
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getCite() {
        String cite = this.getDomNodeOrDie().getAttributeDirect("cite");
        return cite;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setCite(String cite) {
        this.getDomNodeOrDie().setAttribute("cite", cite);
    }

    @JsxGetter(propertyName="width")
    public Object getWidth_js() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_PRE_WIDTH_STRING)) {
            return this.getWidthOrHeight("width", Boolean.TRUE);
        }
        String value = this.getDomNodeOrDie().getAttributeDirect("width");
        Integer intValue = HTMLCanvasElement.getValue(value);
        if (intValue != null) {
            return intValue;
        }
        return 0;
    }

    @JsxSetter
    public void setWidth(String width) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_PRE_WIDTH_STRING)) {
            this.setWidthOrHeight("width", width, true);
        } else {
            this.getDomNodeOrDie().setAttribute("width", width);
        }
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getClear() {
        String clear = this.getDomNodeOrDie().getAttributeDirect("clear");
        if (!ArrayUtils.contains((Object[])VALID_CLEAR_VALUES, (Object)clear)) {
            return "";
        }
        return clear;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setClear(String clear) {
        if (!ArrayUtils.contains((Object[])VALID_CLEAR_VALUES, (Object)clear)) {
            throw Context.reportRuntimeError((String)("Invalid clear property value: '" + clear + "'."));
        }
        this.getDomNodeOrDie().setAttribute("clear", clear);
    }
}

