/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DoTypeProcessor;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextSelectionDelegate;
import com.gargoylesoftware.htmlunit.html.impl.SelectionDelegate;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlDateInput
extends HtmlInput
implements SelectableTextInput,
LabelableElement {
    private static DateTimeFormatter FORMATTER_ = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private SelectableTextSelectionDelegate selectionDelegate_ = new SelectableTextSelectionDelegate(this);
    private DoTypeProcessor doTypeProcessor_ = new DoTypeProcessor(this);

    HtmlDateInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    protected void doType(char c, boolean lastType) {
        this.doTypeProcessor_.doType(this.getValueAttribute(), (SelectionDelegate)this.selectionDelegate_, c, (HtmlElement)this, lastType);
    }

    @Override
    protected void doType(int keyCode, boolean lastType) {
        this.doTypeProcessor_.doType(this.getValueAttribute(), (SelectionDelegate)this.selectionDelegate_, keyCode, (HtmlElement)this, lastType);
    }

    @Override
    protected void typeDone(String newValue, boolean notifyAttributeChangeListeners) {
        if (newValue.length() <= this.getMaxLength()) {
            this.setAttributeNS(null, "value", newValue, notifyAttributeChangeListeners, false);
        }
    }

    @Override
    protected boolean isSubmittableByEnter() {
        return true;
    }

    @Override
    public void select() {
        this.selectionDelegate_.select();
    }

    @Override
    public String getSelectedText() {
        return this.selectionDelegate_.getSelectedText();
    }

    @Override
    public String getText() {
        return this.getValueAttribute();
    }

    @Override
    public void setText(String text) {
        this.setValueAttribute(text);
    }

    @Override
    public int getSelectionStart() {
        return this.selectionDelegate_.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        this.selectionDelegate_.setSelectionStart(selectionStart);
    }

    @Override
    public int getSelectionEnd() {
        return this.selectionDelegate_.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        this.selectionDelegate_.setSelectionEnd(selectionEnd);
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        Page page;
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
        if ("value".equals(qualifiedName) && (page = this.getPage()) != null && ((SgmlPage)page).isHtmlPage()) {
            int pos = 0;
            if (!this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_MOVE_SELECTION_TO_START)) {
                pos = attributeValue.length();
            }
            this.setSelectionStart(pos);
            this.setSelectionEnd(pos);
        }
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        boolean modifyValue = this.getValueAttribute().equals(this.getDefaultValue());
        this.setDefaultValue(defaultValue, modifyValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValueAttribute(String newValue) {
        try {
            if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_DATE_SUPPORTED) && StringUtils.isNotEmpty((CharSequence)newValue)) {
                FORMATTER_.parse(newValue);
            }
            super.setValueAttribute(newValue);
        }
        catch (DateTimeParseException dateTimeParseException) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setSelectionEnd(0);
    }

    @Override
    protected boolean isPatternSupported() {
        return true;
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlDateInput newnode = (HtmlDateInput)super.cloneNode(deep);
        newnode.selectionDelegate_ = new SelectableTextSelectionDelegate(newnode);
        newnode.doTypeProcessor_ = new DoTypeProcessor(newnode);
        return newnode;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isMaxValid() && this.isMinValid();
    }

    private boolean isMinValid() {
        if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_DATE_SUPPORTED) && !this.getMin().isEmpty()) {
            try {
                LocalDate dateValue = LocalDate.parse(this.getValueAttribute(), FORMATTER_);
                LocalDate minDate = LocalDate.parse(this.getMin(), FORMATTER_);
                return minDate.isEqual(dateValue) || minDate.isBefore(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean isMaxValid() {
        if (this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_DATE_SUPPORTED) && !this.getMax().isEmpty()) {
            try {
                LocalDate dateValue = LocalDate.parse(this.getValueAttribute(), FORMATTER_);
                LocalDate maxDate = LocalDate.parse(this.getMax(), FORMATTER_);
                return maxDate.isEqual(dateValue) || maxDate.isAfter(dateValue);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return true;
    }
}

