/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html.serializer;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlListItem;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlNumberInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOrderedList;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.HtmlUnorderedList;
import com.gargoylesoftware.htmlunit.html.TableRowGroup;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HtmlSerializerNormalizedText {
    private boolean ignoreMaskedElements_ = true;

    public String asText(DomNode node) {
        HtmlSerializerTextBuilder builder = new HtmlSerializerTextBuilder();
        this.appendNode(builder, node);
        return builder.getText();
    }

    protected void appendChildren(HtmlSerializerTextBuilder builder, DomNode node) {
        for (DomNode child : node.getChildren()) {
            this.appendNode(builder, child);
        }
    }

    protected void appendNode(HtmlSerializerTextBuilder builder, DomNode node) {
        if (node instanceof DomText) {
            this.appendText(builder, (DomText)node);
        } else if (!(node instanceof DomComment || node instanceof HtmlApplet && node.getPage().getWebClient().getOptions().isAppletEnabled())) {
            if (node instanceof HtmlBreak) {
                this.appendBreak(builder, (HtmlBreak)node);
            } else if (!(node instanceof HtmlHiddenInput || node instanceof HtmlScript || node instanceof HtmlStyle || node instanceof HtmlNoFrames)) {
                if (node instanceof HtmlTextArea) {
                    this.appendTextArea(builder, (HtmlTextArea)node);
                } else if (node instanceof HtmlTitle) {
                    this.appendTitle(builder, (HtmlTitle)node);
                } else if (node instanceof HtmlTableRow) {
                    this.appendTableRow(builder, (HtmlTableRow)node);
                } else if (node instanceof HtmlSelect) {
                    this.appendSelect(builder, (HtmlSelect)node);
                } else if (node instanceof HtmlSubmitInput) {
                    this.appendSubmitInput(builder, (HtmlSubmitInput)node);
                } else if (node instanceof HtmlResetInput) {
                    this.appendResetInput(builder, (HtmlResetInput)node);
                } else if (node instanceof HtmlCheckBoxInput) {
                    this.appendCheckBoxInput(builder, (HtmlCheckBoxInput)node);
                } else if (node instanceof HtmlRadioButtonInput) {
                    this.appendRadioButtonInput(builder, (HtmlRadioButtonInput)node);
                } else if (node instanceof HtmlNumberInput) {
                    this.appendNumberInput(builder, (HtmlNumberInput)node);
                } else if (node instanceof HtmlInput) {
                    this.appendInput(builder, (HtmlInput)node);
                } else if (node instanceof HtmlTable) {
                    this.appendTable(builder, (HtmlTable)node);
                } else if (node instanceof HtmlOrderedList) {
                    this.appendOrderedList(builder, (HtmlOrderedList)node);
                } else if (node instanceof HtmlUnorderedList) {
                    this.appendUnorderedList(builder, (HtmlUnorderedList)node);
                } else if (node instanceof HtmlPreformattedText) {
                    this.appendPreformattedText(builder, (HtmlPreformattedText)node);
                } else if (node instanceof HtmlInlineFrame) {
                    this.appendInlineFrame(builder, (HtmlInlineFrame)node);
                } else if (!(node instanceof HtmlNoScript) || !node.getPage().getWebClient().isJavaScriptEnabled()) {
                    this.appendDomNode(builder, node);
                }
            }
        }
    }

    protected void appendDomNode(HtmlSerializerTextBuilder builder, DomNode domNode) {
        Object scriptableObject;
        SgmlPage page;
        boolean block = false;
        if (!(domNode instanceof HtmlBody) && (page = domNode.getPage()) != null && page.getWebClient().isJavaScriptEngineEnabled() && (scriptableObject = domNode.getScriptableObject()) instanceof Element) {
            Element element = (Element)scriptableObject;
            String display = element.getWindow().getComputedStyle(element, null).getDisplay();
            block = "block".equals(display);
        }
        if (block) {
            builder.appendBlockSeparator();
        }
        this.appendChildren(builder, domNode);
        if (block) {
            builder.appendBlockSeparator();
        }
    }

    protected void appendSubmitInput(HtmlSerializerTextBuilder builder, HtmlSubmitInput htmlSubmitInput) {
        String text = htmlSubmitInput.getValueAttribute();
        if (text == DomElement.ATTRIBUTE_NOT_DEFINED) {
            text = "Submit Query";
        }
        builder.append(text, HtmlSerializerTextBuilder.Mode.NORMALIZE);
    }

    protected void appendInput(HtmlSerializerTextBuilder builder, HtmlInput htmlInput) {
        builder.append(" ", HtmlSerializerTextBuilder.Mode.NORMALIZE);
        builder.append(htmlInput.getValueAttribute(), HtmlSerializerTextBuilder.Mode.NORMALIZE);
        builder.append(" ", HtmlSerializerTextBuilder.Mode.NORMALIZE);
    }

    protected void appendNumberInput(HtmlSerializerTextBuilder builder, HtmlNumberInput htmlNumberInput) {
        builder.append(" ", HtmlSerializerTextBuilder.Mode.NORMALIZE);
        String val = htmlNumberInput.getValueAttribute();
        int lastPos = val.length() - 1;
        if (lastPos >= 0 && val.charAt(lastPos) == '.') {
            val = val.substring(0, lastPos);
        }
        builder.append(val, HtmlSerializerTextBuilder.Mode.NORMALIZE);
        builder.append(" ", HtmlSerializerTextBuilder.Mode.NORMALIZE);
    }

    protected void appendResetInput(HtmlSerializerTextBuilder builder, HtmlResetInput htmlResetInput) {
        String text = htmlResetInput.getValueAttribute();
        if (text == DomElement.ATTRIBUTE_NOT_DEFINED) {
            text = "Reset";
        }
        builder.append(text, HtmlSerializerTextBuilder.Mode.NORMALIZE);
    }

    protected void appendUnorderedList(HtmlSerializerTextBuilder builder, HtmlUnorderedList htmlUnorderedList) {
        builder.appendBlockSeparator();
        boolean first = true;
        for (DomNode item : htmlUnorderedList.getChildren()) {
            if (!first) {
                builder.appendBlockSeparator();
            }
            first = false;
            this.appendNode(builder, item);
        }
        builder.appendBlockSeparator();
    }

    protected void appendTitle(HtmlSerializerTextBuilder builder, HtmlTitle htmlTitle) {
        DomNode child = htmlTitle.getFirstChild();
        if (child instanceof DomText) {
            builder.append(((DomText)child).getData(), HtmlSerializerTextBuilder.Mode.NORMALIZE);
            builder.appendBlockSeparator();
        }
    }

    protected void appendTableRow(HtmlSerializerTextBuilder builder, HtmlTableRow htmlTableRow) {
        boolean first = true;
        for (HtmlTableCell cell : htmlTableRow.getCells()) {
            if (!first) {
                builder.appendTab();
            } else {
                first = false;
            }
            this.appendChildren(builder, cell);
        }
    }

    protected void appendTextArea(HtmlSerializerTextBuilder builder, HtmlTextArea htmlTextArea) {
        if (this.isVisible(htmlTextArea)) {
            builder.append(htmlTextArea.getText(), HtmlSerializerTextBuilder.Mode.PRESERVE_BLANK_NEWLINE);
        }
    }

    protected void appendTable(HtmlSerializerTextBuilder builder, HtmlTable htmlTable) {
        DomNode firstChild;
        builder.appendBlockSeparator();
        String caption = htmlTable.getCaptionText();
        if (caption != null) {
            builder.append(caption, HtmlSerializerTextBuilder.Mode.NORMALIZE);
            builder.appendBlockSeparator();
        }
        boolean first = true;
        HtmlTableHeader tableHeader = htmlTable.getHeader();
        if (tableHeader != null) {
            first = this.appendTableRows(builder, tableHeader.getRows(), true, null, null);
        }
        HtmlTableFooter tableFooter = htmlTable.getFooter();
        List<HtmlTableRow> tableRows = htmlTable.getRows();
        first = this.appendTableRows(builder, tableRows, first, tableHeader, tableFooter);
        if (tableFooter != null) {
            first = this.appendTableRows(builder, tableFooter.getRows(), first, null, null);
        } else if (tableRows.isEmpty() && (firstChild = htmlTable.getFirstChild()) != null) {
            this.appendNode(builder, firstChild);
        }
        builder.appendBlockSeparator();
    }

    protected boolean appendTableRows(HtmlSerializerTextBuilder builder, List<HtmlTableRow> rows, boolean first, TableRowGroup skipParent1, TableRowGroup skipParent2) {
        for (HtmlTableRow row : rows) {
            if (row.getParentNode() == skipParent1 || row.getParentNode() == skipParent2) continue;
            if (!first) {
                builder.appendBlockSeparator();
            }
            first = false;
            this.appendTableRow(builder, row);
        }
        return first;
    }

    protected void appendSelect(HtmlSerializerTextBuilder builder, HtmlSelect htmlSelect) {
        List<HtmlOption> options = htmlSelect.getSelectedOptions();
        Iterator<HtmlOption> i = options.iterator();
        while (i.hasNext()) {
            HtmlOption currentOption = i.next();
            this.appendChildren(builder, currentOption);
            if (!i.hasNext()) continue;
            builder.appendBlockSeparator();
        }
    }

    protected void appendOrderedList(HtmlSerializerTextBuilder builder, HtmlOrderedList htmlOrderedList) {
        builder.appendBlockSeparator();
        boolean first = true;
        int i = 1;
        for (DomNode item : htmlOrderedList.getChildren()) {
            if (!first) {
                builder.appendBlockSeparator();
            }
            first = false;
            if (item instanceof HtmlListItem) {
                builder.append(Integer.toString(i++), HtmlSerializerTextBuilder.Mode.NORMALIZE);
                builder.append(". ", HtmlSerializerTextBuilder.Mode.NORMALIZE);
                this.appendChildren(builder, item);
                continue;
            }
            this.appendNode(builder, item);
        }
        builder.appendBlockSeparator();
    }

    protected void appendPreformattedText(HtmlSerializerTextBuilder builder, HtmlPreformattedText htmlPreformattedText) {
        if (this.isVisible(htmlPreformattedText)) {
            builder.appendBlockSeparator();
            builder.append(htmlPreformattedText.getTextContent(), HtmlSerializerTextBuilder.Mode.PRESERVE_BLANK_TAB_NEWLINE);
            builder.appendBlockSeparator();
        }
    }

    protected void appendInlineFrame(HtmlSerializerTextBuilder builder, HtmlInlineFrame htmlInlineFrame) {
        if (this.isVisible(htmlInlineFrame)) {
            builder.appendBlockSeparator();
            Page page = htmlInlineFrame.getEnclosedPage();
            if (page instanceof SgmlPage) {
                builder.append(((SgmlPage)page).asNormalizedText(), HtmlSerializerTextBuilder.Mode.NORMALIZE);
            }
            builder.appendBlockSeparator();
        }
    }

    protected void appendText(HtmlSerializerTextBuilder builder, DomText domText) {
        DomNode parent = domText.getParentNode();
        if (parent == null || parent instanceof HtmlTitle || this.isVisible(parent)) {
            builder.append(domText.getData(), HtmlSerializerTextBuilder.Mode.NORMALIZE);
        }
    }

    protected void appendBreak(HtmlSerializerTextBuilder builder, HtmlBreak htmlBreak) {
        builder.appendNewLine();
    }

    protected void appendCheckBoxInput(HtmlSerializerTextBuilder builder, HtmlCheckBoxInput htmlCheckBoxInput) {
        if (htmlCheckBoxInput.isChecked()) {
            builder.append("checked", HtmlSerializerTextBuilder.Mode.NORMALIZE);
        } else {
            builder.append("unchecked", HtmlSerializerTextBuilder.Mode.NORMALIZE);
        }
    }

    protected void appendRadioButtonInput(HtmlSerializerTextBuilder builder, HtmlRadioButtonInput htmlRadioButtonInput) {
        if (htmlRadioButtonInput.isChecked()) {
            builder.append("checked", HtmlSerializerTextBuilder.Mode.NORMALIZE);
        } else {
            builder.append("unchecked", HtmlSerializerTextBuilder.Mode.NORMALIZE);
        }
    }

    private boolean isVisible(DomNode node) {
        return !this.ignoreMaskedElements_ || node.isDisplayed();
    }

    public void setIgnoreMaskedElements(boolean ignore) {
        this.ignoreMaskedElements_ = ignore;
    }

    protected static class HtmlSerializerTextBuilder {
        private static final String LINE_SEPARATOR = "\n";
        private static final int LINE_SEPARATOR_LENGTH = "\n".length();
        private State state_;
        private final StringBuilder builder_ = new StringBuilder();
        private int trimRightPos_;

        public HtmlSerializerTextBuilder() {
            this.state_ = State.EMPTY;
            this.trimRightPos_ = this.builder_.length();
        }

        public void append(String content, Mode mode) {
            int length = content.length();
            if (length == 0) {
                return;
            }
            String text = content;
            if (mode == Mode.PRESERVE_BLANK_NEWLINE) {
                text = StringUtils.stripEnd((String)text, null);
            }
            boolean crFound = false;
            for (char c : text.toCharArray()) {
                if (mode == Mode.NORMALIZE) {
                    if (HtmlSerializerTextBuilder.isSpace(c)) {
                        switch (this.state_) {
                            case EMPTY: 
                            case TRIM: 
                            case BLANK_AT_END: 
                            case BLANK_AT_END_AFTER_NEWLINE: 
                            case BLOCK_SEPARATOR_AT_END: {
                                break;
                            }
                            case NEWLINE_AT_END: {
                                this.builder_.append(' ');
                                this.state_ = State.BLANK_AT_END_AFTER_NEWLINE;
                                break;
                            }
                            default: {
                                this.builder_.append(' ');
                                this.state_ = State.BLANK_AT_END;
                                break;
                            }
                        }
                        continue;
                    }
                    if (c == '\u00a0') {
                        this.builder_.append(' ');
                        this.state_ = State.DEFAULT;
                        this.trimRightPos_ = this.builder_.length();
                        continue;
                    }
                    this.builder_.append(c);
                    this.state_ = State.DEFAULT;
                    this.trimRightPos_ = this.builder_.length();
                    continue;
                }
                if (c == '\n') {
                    this.appendNewLine();
                    crFound = false;
                    continue;
                }
                if (crFound) {
                    this.appendNewLine();
                }
                boolean bl = crFound = c == '\r';
                if (c == '\t') {
                    if (mode == Mode.PRESERVE_BLANK_TAB_NEWLINE) {
                        this.appendTab();
                    } else if (this.state_ != State.BLOCK_SEPARATOR_AT_END) {
                        this.builder_.append(' ');
                    }
                } else if (c == '\u00a0') {
                    this.appendBlank();
                } else if (c == ' ') {
                    this.appendBlank();
                } else {
                    this.builder_.append(c);
                }
                this.trimRightPos_ = this.builder_.length();
            }
            if (crFound) {
                this.appendNewLine();
            }
            if (mode != Mode.NORMALIZE) {
                this.state_ = State.TRIM;
            }
        }

        public void appendBlockSeparator() {
            switch (this.state_) {
                case EMPTY: {
                    break;
                }
                case BLANK_AT_END: {
                    this.builder_.setLength(this.trimRightPos_);
                    if (this.builder_.length() == 0) {
                        this.state_ = State.EMPTY;
                        break;
                    }
                    this.builder_.append(LINE_SEPARATOR);
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                    break;
                }
                case BLANK_AT_END_AFTER_NEWLINE: {
                    this.builder_.setLength(this.trimRightPos_ - LINE_SEPARATOR_LENGTH);
                    this.trimRightPos_ -= LINE_SEPARATOR_LENGTH;
                    if (this.builder_.length() == 0) {
                        this.state_ = State.EMPTY;
                        break;
                    }
                    this.builder_.append(LINE_SEPARATOR);
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                    break;
                }
                case BLOCK_SEPARATOR_AT_END: {
                    break;
                }
                case NEWLINE_AT_END: {
                    this.builder_.setLength(this.builder_.length() - LINE_SEPARATOR_LENGTH);
                    this.trimRightPos_ -= LINE_SEPARATOR_LENGTH;
                    if (this.builder_.length() == 0) {
                        this.state_ = State.EMPTY;
                        break;
                    }
                    this.builder_.append(LINE_SEPARATOR);
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                    break;
                }
                default: {
                    this.builder_.append(LINE_SEPARATOR);
                    this.state_ = State.BLOCK_SEPARATOR_AT_END;
                }
            }
        }

        public void appendNewLine() {
            this.builder_.append(LINE_SEPARATOR);
            this.state_ = State.NEWLINE_AT_END;
            this.trimRightPos_ = this.builder_.length();
        }

        public void appendTab() {
            this.builder_.append('\t');
            this.trimRightPos_ = this.builder_.length();
        }

        private void appendBlank() {
            this.builder_.append(' ');
            this.trimRightPos_ = this.builder_.length();
        }

        public String getText() {
            return this.builder_.substring(0, this.trimRightPos_);
        }

        private static boolean isSpace(char ch) {
            return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\f' || ch == '\r';
        }

        private static enum State {
            DEFAULT,
            EMPTY,
            TRIM,
            BLANK_AT_END,
            BLANK_AT_END_AFTER_NEWLINE,
            NEWLINE_AT_END,
            BLOCK_SEPARATOR_AT_END;

        }

        protected static enum Mode {
            NORMALIZE,
            PRESERVE_BLANK_TAB_NEWLINE,
            PRESERVE_BLANK_NEWLINE;

        }
    }
}

