/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering;

import com.gargoylesoftware.htmlunit.html.impl.Color;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.ImageData;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.Path2D;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.RenderingBackend;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwtRenderingBackend
implements RenderingBackend {
    private static final Log LOG = LogFactory.getLog(AwtRenderingBackend.class);
    private static int ID_GENERATOR_ = 0;
    private static final Map<String, java.awt.Color> knownColors = new HashMap<String, java.awt.Color>();
    private final int id_ = ID_GENERATOR_++;
    private final BufferedImage image_;
    private final Graphics2D graphics2D_;
    private AffineTransform transformation_;
    private float globalAlpha_;
    private int lineWidth_;
    private java.awt.Color fillColor_;
    private java.awt.Color strokeColor_;
    private List<java.awt.geom.Path2D> subPaths_;
    private Deque<SaveState> savedStates_;

    public AwtRenderingBackend(int imageWidth, int imageHeight) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] AwtRenderingBackend(" + imageWidth + ", " + imageHeight + ")"));
        }
        this.image_ = new BufferedImage(imageWidth, imageHeight, 2);
        this.graphics2D_ = this.image_.createGraphics();
        this.graphics2D_.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics2D_.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics2D_.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.fillColor_ = java.awt.Color.black;
        this.strokeColor_ = java.awt.Color.black;
        this.lineWidth_ = 1;
        this.transformation_ = new AffineTransform();
        this.setGlobalAlpha(1.0);
        this.graphics2D_.setClip(null);
        Font font = new Font("SansSerif", 0, 10);
        this.graphics2D_.setFont(font);
        this.graphics2D_.setBackground(new java.awt.Color(0.0f, 0.0f, 0.0f, 0.0f));
        this.graphics2D_.setColor(java.awt.Color.black);
        this.graphics2D_.clearRect(0, 0, imageWidth, imageHeight);
        this.subPaths_ = new ArrayList<java.awt.geom.Path2D>();
        this.savedStates_ = new ArrayDeque<SaveState>();
    }

    @Override
    public double getGlobalAlpha() {
        return this.globalAlpha_;
    }

    @Override
    public void setGlobalAlpha(double globalAlpha) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] setGlobalAlpha(" + globalAlpha + ")"));
        }
        if (globalAlpha >= 0.0 && globalAlpha <= 1.0) {
            this.globalAlpha_ = (float)globalAlpha;
            AlphaComposite composite = AlphaComposite.getInstance(3, this.globalAlpha_);
            this.graphics2D_.setComposite(composite);
        }
    }

    @Override
    public void beginPath() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] beginPath()"));
        }
        this.subPaths_.clear();
    }

    @Override
    public void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        java.awt.geom.Path2D subPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] ellipse()"));
        }
        if ((subPath = this.getCurrentSubPath()) != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            double startAngleDegree = 360.0 - startAngle * 180.0 / Math.PI;
            double endAngleDegree = 360.0 - endAngle * 180.0 / Math.PI;
            double extendAngle = startAngleDegree - endAngleDegree;
            extendAngle = Math.min(360.0, Math.abs(extendAngle));
            if (anticlockwise && extendAngle < 360.0) {
                extendAngle -= 360.0;
            }
            AffineTransform transformation = new AffineTransform();
            transformation.rotate(rotation, p.getX(), p.getY());
            Arc2D.Double arc = new Arc2D.Double(p.getX() - radiusX, p.getY() - radiusY, radiusX * 2.0, radiusY * 2.0, startAngleDegree, extendAngle * -1.0, 0);
            subPath.append(transformation.createTransformedShape(arc), false);
        }
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        java.awt.geom.Path2D subPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] bezierCurveTo()"));
        }
        if ((subPath = this.getCurrentSubPath()) != null) {
            Point2D cp1 = this.transformation_.transform(new Point2D.Double(cp1x, cp1y), null);
            Point2D cp2 = this.transformation_.transform(new Point2D.Double(cp2x, cp2y), null);
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            subPath.curveTo(cp1.getX(), cp1.getY(), cp2.getX(), cp2.getY(), p.getX(), p.getY());
        }
    }

    @Override
    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        java.awt.geom.Path2D subPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] arc()"));
        }
        if ((subPath = this.getCurrentSubPath()) != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            double startAngleDegree = 360.0 - startAngle * 180.0 / Math.PI;
            double endAngleDegree = 360.0 - endAngle * 180.0 / Math.PI;
            double extendAngle = startAngleDegree - endAngleDegree;
            extendAngle = Math.min(360.0, Math.abs(extendAngle));
            if (anticlockwise && extendAngle < 360.0) {
                extendAngle -= 360.0;
            }
            Arc2D.Double arc = new Arc2D.Double(p.getX() - radius, p.getY() - radius, radius * 2.0, radius * 2.0, startAngleDegree, extendAngle * -1.0, 0);
            subPath.append(arc, false);
        }
    }

    @Override
    public void clearRect(double x, double y, double w, double h) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] clearRect(" + x + ", " + y + ", " + w + ", " + h + ")"));
        }
        Composite saved = this.graphics2D_.getComposite();
        this.graphics2D_.setColor(java.awt.Color.BLACK);
        this.graphics2D_.setComposite(AlphaComposite.Clear);
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        this.graphics2D_.fill(this.transformation_.createTransformedShape(rect));
        this.graphics2D_.setComposite(saved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawImage(ImageReader imageReader, int sx, int sy, Integer sWidth, Integer sHeight, int dx, int dy, Integer dWidth, Integer dHeight) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] drawImage(" + sx + ", " + sy + ", " + sWidth + ", " + sHeight + "," + dx + ", " + dy + ", " + dWidth + ", " + dHeight + ")"));
        }
        if (imageReader.getNumImages(true) != 0) {
            BufferedImage img = imageReader.read(0);
            AffineTransform savedTransform = this.graphics2D_.getTransform();
            try {
                this.graphics2D_.setTransform(this.transformation_);
                this.graphics2D_.setColor(this.fillColor_);
                int sx2 = sWidth == null ? sx + img.getWidth() : sx + sWidth;
                int sy2 = sHeight == null ? sy + img.getHeight() : sy + sHeight;
                int dx1 = dx;
                int dx2 = dWidth == null ? dx + img.getWidth() : (dWidth < 0 ? (dx1 += dWidth.intValue()) - dWidth : dx1 + dWidth);
                int dy1 = dy;
                int dy2 = dHeight == null ? dy + img.getHeight() : (dHeight < 0 ? (dy1 += dHeight.intValue()) - dHeight : dy1 + dHeight);
                final Object done = new Object();
                ImageObserver imageObserver = new ImageObserver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
                        if ((flags & 0x20) == 32) {
                            return true;
                        }
                        if ((flags & 0x80) == 128 || (flags & 0x40) == 64) {
                            return true;
                        }
                        Object object = done;
                        synchronized (object) {
                            done.notify();
                        }
                        return false;
                    }
                };
                Object object = done;
                synchronized (object) {
                    boolean completelyLoaded = this.graphics2D_.drawImage(img, dx1, dy1, dx2, dy2, sx, sy, sx2, sy2, imageObserver);
                    if (!completelyLoaded) {
                        while (true) {
                            try {
                                done.wait(4000L);
                            }
                            catch (InterruptedException e) {
                                LOG.error((Object)("[" + this.id_ + "] AwtRenderingBackend interrupted while waiting for drawImage to finish."), (Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            finally {
                this.graphics2D_.setTransform(savedTransform);
            }
        }
    }

    @Override
    public String encodeToString(String type) throws IOException {
        String imageType = type;
        if (imageType != null && imageType.startsWith("image/")) {
            imageType = imageType.substring(6);
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)this.image_, imageType, bos);
            byte[] imageBytes = bos.toByteArray();
            String string = new String(new Base64().encode(imageBytes), StandardCharsets.US_ASCII);
            return string;
        }
    }

    @Override
    public void fill() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] fill()"));
        }
        this.graphics2D_.setStroke(new BasicStroke(this.getLineWidth()));
        this.graphics2D_.setColor(this.fillColor_);
        for (java.awt.geom.Path2D path2d : this.subPaths_) {
            this.graphics2D_.fill(path2d);
        }
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] fillRect(" + x + ", " + y + ", " + w + ", " + h + ")"));
        }
        this.graphics2D_.setColor(this.fillColor_);
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        this.graphics2D_.fill(this.transformation_.createTransformedShape(rect));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillText(String text, double x, double y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] fillText('" + text + "', " + x + ", " + y + ")"));
        }
        AffineTransform savedTransform = this.graphics2D_.getTransform();
        try {
            this.graphics2D_.setTransform(this.transformation_);
            this.graphics2D_.setColor(this.fillColor_);
            this.graphics2D_.drawString(text, (int)x, (int)y);
        }
        finally {
            this.graphics2D_.setTransform(savedTransform);
        }
    }

    @Override
    public byte[] getBytes(int width, int height, int sx, int sy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] getBytes(" + width + ", " + height + ", " + sx + ", " + sy + ")"));
        }
        byte[] array = new byte[width * height * 4];
        int index = 0;
        for (int x = sx; x < sx + width; ++x) {
            if (x < 0 || x >= this.image_.getWidth()) {
                array[index++] = 0;
                array[index++] = 0;
                array[index++] = 0;
                array[index++] = 0;
                continue;
            }
            for (int y = sy; y < sy + height; ++y) {
                if (y < 0 || y >= this.image_.getHeight()) {
                    array[index++] = 0;
                    array[index++] = 0;
                    array[index++] = 0;
                    array[index++] = 0;
                    continue;
                }
                int color = this.image_.getRGB(x, y);
                array[index++] = (byte)((color & 0xFF0000) >> 16);
                array[index++] = (byte)((color & 0xFF00) >> 8);
                array[index++] = (byte)(color & 0xFF);
                array[index++] = (byte)((color & 0xFF000000) >>> 24);
            }
        }
        return array;
    }

    @Override
    public void lineTo(double x, double y) {
        java.awt.geom.Path2D subPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] lineTo(" + x + ", " + y + ")"));
        }
        if ((subPath = this.getCurrentSubPath()) != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            subPath.lineTo(p.getX(), p.getY());
        }
    }

    @Override
    public void moveTo(double x, double y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] moveTo(" + x + ", " + y + ")"));
        }
        Path2D.Double subPath = new Path2D.Double();
        Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
        ((java.awt.geom.Path2D)subPath).moveTo(p.getX(), p.getY());
        this.subPaths_.add(subPath);
    }

    @Override
    public void putImageData(ImageData imageData, int dx, int dy, int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] putImageData()"));
        }
        java.awt.Color orgColor = this.graphics2D_.getColor();
        int width = dx + imageData.getWidth();
        int height = dy + imageData.getHeight();
        int imageWidth = dirtyX + dirtyWidth;
        int imageHeight = dirtyY + dirtyHeight;
        byte[] bytes = imageData.getData().getBuffer().getBuffer();
        int byteIdx = 0;
        int imageX = 0;
        int imageY = 0;
        for (int insertY = dy; insertY < height; ++insertY) {
            for (int insertX = dx; insertX < width; ++insertX) {
                if (0 <= insertX && insertX < this.image_.getWidth() && 0 <= insertY && insertY < this.image_.getHeight() && dirtyX <= imageX && imageX < imageWidth && dirtyY <= imageY && imageY < imageHeight) {
                    int r = bytes[byteIdx++] & 0xFF;
                    int g = bytes[byteIdx++] & 0xFF;
                    int b = bytes[byteIdx++] & 0xFF;
                    int a = bytes[byteIdx++] & 0xFF;
                    java.awt.Color color = new java.awt.Color(r, g, b, a);
                    this.graphics2D_.setColor(color);
                    this.graphics2D_.drawLine(insertX, insertY, insertX, insertY);
                } else {
                    byteIdx += 4;
                }
                if (++imageX != imageData.getWidth()) continue;
                imageX = 0;
                ++imageY;
            }
        }
        this.graphics2D_.setColor(orgColor);
    }

    @Override
    public void quadraticCurveTo(double cpx, double cpy, double x, double y) {
        java.awt.geom.Path2D subPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] quadraticCurveTo()"));
        }
        if ((subPath = this.getCurrentSubPath()) != null) {
            Point2D cp = this.transformation_.transform(new Point2D.Double(cpx, cpy), null);
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            subPath.quadTo(cp.getX(), cp.getY(), p.getX(), p.getY());
        }
    }

    @Override
    public void rect(double x, double y, double w, double h) {
        java.awt.geom.Path2D subPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] rect()"));
        }
        if ((subPath = this.getCurrentSubPath()) != null) {
            Point2D p = this.transformation_.transform(new Point2D.Double(x, y), null);
            Rectangle2D.Double rect = new Rectangle2D.Double(p.getX(), p.getY(), w, h);
            subPath.append(rect, false);
        }
    }

    @Override
    public void setFillStyle(String fillStyle) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] setFillStyle(" + fillStyle + ")"));
        }
        this.fillColor_ = AwtRenderingBackend.extractColor(fillStyle);
    }

    @Override
    public void setStrokeStyle(String strokeStyle) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] setStrokeStyle(" + strokeStyle + ")"));
        }
        this.strokeColor_ = AwtRenderingBackend.extractColor(strokeStyle);
    }

    private static java.awt.Color extractColor(String style) {
        String tmpStyle = style.replaceAll("\\s", "");
        java.awt.Color color = AwtRenderingBackend.toAwtColor(StringUtils.findColorRGB(tmpStyle));
        if (color == null) {
            color = AwtRenderingBackend.toAwtColor(StringUtils.findColorRGBA(tmpStyle));
        }
        if (color == null) {
            color = AwtRenderingBackend.toAwtColor(StringUtils.findColorHSL(tmpStyle));
        }
        if (color == null) {
            if (tmpStyle.length() > 0 && tmpStyle.charAt(0) == '#') {
                color = AwtRenderingBackend.toAwtColor(StringUtils.asColorHexadecimal(tmpStyle));
            } else {
                color = knownColors.get(tmpStyle.toLowerCase(Locale.ROOT));
                if (color == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Can not find color '" + tmpStyle + '\''));
                    }
                    color = java.awt.Color.black;
                }
            }
        }
        return color;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth_;
    }

    @Override
    public void restore() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] restore()"));
        }
        if (this.savedStates_.isEmpty()) {
            return;
        }
        this.savedStates_.pop().applyOn(this);
    }

    @Override
    public void rotate(double angle) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] rotate()"));
        }
        this.transformation_.rotate(angle);
    }

    @Override
    public void save() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] save()"));
        }
        this.savedStates_.push(new SaveState(this));
    }

    @Override
    public void setLineWidth(int lineWidth) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] setLineWidth(" + lineWidth + ")"));
        }
        this.lineWidth_ = lineWidth;
    }

    @Override
    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] setTransform(" + m11 + ", " + m12 + ", " + m21 + ", " + m22 + ", " + dx + ", " + dy + ")"));
        }
        this.transformation_ = new AffineTransform(m11, m12, m21, m22, dx, dy);
    }

    @Override
    public void stroke() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] stroke()"));
        }
        this.graphics2D_.setStroke(new BasicStroke(this.getLineWidth()));
        this.graphics2D_.setColor(this.strokeColor_);
        for (java.awt.geom.Path2D path2d : this.subPaths_) {
            this.graphics2D_.draw(path2d);
        }
    }

    @Override
    public void strokeRect(int x, int y, int w, int h) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] strokeRect(" + x + ", " + y + ", " + w + ", " + h + ")"));
        }
        this.graphics2D_.setColor(this.strokeColor_);
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        this.graphics2D_.draw(this.transformation_.createTransformedShape(rect));
    }

    @Override
    public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] transform()"));
        }
        this.transformation_.concatenate(new AffineTransform(m11, m12, m21, m22, dx, dy));
    }

    @Override
    public void translate(int x, int y) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] translate()"));
        }
        this.transformation_.translate(x, y);
    }

    @Override
    public void clip(RenderingBackend.WindingRule windingRule, Path2D path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] clip(" + (Object)((Object)windingRule) + ", " + path + ")"));
        }
        if (path == null && this.subPaths_.isEmpty()) {
            this.graphics2D_.setClip(null);
            return;
        }
        java.awt.geom.Path2D currentPath = path == null ? this.subPaths_.get(this.subPaths_.size() - 1) : null;
        currentPath.closePath();
        switch (windingRule) {
            case NON_ZERO: {
                currentPath.setWindingRule(1);
                break;
            }
            default: {
                currentPath.setWindingRule(0);
            }
        }
        this.graphics2D_.clip(currentPath);
    }

    @Override
    public void closePath() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[" + this.id_ + "] closePath()"));
        }
        if (this.subPaths_.isEmpty()) {
            return;
        }
        this.subPaths_.get(this.subPaths_.size() - 1).closePath();
    }

    private java.awt.geom.Path2D getCurrentSubPath() {
        if (this.subPaths_.isEmpty()) {
            Path2D.Double subPath = new Path2D.Double();
            this.subPaths_.add(subPath);
            return subPath;
        }
        return this.subPaths_.get(this.subPaths_.size() - 1);
    }

    private static java.awt.Color toAwtColor(Color color) {
        if (color == null) {
            return null;
        }
        return new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    static {
        knownColors.put("black", java.awt.Color.decode("#000000"));
        knownColors.put("silver", java.awt.Color.decode("#c0c0c0"));
        knownColors.put("gray", java.awt.Color.decode("#808080"));
        knownColors.put("white", java.awt.Color.decode("#ffffff"));
        knownColors.put("maroon", java.awt.Color.decode("#800000"));
        knownColors.put("red", java.awt.Color.decode("#ff0000"));
        knownColors.put("purple", java.awt.Color.decode("#800080"));
        knownColors.put("fuchsia", java.awt.Color.decode("#ff00ff"));
        knownColors.put("green", java.awt.Color.decode("#008000"));
        knownColors.put("lime", java.awt.Color.decode("#00ff00"));
        knownColors.put("olive", java.awt.Color.decode("#808000"));
        knownColors.put("yellow", java.awt.Color.decode("#ffff00"));
        knownColors.put("navy", java.awt.Color.decode("#000080"));
        knownColors.put("blue", java.awt.Color.decode("#0000ff"));
        knownColors.put("teal", java.awt.Color.decode("#008080"));
        knownColors.put("aqua", java.awt.Color.decode("#00ffff"));
        knownColors.put("orange", java.awt.Color.decode("#ffa500"));
        knownColors.put("aliceblue", java.awt.Color.decode("#f0f8ff"));
        knownColors.put("antiquewhite", java.awt.Color.decode("#faebd7"));
        knownColors.put("aquamarine", java.awt.Color.decode("#7fffd4"));
        knownColors.put("azure", java.awt.Color.decode("#f0ffff"));
        knownColors.put("beige", java.awt.Color.decode("#f5f5dc"));
        knownColors.put("bisque", java.awt.Color.decode("#ffe4c4"));
        knownColors.put("blanchedalmond", java.awt.Color.decode("#ffebcd"));
        knownColors.put("blueviolet", java.awt.Color.decode("#8a2be2"));
        knownColors.put("brown", java.awt.Color.decode("#a52a2a"));
        knownColors.put("burlywood", java.awt.Color.decode("#deb887"));
        knownColors.put("cadetblue", java.awt.Color.decode("#5f9ea0"));
        knownColors.put("chartreuse", java.awt.Color.decode("#7fff00"));
        knownColors.put("chocolate", java.awt.Color.decode("#d2691e"));
        knownColors.put("coral", java.awt.Color.decode("#ff7f50"));
        knownColors.put("cornflowerblue", java.awt.Color.decode("#6495ed"));
        knownColors.put("cornsilk", java.awt.Color.decode("#fff8dc"));
        knownColors.put("crimson", java.awt.Color.decode("#dc143c"));
        knownColors.put("cyan", java.awt.Color.decode("#00ffff"));
        knownColors.put("darkblue", java.awt.Color.decode("#00008b"));
        knownColors.put("darkcyan", java.awt.Color.decode("#008b8b"));
        knownColors.put("darkgoldenrod", java.awt.Color.decode("#b8860b"));
        knownColors.put("darkgray", java.awt.Color.decode("#a9a9a9"));
        knownColors.put("darkgreen", java.awt.Color.decode("#006400"));
        knownColors.put("darkgrey", java.awt.Color.decode("#a9a9a9"));
        knownColors.put("darkkhaki", java.awt.Color.decode("#bdb76b"));
        knownColors.put("darkmagenta", java.awt.Color.decode("#8b008b"));
        knownColors.put("darkolivegreen", java.awt.Color.decode("#556b2f"));
        knownColors.put("darkorange", java.awt.Color.decode("#ff8c00"));
        knownColors.put("darkorchid", java.awt.Color.decode("#9932cc"));
        knownColors.put("darkred", java.awt.Color.decode("#8b0000"));
        knownColors.put("darksalmon", java.awt.Color.decode("#e9967a"));
        knownColors.put("darkseagreen", java.awt.Color.decode("#8fbc8f"));
        knownColors.put("darkslateblue", java.awt.Color.decode("#483d8b"));
        knownColors.put("darkslategray", java.awt.Color.decode("#2f4f4f"));
        knownColors.put("darkslategrey", java.awt.Color.decode("#2f4f4f"));
        knownColors.put("darkturquoise", java.awt.Color.decode("#00ced1"));
        knownColors.put("darkviolet", java.awt.Color.decode("#9400d3"));
        knownColors.put("deeppink", java.awt.Color.decode("#ff1493"));
        knownColors.put("deepskyblue", java.awt.Color.decode("#00bfff"));
        knownColors.put("dimgray", java.awt.Color.decode("#696969"));
        knownColors.put("dimgrey", java.awt.Color.decode("#696969"));
        knownColors.put("dodgerblue", java.awt.Color.decode("#1e90ff"));
        knownColors.put("firebrick", java.awt.Color.decode("#b22222"));
        knownColors.put("floralwhite", java.awt.Color.decode("#fffaf0"));
        knownColors.put("forestgreen", java.awt.Color.decode("#228b22"));
        knownColors.put("gainsboro", java.awt.Color.decode("#dcdcdc"));
        knownColors.put("ghostwhite", java.awt.Color.decode("#f8f8ff"));
        knownColors.put("gold", java.awt.Color.decode("#ffd700"));
        knownColors.put("goldenrod", java.awt.Color.decode("#daa520"));
        knownColors.put("greenyellow", java.awt.Color.decode("#adff2f"));
        knownColors.put("grey", java.awt.Color.decode("#808080"));
        knownColors.put("honeydew", java.awt.Color.decode("#f0fff0"));
        knownColors.put("hotpink", java.awt.Color.decode("#ff69b4"));
        knownColors.put("indianred", java.awt.Color.decode("#cd5c5c"));
        knownColors.put("indigo", java.awt.Color.decode("#4b0082"));
        knownColors.put("ivory", java.awt.Color.decode("#fffff0"));
        knownColors.put("khaki", java.awt.Color.decode("#f0e68c"));
        knownColors.put("lavender", java.awt.Color.decode("#e6e6fa"));
        knownColors.put("lavenderblush", java.awt.Color.decode("#fff0f5"));
        knownColors.put("lawngreen", java.awt.Color.decode("#7cfc00"));
        knownColors.put("lemonchiffon", java.awt.Color.decode("#fffacd"));
        knownColors.put("lightblue", java.awt.Color.decode("#add8e6"));
        knownColors.put("lightcoral", java.awt.Color.decode("#f08080"));
        knownColors.put("lightcyan", java.awt.Color.decode("#e0ffff"));
        knownColors.put("lightgoldenrodyellow", java.awt.Color.decode("#fafad2"));
        knownColors.put("lightgray", java.awt.Color.decode("#d3d3d3"));
        knownColors.put("lightgreen", java.awt.Color.decode("#90ee90"));
        knownColors.put("lightgrey", java.awt.Color.decode("#d3d3d3"));
        knownColors.put("lightpink", java.awt.Color.decode("#ffb6c1"));
        knownColors.put("lightsalmon", java.awt.Color.decode("#ffa07a"));
        knownColors.put("lightseagreen", java.awt.Color.decode("#20b2aa"));
        knownColors.put("lightskyblue", java.awt.Color.decode("#87cefa"));
        knownColors.put("lightslategray", java.awt.Color.decode("#778899"));
        knownColors.put("lightslategrey", java.awt.Color.decode("#778899"));
        knownColors.put("lightsteelblue", java.awt.Color.decode("#b0c4de"));
        knownColors.put("lightyellow", java.awt.Color.decode("#ffffe0"));
        knownColors.put("limegreen", java.awt.Color.decode("#32cd32"));
        knownColors.put("linen", java.awt.Color.decode("#faf0e6"));
        knownColors.put("magenta", java.awt.Color.decode("#ff00ff"));
        knownColors.put("mediumaquamarine", java.awt.Color.decode("#66cdaa"));
        knownColors.put("mediumblue", java.awt.Color.decode("#0000cd"));
        knownColors.put("mediumorchid", java.awt.Color.decode("#ba55d3"));
        knownColors.put("mediumpurple", java.awt.Color.decode("#9370db"));
        knownColors.put("mediumseagreen", java.awt.Color.decode("#3cb371"));
        knownColors.put("mediumslateblue", java.awt.Color.decode("#7b68ee"));
        knownColors.put("mediumspringgreen", java.awt.Color.decode("#00fa9a"));
        knownColors.put("mediumturquoise", java.awt.Color.decode("#48d1cc"));
        knownColors.put("mediumvioletred", java.awt.Color.decode("#c71585"));
        knownColors.put("midnightblue", java.awt.Color.decode("#191970"));
        knownColors.put("mintcream", java.awt.Color.decode("#f5fffa"));
        knownColors.put("mistyrose", java.awt.Color.decode("#ffe4e1"));
        knownColors.put("moccasin", java.awt.Color.decode("#ffe4b5"));
        knownColors.put("navajowhite", java.awt.Color.decode("#ffdead"));
        knownColors.put("oldlace", java.awt.Color.decode("#fdf5e6"));
        knownColors.put("olivedrab", java.awt.Color.decode("#6b8e23"));
        knownColors.put("orangered", java.awt.Color.decode("#ff4500"));
        knownColors.put("orchid", java.awt.Color.decode("#da70d6"));
        knownColors.put("palegoldenrod", java.awt.Color.decode("#eee8aa"));
        knownColors.put("palegreen", java.awt.Color.decode("#98fb98"));
        knownColors.put("paleturquoise", java.awt.Color.decode("#afeeee"));
        knownColors.put("palevioletred", java.awt.Color.decode("#db7093"));
        knownColors.put("papayawhip", java.awt.Color.decode("#ffefd5"));
        knownColors.put("peachpuff", java.awt.Color.decode("#ffdab9"));
        knownColors.put("peru", java.awt.Color.decode("#cd853f"));
        knownColors.put("pink", java.awt.Color.decode("#ffc0cb"));
        knownColors.put("plum", java.awt.Color.decode("#dda0dd"));
        knownColors.put("powderblue", java.awt.Color.decode("#b0e0e6"));
        knownColors.put("rosybrown", java.awt.Color.decode("#bc8f8f"));
        knownColors.put("royalblue", java.awt.Color.decode("#4169e1"));
        knownColors.put("saddlebrown", java.awt.Color.decode("#8b4513"));
        knownColors.put("salmon", java.awt.Color.decode("#fa8072"));
        knownColors.put("sandybrown", java.awt.Color.decode("#f4a460"));
        knownColors.put("seagreen", java.awt.Color.decode("#2e8b57"));
        knownColors.put("seashell", java.awt.Color.decode("#fff5ee"));
        knownColors.put("sienna", java.awt.Color.decode("#a0522d"));
        knownColors.put("skyblue", java.awt.Color.decode("#87ceeb"));
        knownColors.put("slateblue", java.awt.Color.decode("#6a5acd"));
        knownColors.put("slategray", java.awt.Color.decode("#708090"));
        knownColors.put("slategrey", java.awt.Color.decode("#708090"));
        knownColors.put("snow", java.awt.Color.decode("#fffafa"));
        knownColors.put("springgreen", java.awt.Color.decode("#00ff7f"));
        knownColors.put("steelblue", java.awt.Color.decode("#4682b4"));
        knownColors.put("tan", java.awt.Color.decode("#d2b48c"));
        knownColors.put("thistle", java.awt.Color.decode("#d8bfd8"));
        knownColors.put("tomato", java.awt.Color.decode("#ff6347"));
        knownColors.put("turquoise", java.awt.Color.decode("#40e0d0"));
        knownColors.put("violet", java.awt.Color.decode("#ee82ee"));
        knownColors.put("wheat", java.awt.Color.decode("#f5deb3"));
        knownColors.put("whitesmoke", java.awt.Color.decode("#f5f5f5"));
        knownColors.put("yellowgreen", java.awt.Color.decode("#9acd32"));
        knownColors.put("rebeccapurple", java.awt.Color.decode("#663399"));
    }

    private static final class SaveState {
        private AffineTransform transformation_;
        private float globalAlpha_;
        private int lineWidth_;
        private java.awt.Color fillColor_;
        private java.awt.Color strokeColor_;
        private Shape clip_;

        SaveState(AwtRenderingBackend backend) {
            this.transformation_ = backend.transformation_;
            this.globalAlpha_ = backend.globalAlpha_;
            this.lineWidth_ = backend.lineWidth_;
            this.fillColor_ = backend.fillColor_;
            this.strokeColor_ = backend.strokeColor_;
            this.clip_ = backend.graphics2D_.getClip();
        }

        void applyOn(AwtRenderingBackend backend) {
            backend.transformation_ = this.transformation_;
            backend.globalAlpha_ = this.globalAlpha_;
            backend.lineWidth_ = this.lineWidth_;
            backend.fillColor_ = this.fillColor_;
            backend.strokeColor_ = this.strokeColor_;
            backend.graphics2D_.setClip(this.clip_);
        }
    }
}

