/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.UIEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.util.ArrayList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class MouseEvent
extends UIEvent {
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final int MOZ_SOURCE_UNKNOWN = 0;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final int MOZ_SOURCE_MOUSE = 1;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final int MOZ_SOURCE_PEN = 2;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final int MOZ_SOURCE_ERASER = 3;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final int MOZ_SOURCE_CURSOR = 4;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final int MOZ_SOURCE_TOUCH = 5;
    @JsxConstant(value={SupportedBrowser.FF, SupportedBrowser.FF78})
    public static final int MOZ_SOURCE_KEYBOARD = 6;
    public static final String TYPE_CLICK = "click";
    public static final String TYPE_DBL_CLICK = "dblclick";
    public static final String TYPE_MOUSE_OVER = "mouseover";
    public static final String TYPE_MOUSE_MOVE = "mousemove";
    public static final String TYPE_MOUSE_OUT = "mouseout";
    public static final String TYPE_MOUSE_DOWN = "mousedown";
    public static final String TYPE_MOUSE_UP = "mouseup";
    public static final String TYPE_CONTEXT_MENU = "contextmenu";
    public static final int BUTTON_LEFT = 0;
    public static final int BUTTON_MIDDLE = 1;
    public static final int BUTTON_RIGHT = 2;
    private Integer screenX_;
    private Integer screenY_;
    private Integer clientX_;
    private Integer clientY_;
    private int button_;
    private int buttons_;
    private boolean processLabelAfterBubbling_ = true;
    private boolean metaKey_;

    public MouseEvent() {
        this.screenX_ = 0;
        this.screenY_ = 0;
        this.setDetail(1L);
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(ScriptRuntime.toString((Object)type), details);
        if (details != null && !Undefined.isUndefined((Object)details)) {
            Object buttons;
            Object button;
            Object clientX;
            Object screenX = details.get("screenX", (Scriptable)details);
            if (NOT_FOUND != screenX) {
                this.screenX_ = ScriptRuntime.toInt32((Object)screenX);
            }
            Object screenY = details.get("screenY", (Scriptable)details);
            if (NOT_FOUND != screenX) {
                this.screenY_ = ScriptRuntime.toInt32((Object)screenY);
            }
            if (NOT_FOUND != (clientX = details.get("clientX", (Scriptable)details))) {
                this.clientX_ = ScriptRuntime.toInt32((Object)clientX);
            }
            Object clientY = details.get("clientY", (Scriptable)details);
            if (NOT_FOUND != clientX) {
                this.clientY_ = ScriptRuntime.toInt32((Object)clientY);
            }
            if (NOT_FOUND != (button = details.get("button", (Scriptable)details))) {
                this.button_ = ScriptRuntime.toInt32((Object)button);
            }
            if (NOT_FOUND != (buttons = details.get("buttons", (Scriptable)details))) {
                this.buttons_ = ScriptRuntime.toInt32((Object)buttons);
            }
            this.setAltKey(ScriptRuntime.toBoolean((Object)details.get((Object)"altKey")));
            this.setCtrlKey(ScriptRuntime.toBoolean((Object)details.get((Object)"ctrlKey")));
            this.setMetaKey(ScriptRuntime.toBoolean((Object)details.get((Object)"metaKey")));
            this.setShiftKey(ScriptRuntime.toBoolean((Object)details.get((Object)"shiftKey")));
        }
    }

    public MouseEvent(DomNode domNode, String type, boolean shiftKey, boolean ctrlKey, boolean altKey, int button) {
        super(domNode, type);
        this.setShiftKey(shiftKey);
        this.setCtrlKey(ctrlKey);
        this.setAltKey(altKey);
        if (button != 0 && button != 1 && button != 2) {
            throw new IllegalArgumentException("Invalid button code: " + button);
        }
        this.button_ = button;
        if (TYPE_DBL_CLICK.equals(type)) {
            this.setDetail(2L);
        } else {
            this.setDetail(1L);
        }
    }

    @JsxGetter
    public int getClientX() {
        if (this.clientX_ == null) {
            this.clientX_ = this.getScreenX();
        }
        return this.clientX_;
    }

    public void setClientX(int value) {
        this.clientX_ = value;
    }

    @JsxGetter
    public int getScreenX() {
        if (this.screenX_ == null) {
            HTMLElement target = (HTMLElement)this.getTarget();
            this.screenX_ = target.getPosX() + 10;
        }
        return this.screenX_;
    }

    @JsxGetter
    public int getPageX() {
        return this.getScreenX();
    }

    @JsxGetter
    public int getClientY() {
        if (this.clientY_ == null) {
            this.clientY_ = this.getScreenY();
        }
        return this.clientY_;
    }

    public void setClientY(int value) {
        this.clientY_ = value;
    }

    @JsxGetter
    public int getScreenY() {
        if (this.screenY_ == null) {
            HTMLElement target = (HTMLElement)this.getTarget();
            this.screenY_ = target.getPosY() + 10;
        }
        return this.screenY_;
    }

    @JsxGetter
    public int getPageY() {
        return this.getScreenY();
    }

    @JsxGetter
    public int getButton() {
        return this.button_;
    }

    public void setButton(int value) {
        this.button_ = value;
    }

    @JsxGetter
    public int getButtons() {
        return this.buttons_;
    }

    public void setButtons(int value) {
        this.buttons_ = value;
    }

    @JsxGetter
    public int getWhich() {
        return this.button_ + 1;
    }

    @JsxFunction
    public void initMouseEvent(String type, boolean bubbles, boolean cancelable, Object view, int detail, int screenX, int screenY, int clientX, int clientY, boolean ctrlKey, boolean altKey, boolean shiftKey, boolean metaKey, int button, Object relatedTarget) {
        this.initUIEvent(type, bubbles, cancelable, view, detail);
        this.screenX_ = screenX;
        this.screenY_ = screenY;
        this.clientX_ = clientX;
        this.clientY_ = clientY;
        this.setCtrlKey(ctrlKey);
        this.setAltKey(altKey);
        this.setShiftKey(shiftKey);
        this.setMetaKey(metaKey);
        this.button_ = button;
    }

    public static MouseEvent getCurrentMouseEvent() {
        int lastIdx;
        Event lastEvent;
        ArrayList events;
        Context context = Context.getCurrentContext();
        if (context != null && (events = (ArrayList)context.getThreadLocal((Object)"Event#current")) != null && events.size() > 0 && (lastEvent = (Event)events.get(lastIdx = events.size() - 1)) instanceof MouseEvent) {
            return (MouseEvent)lastEvent;
        }
        return null;
    }

    public static boolean isMouseEvent(String type) {
        return TYPE_CLICK.equals(type) || TYPE_MOUSE_OVER.equals(type) || TYPE_MOUSE_MOVE.equals(type) || TYPE_MOUSE_OUT.equals(type) || TYPE_MOUSE_DOWN.equals(type) || TYPE_MOUSE_UP.equals(type) || TYPE_CONTEXT_MENU.equals(type);
    }

    @Override
    @JsxGetter
    public boolean isAltKey() {
        return super.isAltKey();
    }

    @Override
    @JsxGetter
    public boolean isCtrlKey() {
        return super.isCtrlKey();
    }

    @Override
    @JsxGetter
    public boolean isShiftKey() {
        return super.isShiftKey();
    }

    @Override
    public boolean processLabelAfterBubbling() {
        return TYPE_CLICK == this.getType() && this.processLabelAfterBubbling_;
    }

    public void disableProcessLabelAfterBubbling() {
        this.processLabelAfterBubbling_ = false;
    }

    @JsxGetter
    public boolean getMetaKey() {
        return this.metaKey_;
    }

    protected void setMetaKey(boolean metaKey) {
        this.metaKey_ = metaKey;
    }
}

