/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.Cache;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.History;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.TopLevelWindow;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.ElementFromPointHandler;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlBase;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlFrame;
import com.gargoylesoftware.htmlunit.html.HtmlFrameSet;
import com.gargoylesoftware.htmlunit.html.HtmlHead;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlLegend;
import com.gargoylesoftware.htmlunit.html.HtmlMeta;
import com.gargoylesoftware.htmlunit.html.HtmlObject;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.ScriptElementSupport;
import com.gargoylesoftware.htmlunit.html.XmlSerializer;
import com.gargoylesoftware.htmlunit.html.impl.SelectableTextInput;
import com.gargoylesoftware.htmlunit.html.impl.SimpleRange;
import com.gargoylesoftware.htmlunit.html.parser.HTMLParserDOMBuilder;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.BeforeUnloadEvent;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Script;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.ranges.Range;

public class HtmlPage
extends SgmlPage {
    private static final Log LOG = LogFactory.getLog(HtmlPage.class);
    private static final Comparator<DomElement> documentPositionComparator = new DocumentPositionComparator();
    private HTMLParserDOMBuilder domBuilder_;
    private transient Charset originalCharset_;
    private transient Object lock_ = new Object();
    private Map<String, SortedSet<DomElement>> idMap_ = Collections.synchronizedMap(new HashMap());
    private Map<String, SortedSet<DomElement>> nameMap_ = Collections.synchronizedMap(new HashMap());
    private SortedSet<BaseFrameElement> frameElements_ = new TreeSet<DomElement>(documentPositionComparator);
    private int parserCount_;
    private int snippetParserCount_;
    private int inlineSnippetParserCount_;
    private Collection<HtmlAttributeChangeListener> attributeListeners_;
    private List<PostponedAction> afterLoadActions_ = Collections.synchronizedList(new ArrayList());
    private boolean cleaning_;
    private HtmlBase base_;
    private URL baseUrl_;
    private List<AutoCloseable> autoCloseableList_;
    private ElementFromPointHandler elementFromPointHandler_;
    private DomElement elementWithFocus_;
    private List<Range> selectionRanges_ = new ArrayList<Range>(3);
    private static final List<String> TABBABLE_TAGS = Arrays.asList("a", "area", "button", "input", "object", "select", "textarea");
    private static final List<String> ACCEPTABLE_TAG_NAMES = Arrays.asList("a", "area", "button", "input", "label", "legend", "textarea");

    public HtmlPage(WebResponse webResponse, WebWindow webWindow) {
        super(webResponse, webWindow);
    }

    @Override
    public HtmlPage getPage() {
        return this;
    }

    @Override
    public boolean hasCaseSensitiveTagNames() {
        return false;
    }

    @Override
    public void initialize() throws IOException, FailingHttpStatusCodeException {
        boolean isAboutBlank;
        WebWindow enclosingWindow = this.getEnclosingWindow();
        boolean bl = isAboutBlank = this.getUrl() == UrlUtils.URL_ABOUT_BLANK;
        if (isAboutBlank) {
            TopLevelWindow topWindow;
            WebWindow openerWindow;
            if (enclosingWindow instanceof FrameWindow && !((FrameWindow)enclosingWindow).getFrameElement().isContentLoaded()) {
                return;
            }
            if (enclosingWindow instanceof TopLevelWindow && (openerWindow = (topWindow = (TopLevelWindow)enclosingWindow).getOpener()) != null && openerWindow.getEnclosedPage() != null) {
                this.baseUrl_ = openerWindow.getEnclosedPage().getWebResponse().getWebRequest().getUrl();
            }
        }
        if (!isAboutBlank) {
            this.setReadyState("interactive");
            this.getDocumentElement().setReadyState("interactive");
        }
        this.executeDeferredScriptsIfNeeded();
        this.executeEventHandlersIfNeeded("DOMContentLoaded");
        this.loadFrames();
        if (!isAboutBlank) {
            if (this.hasFeature(BrowserVersionFeatures.FOCUS_BODY_ELEMENT_AT_START)) {
                this.setElementWithFocus(this.getBody());
            }
            this.setReadyState("complete");
            this.getDocumentElement().setReadyState("complete");
        }
        boolean isFrameWindow = enclosingWindow instanceof FrameWindow;
        boolean isFirstPageInFrameWindow = false;
        if (isFrameWindow) {
            isFrameWindow = ((FrameWindow)enclosingWindow).getFrameElement() instanceof HtmlFrame;
            History hist = enclosingWindow.getHistory();
            if (hist.getLength() > 0 && UrlUtils.URL_ABOUT_BLANK == hist.getUrl(0)) {
                isFirstPageInFrameWindow = hist.getLength() <= 2;
            } else {
                boolean bl2 = isFirstPageInFrameWindow = enclosingWindow.getHistory().getLength() < 2;
            }
        }
        if (isFrameWindow && !isFirstPageInFrameWindow) {
            this.executeEventHandlersIfNeeded("load");
        }
        for (FrameWindow frameWindow : this.getFrames()) {
            Page page;
            if (!(frameWindow.getFrameElement() instanceof HtmlFrame) || (page = frameWindow.getEnclosedPage()) == null || !page.isHtmlPage()) continue;
            ((HtmlPage)page).executeEventHandlersIfNeeded("load");
        }
        if (!isFrameWindow) {
            HtmlElement body;
            this.executeEventHandlersIfNeeded("load");
            if (!isAboutBlank && enclosingWindow.getWebClient().isJavaScriptEnabled() && this.hasFeature(BrowserVersionFeatures.EVENT_FOCUS_ON_LOAD) && (body = this.getBody()) != null) {
                Event event = new Event((Window)enclosingWindow.getScriptableObject(), "focus");
                body.fireEvent(event);
            }
        }
        try {
            while (!this.afterLoadActions_.isEmpty()) {
                PostponedAction action = this.afterLoadActions_.remove(0);
                action.execute();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.executeRefreshIfNeeded();
    }

    void addAfterLoadAction(PostponedAction action) {
        this.afterLoadActions_.add(action);
    }

    @Override
    public void cleanUp() {
        if (this.cleaning_) {
            return;
        }
        this.cleaning_ = true;
        super.cleanUp();
        this.executeEventHandlersIfNeeded("unload");
        this.deregisterFramesIfNeeded();
        this.cleaning_ = false;
        if (this.autoCloseableList_ != null) {
            for (AutoCloseable closeable : new ArrayList<AutoCloseable>(this.autoCloseableList_)) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public HtmlElement getDocumentElement() {
        return (HtmlElement)super.getDocumentElement();
    }

    public HtmlElement getBody() {
        HtmlElement doc = this.getDocumentElement();
        if (doc != null) {
            for (DomNode node : doc.getChildren()) {
                if (!(node instanceof HtmlBody) && !(node instanceof HtmlFrameSet)) continue;
                return (HtmlElement)node;
            }
        }
        return null;
    }

    public HtmlElement getHead() {
        HtmlElement doc = this.getDocumentElement();
        if (doc != null) {
            for (DomNode node : doc.getChildren()) {
                if (!(node instanceof HtmlHead)) continue;
                return (HtmlElement)node;
            }
        }
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) {
        throw new UnsupportedOperationException("HtmlPage.importNode is not yet implemented.");
    }

    @Override
    public String getInputEncoding() {
        throw new UnsupportedOperationException("HtmlPage.getInputEncoding is not yet implemented.");
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.setXmlStandalone is not yet implemented.");
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.setXmlVersion is not yet implemented.");
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new UnsupportedOperationException("HtmlPage.getStrictErrorChecking is not yet implemented.");
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new UnsupportedOperationException("HtmlPage.setStrictErrorChecking is not yet implemented.");
    }

    @Override
    public String getDocumentURI() {
        throw new UnsupportedOperationException("HtmlPage.getDocumentURI is not yet implemented.");
    }

    @Override
    public void setDocumentURI(String documentURI) {
        throw new UnsupportedOperationException("HtmlPage.setDocumentURI is not yet implemented.");
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.adoptNode is not yet implemented.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        throw new UnsupportedOperationException("HtmlPage.getDomConfig is not yet implemented.");
    }

    @Override
    public Node renameNode(Node newNode, String namespaceURI, String qualifiedName) throws DOMException {
        throw new UnsupportedOperationException("HtmlPage.renameNode is not yet implemented.");
    }

    @Override
    public Charset getCharset() {
        if (this.originalCharset_ == null) {
            this.originalCharset_ = this.getWebResponse().getContentCharset();
        }
        return this.originalCharset_;
    }

    @Override
    public String getContentType() {
        return this.getWebResponse().getContentType();
    }

    @Override
    public DOMImplementation getImplementation() {
        throw new UnsupportedOperationException("HtmlPage.getImplementation is not yet implemented.");
    }

    @Override
    public DomElement createElement(String tagName) {
        if (tagName.indexOf(58) == -1) {
            tagName = tagName.toLowerCase(Locale.ROOT);
        }
        return this.getWebClient().getPageCreator().getHtmlParser().getFactory(tagName).createElementNS(this, null, tagName, null, true);
    }

    @Override
    public DomElement createElementNS(String namespaceURI, String qualifiedName) {
        return this.getWebClient().getPageCreator().getHtmlParser().getElementFactory(this, namespaceURI, qualifiedName, false, true).createElementNS(this, namespaceURI, qualifiedName, null, true);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("HtmlPage.createAttributeNS is not yet implemented.");
    }

    @Override
    public EntityReference createEntityReference(String id) {
        throw new UnsupportedOperationException("HtmlPage.createEntityReference is not yet implemented.");
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String namespaceURI, String qualifiedName) {
        throw new UnsupportedOperationException("HtmlPage.createProcessingInstruction is not yet implemented.");
    }

    @Override
    public DomElement getElementById(String elementId) {
        SortedSet<DomElement> elements = this.idMap_.get(elementId);
        if (elements != null) {
            return elements.first();
        }
        return null;
    }

    public HtmlAnchor getAnchorByName(String name) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "name", name);
    }

    public HtmlAnchor getAnchorByHref(String href) throws ElementNotFoundException {
        return (HtmlAnchor)this.getDocumentElement().getOneHtmlElementByAttribute("a", "href", href);
    }

    public List<HtmlAnchor> getAnchors() {
        return this.getDocumentElement().getElementsByTagNameImpl("a");
    }

    public HtmlAnchor getAnchorByText(String text) throws ElementNotFoundException {
        WebAssert.notNull("text", text);
        for (HtmlAnchor anchor : this.getAnchors()) {
            if (!text.equals(anchor.asText())) continue;
            return anchor;
        }
        throw new ElementNotFoundException("a", "<text>", text);
    }

    public HtmlForm getFormByName(String name) throws ElementNotFoundException {
        List forms = this.getDocumentElement().getElementsByAttribute("form", "name", name);
        if (forms.isEmpty()) {
            throw new ElementNotFoundException("form", "name", name);
        }
        return (HtmlForm)forms.get(0);
    }

    public List<HtmlForm> getForms() {
        return this.getDocumentElement().getElementsByTagNameImpl("form");
    }

    public URL getFullyQualifiedUrl(String relativeUrl) throws MalformedURLException {
        if (this.hasFeature(BrowserVersionFeatures.URL_MISSING_SLASHES)) {
            boolean incorrectnessNotified = false;
            while (relativeUrl.startsWith("http:") && !relativeUrl.startsWith("http://")) {
                if (!incorrectnessNotified) {
                    this.notifyIncorrectness("Incorrect URL \"" + relativeUrl + "\" has been corrected");
                    incorrectnessNotified = true;
                }
                relativeUrl = "http:/" + relativeUrl.substring(5);
            }
        }
        return WebClient.expandUrl(this.getBaseURL(), relativeUrl);
    }

    public String getResolvedTarget(String elementTarget) {
        String resolvedTarget = this.base_ == null ? elementTarget : (elementTarget != null && !elementTarget.isEmpty() ? elementTarget : this.base_.getTargetAttribute());
        return resolvedTarget;
    }

    public List<String> getTabbableElementIds() {
        ArrayList<String> list = new ArrayList<String>();
        for (HtmlElement element : this.getTabbableElements()) {
            list.add(element.getId());
        }
        return Collections.unmodifiableList(list);
    }

    public List<HtmlElement> getTabbableElements() {
        ArrayList<HtmlElement> tabbableElements = new ArrayList<HtmlElement>();
        for (HtmlElement element : this.getHtmlElementDescendants()) {
            boolean disabled;
            String tagName = element.getTagName();
            if (!TABBABLE_TAGS.contains(tagName) || (disabled = element.hasAttribute("disabled")) || element.getTabIndex() == HtmlElement.TAB_INDEX_OUT_OF_BOUNDS) continue;
            tabbableElements.add(element);
        }
        Collections.sort(tabbableElements, HtmlPage.createTabOrderComparator());
        return Collections.unmodifiableList(tabbableElements);
    }

    private static Comparator<HtmlElement> createTabOrderComparator() {
        return new Comparator<HtmlElement>(){

            @Override
            public int compare(HtmlElement element1, HtmlElement element2) {
                Short i1 = element1.getTabIndex();
                Short i2 = element2.getTabIndex();
                int index1 = i1 == null ? -1 : (int)i1.shortValue();
                int index2 = i2 == null ? -1 : (int)i2.shortValue();
                int result = index1 > 0 && index2 > 0 ? index1 - index2 : (index1 > 0 ? -1 : (index2 > 0 ? 1 : (index1 == index2 ? 0 : index2 - index1)));
                return result;
            }
        };
    }

    public HtmlElement getHtmlElementByAccessKey(char accessKey) {
        List<HtmlElement> elements = this.getHtmlElementsByAccessKey(accessKey);
        if (elements.isEmpty()) {
            return null;
        }
        return elements.get(0);
    }

    public List<HtmlElement> getHtmlElementsByAccessKey(char accessKey) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        String searchString = Character.toString(accessKey).toLowerCase(Locale.ROOT);
        for (HtmlElement element : this.getHtmlElementDescendants()) {
            String accessKeyAttribute;
            if (!ACCEPTABLE_TAG_NAMES.contains(element.getTagName()) || !searchString.equalsIgnoreCase(accessKeyAttribute = element.getAttributeDirect("accesskey"))) continue;
            elements.add(element);
        }
        return elements;
    }

    public ScriptResult executeJavaScript(String sourceCode) {
        return this.executeJavaScript(sourceCode, "injected script", 1);
    }

    public ScriptResult executeJavaScript(String sourceCode, String sourceName, int startLine) {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return new ScriptResult(Undefined.instance);
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)sourceCode, (CharSequence)"javascript:") && (sourceCode = sourceCode.substring("javascript:".length()).trim()).startsWith("return ")) {
            sourceCode = sourceCode.substring("return ".length());
        }
        Object result = this.getWebClient().getJavaScriptEngine().execute(this, sourceCode, sourceName, startLine);
        return new ScriptResult(result);
    }

    JavaScriptLoadResult loadExternalJavaScriptFile(String srcAttribute, Charset scriptCharset) throws FailingHttpStatusCodeException {
        Object script;
        URL scriptURL;
        WebClient client = this.getWebClient();
        if (StringUtils.isBlank((CharSequence)srcAttribute) || !client.isJavaScriptEnabled()) {
            return JavaScriptLoadResult.NOOP;
        }
        try {
            scriptURL = this.getFullyQualifiedUrl(srcAttribute);
            String protocol = scriptURL.getProtocol();
            if ("javascript".equals(protocol)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Ignoring script src [" + srcAttribute + "]"));
                }
                return JavaScriptLoadResult.NOOP;
            }
            if (!("http".equals(protocol) || "https".equals(protocol) || "data".equals(protocol) || "file".equals(protocol))) {
                client.getJavaScriptErrorListener().malformedScriptURL(this, srcAttribute, new MalformedURLException("unknown protocol: '" + protocol + "'"));
                return JavaScriptLoadResult.NOOP;
            }
        }
        catch (MalformedURLException e) {
            client.getJavaScriptErrorListener().malformedScriptURL(this, srcAttribute, e);
            return JavaScriptLoadResult.NOOP;
        }
        try {
            script = this.loadJavaScriptFromUrl(scriptURL, scriptCharset);
        }
        catch (IOException e) {
            client.getJavaScriptErrorListener().loadScriptError(this, scriptURL, e);
            return JavaScriptLoadResult.DOWNLOAD_ERROR;
        }
        catch (FailingHttpStatusCodeException e) {
            if (e.getStatusCode() == 204) {
                return JavaScriptLoadResult.NO_CONTENT;
            }
            client.getJavaScriptErrorListener().loadScriptError(this, scriptURL, e);
            throw e;
        }
        if (script == null) {
            return JavaScriptLoadResult.COMPILATION_ERROR;
        }
        AbstractJavaScriptEngine<?> engine = client.getJavaScriptEngine();
        engine.execute(this, script);
        return JavaScriptLoadResult.SUCCESS;
    }

    private Object loadJavaScriptFromUrl(URL url, Charset scriptCharset) throws IOException, FailingHttpStatusCodeException {
        WebRequest referringRequest = this.getWebResponse().getWebRequest();
        WebClient client = this.getWebClient();
        WebRequest request = new WebRequest(url);
        request.setAdditionalHeaders(new HashMap<String, String>(referringRequest.getAdditionalHeaders()));
        BrowserVersion browserVersion = client.getBrowserVersion();
        request.setAdditionalHeader("Accept", client.getBrowserVersion().getScriptAcceptHeader());
        if (browserVersion.hasFeature(BrowserVersionFeatures.HTTP_HEADER_SEC_FETCH)) {
            request.setAdditionalHeader("Sec-Fetch-Site", "same-origin");
            request.setAdditionalHeader("Sec-Fetch-Mode", "no-cors");
            request.setAdditionalHeader("Sec-Fetch-Dest", "script");
        }
        request.setRefererlHeader(referringRequest.getUrl());
        WebResponse response = client.loadWebResponse(request);
        Cache cache = client.getCache();
        Object cachedScript = cache.getCachedObject(request);
        if (cachedScript instanceof Script) {
            return cachedScript;
        }
        client.printContentIfNecessary(response);
        client.throwFailingHttpStatusCodeExceptionIfNecessary(response);
        int statusCode = response.getStatusCode();
        if (statusCode == 204) {
            throw new FailingHttpStatusCodeException(response);
        }
        if (statusCode < 200 || statusCode >= 300) {
            throw new IOException("Unable to download JavaScript from '" + url + "' (status " + statusCode + ").");
        }
        String contentType = response.getContentType();
        if (!"application/javascript".equalsIgnoreCase(contentType) && !"application/ecmascript".equalsIgnoreCase(contentType)) {
            if ("text/javascript".equals(contentType) || "text/ecmascript".equals(contentType) || "application/x-javascript".equalsIgnoreCase(contentType)) {
                this.getWebClient().getIncorrectnessListener().notify("Obsolete content type encountered: '" + contentType + "'.", this);
            } else {
                this.getWebClient().getIncorrectnessListener().notify("Expected content type of 'application/javascript' or 'application/ecmascript' for remotely loaded JavaScript element at '" + url + "', but got '" + contentType + "'.", this);
            }
        }
        Charset scriptEncoding = Charset.forName("windows-1252");
        boolean ignoreBom = false;
        Charset contentCharset = EncodingSniffer.sniffEncodingFromHttpHeaders(response.getResponseHeaders());
        if (contentCharset == null) {
            if (scriptCharset != null && StandardCharsets.ISO_8859_1 != scriptCharset) {
                ignoreBom = true;
                scriptEncoding = scriptCharset;
            } else {
                ignoreBom = StandardCharsets.ISO_8859_1 != scriptCharset;
            }
        } else if (StandardCharsets.ISO_8859_1 == contentCharset) {
            ignoreBom = true;
        } else {
            ignoreBom = true;
            scriptEncoding = contentCharset;
        }
        String scriptCode = response.getContentAsString(scriptEncoding, ignoreBom && this.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_IGNORES_UTF8_BOM_SOMETIMES));
        if (null != scriptCode) {
            AbstractJavaScriptEngine<?> javaScriptEngine = client.getJavaScriptEngine();
            Object script = javaScriptEngine.compile(this, scriptCode, url.toExternalForm(), 1);
            if (script != null && cache.cacheIfPossible(request, response, script)) {
                return script;
            }
            response.cleanUp();
            return script;
        }
        response.cleanUp();
        return null;
    }

    public String getTitleText() {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement != null) {
            return titleElement.asText();
        }
        return "";
    }

    public void setTitleText(String message) {
        HtmlTitle titleElement = this.getTitleElement();
        if (titleElement == null) {
            HtmlHead head;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No title element, creating one");
            }
            if ((head = (HtmlHead)HtmlPage.getFirstChildElement(this.getDocumentElement(), HtmlHead.class)) == null) {
                throw new IllegalStateException("Headelement was not defined for this page");
            }
            Map<String, DomAttr> emptyMap = Collections.emptyMap();
            titleElement = new HtmlTitle("title", this, emptyMap);
            if (head.getFirstChild() != null) {
                head.getFirstChild().insertBefore(titleElement);
            } else {
                head.appendChild(titleElement);
            }
        }
        titleElement.setNodeValue(message);
    }

    private static DomElement getFirstChildElement(DomElement startElement, Class<?> clazz) {
        if (startElement == null) {
            return null;
        }
        for (DomElement element : startElement.getChildElements()) {
            if (!clazz.isInstance(element)) continue;
            return element;
        }
        return null;
    }

    private DomElement getFirstChildElementRecursive(DomElement startElement, Class<?> clazz) {
        if (startElement == null) {
            return null;
        }
        for (DomElement element : startElement.getChildElements()) {
            if (clazz.isInstance(element)) {
                return element;
            }
            DomElement childFound = this.getFirstChildElementRecursive(element, clazz);
            if (childFound == null) continue;
            return childFound;
        }
        return null;
    }

    private HtmlTitle getTitleElement() {
        return (HtmlTitle)this.getFirstChildElementRecursive(this.getDocumentElement(), HtmlTitle.class);
    }

    private boolean executeEventHandlersIfNeeded(String eventType) {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return true;
        }
        WebWindow window = this.getEnclosingWindow();
        if (window.getScriptableObject() instanceof Window) {
            Event event = eventType.equals("beforeunload") ? new BeforeUnloadEvent(this, eventType) : new Event(this, eventType);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Firing " + event));
            }
            EventTarget jsNode = "DOMContentLoaded".equals(eventType) ? (EventTarget)this.getScriptableObject() : (EventTarget)window.getScriptableObject();
            HtmlUnitContextFactory cf = ((JavaScriptEngine)this.getWebClient().getJavaScriptEngine()).getContextFactory();
            cf.callSecured(cx -> jsNode.fireEvent(event), this);
            if (!this.isOnbeforeunloadAccepted(this, event)) {
                return false;
            }
        }
        if (window instanceof FrameWindow) {
            FrameWindow fw = (FrameWindow)window;
            BaseFrameElement frame = fw.getFrameElement();
            if ("load".equals(eventType) && frame.getParentNode() instanceof DomDocumentFragment) {
                return true;
            }
            if (frame.hasEventHandlers("on" + eventType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Executing on" + eventType + " handler for " + frame));
                }
                if (window.getScriptableObject() instanceof Window) {
                    Event event;
                    if ("beforeunload".equals(eventType)) {
                        event = new BeforeUnloadEvent(frame, eventType);
                    } else {
                        if (FrameWindow.PageDenied.BY_CONTENT_SECURIRY_POLICY == fw.getPageDenied() && this.hasFeature(BrowserVersionFeatures.JS_EVENT_LOAD_SUPPRESSED_BY_CONTENT_SECURIRY_POLICY)) {
                            return true;
                        }
                        event = new Event(frame, eventType);
                    }
                    frame.fireEvent(event);
                    if (!this.isOnbeforeunloadAccepted((HtmlPage)frame.getPage(), event)) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isOnbeforeunloadAccepted() {
        return this.executeEventHandlersIfNeeded("beforeunload");
    }

    private boolean isOnbeforeunloadAccepted(HtmlPage page, Event event) {
        BeforeUnloadEvent beforeUnloadEvent;
        if (event instanceof BeforeUnloadEvent && (beforeUnloadEvent = (BeforeUnloadEvent)event).isBeforeUnloadMessageSet()) {
            OnbeforeunloadHandler handler = this.getWebClient().getOnbeforeunloadHandler();
            if (handler == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"document.onbeforeunload() returned a string in event.returnValue, but no onbeforeunload handler installed.");
                }
            } else {
                String message = Context.toString((Object)beforeUnloadEvent.getReturnValue());
                return handler.handleEvent(page, message);
            }
        }
        return true;
    }

    private void executeRefreshIfNeeded() throws IOException {
        URL url;
        double time;
        boolean timeOnly;
        WebWindow window = this.getEnclosingWindow();
        if (window == null) {
            return;
        }
        String refreshString = this.getRefreshStringOrNull();
        if (refreshString == null || refreshString.isEmpty()) {
            return;
        }
        int index = StringUtils.indexOfAnyBut((CharSequence)refreshString, (CharSequence)"0123456789");
        boolean bl = timeOnly = index == -1;
        if (timeOnly) {
            try {
                time = Double.parseDouble(refreshString);
            }
            catch (NumberFormatException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Malformed refresh string (no ';' but not a number): " + refreshString), (Throwable)e);
                }
                return;
            }
            url = this.getUrl();
        } else {
            try {
                time = Double.parseDouble(refreshString.substring(0, index).trim());
            }
            catch (NumberFormatException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Malformed refresh string (no valid number before ';') " + refreshString), (Throwable)e);
                }
                return;
            }
            index = refreshString.toLowerCase(Locale.ROOT).indexOf("url=", index);
            if (index == -1) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Malformed refresh string (found ';' but no 'url='): " + refreshString));
                }
                return;
            }
            StringBuilder builder = new StringBuilder(refreshString.substring(index + 4));
            if (StringUtils.isBlank((CharSequence)builder.toString())) {
                url = this.getUrl();
            } else {
                if (builder.charAt(0) == '\"' || builder.charAt(0) == '\'') {
                    builder.deleteCharAt(0);
                }
                if (builder.charAt(builder.length() - 1) == '\"' || builder.charAt(builder.length() - 1) == '\'') {
                    builder.deleteCharAt(builder.length() - 1);
                }
                String urlString = builder.toString();
                try {
                    url = this.getFullyQualifiedUrl(urlString);
                }
                catch (MalformedURLException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Malformed URL in refresh string: " + refreshString), (Throwable)e);
                    }
                    throw e;
                }
            }
        }
        int timeRounded = (int)time;
        this.checkRecursion();
        this.getWebClient().getRefreshHandler().handleRefresh(this, url, timeRounded);
    }

    private void checkRecursion() {
        StackTraceElement[] elements = new Exception().getStackTrace();
        if (elements.length > 500) {
            for (int i = 0; i < 500; ++i) {
                if (elements[i].getClassName().startsWith("com.gargoylesoftware.htmlunit.")) continue;
                return;
            }
            WebResponse webResponse = this.getWebResponse();
            throw new FailingHttpStatusCodeException("Too much redirect for " + webResponse.getWebRequest().getUrl(), webResponse);
        }
    }

    private String getRefreshStringOrNull() {
        List<HtmlMeta> metaTags = this.getMetaTags("refresh");
        if (!metaTags.isEmpty()) {
            return metaTags.get(0).getContentAttribute().trim();
        }
        return this.getWebResponse().getResponseHeaderValue("Refresh");
    }

    private void executeDeferredScriptsIfNeeded() {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return;
        }
        HtmlElement doc = this.getDocumentElement();
        ArrayList elements = new ArrayList(doc.getElementsByTagName("script"));
        for (HtmlElement e : elements) {
            HtmlScript script;
            if (!(e instanceof HtmlScript) || !(script = (HtmlScript)e).isDeferred() || DomElement.ATTRIBUTE_NOT_DEFINED == script.getSrcAttribute()) continue;
            ScriptElementSupport.executeScriptIfNeeded(script, true, true);
        }
    }

    public void deregisterFramesIfNeeded() {
        for (WebWindow webWindow : this.getFrames()) {
            this.getWebClient().deregisterWebWindow(webWindow);
            Page page = webWindow.getEnclosedPage();
            if (page == null || !page.isHtmlPage()) continue;
            ((HtmlPage)page).deregisterFramesIfNeeded();
        }
    }

    public List<FrameWindow> getFrames() {
        ArrayList<FrameWindow> list = new ArrayList<FrameWindow>(this.frameElements_.size());
        for (BaseFrameElement frameElement : this.frameElements_) {
            list.add(frameElement.getEnclosedWindow());
        }
        return list;
    }

    public FrameWindow getFrameByName(String name) throws ElementNotFoundException {
        for (FrameWindow frame : this.getFrames()) {
            if (!frame.getName().equals(name)) continue;
            return frame;
        }
        throw new ElementNotFoundException("frame or iframe", "name", name);
    }

    public DomElement pressAccessKey(char accessKey) throws IOException {
        HtmlElement element = this.getHtmlElementByAccessKey(accessKey);
        if (element != null) {
            Object newPage;
            element.focus();
            if ((element instanceof HtmlAnchor || element instanceof HtmlArea || element instanceof HtmlButton || element instanceof HtmlInput || element instanceof HtmlLabel || element instanceof HtmlLegend || element instanceof HtmlTextArea) && (newPage = element.click()) != this && this.getFocusedElement() == element) {
                this.getFocusedElement().blur();
            }
        }
        return this.getFocusedElement();
    }

    public HtmlElement tabToNextElement() {
        int index;
        List<HtmlElement> elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.setFocusedElement(null);
            return null;
        }
        DomElement elementWithFocus = this.getFocusedElement();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? elements.get(0) : ((index = elements.indexOf(elementWithFocus)) == -1 ? elements.get(0) : (index == elements.size() - 1 ? elements.get(0) : elements.get(index + 1)));
        this.setFocusedElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public HtmlElement tabToPreviousElement() {
        int index;
        List<HtmlElement> elements = this.getTabbableElements();
        if (elements.isEmpty()) {
            this.setFocusedElement(null);
            return null;
        }
        DomElement elementWithFocus = this.getFocusedElement();
        HtmlElement elementToGiveFocus = elementWithFocus == null ? elements.get(elements.size() - 1) : ((index = elements.indexOf(elementWithFocus)) == -1 ? elements.get(elements.size() - 1) : (index == 0 ? elements.get(elements.size() - 1) : elements.get(index - 1)));
        this.setFocusedElement(elementToGiveFocus);
        return elementToGiveFocus;
    }

    public <E extends HtmlElement> E getHtmlElementById(String elementId) throws ElementNotFoundException {
        DomElement element = this.getElementById(elementId);
        if (element == null) {
            throw new ElementNotFoundException("*", "id", elementId);
        }
        return (E)((HtmlElement)element);
    }

    public List<DomElement> getElementsById(String elementId) {
        SortedSet<DomElement> elements = this.idMap_.get(elementId);
        if (elements != null) {
            return new ArrayList<DomElement>(elements);
        }
        return Collections.emptyList();
    }

    public <E extends DomElement> E getElementByName(String name) throws ElementNotFoundException {
        SortedSet<DomElement> elements = this.nameMap_.get(name);
        if (elements != null) {
            return (E)elements.first();
        }
        throw new ElementNotFoundException("*", "name", name);
    }

    public List<DomElement> getElementsByName(String name) {
        SortedSet<DomElement> elements = this.nameMap_.get(name);
        if (elements != null) {
            return new ArrayList<DomElement>(elements);
        }
        return Collections.emptyList();
    }

    public List<DomElement> getElementsByIdAndOrName(String idAndOrName) {
        Collection list1 = this.idMap_.get(idAndOrName);
        Collection list2 = this.nameMap_.get(idAndOrName);
        ArrayList<DomElement> list = new ArrayList<DomElement>();
        if (list1 != null) {
            list.addAll(list1);
        }
        if (list2 != null) {
            for (DomElement elt : list2) {
                if (list.contains(elt)) continue;
                list.add(elt);
            }
        }
        return list;
    }

    void notifyNodeAdded(DomNode node) {
        if (node instanceof DomElement) {
            this.addMappedElement((DomElement)node, true);
            if (node instanceof BaseFrameElement) {
                this.frameElements_.add((BaseFrameElement)node);
            }
            for (HtmlElement child : node.getHtmlElementDescendants()) {
                if (!(child instanceof BaseFrameElement)) continue;
                this.frameElements_.add((BaseFrameElement)child);
            }
            if ("base".equals(node.getNodeName())) {
                this.calculateBase();
            }
        }
        node.onAddedToPage();
    }

    void notifyNodeRemoved(DomNode node) {
        if (node instanceof HtmlElement) {
            this.removeMappedElement((HtmlElement)node, true, true);
            if (node instanceof BaseFrameElement) {
                this.frameElements_.remove(node);
            }
            for (HtmlElement child : node.getHtmlElementDescendants()) {
                if (!(child instanceof BaseFrameElement)) continue;
                this.frameElements_.remove(child);
            }
            if ("base".equals(node.getNodeName())) {
                this.calculateBase();
            }
        }
    }

    void addMappedElement(DomElement element) {
        this.addMappedElement(element, false);
    }

    void addMappedElement(DomElement element, boolean recurse) {
        if (this.isAncestorOf(element)) {
            this.addElement(this.idMap_, element, "id", recurse);
            this.addElement(this.nameMap_, element, "name", recurse);
        }
    }

    private void addElement(Map<String, SortedSet<DomElement>> map, DomElement element, String attribute, boolean recurse) {
        String value = this.getAttributeValue(element, attribute);
        if (DomElement.ATTRIBUTE_NOT_DEFINED != value) {
            SortedSet<DomElement> elements = map.get(value);
            if (elements == null) {
                elements = new TreeSet<DomElement>(documentPositionComparator);
                elements.add(element);
                map.put(value, elements);
            } else if (!elements.contains(element)) {
                elements.add(element);
            }
        }
        if (recurse) {
            for (DomElement child : element.getChildElements()) {
                this.addElement(map, child, attribute, true);
            }
        }
    }

    private String getAttributeValue(DomElement element, String attribute) {
        Object jsValue;
        ScriptableObject scriptObject;
        Object o;
        String value = element.getAttribute(attribute);
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value && this.getWebClient().isJavaScriptEngineEnabled() && !(element instanceof HtmlApplet) && !(element instanceof HtmlObject) && (o = element.getScriptableObject()) instanceof ScriptableObject && (scriptObject = (ScriptableObject)o).has(attribute, (Scriptable)scriptObject) && (jsValue = scriptObject.get(attribute, (Scriptable)scriptObject)) != Scriptable.NOT_FOUND && jsValue instanceof String) {
            value = (String)jsValue;
        }
        return value;
    }

    void removeMappedElement(HtmlElement element) {
        this.removeMappedElement(element, false, false);
    }

    void removeMappedElement(DomElement element, boolean recurse, boolean descendant) {
        if (descendant || this.isAncestorOf(element)) {
            this.removeElement(this.idMap_, element, "id", recurse);
            this.removeElement(this.nameMap_, element, "name", recurse);
        }
    }

    private void removeElement(Map<String, SortedSet<DomElement>> map, DomElement element, String attribute, boolean recurse) {
        SortedSet<DomElement> elements;
        String value = this.getAttributeValue(element, attribute);
        if (!(DomElement.ATTRIBUTE_NOT_DEFINED == value || (elements = map.remove(value)) == null || elements.size() == 1 && elements.contains(element))) {
            elements.remove(element);
            map.put(value, elements);
        }
        if (recurse) {
            for (DomElement child : element.getChildElements()) {
                this.removeElement(map, child, attribute, true);
            }
        }
    }

    static boolean isMappedElement(Document document, String attributeName) {
        return document instanceof HtmlPage && ("name".equals(attributeName) || "id".equals(attributeName));
    }

    private void calculateBase() {
        NodeList baseElements = this.getDocumentElement().getElementsByTagName("base");
        switch (baseElements.size()) {
            case 0: {
                this.base_ = null;
                break;
            }
            case 1: {
                this.base_ = (HtmlBase)baseElements.get(0);
                break;
            }
            default: {
                this.base_ = (HtmlBase)baseElements.get(0);
                this.notifyIncorrectness("Multiple 'base' detected, only the first is used.");
            }
        }
    }

    void loadFrames() throws FailingHttpStatusCodeException {
        for (FrameWindow w : this.getFrames()) {
            BaseFrameElement frame = w.getFrameElement();
            if (frame.getEnclosedWindow() == null || UrlUtils.URL_ABOUT_BLANK != frame.getEnclosedPage().getUrl() || frame.isContentLoaded()) continue;
            frame.loadInnerPage();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("HtmlPage(").append(this.getUrl()).append(")@").append(this.hashCode());
        return builder.toString();
    }

    protected List<HtmlMeta> getMetaTags(String httpEquiv) {
        if (this.getDocumentElement() == null) {
            return Collections.emptyList();
        }
        String nameLC = httpEquiv.toLowerCase(Locale.ROOT);
        DomNodeList tags = this.getDocumentElement().getElementsByTagNameImpl("meta");
        ArrayList<HtmlMeta> foundTags = new ArrayList<HtmlMeta>();
        for (HtmlMeta htmlMeta : tags) {
            if (!nameLC.equals(htmlMeta.getHttpEquivAttribute().toLowerCase(Locale.ROOT))) continue;
            foundTags.add(htmlMeta);
        }
        return foundTags;
    }

    @Override
    protected HtmlPage clone() {
        HtmlPage result = (HtmlPage)super.clone();
        result.elementWithFocus_ = null;
        result.idMap_ = Collections.synchronizedMap(new HashMap());
        result.nameMap_ = Collections.synchronizedMap(new HashMap());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HtmlPage cloneNode(boolean deep) {
        Object jsObjClone;
        HtmlPage result = (HtmlPage)super.cloneNode(false);
        if (this.getWebClient().isJavaScriptEnabled()) {
            jsObjClone = ((SimpleScriptable)this.getScriptableObject()).clone();
            ((SimpleScriptable)jsObjClone).setDomNode(result);
        }
        if (deep) {
            jsObjClone = this.lock_;
            synchronized (jsObjClone) {
                result.attributeListeners_ = null;
            }
            result.selectionRanges_ = new ArrayList<Range>(3);
            result.afterLoadActions_ = new ArrayList<PostponedAction>();
            result.frameElements_ = new TreeSet<DomElement>(documentPositionComparator);
            for (DomNode child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                result.appendChild(child.cloneNode(true));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ == null) {
                this.attributeListeners_ = new LinkedHashSet<HtmlAttributeChangeListener>();
            }
            this.attributeListeners_.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                this.attributeListeners_.remove(listener);
            }
        }
    }

    void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeAdded(event);
            }
        }
    }

    void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeReplaced(event);
            }
        }
    }

    void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        List<HtmlAttributeChangeListener> listeners = this.safeGetAttributeListeners();
        if (listeners != null) {
            for (HtmlAttributeChangeListener listener : listeners) {
                listener.attributeRemoved(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HtmlAttributeChangeListener> safeGetAttributeListeners() {
        Object object = this.lock_;
        synchronized (object) {
            if (this.attributeListeners_ != null) {
                return new ArrayList<HtmlAttributeChangeListener>(this.attributeListeners_);
            }
            return null;
        }
    }

    @Override
    protected void checkChildHierarchy(Node newChild) throws DOMException {
        if (newChild instanceof Element) {
            if (this.getDocumentElement() != null) {
                throw new DOMException(3, "The Document may only have a single child Element.");
            }
        } else if (newChild instanceof DocumentType) {
            if (this.getDoctype() != null) {
                throw new DOMException(3, "The Document may only have a single child DocumentType.");
            }
        } else if (!(newChild instanceof Comment) && !(newChild instanceof ProcessingInstruction)) {
            throw new DOMException(3, "The Document may not have a child of this type: " + newChild.getNodeType());
        }
        super.checkChildHierarchy(newChild);
    }

    public boolean isBeingParsed() {
        return this.parserCount_ > 0;
    }

    public void registerParsingStart() {
        ++this.parserCount_;
    }

    public void registerParsingEnd() {
        --this.parserCount_;
    }

    public boolean isParsingHtmlSnippet() {
        return this.snippetParserCount_ > 0;
    }

    public void registerSnippetParsingStart() {
        ++this.snippetParserCount_;
    }

    public void registerSnippetParsingEnd() {
        --this.snippetParserCount_;
    }

    public boolean isParsingInlineHtmlSnippet() {
        return this.inlineSnippetParserCount_ > 0;
    }

    public void registerInlineSnippetParsingStart() {
        ++this.inlineSnippetParserCount_;
    }

    public void registerInlineSnippetParsingEnd() {
        --this.inlineSnippetParserCount_;
    }

    public Page refresh() throws IOException {
        return this.getWebClient().getPage(this.getWebResponse().getWebRequest());
    }

    public void writeInParsedStream(String string) {
        this.getDOMBuilder().pushInputString(string);
    }

    public void setDOMBuilder(HTMLParserDOMBuilder htmlUnitDOMBuilder) {
        this.domBuilder_ = htmlUnitDOMBuilder;
    }

    public HTMLParserDOMBuilder getDOMBuilder() {
        return this.domBuilder_;
    }

    public Map<String, String> getNamespaces() {
        NamedNodeMap attributes = this.getDocumentElement().getAttributes();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            if (!name.startsWith("xmlns")) continue;
            int startPos = 5;
            if (name.length() > 5 && name.charAt(5) == ':') {
                startPos = 6;
            }
            name = name.substring(startPos);
            namespaces.put(name, attr.getValue());
        }
        return namespaces;
    }

    @Override
    public void setDocumentType(DocumentType type) {
        super.setDocumentType(type);
    }

    public void save(File file) throws IOException {
        new XmlSerializer().save(this, file);
    }

    public boolean isQuirksMode() {
        return "BackCompat".equals(((HTMLDocument)this.getScriptableObject()).getCompatMode());
    }

    @Override
    public boolean isAttachedToPage() {
        return true;
    }

    @Override
    public boolean isHtmlPage() {
        return true;
    }

    public URL getBaseURL() {
        URL baseUrl;
        if (this.base_ == null) {
            boolean frame;
            baseUrl = this.getUrl();
            WebWindow window = this.getEnclosingWindow();
            boolean bl = frame = window != null && window != window.getTopWindow();
            if (frame) {
                boolean frameSrcIsNotSet = baseUrl == UrlUtils.URL_ABOUT_BLANK;
                boolean frameSrcIsJs = "javascript".equals(baseUrl.getProtocol());
                if (frameSrcIsNotSet || frameSrcIsJs) {
                    baseUrl = ((HtmlPage)window.getTopWindow().getEnclosedPage()).getWebResponse().getWebRequest().getUrl();
                }
            } else if (this.baseUrl_ != null) {
                baseUrl = this.baseUrl_;
            }
        } else {
            String href = this.base_.getHrefAttribute().trim();
            if (StringUtils.isEmpty((CharSequence)href)) {
                baseUrl = this.getUrl();
            } else {
                URL url = this.getUrl();
                try {
                    if (href.startsWith("http://") || href.startsWith("https://")) {
                        baseUrl = new URL(href);
                    } else if (href.startsWith("//")) {
                        baseUrl = new URL(String.format("%s:%s", url.getProtocol(), href));
                    } else if (href.length() > 0 && href.charAt(0) == '/') {
                        int port = Window.getPort(url);
                        baseUrl = new URL(String.format("%s://%s:%d%s", url.getProtocol(), url.getHost(), port, href));
                    } else {
                        baseUrl = url.toString().endsWith("/") ? new URL(String.format("%s%s", url.toString(), href)) : new URL(UrlUtils.resolveUrl(url, href));
                    }
                }
                catch (MalformedURLException e) {
                    this.notifyIncorrectness("Invalid base url: \"" + href + "\", ignoring it");
                    baseUrl = url;
                }
            }
        }
        return baseUrl;
    }

    public void addAutoCloseable(AutoCloseable autoCloseable) {
        if (autoCloseable == null) {
            return;
        }
        if (this.autoCloseableList_ == null) {
            this.autoCloseableList_ = new ArrayList<AutoCloseable>();
        }
        this.autoCloseableList_.add(autoCloseable);
    }

    @Override
    public boolean handles(Event event) {
        if ("blur".equals(event.getType()) || "focus".equals(event.getType())) {
            return true;
        }
        return super.handles(event);
    }

    public void setElementFromPointHandler(ElementFromPointHandler elementFromPointHandler) {
        this.elementFromPointHandler_ = elementFromPointHandler;
    }

    public HtmlElement getElementFromPoint(int x, int y) {
        if (this.elementFromPointHandler_ == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("ElementFromPointHandler was not specicifed for " + this));
            }
            if (x <= 0 || y <= 0) {
                return null;
            }
            return this.getBody();
        }
        return this.elementFromPointHandler_.getElementFromPoint(this, x, y);
    }

    public boolean setFocusedElement(DomElement newElement) {
        return this.setFocusedElement(newElement, false);
    }

    public boolean setFocusedElement(DomElement newElement, boolean windowActivated) {
        Object o;
        if (this.elementWithFocus_ == newElement && !windowActivated) {
            return true;
        }
        DomElement oldFocusedElement = this.elementWithFocus_;
        this.elementWithFocus_ = null;
        if (this.getWebClient().isJavaScriptEnabled() && (o = this.getScriptableObject()) instanceof HTMLDocument) {
            ((HTMLDocument)o).setActiveElement(null);
        }
        if (!windowActivated) {
            if (this.hasFeature(BrowserVersionFeatures.EVENT_FOCUS_IN_FOCUS_OUT_BLUR)) {
                if (oldFocusedElement != null) {
                    oldFocusedElement.fireEvent("focusout");
                }
                if (newElement != null) {
                    newElement.fireEvent("focusin");
                }
            }
            if (oldFocusedElement != null) {
                oldFocusedElement.removeFocus();
                oldFocusedElement.fireEvent("blur");
                if (this.hasFeature(BrowserVersionFeatures.EVENT_FOCUS_FOCUS_IN_BLUR_OUT)) {
                    oldFocusedElement.fireEvent("focusout");
                }
            }
        }
        this.elementWithFocus_ = newElement;
        if (newElement instanceof SelectableTextInput && this.hasFeature(BrowserVersionFeatures.PAGE_SELECTION_RANGE_FROM_SELECTABLE_TEXT_INPUT)) {
            SelectableTextInput sti = (SelectableTextInput)((Object)newElement);
            this.setSelectionRange(new SimpleRange(sti, sti.getSelectionStart(), sti, sti.getSelectionEnd()));
        }
        if (newElement != null) {
            Object e;
            if (this.getWebClient().isJavaScriptEnabled() && (o = this.getScriptableObject()) instanceof HTMLDocument && (e = newElement.getScriptableObject()) instanceof HTMLElement) {
                ((HTMLDocument)o).setActiveElement((HTMLElement)e);
            }
            newElement.focus();
            newElement.fireEvent("focus");
            if (this.hasFeature(BrowserVersionFeatures.EVENT_FOCUS_FOCUS_IN_BLUR_OUT)) {
                newElement.fireEvent("focusin");
            }
        }
        return this == this.getEnclosingWindow().getEnclosedPage();
    }

    public DomElement getFocusedElement() {
        return this.elementWithFocus_;
    }

    public void setElementWithFocus(DomElement elementWithFocus) {
        this.elementWithFocus_ = elementWithFocus;
    }

    public List<Range> getSelectionRanges() {
        return this.selectionRanges_;
    }

    public void setSelectionRange(Range selectionRange) {
        this.selectionRanges_.clear();
        this.selectionRanges_.add(selectionRange);
    }

    public ScriptResult executeJavaScriptFunction(Object function, Object thisObject, Object[] args, DomNode htmlElementScope) {
        if (!this.getWebClient().isJavaScriptEnabled()) {
            return new ScriptResult(null);
        }
        return this.executeJavaScriptFunction((Function)function, (Scriptable)thisObject, args, htmlElementScope);
    }

    private ScriptResult executeJavaScriptFunction(Function function, Scriptable thisObject, Object[] args, DomNode htmlElementScope) {
        JavaScriptEngine engine = (JavaScriptEngine)this.getWebClient().getJavaScriptEngine();
        Object result = engine.callFunction(this, function, thisObject, args, htmlElementScope);
        return new ScriptResult(result);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.originalCharset_ == null ? null : this.originalCharset_.name());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        String charsetName = (String)ois.readObject();
        if (charsetName != null) {
            this.originalCharset_ = Charset.forName(charsetName);
        }
        this.lock_ = new Object();
    }

    @Override
    public void setNodeValue(String value) {
    }

    @Override
    public void setPrefix(String prefix) {
    }

    static enum JavaScriptLoadResult {
        NOOP,
        NO_CONTENT,
        SUCCESS,
        DOWNLOAD_ERROR,
        COMPILATION_ERROR;

    }

    static class DocumentPositionComparator
    implements Comparator<DomElement>,
    Serializable {
        DocumentPositionComparator() {
        }

        @Override
        public int compare(DomElement elt1, DomElement elt2) {
            short relation = elt1.compareDocumentPosition(elt2);
            if (relation == 0) {
                return 0;
            }
            if ((relation & 8) != 0 || (relation & 2) != 0) {
                return 1;
            }
            return -1;
        }
    }
}

