/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.BrowserVersion;

abstract class BrowserConfiguration {
    private String defaultValue_;

    BrowserConfiguration(String defaultValue) {
        this.defaultValue_ = defaultValue;
    }

    String getDefaultValue() {
        return this.defaultValue_;
    }

    abstract boolean matches(BrowserVersion var1);

    public boolean isIteratable() {
        return true;
    }

    static BrowserConfiguration getMatchingConfiguration(BrowserVersion browserVersion, BrowserConfiguration[] browserConfigurations) {
        for (BrowserConfiguration browserConfiguration : browserConfigurations) {
            if (!browserConfiguration.matches(browserVersion)) continue;
            return browserConfiguration;
        }
        return null;
    }

    static BrowserConfiguration chromeAndEdge(String defaultValue) {
        return new ChromeAndEdge(defaultValue);
    }

    static BrowserConfiguration edge(String defaultValue) {
        return new Edge(defaultValue);
    }

    static BrowserConfiguration chromeAndEdgeAndFirefox(String defaultValue) {
        return new ChromeAndEdgeAndFirefox(defaultValue);
    }

    static BrowserConfiguration chromeAndEdgeNotIterable(String defaultValue) {
        return new ChromeAndEdgeNotIterable(defaultValue);
    }

    static BrowserConfiguration ff(String defaultValue) {
        return new FF(defaultValue);
    }

    static BrowserConfiguration ffNotIterable(String defaultValue) {
        return new FFNotIterable(defaultValue);
    }

    static BrowserConfiguration ffLatest(String defaultValue) {
        return new FFLatest(defaultValue);
    }

    static BrowserConfiguration ff78(String defaultValue) {
        return new FF78(defaultValue);
    }

    static BrowserConfiguration ie(String defaultValue) {
        return new IE(defaultValue);
    }

    static BrowserConfiguration ieNotIterable(String defaultValue) {
        return new IENotIterable(defaultValue);
    }

    private static class IENotIterable
    extends BrowserConfiguration {
        IENotIterable(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isIE();
        }

        @Override
        public boolean isIteratable() {
            return false;
        }
    }

    private static class IE
    extends BrowserConfiguration {
        IE(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isIE();
        }
    }

    private static class FFLatest
    extends BrowserConfiguration {
        FFLatest(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() > BrowserVersion.FIREFOX_78.getBrowserVersionNumeric();
        }
    }

    private static class FF78
    extends BrowserConfiguration {
        FF78(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox() && browserVersion.getBrowserVersionNumeric() == BrowserVersion.FIREFOX_78.getBrowserVersionNumeric();
        }
    }

    private static class FFNotIterable
    extends BrowserConfiguration {
        FFNotIterable(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox();
        }

        @Override
        public boolean isIteratable() {
            return false;
        }
    }

    private static class FF
    extends BrowserConfiguration {
        FF(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isFirefox();
        }
    }

    private static class ChromeAndEdgeAndFirefox
    extends BrowserConfiguration {
        ChromeAndEdgeAndFirefox(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome() || browserVersion == BrowserVersion.EDGE || browserVersion.isFirefox();
        }
    }

    private static class ChromeAndEdge
    extends BrowserConfiguration {
        ChromeAndEdge(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome() || browserVersion == BrowserVersion.EDGE;
        }
    }

    private static class Edge
    extends BrowserConfiguration {
        Edge(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isEdge();
        }
    }

    static class ChromeAndEdgeNotIterable
    extends BrowserConfiguration {
        ChromeAndEdgeNotIterable(String defaultValue) {
            super(defaultValue);
        }

        @Override
        public boolean matches(BrowserVersion browserVersion) {
            return browserVersion.isChrome() || browserVersion == BrowserVersion.EDGE;
        }

        @Override
        public boolean isIteratable() {
            return false;
        }
    }
}

