/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptableProxy;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLUnknownElement;
import java.util.Deque;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleScriptable
extends HtmlUnitScriptable
implements Cloneable {
    private static final Log LOG = LogFactory.getLog(SimpleScriptable.class);
    private DomNode domNode_;
    private boolean caseSensitive_ = true;

    public Object get(String name, Scriptable start) {
        Object response;
        if (!this.caseSensitive_) {
            for (Object o : this.getAllIds()) {
                String objectName = Context.toString((Object)o);
                if (!name.equalsIgnoreCase(objectName)) continue;
                name = objectName;
                break;
            }
        }
        if ((response = super.get(name, start)) != NOT_FOUND) {
            return response;
        }
        if (this == start) {
            response = this.getWithPreemption(name);
        }
        if (response == NOT_FOUND && start instanceof Window) {
            response = ((Window)start).getWithFallback(name);
        }
        return response;
    }

    protected Object getWithPreemption(String name) {
        return NOT_FOUND;
    }

    public boolean has(int index, Scriptable start) {
        Object found = this.get(index, start);
        if (!Undefined.isUndefined((Object)found) && Scriptable.NOT_FOUND != found) {
            return true;
        }
        return super.has(index, start);
    }

    public DomNode getDomNodeOrDie() {
        if (this.domNode_ == null) {
            String clazz = this.getClass().getName();
            throw new IllegalStateException("DomNode has not been set for this SimpleScriptable: " + clazz);
        }
        return this.domNode_;
    }

    public DomNode getDomNodeOrNull() {
        return this.domNode_;
    }

    public void setDomNode(DomNode domNode) {
        this.setDomNode(domNode, true);
    }

    protected void setDomNode(DomNode domNode, boolean assignScriptObject) {
        WebAssert.notNull("domNode", domNode);
        this.domNode_ = domNode;
        if (assignScriptObject) {
            this.domNode_.setScriptableObject(this);
        }
    }

    protected SimpleScriptable getScriptableFor(Object object) {
        if (object instanceof WebWindow) {
            return (SimpleScriptable)((WebWindow)object).getScriptableObject();
        }
        DomNode domNode = (DomNode)object;
        Object scriptObject = domNode.getScriptableObject();
        if (scriptObject != null) {
            return (SimpleScriptable)scriptObject;
        }
        return this.makeScriptableFor(domNode);
    }

    public SimpleScriptable makeScriptableFor(DomNode domNode) {
        SimpleScriptable scriptable;
        Class javaScriptClass = null;
        if (domNode instanceof HtmlImage && "image".equals(((HtmlImage)domNode).getOriginalQualifiedName()) && ((HtmlImage)domNode).wasCreatedByJavascript()) {
            if (domNode.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLELEMENT)) {
                javaScriptClass = HTMLElement.class;
            } else if (domNode.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLUNKNOWNELEMENT)) {
                javaScriptClass = HTMLUnknownElement.class;
            }
        }
        if (javaScriptClass == null) {
            JavaScriptEngine javaScriptEngine = (JavaScriptEngine)this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine();
            for (Class<?> c = domNode.getClass(); javaScriptClass == null && c != null; c = c.getSuperclass()) {
                javaScriptClass = javaScriptEngine.getJavaScriptClass(c);
            }
        }
        if (javaScriptClass == null) {
            scriptable = new HTMLElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No JavaScript class found for element <" + domNode.getNodeName() + ">. Using HTMLElement"));
            }
        } else {
            try {
                scriptable = (SimpleScriptable)javaScriptClass.newInstance();
            }
            catch (Exception e) {
                throw Context.throwAsScriptRuntimeEx((Throwable)e);
            }
        }
        this.initParentScope(domNode, scriptable);
        scriptable.setPrototype(this.getPrototype(javaScriptClass));
        scriptable.setDomNode(domNode);
        return scriptable;
    }

    protected void initParentScope(DomNode domNode, SimpleScriptable scriptable) {
        SgmlPage page = domNode.getPage();
        WebWindow enclosingWindow = page.getEnclosingWindow();
        if (enclosingWindow != null && enclosingWindow.getEnclosedPage() == page) {
            scriptable.setParentScope((Scriptable)enclosingWindow.getScriptableObject());
        } else {
            scriptable.setParentScope(ScriptableObject.getTopLevelScope((Scriptable)((Scriptable)page.getScriptableObject())));
        }
    }

    public Scriptable getPrototype(Class<? extends SimpleScriptable> javaScriptClass) {
        Scriptable prototype = this.getWindow().getPrototype(javaScriptClass);
        if (prototype == null && javaScriptClass != SimpleScriptable.class) {
            return this.getPrototype(javaScriptClass.getSuperclass());
        }
        return prototype;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    public Window getWindow() throws RuntimeException {
        return SimpleScriptable.getWindow((Scriptable)this);
    }

    protected static Window getWindow(Scriptable s) throws RuntimeException {
        Scriptable top = ScriptableObject.getTopLevelScope((Scriptable)s);
        if (top instanceof Window) {
            return (Window)top;
        }
        throw new RuntimeException("Unable to find window associated with " + s);
    }

    protected Scriptable getStartingScope() {
        Deque stack = (Deque)Context.getCurrentContext().getThreadLocal((Object)"startingScope");
        if (null == stack) {
            return null;
        }
        return (Scriptable)stack.peek();
    }

    public BrowserVersion getBrowserVersion() {
        DomNode node = this.getDomNodeOrNull();
        if (node != null) {
            return node.getPage().getWebClient().getBrowserVersion();
        }
        return this.getWindow().getWebWindow().getWebClient().getBrowserVersion();
    }

    public boolean hasInstance(Scriptable instance) {
        if (this.getPrototype() == null) {
            Object prototype = this.get("prototype", (Scriptable)this);
            if (!(prototype instanceof ScriptableObject)) {
                Context.throwAsScriptRuntimeEx((Throwable)new Exception("Null prototype"));
            }
            return ((ScriptableObject)prototype).hasInstance(instance);
        }
        return super.hasInstance(instance);
    }

    protected Object equivalentValues(Object value) {
        if (value instanceof SimpleScriptableProxy) {
            value = ((SimpleScriptableProxy)value).getDelegee();
        }
        return super.equivalentValues(value);
    }

    public SimpleScriptable clone() {
        try {
            return (SimpleScriptable)super.clone();
        }
        catch (Exception e) {
            throw new IllegalStateException("Clone not supported");
        }
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive_ = caseSensitive;
        Scriptable prototype = this.getPrototype();
        if (prototype instanceof SimpleScriptable) {
            ((SimpleScriptable)prototype).setCaseSensitive(caseSensitive);
        }
    }
}

