/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.parser.HTMLParser;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.xml.XMLDocument;
import java.io.IOException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class DOMParser
extends SimpleScriptable {
    @JsxConstructor
    public DOMParser() {
    }

    @JsxFunction
    public Document parseFromString(String str, Object type) {
        try {
            Document document = DOMParser.parseFromString(this, str, type);
            if (document == null) {
                throw Context.reportRuntimeError((String)("Invalid 'type' parameter: " + type));
            }
            return document;
        }
        catch (IOException e) {
            throw Context.reportRuntimeError((String)("Parsing failed" + e.getMessage()));
        }
    }

    public static Document parseFromString(SimpleScriptable scriptable, String str, Object type) throws IOException {
        if (type == null || Undefined.isUndefined((Object)type)) {
            throw Context.reportRuntimeError((String)"Missing 'type' parameter");
        }
        if ("text/xml".equals(type) || "application/xml".equals(type) || "application/xhtml+xml".equals(type) || "image/svg+xml".equals(type)) {
            XMLDocument document = new XMLDocument();
            document.setParentScope(scriptable.getParentScope());
            document.setPrototype(scriptable.getPrototype(XMLDocument.class));
            document.loadXML(str);
            return document;
        }
        if ("text/html".equals(type)) {
            WebWindow webWindow = scriptable.getWindow().getWebWindow();
            WebClient webClient = webWindow.getWebClient();
            StringWebResponse webResponse = new StringWebResponse(str, webWindow.getEnclosedPage().getUrl());
            HtmlPage page = new HtmlPage(webResponse, webWindow);
            page.setEnclosingWindow(null);
            Window window = (Window)webWindow.getScriptableObject();
            HTMLDocument document = new HTMLDocument();
            document.setParentScope((Scriptable)window);
            document.setPrototype(window.getPrototype(document.getClass()));
            document.setDomNode(page);
            HTMLParser htmlParser = webClient.getPageCreator().getHtmlParser();
            htmlParser.parse(webResponse, page, false);
            return (Document)page.getScriptableObject();
        }
        return null;
    }
}

