/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ExternalArrayData;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(isJSObject=false)
public class AbstractList
extends HtmlUnitScriptable
implements Function,
ExternalArrayData {
    private boolean avoidObjectDetection_;
    private boolean attributeChangeSensitive_;
    private List<DomNode> cachedElements_;
    private boolean listenerRegistered_;

    public AbstractList() {
    }

    public AbstractList(DomNode domeNode, boolean attributeChangeSensitive) {
        this(domeNode, attributeChangeSensitive, null);
    }

    protected AbstractList(DomNode domNode, List<DomNode> initialElements) {
        this(domNode, true, new ArrayList<DomNode>(initialElements));
    }

    private AbstractList(DomNode domNode, boolean attributeChangeSensitive, List<DomNode> initialElements) {
        if (domNode != null) {
            this.setDomNode(domNode, false);
            ScriptableObject parentScope = (ScriptableObject)domNode.getScriptableObject();
            if (parentScope != null) {
                this.setParentScope((Scriptable)parentScope);
                this.setPrototype(this.getPrototype(this.getClass()));
            }
        }
        this.attributeChangeSensitive_ = attributeChangeSensitive;
        this.cachedElements_ = initialElements;
        if (initialElements != null) {
            this.registerListener();
        }
        this.setExternalArrayData(this);
    }

    public boolean avoidObjectDetection() {
        return this.avoidObjectDetection_;
    }

    public void setAvoidObjectDetection(boolean newValue) {
        this.avoidObjectDetection_ = newValue;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        Object object = this.getIt(args[0]);
        if (object == NOT_FOUND) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NULL_IF_NOT_FOUND)) {
                return null;
            }
            return Undefined.instance;
        }
        return object;
    }

    public final Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        return null;
    }

    private Object getIt(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            int i = n.intValue();
            return this.get(i, (Scriptable)this);
        }
        String key = String.valueOf(o);
        return this.get(key, (Scriptable)this);
    }

    @Override
    protected void setDomNode(DomNode domNode, boolean assignScriptObject) {
        DomNode oldDomNode = this.getDomNodeOrNull();
        super.setDomNode(domNode, assignScriptObject);
        if (oldDomNode != domNode) {
            this.listenerRegistered_ = false;
        }
    }

    public List<DomNode> getElements() {
        List<DomNode> cachedElements = this.cachedElements_;
        if (cachedElements == null) {
            cachedElements = this.getParentScope() == null ? new ArrayList<DomNode>() : this.computeElements();
            this.cachedElements_ = cachedElements;
        }
        this.registerListener();
        return cachedElements;
    }

    private void registerListener() {
        DomNode domNode;
        if (!this.listenerRegistered_ && (domNode = this.getDomNodeOrNull()) != null) {
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl(this);
            domNode.addDomChangeListener(listener);
            if (this.attributeChangeSensitive_) {
                if (domNode instanceof HtmlElement) {
                    ((HtmlElement)domNode).addHtmlAttributeChangeListener(listener);
                } else if (domNode instanceof HtmlPage) {
                    ((HtmlPage)domNode).addHtmlAttributeChangeListener(listener);
                }
            }
            this.listenerRegistered_ = true;
        }
    }

    protected List<DomNode> computeElements() {
        ArrayList<DomNode> response = new ArrayList<DomNode>();
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode == null) {
            return response;
        }
        for (DomNode node : this.getCandidates()) {
            if (!(node instanceof DomElement) || !this.isMatching(node)) continue;
            response.add(node);
        }
        return response;
    }

    protected Iterable<DomNode> getCandidates() {
        DomNode domNode = this.getDomNodeOrNull();
        return domNode.getDescendants();
    }

    protected boolean isMatching(DomNode node) {
        return false;
    }

    @Override
    protected Object getWithPreemption(String name) {
        if ("length".equals(name)) {
            return NOT_FOUND;
        }
        List<DomNode> elements = this.getElements();
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        for (DomNode next : elements) {
            String id;
            if (!(next instanceof DomElement) || !name.equals(id = ((DomElement)next).getId())) continue;
            matchingElements.add(next);
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        if (!matchingElements.isEmpty()) {
            AbstractList collection = this.create(this.getDomNodeOrDie(), matchingElements);
            collection.setAvoidObjectDetection(true);
            return collection;
        }
        return this.getWithPreemptionByName(name, elements);
    }

    protected AbstractList create(DomNode parentScope, List<DomNode> initialElements) {
        return new AbstractList(parentScope, initialElements);
    }

    protected Object getWithPreemptionByName(String name, List<DomNode> elements) {
        ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
        for (DomNode next : elements) {
            String nodeName;
            if (!(next instanceof DomElement) || !name.equals(nodeName = ((DomElement)next).getAttributeDirect("name"))) continue;
            matchingElements.add(next);
        }
        if (matchingElements.isEmpty()) {
            return NOT_FOUND;
        }
        if (matchingElements.size() == 1) {
            return this.getScriptableForElement(matchingElements.get(0));
        }
        DomNode domNode = this.getDomNodeOrNull();
        AbstractList collection = this.create(domNode, matchingElements);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    @JsxGetter
    public final int getLength() {
        return this.getElements().size();
    }

    @JsxFunction
    public Object item(Object index) {
        Object object = this.getIt(index);
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + this.getDomNodeOrNull();
    }

    @Override
    protected Object equivalentValues(Object other) {
        if (other == this) {
            return Boolean.TRUE;
        }
        if (other instanceof AbstractList) {
            AbstractList otherArray = (AbstractList)other;
            DomNode domNode = this.getDomNodeOrNull();
            DomNode domNodeOther = otherArray.getDomNodeOrNull();
            if (this.getClass() == other.getClass() && domNode == domNodeOther && this.getElements().equals(otherArray.getElements())) {
                return Boolean.TRUE;
            }
            return NOT_FOUND;
        }
        return super.equivalentValues(other);
    }

    protected EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
        return EffectOnCache.RESET;
    }

    protected Scriptable getScriptableForElement(Object object) {
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return this.getScriptableFor(object);
    }

    public void defineProperty(String propertyName, Object delegateTo, Method getter, Method setter, int attributes) {
        if ("length".equals(propertyName) && this.getPrototype() != null) {
            return;
        }
        super.defineProperty(propertyName, delegateTo, getter, setter, attributes);
    }

    public Object getArrayElement(int index) {
        List<DomNode> elements = this.getElements();
        if (index >= 0 && index < elements.size()) {
            return this.getScriptableForElement(elements.get(index));
        }
        return NOT_FOUND;
    }

    public void setArrayElement(int index, Object value) {
    }

    public int getArrayLength() {
        return this.getElements().size();
    }

    private static final class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private final transient WeakReference<AbstractList> nodeList_;

        DomHtmlAttributeChangeListenerImpl(AbstractList nodeList) {
            this.nodeList_ = new WeakReference<AbstractList>(nodeList);
        }

        @Override
        public void nodeAdded(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void nodeDeleted(DomChangeEvent event) {
            this.clearCache();
        }

        @Override
        public void attributeAdded(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            this.handleChangeOnCache(event);
        }

        @Override
        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            AbstractList nodes = (AbstractList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            if (nodes.attributeChangeSensitive_) {
                this.handleChangeOnCache(event);
            }
        }

        private void handleChangeOnCache(HtmlAttributeChangeEvent event) {
            AbstractList nodes = (AbstractList)this.nodeList_.get();
            if (null == nodes) {
                return;
            }
            EffectOnCache effectOnCache = nodes.getEffectOnCache(event);
            if (EffectOnCache.NONE == effectOnCache) {
                return;
            }
            if (EffectOnCache.RESET == effectOnCache) {
                this.clearCache();
            }
        }

        private void clearCache() {
            AbstractList nodes = (AbstractList)this.nodeList_.get();
            if (null != nodes) {
                nodes.cachedElements_ = null;
            }
        }
    }

    protected static enum EffectOnCache {
        NONE,
        RESET;

    }
}

