/*
 * Copyright (c) 2002-2022 Gargoyle Software Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.gargoylesoftware.htmlunit.html;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gargoylesoftware.htmlunit.SgmlPage;

/**
 * Wrapper for the HTML element "fieldset".
 *
 * @author <a href="mailto:mbowler@GargoyleSoftware.com">Mike Bowler</a>
 * @author David K. Taylor
 * @author <a href="mailto:cse@dynabean.de">Christian Sell</a>
 * @author Ahmed Ashour
 * @author Frank Danek
 * @author Ronald Brill
 */
public class HtmlFieldSet extends HtmlElement implements ValidatableElement {

    /** The HTML tag represented by this element. */
    public static final String TAG_NAME = "fieldset";

    private String customValidity_;

    /**
     * Creates an instance of HtmlFieldSet
     *
     * @param qualifiedName the qualified name of the element type to instantiate
     * @param page the HtmlPage that contains this element
     * @param attributes the initial attributes
     */
    HtmlFieldSet(final String qualifiedName, final SgmlPage page,
            final Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean willValidate() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void setCustomValidity(final String message) {
        customValidity_ = message;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasBadInputValidityState() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isCustomErrorValidityState() {
        return !StringUtils.isEmpty(customValidity_);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasPatternMismatchValidityState() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isStepMismatchValidityState() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isTooLongValidityState() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isTooShortValidityState() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasTypeMismatchValidityState() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasRangeOverflowValidityState() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean hasRangeUnderflowValidityState() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean isValidValidityState() {
        return !isCustomErrorValidityState();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isValueMissingValidityState() {
        return false;
    }
}
