/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.PluginConfiguration;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.javascript.configuration.AbstractJavaScriptConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserFeature;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.FilenameUtils;

public final class BrowserVersion
implements Serializable {
    private static final String NETSCAPE = "Netscape";
    private static final String LANGUAGE_ENGLISH_US = "en-US";
    private static final String TIMEZONE_NEW_YORK = "America/New_York";
    private static final String CPU_CLASS_X86 = "x86";
    private static final String PLATFORM_WIN32 = "Win32";
    public static final BrowserVersion FIREFOX = new BrowserVersion(103, "FF");
    private static final int FIREFOX_ESR_NUMERIC = 91;
    public static final BrowserVersion FIREFOX_ESR = new BrowserVersion(91, "FF-ESR");
    public static final BrowserVersion INTERNET_EXPLORER = new BrowserVersion(11, "IE");
    public static final BrowserVersion EDGE = new BrowserVersion(104, "Edge");
    public static final BrowserVersion CHROME = new BrowserVersion(104, "Chrome");
    public static final BrowserVersion[] ALL_SUPPORTED_BROWSERS = new BrowserVersion[]{CHROME, EDGE, FIREFOX, FIREFOX_ESR, INTERNET_EXPLORER};
    public static final BrowserVersion BEST_SUPPORTED;
    private static BrowserVersion DefaultBrowserVersion_;
    private final int browserVersionNumeric_;
    private final String nickname_;
    private String applicationCodeName_ = "Mozilla";
    private String applicationMinorVersion_ = "0";
    private String applicationName_;
    private String applicationVersion_;
    private String buildId_;
    private String productSub_;
    private String vendor_ = "";
    private Locale browserLocale_ = Locale.forLanguageTag("en-US");
    private String cpuClass_ = "x86";
    private boolean onLine_ = true;
    private String platform_ = "Win32";
    private String systemLanguage_ = "en-US";
    private TimeZone systemTimezone_ = TimeZone.getTimeZone("America/New_York");
    private String userAgent_;
    private String userLanguage_ = "en-US";
    private final Set<PluginConfiguration> plugins_;
    private final Set<BrowserVersionFeatures> features_;
    private String acceptEncodingHeader_;
    private String acceptLanguageHeader_;
    private String htmlAcceptHeader_;
    private String imgAcceptHeader_;
    private String cssAcceptHeader_;
    private String scriptAcceptHeader_;
    private String secClientHintUserAgentHeader_;
    private String secClientHintUserAgentPlatformHeader_;
    private String xmlHttpRequestAcceptHeader_;
    private String[] headerNamesOrdered_;
    private int[] fontHeights_;
    private final Map<String, String> uploadMimeTypes_;

    BrowserVersion(int browserVersionNumeric, String nickname) {
        this.browserVersionNumeric_ = browserVersionNumeric;
        this.nickname_ = nickname;
        this.applicationName_ = NETSCAPE;
        this.acceptEncodingHeader_ = "gzip, deflate";
        this.htmlAcceptHeader_ = "*/*";
        this.imgAcceptHeader_ = "*/*";
        this.cssAcceptHeader_ = "*/*";
        this.scriptAcceptHeader_ = "*/*";
        this.xmlHttpRequestAcceptHeader_ = "*/*";
        this.secClientHintUserAgentHeader_ = "";
        this.secClientHintUserAgentPlatformHeader_ = "\"Windows\"";
        this.plugins_ = new HashSet<PluginConfiguration>();
        this.features_ = EnumSet.noneOf(BrowserVersionFeatures.class);
        this.uploadMimeTypes_ = new HashMap<String, String>();
        this.initFeatures();
    }

    private void initFeatures() {
        SupportedBrowser expectedBrowser = this.isChrome() ? SupportedBrowser.CHROME : (this.isEdge() ? SupportedBrowser.EDGE : (this.isFirefox78() ? SupportedBrowser.FF_ESR : (this.isFirefox() ? SupportedBrowser.FF : SupportedBrowser.IE)));
        for (BrowserVersionFeatures features : BrowserVersionFeatures.values()) {
            try {
                Field field = BrowserVersionFeatures.class.getField(features.name());
                BrowserFeature browserFeature = field.getAnnotation(BrowserFeature.class);
                if (browserFeature == null) continue;
                for (SupportedBrowser browser : browserFeature.value()) {
                    if (!AbstractJavaScriptConfiguration.isCompatible(expectedBrowser, browser)) continue;
                    this.features_.add(features);
                }
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static BrowserVersion getDefault() {
        return DefaultBrowserVersion_;
    }

    public static void setDefault(BrowserVersion newBrowserVersion) {
        WebAssert.notNull("newBrowserVersion", newBrowserVersion);
        DefaultBrowserVersion_ = newBrowserVersion;
    }

    public boolean isIE() {
        return this.getNickname().startsWith("IE");
    }

    public boolean isChrome() {
        return this.getNickname().startsWith("Chrome");
    }

    public boolean isEdge() {
        return this.getNickname().startsWith("Edge");
    }

    public boolean isFirefox() {
        return this.getNickname().startsWith("FF");
    }

    public boolean isFirefox78() {
        return this.isFirefox() && this.getBrowserVersionNumeric() == 91;
    }

    public String getNickname() {
        return this.nickname_;
    }

    public int getBrowserVersionNumeric() {
        return this.browserVersionNumeric_;
    }

    public String getApplicationCodeName() {
        return this.applicationCodeName_;
    }

    public String getApplicationMinorVersion() {
        return this.applicationMinorVersion_;
    }

    public String getApplicationName() {
        return this.applicationName_;
    }

    public String getApplicationVersion() {
        return this.applicationVersion_;
    }

    public String getVendor() {
        return this.vendor_;
    }

    public Locale getBrowserLocale() {
        return this.browserLocale_;
    }

    public String getBrowserLanguage() {
        return this.browserLocale_.toLanguageTag();
    }

    public String getCpuClass() {
        return this.cpuClass_;
    }

    public boolean isOnLine() {
        return this.onLine_;
    }

    public String getPlatform() {
        return this.platform_;
    }

    public String getSystemLanguage() {
        return this.systemLanguage_;
    }

    public TimeZone getSystemTimezone() {
        return this.systemTimezone_;
    }

    public String getUserAgent() {
        return this.userAgent_;
    }

    public String getUserLanguage() {
        return this.userLanguage_;
    }

    public String getAcceptEncodingHeader() {
        return this.acceptEncodingHeader_;
    }

    public String getAcceptLanguageHeader() {
        return this.acceptLanguageHeader_;
    }

    public String getHtmlAcceptHeader() {
        return this.htmlAcceptHeader_;
    }

    public String getScriptAcceptHeader() {
        return this.scriptAcceptHeader_;
    }

    public String getXmlHttpRequestAcceptHeader() {
        return this.xmlHttpRequestAcceptHeader_;
    }

    public String getImgAcceptHeader() {
        return this.imgAcceptHeader_;
    }

    public String getCssAcceptHeader() {
        return this.cssAcceptHeader_;
    }

    public String getSecClientHintUserAgentHeader() {
        return this.secClientHintUserAgentHeader_;
    }

    public String getSecClientHintUserAgentPlatformHeader() {
        return this.secClientHintUserAgentPlatformHeader_;
    }

    public Set<PluginConfiguration> getPlugins() {
        return this.plugins_;
    }

    public boolean hasFeature(BrowserVersionFeatures property) {
        return this.features_.contains((Object)property);
    }

    public String getBuildId() {
        return this.buildId_;
    }

    public String getProductSub() {
        return this.productSub_;
    }

    public String[] getHeaderNamesOrdered() {
        return this.headerNamesOrdered_;
    }

    public void registerUploadMimeType(String fileExtension, String mimeType) {
        if (fileExtension != null) {
            this.uploadMimeTypes_.put(fileExtension.toLowerCase(Locale.ROOT), mimeType);
        }
    }

    public String getUploadMimeType(File file) {
        if (file == null) {
            return "";
        }
        String fileExtension = FilenameUtils.getExtension((String)file.getName());
        String mimeType = this.uploadMimeTypes_.get(fileExtension.toLowerCase(Locale.ROOT));
        if (mimeType != null) {
            return mimeType;
        }
        return "";
    }

    public int getFontHeight(String fontSize) {
        if (this.fontHeights_ == null) {
            return 18;
        }
        int fontSizeInt = Integer.parseInt(fontSize.substring(0, fontSize.length() - 2));
        if (fontSizeInt < this.fontHeights_.length) {
            return this.fontHeights_[fontSizeInt];
        }
        return (int)((double)fontSizeInt * 1.2);
    }

    public int getPixesPerChar() {
        return 10;
    }

    public String toString() {
        return this.nickname_;
    }

    static /* synthetic */ String[] access$2702(BrowserVersion x0, String[] x1) {
        x0.headerNamesOrdered_ = x1;
        return x1;
    }

    static /* synthetic */ int[] access$002(BrowserVersion x0, int[] x1) {
        x0.fontHeights_ = x1;
        return x1;
    }

    static {
        DefaultBrowserVersion_ = BEST_SUPPORTED = CHROME;
        BrowserVersion.FIREFOX_ESR.applicationVersion_ = "5.0 (Windows)";
        BrowserVersion.FIREFOX_ESR.userAgent_ = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:" + FIREFOX_ESR.getBrowserVersionNumeric() + ".0) Gecko/20100101 Firefox/" + FIREFOX_ESR.getBrowserVersionNumeric() + ".0";
        BrowserVersion.FIREFOX_ESR.buildId_ = "20181001000000";
        BrowserVersion.FIREFOX_ESR.productSub_ = "20100101";
        BrowserVersion.FIREFOX_ESR.headerNamesOrdered_ = new String[]{"Host", "User-Agent", "Accept", "Accept-Language", "Accept-Encoding", "Connection", "Referer", "Cookie", "Upgrade-Insecure-Requests", "Sec-Fetch-Dest", "Sec-Fetch-Mode", "Sec-Fetch-Site", "Sec-Fetch-User"};
        BrowserVersion.FIREFOX_ESR.htmlAcceptHeader_ = "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8";
        BrowserVersion.FIREFOX_ESR.acceptLanguageHeader_ = "en-US,en;q=0.5";
        BrowserVersion.FIREFOX_ESR.xmlHttpRequestAcceptHeader_ = "*/*";
        BrowserVersion.FIREFOX_ESR.imgAcceptHeader_ = "image/webp,*/*";
        BrowserVersion.FIREFOX_ESR.cssAcceptHeader_ = "text/css,*/*;q=0.1";
        BrowserVersion.FIREFOX_ESR.fontHeights_ = new int[]{0, 2, 3, 5, 6, 6, 7, 9, 10, 11, 12, 13, 15, 16, 16, 17, 18, 20, 21, 22, 23, 25, 26, 26, 28, 29, 31, 32, 33, 34, 35, 37, 38, 38, 39, 41, 42, 43, 44, 45, 47, 48, 48, 49, 51, 52, 53, 54, 56, 58, 59, 59, 60, 61, 63, 64, 65, 66, 68, 69, 69, 70, 71, 73, 74, 75, 76, 77, 79, 79, 80, 82, 84, 85, 86, 87, 88, 90, 91, 91, 92, 94, 95, 96, 97, 98, 100, 101, 101, 102, 103, 105, 106, 107, 108, 111, 112, 112, 113, 114, 116, 117, 118, 119, 120, 122, 122, 123, 124, 126, 127, 128, 129, 130, 132, 132, 133, 134, 137, 138, 139, 140, 141, 143, 143, 144, 145, 146, 148};
        BrowserVersion.FIREFOX.applicationVersion_ = "5.0 (Windows)";
        BrowserVersion.FIREFOX.userAgent_ = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:" + FIREFOX.getBrowserVersionNumeric() + ".0) Gecko/20100101 Firefox/" + FIREFOX.getBrowserVersionNumeric() + ".0";
        BrowserVersion.FIREFOX.buildId_ = "20181001000000";
        BrowserVersion.FIREFOX.productSub_ = "20100101";
        BrowserVersion.FIREFOX.headerNamesOrdered_ = new String[]{"Host", "User-Agent", "Accept", "Accept-Language", "Accept-Encoding", "Connection", "Referer", "Cookie", "Upgrade-Insecure-Requests", "Sec-Fetch-Dest", "Sec-Fetch-Mode", "Sec-Fetch-Site", "Sec-Fetch-User"};
        BrowserVersion.FIREFOX.acceptEncodingHeader_ = "gzip, deflate, br";
        BrowserVersion.FIREFOX.htmlAcceptHeader_ = "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,*/*;q=0.8";
        BrowserVersion.FIREFOX.acceptLanguageHeader_ = "en-US,en;q=0.5";
        BrowserVersion.FIREFOX.xmlHttpRequestAcceptHeader_ = "*/*";
        BrowserVersion.FIREFOX.imgAcceptHeader_ = "image/avif,image/webp,*/*";
        BrowserVersion.FIREFOX.cssAcceptHeader_ = "text/css,*/*;q=0.1";
        BrowserVersion.FIREFOX.fontHeights_ = new int[]{0, 2, 3, 5, 6, 6, 7, 9, 10, 11, 12, 13, 15, 16, 16, 17, 18, 20, 21, 22, 23, 25, 26, 26, 28, 29, 31, 32, 33, 34, 35, 37, 38, 38, 39, 41, 42, 43, 44, 45, 47, 48, 48, 49, 51, 52, 53, 54, 56, 58, 59, 59, 60, 61, 63, 64, 65, 66, 68, 69, 69, 70, 71, 73, 74, 75, 76, 77, 79, 79, 80, 82, 84, 85, 86, 87, 88, 90, 91, 91, 92, 94, 95, 96, 97, 98, 100, 101, 101, 102, 103, 105, 106, 107, 108, 111, 112, 112, 113, 114, 116, 117, 118, 119, 120, 122, 122, 123, 124, 126, 127, 128, 129, 130, 132, 132, 133, 134, 137, 138, 139, 140, 141, 143, 143, 144, 145, 146, 148};
        BrowserVersion.INTERNET_EXPLORER.applicationVersion_ = "5.0 (Windows NT 10.0; WOW64; Trident/7.0; Zoom 3.6.0; rv:" + INTERNET_EXPLORER.getBrowserVersionNumeric() + ".0) like Gecko";
        BrowserVersion.INTERNET_EXPLORER.userAgent_ = "Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Zoom 3.6.0; rv:11.0) like Gecko";
        BrowserVersion.INTERNET_EXPLORER.headerNamesOrdered_ = new String[]{"Accept", "Referer", "Accept-Language", "User-Agent", "Accept-Encoding", "Host", "DNT", "Connection", "Cookie"};
        BrowserVersion.INTERNET_EXPLORER.htmlAcceptHeader_ = "text/html, application/xhtml+xml, image/jxr, */*";
        BrowserVersion.INTERNET_EXPLORER.acceptLanguageHeader_ = "en-US,en;q=0.9";
        BrowserVersion.INTERNET_EXPLORER.imgAcceptHeader_ = "image/png, image/svg+xml, image/jxr, image/*;q=0.8, */*;q=0.5";
        BrowserVersion.INTERNET_EXPLORER.cssAcceptHeader_ = "text/css, */*";
        BrowserVersion.INTERNET_EXPLORER.scriptAcceptHeader_ = "application/javascript, */*;q=0.8";
        BrowserVersion.INTERNET_EXPLORER.fontHeights_ = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 28, 29, 30, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 51, 52, 53, 54, 55, 56, 58, 59, 60, 61, 62, 63, 64, 66, 67, 68, 69, 70, 71, 72, 74, 75, 76, 77, 78, 79, 80, 82, 83, 84, 85, 86, 87, 89, 90, 91, 92, 93, 94, 95, 97, 98, 99, 100, 101, 102, 103, 105, 106, 107, 108, 109, 110, 112, 113, 114, 115, 116, 117, 118, 120, 121, 122, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 135, 136, 137, 138, 139, 140, 141, 143, 144, 145, 146, 147};
        BrowserVersion.CHROME.applicationVersion_ = "5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/" + CHROME.getBrowserVersionNumeric() + ".0.5112.81 Safari/537.36";
        BrowserVersion.CHROME.userAgent_ = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/" + CHROME.getBrowserVersionNumeric() + ".0.5112.81 Safari/537.36";
        BrowserVersion.CHROME.applicationCodeName_ = "Mozilla";
        BrowserVersion.CHROME.vendor_ = "Google Inc.";
        BrowserVersion.CHROME.cpuClass_ = null;
        BrowserVersion.CHROME.productSub_ = "20030107";
        BrowserVersion.CHROME.headerNamesOrdered_ = new String[]{"Host", "Connection", "sec-ch-ua", "sec-ch-ua-mobile", "sec-ch-ua-platform", "Upgrade-Insecure-Requests", "User-Agent", "Accept", "Sec-Fetch-Site", "Sec-Fetch-Mode", "Sec-Fetch-User", "Sec-Fetch-Dest", "Referer", "Accept-Encoding", "Accept-Language", "Cookie"};
        BrowserVersion.CHROME.acceptEncodingHeader_ = "gzip, deflate, br";
        BrowserVersion.CHROME.acceptLanguageHeader_ = "en-US,en;q=0.9";
        BrowserVersion.CHROME.htmlAcceptHeader_ = "text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9";
        BrowserVersion.CHROME.imgAcceptHeader_ = "image/avif,image/webp,image/apng,image/svg+xml,image/*,*/*;q=0.8";
        BrowserVersion.CHROME.cssAcceptHeader_ = "text/css,*/*;q=0.1";
        BrowserVersion.CHROME.scriptAcceptHeader_ = "*/*";
        BrowserVersion.CHROME.secClientHintUserAgentHeader_ = "\"Chromium\";v=\"" + CHROME.getBrowserVersionNumeric() + "\", \" Not A;Brand\";v=\"99\", \"Google Chrome\";v=\"" + CHROME.getBrowserVersionNumeric() + "\"";
        BrowserVersion.CHROME.fontHeights_ = new int[]{0, 1, 2, 4, 5, 5, 6, 8, 9, 10, 11, 12, 15, 16, 16, 17, 18, 20, 21, 22, 23, 25, 26, 26, 27, 28, 30, 31, 32, 33, 34, 36, 37, 37, 38, 40, 42, 43, 44, 45, 47, 48, 48, 49, 51, 52, 53, 54, 55, 57, 58, 58, 59, 60, 62, 63, 64, 65, 67, 69, 69, 70, 71, 73, 74, 75, 76, 77, 79, 79, 80, 81, 83, 84, 85, 86, 87, 89, 90, 90, 91, 93, 94, 96, 97, 98, 100, 101, 101, 102, 103, 105, 106, 107, 108, 110, 111, 111, 112, 113, 115, 116, 117, 118, 119, 121, 122, 123, 124, 126, 127, 128, 129, 130, 132, 132, 133, 134, 136, 137, 138, 139, 140, 142, 142, 143, 144, 145, 147};
        BrowserVersion.EDGE.applicationVersion_ = "5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/" + EDGE.getBrowserVersionNumeric() + ".0.5112.81 Safari/537.36 Edg/" + EDGE.getBrowserVersionNumeric() + ".0.1293.47";
        BrowserVersion.EDGE.userAgent_ = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/" + EDGE.getBrowserVersionNumeric() + ".0.5112.81 Safari/537.36 Edg/" + EDGE.getBrowserVersionNumeric() + ".0.1293.47";
        BrowserVersion.EDGE.applicationCodeName_ = "Mozilla";
        BrowserVersion.EDGE.vendor_ = "Google Inc.";
        BrowserVersion.EDGE.cpuClass_ = null;
        BrowserVersion.EDGE.productSub_ = "20030107";
        BrowserVersion.EDGE.headerNamesOrdered_ = new String[]{"Host", "Connection", "sec-ch-ua", "sec-ch-ua-mobile", "sec-ch-ua-platform", "Upgrade-Insecure-Requests", "User-Agent", "Accept", "Sec-Fetch-Site", "Sec-Fetch-Mode", "Sec-Fetch-User", "Sec-Fetch-Dest", "Referer", "Accept-Encoding", "Accept-Language", "Cookie"};
        BrowserVersion.EDGE.acceptEncodingHeader_ = "gzip, deflate, br";
        BrowserVersion.EDGE.acceptLanguageHeader_ = "en-US,en;q=0.9";
        BrowserVersion.EDGE.htmlAcceptHeader_ = "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9";
        BrowserVersion.EDGE.imgAcceptHeader_ = "image/webp,image/apng,image/svg+xml,image/*,*/*;q=0.8";
        BrowserVersion.EDGE.cssAcceptHeader_ = "text/css,*/*;q=0.1";
        BrowserVersion.EDGE.scriptAcceptHeader_ = "*/*";
        BrowserVersion.EDGE.secClientHintUserAgentHeader_ = "\"Chromium\";v=\"" + EDGE.getBrowserVersionNumeric() + "\", \" Not A;Brand\";v=\"99\", \"Microsoft Edge\";v=\"" + EDGE.getBrowserVersionNumeric() + "\"";
        BrowserVersion.EDGE.fontHeights_ = new int[]{0, 1, 2, 4, 5, 5, 6, 8, 9, 10, 11, 12, 15, 16, 16, 17, 18, 20, 21, 22, 23, 25, 26, 26, 27, 28, 30, 31, 32, 33, 34, 36, 37, 37, 38, 40, 42, 43, 44, 45, 47, 48, 48, 49, 51, 52, 53, 54, 55, 57, 58, 58, 59, 60, 62, 63, 64, 65, 67, 69, 69, 70, 71, 73, 74, 75, 76, 77, 79, 79, 80, 81, 83, 84, 85, 86, 87, 89, 90, 90, 91, 93, 94, 96, 97, 98, 100, 101, 101, 102, 103, 105, 106, 107, 108, 110, 111, 111, 112, 113, 115, 116, 117, 118, 119, 121, 122, 123, 124, 126, 127, 128, 129, 130, 132, 132, 133, 134, 136, 137, 138, 139, 140, 142, 142, 143, 144, 145, 147};
        CHROME.registerUploadMimeType("html", "text/html");
        CHROME.registerUploadMimeType("htm", "text/html");
        CHROME.registerUploadMimeType("css", "text/css");
        CHROME.registerUploadMimeType("xml", "text/xml");
        CHROME.registerUploadMimeType("gif", "image/gif");
        CHROME.registerUploadMimeType("jpeg", "image/jpeg");
        CHROME.registerUploadMimeType("jpg", "image/jpeg");
        CHROME.registerUploadMimeType("png", "image/png");
        CHROME.registerUploadMimeType("webp", "image/webp");
        CHROME.registerUploadMimeType("mp4", "video/mp4");
        CHROME.registerUploadMimeType("m4v", "video/mp4");
        CHROME.registerUploadMimeType("m4a", "audio/x-m4a");
        CHROME.registerUploadMimeType("mp3", "audio/mpeg");
        CHROME.registerUploadMimeType("ogv", "video/ogg");
        CHROME.registerUploadMimeType("ogm", "video/ogg");
        CHROME.registerUploadMimeType("ogg", "audio/ogg");
        CHROME.registerUploadMimeType("oga", "audio/ogg");
        CHROME.registerUploadMimeType("opus", "audio/ogg");
        CHROME.registerUploadMimeType("webm", "video/webm");
        CHROME.registerUploadMimeType("wav", "audio/wav");
        CHROME.registerUploadMimeType("flac", "audio/flac");
        CHROME.registerUploadMimeType("xhtml", "application/xhtml+xml");
        CHROME.registerUploadMimeType("xht", "application/xhtml+xml");
        CHROME.registerUploadMimeType("xhtm", "application/xhtml+xml");
        CHROME.registerUploadMimeType("txt", "text/plain");
        CHROME.registerUploadMimeType("text", "text/plain");
        EDGE.registerUploadMimeType("html", "text/html");
        EDGE.registerUploadMimeType("htm", "text/html");
        EDGE.registerUploadMimeType("css", "text/css");
        EDGE.registerUploadMimeType("xml", "text/xml");
        EDGE.registerUploadMimeType("gif", "image/gif");
        EDGE.registerUploadMimeType("jpeg", "image/jpeg");
        EDGE.registerUploadMimeType("jpg", "image/jpeg");
        EDGE.registerUploadMimeType("png", "image/png");
        EDGE.registerUploadMimeType("webp", "image/webp");
        EDGE.registerUploadMimeType("mp4", "video/mp4");
        EDGE.registerUploadMimeType("m4v", "video/mp4");
        EDGE.registerUploadMimeType("m4a", "audio/x-m4a");
        EDGE.registerUploadMimeType("mp3", "audio/mpeg");
        EDGE.registerUploadMimeType("ogv", "video/ogg");
        EDGE.registerUploadMimeType("ogm", "video/ogg");
        EDGE.registerUploadMimeType("ogg", "audio/ogg");
        EDGE.registerUploadMimeType("oga", "audio/ogg");
        EDGE.registerUploadMimeType("opus", "audio/ogg");
        EDGE.registerUploadMimeType("webm", "video/webm");
        EDGE.registerUploadMimeType("wav", "audio/wav");
        EDGE.registerUploadMimeType("flac", "audio/flac");
        EDGE.registerUploadMimeType("xhtml", "application/xhtml+xml");
        EDGE.registerUploadMimeType("xht", "application/xhtml+xml");
        EDGE.registerUploadMimeType("xhtm", "application/xhtml+xml");
        EDGE.registerUploadMimeType("txt", "text/plain");
        EDGE.registerUploadMimeType("text", "text/plain");
        FIREFOX_ESR.registerUploadMimeType("html", "text/html");
        FIREFOX_ESR.registerUploadMimeType("htm", "text/html");
        FIREFOX_ESR.registerUploadMimeType("css", "text/css");
        FIREFOX_ESR.registerUploadMimeType("xml", "text/xml");
        FIREFOX_ESR.registerUploadMimeType("gif", "image/gif");
        FIREFOX_ESR.registerUploadMimeType("jpeg", "image/jpeg");
        FIREFOX_ESR.registerUploadMimeType("jpg", "image/jpeg");
        FIREFOX_ESR.registerUploadMimeType("mp4", "video/mp4");
        FIREFOX_ESR.registerUploadMimeType("m4v", "video/mp4");
        FIREFOX_ESR.registerUploadMimeType("m4a", "audio/mp4");
        FIREFOX_ESR.registerUploadMimeType("png", "image/png");
        FIREFOX_ESR.registerUploadMimeType("mp3", "audio/mpeg");
        FIREFOX_ESR.registerUploadMimeType("ogv", "video/ogg");
        FIREFOX_ESR.registerUploadMimeType("ogm", "video/ogg");
        FIREFOX_ESR.registerUploadMimeType("ogg", "video/ogg");
        FIREFOX_ESR.registerUploadMimeType("oga", "audio/ogg");
        FIREFOX_ESR.registerUploadMimeType("opus", "audio/ogg");
        FIREFOX_ESR.registerUploadMimeType("webm", "video/webm");
        FIREFOX_ESR.registerUploadMimeType("webp", "image/webp");
        FIREFOX_ESR.registerUploadMimeType("wav", "audio/wav");
        FIREFOX_ESR.registerUploadMimeType("flac", "audio/x-flac");
        FIREFOX_ESR.registerUploadMimeType("xhtml", "application/xhtml+xml");
        FIREFOX_ESR.registerUploadMimeType("xht", "application/xhtml+xml");
        FIREFOX_ESR.registerUploadMimeType("txt", "text/plain");
        FIREFOX_ESR.registerUploadMimeType("text", "text/plain");
        FIREFOX.registerUploadMimeType("html", "text/html");
        FIREFOX.registerUploadMimeType("htm", "text/html");
        FIREFOX.registerUploadMimeType("css", "text/css");
        FIREFOX.registerUploadMimeType("xml", "text/xml");
        FIREFOX.registerUploadMimeType("gif", "image/gif");
        FIREFOX.registerUploadMimeType("jpeg", "image/jpeg");
        FIREFOX.registerUploadMimeType("jpg", "image/jpeg");
        FIREFOX.registerUploadMimeType("mp4", "video/mp4");
        FIREFOX.registerUploadMimeType("m4v", "video/mp4");
        FIREFOX.registerUploadMimeType("m4a", "audio/mp4");
        FIREFOX.registerUploadMimeType("png", "image/png");
        FIREFOX.registerUploadMimeType("mp3", "audio/mpeg");
        FIREFOX.registerUploadMimeType("ogv", "video/ogg");
        FIREFOX.registerUploadMimeType("ogm", "video/ogg");
        FIREFOX.registerUploadMimeType("ogg", "video/ogg");
        FIREFOX.registerUploadMimeType("oga", "audio/ogg");
        FIREFOX.registerUploadMimeType("opus", "audio/ogg");
        FIREFOX.registerUploadMimeType("webm", "video/webm");
        FIREFOX.registerUploadMimeType("webp", "image/webp");
        FIREFOX.registerUploadMimeType("wav", "audio/wav");
        FIREFOX.registerUploadMimeType("flac", "audio/x-flac");
        FIREFOX.registerUploadMimeType("xhtml", "application/xhtml+xml");
        FIREFOX.registerUploadMimeType("xht", "application/xhtml+xml");
        FIREFOX.registerUploadMimeType("txt", "text/plain");
        FIREFOX.registerUploadMimeType("text", "text/plain");
        INTERNET_EXPLORER.registerUploadMimeType("html", "text/html");
        INTERNET_EXPLORER.registerUploadMimeType("htm", "text/html");
        INTERNET_EXPLORER.registerUploadMimeType("css", "text/css");
        INTERNET_EXPLORER.registerUploadMimeType("xml", "text/xml");
        INTERNET_EXPLORER.registerUploadMimeType("gif", "image/gif");
        INTERNET_EXPLORER.registerUploadMimeType("jpeg", "image/jpeg");
        INTERNET_EXPLORER.registerUploadMimeType("jpg", "image/jpeg");
        INTERNET_EXPLORER.registerUploadMimeType("png", "image/png");
        INTERNET_EXPLORER.registerUploadMimeType("mp4", "video/mp4");
        INTERNET_EXPLORER.registerUploadMimeType("m4v", "video/mp4");
        INTERNET_EXPLORER.registerUploadMimeType("m4a", "audio/mp4");
        INTERNET_EXPLORER.registerUploadMimeType("mp3", "audio/mpeg");
        INTERNET_EXPLORER.registerUploadMimeType("ogv", "video/ogg");
        INTERNET_EXPLORER.registerUploadMimeType("ogm", "video/ogg");
        INTERNET_EXPLORER.registerUploadMimeType("ogg", "audio/ogg");
        INTERNET_EXPLORER.registerUploadMimeType("oga", "audio/ogg");
        INTERNET_EXPLORER.registerUploadMimeType("opus", "audio/ogg");
        INTERNET_EXPLORER.registerUploadMimeType("webm", "video/webm");
        INTERNET_EXPLORER.registerUploadMimeType("wav", "audio/wav");
        INTERNET_EXPLORER.registerUploadMimeType("flac", "audio/x-flac");
        INTERNET_EXPLORER.registerUploadMimeType("xhtml", "application/xhtml+xml");
        INTERNET_EXPLORER.registerUploadMimeType("xht", "application/xhtml+xml");
        INTERNET_EXPLORER.registerUploadMimeType("txt", "text/plain");
    }

    public static class BrowserVersionBuilder {
        private final BrowserVersion workPiece_;

        public BrowserVersionBuilder(BrowserVersion version) {
            this.workPiece_ = new BrowserVersion(version.getBrowserVersionNumeric(), version.getNickname());
            this.setApplicationVersion(version.getApplicationVersion()).setUserAgent(version.getUserAgent()).setApplicationName(version.getApplicationName()).setApplicationCodeName(version.getApplicationCodeName()).setApplicationMinorVersion(version.getApplicationMinorVersion()).setVendor(version.getVendor()).setBrowserLanguage(version.getBrowserLanguage()).setCpuClass(version.getCpuClass()).setOnLine(version.isOnLine()).setPlatform(version.getPlatform()).setSystemLanguage(version.getSystemLanguage()).setSystemTimezone(version.getSystemTimezone()).setUserLanguage(version.getUserLanguage()).setBuildId(version.getBuildId()).setProductSub(version.getProductSub()).setAcceptEncodingHeader(version.getAcceptEncodingHeader()).setAcceptLanguageHeader(version.getAcceptLanguageHeader()).setHtmlAcceptHeader(version.getHtmlAcceptHeader()).setImgAcceptHeader(version.getImgAcceptHeader()).setCssAcceptHeader(version.getCssAcceptHeader()).setScriptAcceptHeader(version.getScriptAcceptHeader()).setXmlHttpRequestAcceptHeader(version.getXmlHttpRequestAcceptHeader()).setSecClientHintUserAgentHeader(version.getSecClientHintUserAgentHeader()).setSecClientHintUserAgentPlatformHeader(version.getSecClientHintUserAgentPlatformHeader()).setHeaderNamesOrdered(version.getHeaderNamesOrdered()).setFontHeights(version.fontHeights_);
            for (PluginConfiguration pluginConf : version.getPlugins()) {
                this.workPiece_.plugins_.add(pluginConf.clone());
            }
            this.workPiece_.features_.addAll(version.features_);
            this.workPiece_.uploadMimeTypes_.putAll(version.uploadMimeTypes_);
        }

        public BrowserVersion build() {
            return this.workPiece_;
        }

        public BrowserVersionBuilder setApplicationMinorVersion(String applicationMinorVersion) {
            this.workPiece_.applicationMinorVersion_ = applicationMinorVersion;
            return this;
        }

        public BrowserVersionBuilder setApplicationName(String applicationName) {
            this.workPiece_.applicationName_ = applicationName;
            return this;
        }

        public BrowserVersionBuilder setApplicationVersion(String applicationVersion) {
            this.workPiece_.applicationVersion_ = applicationVersion;
            return this;
        }

        public BrowserVersionBuilder setVendor(String vendor) {
            this.workPiece_.vendor_ = vendor;
            return this;
        }

        public BrowserVersionBuilder setApplicationCodeName(String applicationCodeName) {
            this.workPiece_.applicationCodeName_ = applicationCodeName;
            return this;
        }

        public BrowserVersionBuilder setBrowserLanguage(String browserLanguage) {
            this.workPiece_.browserLocale_ = Locale.forLanguageTag(browserLanguage);
            return this;
        }

        public BrowserVersionBuilder setCpuClass(String cpuClass) {
            this.workPiece_.cpuClass_ = cpuClass;
            return this;
        }

        public BrowserVersionBuilder setOnLine(boolean onLine) {
            this.workPiece_.onLine_ = onLine;
            return this;
        }

        public BrowserVersionBuilder setPlatform(String platform) {
            this.workPiece_.platform_ = platform;
            return this;
        }

        public BrowserVersionBuilder setSystemLanguage(String systemLanguage) {
            this.workPiece_.systemLanguage_ = systemLanguage;
            return this;
        }

        public BrowserVersionBuilder setSystemTimezone(TimeZone systemTimezone) {
            this.workPiece_.systemTimezone_ = systemTimezone;
            return this;
        }

        public BrowserVersionBuilder setUserAgent(String userAgent) {
            this.workPiece_.userAgent_ = userAgent;
            return this;
        }

        public BrowserVersionBuilder setUserLanguage(String userLanguage) {
            this.workPiece_.userLanguage_ = userLanguage;
            return this;
        }

        public BrowserVersionBuilder setAcceptEncodingHeader(String acceptEncodingHeader) {
            this.workPiece_.acceptEncodingHeader_ = acceptEncodingHeader;
            return this;
        }

        public BrowserVersionBuilder setAcceptLanguageHeader(String acceptLanguageHeader) {
            this.workPiece_.acceptLanguageHeader_ = acceptLanguageHeader;
            return this;
        }

        public BrowserVersionBuilder setHtmlAcceptHeader(String htmlAcceptHeader) {
            this.workPiece_.htmlAcceptHeader_ = htmlAcceptHeader;
            return this;
        }

        public BrowserVersionBuilder setImgAcceptHeader(String imgAcceptHeader) {
            this.workPiece_.imgAcceptHeader_ = imgAcceptHeader;
            return this;
        }

        public BrowserVersionBuilder setCssAcceptHeader(String cssAcceptHeader) {
            this.workPiece_.cssAcceptHeader_ = cssAcceptHeader;
            return this;
        }

        public BrowserVersionBuilder setScriptAcceptHeader(String scriptAcceptHeader) {
            this.workPiece_.scriptAcceptHeader_ = scriptAcceptHeader;
            return this;
        }

        public BrowserVersionBuilder setXmlHttpRequestAcceptHeader(String xmlHttpRequestAcceptHeader) {
            this.workPiece_.xmlHttpRequestAcceptHeader_ = xmlHttpRequestAcceptHeader;
            return this;
        }

        public BrowserVersionBuilder setSecClientHintUserAgentHeader(String secClientHintUserAgentHeader) {
            this.workPiece_.secClientHintUserAgentHeader_ = secClientHintUserAgentHeader;
            return this;
        }

        public BrowserVersionBuilder setSecClientHintUserAgentPlatformHeader(String secClientHintUserAgentPlatformHeader) {
            this.workPiece_.secClientHintUserAgentPlatformHeader_ = secClientHintUserAgentPlatformHeader;
            return this;
        }

        BrowserVersionBuilder setProductSub(String productSub) {
            this.workPiece_.productSub_ = productSub;
            return this;
        }

        BrowserVersionBuilder setHeaderNamesOrdered(String[] headerNamesOrdered) {
            BrowserVersion.access$2702(this.workPiece_, headerNamesOrdered);
            return this;
        }

        BrowserVersionBuilder setFontHeights(int[] fontHeights) {
            BrowserVersion.access$002(this.workPiece_, fontHeights);
            return this;
        }

        BrowserVersionBuilder setBuildId(String buildId) {
            this.workPiece_.buildId_ = buildId;
            return this;
        }
    }
}

