/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.corejs.javascript.ast;

import net.sourceforge.htmlunit.corejs.javascript.ast.AstNode;
import net.sourceforge.htmlunit.corejs.javascript.ast.NodeVisitor;

public class StringLiteral
extends AstNode {
    private String value;
    private char quoteChar;

    public StringLiteral() {
        this.type = 41;
    }

    public StringLiteral(int pos) {
        super(pos);
        this.type = 41;
    }

    public StringLiteral(int pos, int len) {
        super(pos, len);
        this.type = 41;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(boolean includeQuotes) {
        if (!includeQuotes) {
            return this.value;
        }
        return this.quoteChar + this.value + this.quoteChar;
    }

    public void setValue(String value) {
        this.assertNotNull(value);
        this.value = value;
    }

    public char getQuoteCharacter() {
        return this.quoteChar;
    }

    public void setQuoteCharacter(char c) {
        this.quoteChar = c;
    }

    public String toSource(int depth) {
        String q = String.valueOf(this.getQuoteCharacter());
        String rep = "\\\\" + q;
        String s = this.value.replaceAll(q, rep);
        s = s.replaceAll("\n", "\\\\n");
        s = s.replaceAll("\r", "\\\\r");
        s = s.replaceAll("\t", "\\\\t");
        s = s.replaceAll("\f", "\\\\f");
        return this.makeIndent(depth) + q + s + q;
    }

    public void visit(NodeVisitor v) {
        v.visit(this);
    }
}

