/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.ExpressionOwner;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.XPathVisitor;
import net.sourceforge.htmlunit.xpath.compiler.Compiler;
import net.sourceforge.htmlunit.xpath.compiler.FunctionTable;
import net.sourceforge.htmlunit.xpath.compiler.XPathParser;
import net.sourceforge.htmlunit.xpath.objects.XObject;
import net.sourceforge.htmlunit.xpath.res.XPATHMessages;
import net.sourceforge.htmlunit.xpath.xml.utils.DefaultErrorHandler;
import net.sourceforge.htmlunit.xpath.xml.utils.PrefixResolver;
import net.sourceforge.htmlunit.xpath.xml.utils.WrappedRuntimeException;
import org.w3c.dom.Node;

public class XPath
implements ExpressionOwner {
    private Expression m_mainExp;
    private transient FunctionTable m_funcTable = null;
    String m_patternString;
    public static final int SELECT = 0;
    public static final int MATCH = 1;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;

    private void initFunctionTable() {
        this.m_funcTable = new FunctionTable();
    }

    @Override
    public Expression getExpression() {
        return this.m_mainExp;
    }

    @Override
    public void setExpression(Expression exp) {
        if (null != this.m_mainExp) {
            exp.exprSetParent(this.m_mainExp.exprGetParent());
        }
        this.m_mainExp = exp;
    }

    public SourceLocator getLocator() {
        return this.m_mainExp;
    }

    public XPath(String exprString, PrefixResolver prefixResolver, int type, ErrorListener errorListener) throws TransformerException {
        this.initFunctionTable();
        if (null == errorListener) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = exprString;
        XPathParser parser = new XPathParser(errorListener);
        Compiler compiler = new Compiler(errorListener, this.m_funcTable);
        if (0 == type) {
            parser.initXPath(compiler, exprString, prefixResolver);
        } else if (1 == type) {
            parser.initMatchPattern(compiler, exprString, prefixResolver);
        } else {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_CANNOT_DEAL_XPATH_TYPE", new Object[]{Integer.toString(type)}));
        }
        Expression expr = compiler.compile(0);
        this.setExpression(expr);
    }

    public XPath(String exprString, PrefixResolver prefixResolver, int type, ErrorListener errorListener, FunctionTable aTable) throws TransformerException {
        this.m_funcTable = aTable;
        if (null == errorListener) {
            errorListener = new DefaultErrorHandler();
        }
        this.m_patternString = exprString;
        XPathParser parser = new XPathParser(errorListener);
        Compiler compiler = new Compiler(errorListener, this.m_funcTable);
        if (0 == type) {
            parser.initXPath(compiler, exprString, prefixResolver);
        } else if (1 == type) {
            parser.initMatchPattern(compiler, exprString, prefixResolver);
        } else {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_CANNOT_DEAL_XPATH_TYPE", new Object[]{Integer.toString(type)}));
        }
        Expression expr = compiler.compile(0);
        this.setExpression(expr);
    }

    public XPath(String exprString, PrefixResolver prefixResolver, int type) throws TransformerException {
        this(exprString, prefixResolver, type, null);
    }

    public XPath(Expression expr) {
        this.setExpression(expr);
        this.initFunctionTable();
    }

    public XObject execute(XPathContext xctxt, Node contextNode, PrefixResolver namespaceContext) throws TransformerException {
        return this.execute(xctxt, xctxt.getDTMHandleFromNode(contextNode), namespaceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XObject execute(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        XObject xobj;
        block11: {
            xctxt.pushNamespaceContext(namespaceContext);
            xctxt.pushCurrentNodeAndExpression(contextNode);
            xobj = null;
            try {
                xobj = this.m_mainExp.execute(xctxt);
            }
            catch (TransformerException te) {
                te.setLocator(this.getLocator());
                ErrorListener el = xctxt.getErrorListener();
                if (null != el) {
                    el.error(te);
                    break block11;
                }
                throw te;
            }
            catch (Exception e) {
                while (e instanceof WrappedRuntimeException) {
                    e = ((WrappedRuntimeException)e).getException();
                }
                String msg = e.getMessage();
                if (msg == null || msg.length() == 0) {
                    msg = XPATHMessages.createXPATHMessage("ER_XPATH_ERROR", null);
                }
                TransformerException te = new TransformerException(msg, this.getLocator(), e);
                ErrorListener el = xctxt.getErrorListener();
                if (null != el) {
                    el.fatalError(te);
                    break block11;
                }
                throw te;
            }
            finally {
                xctxt.popNamespaceContext();
                xctxt.popCurrentNodeAndExpression();
            }
        }
        return xobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bool(XPathContext xctxt, int contextNode, PrefixResolver namespaceContext) throws TransformerException {
        block11: {
            xctxt.pushNamespaceContext(namespaceContext);
            xctxt.pushCurrentNodeAndExpression(contextNode);
            try {
                boolean bl = this.m_mainExp.bool(xctxt);
                return bl;
            }
            catch (TransformerException te) {
                te.setLocator(this.getLocator());
                ErrorListener el = xctxt.getErrorListener();
                if (null != el) {
                    el.error(te);
                    break block11;
                }
                throw te;
            }
            catch (Exception e) {
                while (e instanceof WrappedRuntimeException) {
                    e = ((WrappedRuntimeException)e).getException();
                }
                String msg = e.getMessage();
                if (msg == null || msg.length() == 0) {
                    msg = XPATHMessages.createXPATHMessage("ER_XPATH_ERROR", null);
                }
                TransformerException te = new TransformerException(msg, this.getLocator(), e);
                ErrorListener el = xctxt.getErrorListener();
                if (null != el) {
                    el.fatalError(te);
                    break block11;
                }
                throw te;
            }
            finally {
                xctxt.popNamespaceContext();
                xctxt.popCurrentNodeAndExpression();
            }
        }
        return false;
    }

    public void warn(XPathContext xctxt, String msg, Object[] args) throws TransformerException {
        String fmsg = XPATHMessages.createXPATHWarning(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (null != ehandler) {
            ehandler.warning(new TransformerException(fmsg));
        }
    }

    public void assertion(boolean b, String msg) {
        if (!b) {
            String fMsg = XPATHMessages.createXPATHMessage("ER_INCORRECT_PROGRAMMER_ASSERTION", new Object[]{msg});
            throw new RuntimeException(fMsg);
        }
    }

    public void error(XPathContext xctxt, String msg, Object[] args) throws TransformerException {
        String fmsg = XPATHMessages.createXPATHMessage(msg, args);
        ErrorListener ehandler = xctxt.getErrorListener();
        if (null != ehandler) {
            ehandler.fatalError(new TransformerException(fmsg));
        }
    }

    public void callVisitors(XPathVisitor visitor) {
        this.m_mainExp.callVisitors(this, visitor);
    }
}

