/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.axes;

import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.axes.LocPathIterator;
import net.sourceforge.htmlunit.xpath.objects.XObject;
import net.sourceforge.htmlunit.xpath.patterns.NodeTest;
import net.sourceforge.htmlunit.xpath.patterns.StepPattern;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTMAxisTraverser;

public class MatchPatternIterator
extends LocPathIterator {
    protected StepPattern m_pattern;
    protected int m_superAxis = -1;
    protected DTMAxisTraverser m_traverser;
    private static final boolean DEBUG = false;

    @Override
    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        this.m_traverser = this.m_cdtm.getAxisTraverser(this.m_superAxis);
    }

    @Override
    public void detach() {
        if (this.m_allowDetach) {
            this.m_traverser = null;
            super.detach();
        }
    }

    protected int getNextNode() {
        this.m_lastFetched = -1 == this.m_lastFetched ? this.m_traverser.first(this.m_context) : this.m_traverser.next(this.m_context, this.m_lastFetched);
        return this.m_lastFetched;
    }

    @Override
    public int nextNode() {
        int next;
        if (this.m_foundLast) {
            return -1;
        }
        while (-1 != (next = this.getNextNode()) && 1 != this.acceptNode(next, this.m_execContext) && next != -1) {
        }
        if (-1 != next) {
            this.incrementCurrentPos();
            return next;
        }
        this.m_foundLast = true;
        return -1;
    }

    public short acceptNode(int n, XPathContext xctxt) {
        try {
            xctxt.pushCurrentNode(n);
            xctxt.pushIteratorRoot(this.m_context);
            XObject score = this.m_pattern.execute(xctxt);
            short s = score == NodeTest.SCORE_NONE ? (short)3 : 1;
            return s;
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
        finally {
            xctxt.popCurrentNode();
            xctxt.popIteratorRoot();
        }
    }
}

