package net.sourceforge.lept4j;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
/**
 * Expandable byte buffer for memory read/write operations<br>
 * <i>native declaration : bbuffer.h:18</i><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class L_ByteBuffer extends Structure {
	/**
	 * size of allocated byte array<br>
	 * C type : l_int32
	 */
	public int nalloc;
	/**
	 * number of bytes read into to the array<br>
	 * C type : l_int32
	 */
	public int n;
	/**
	 * number of bytes written from the array<br>
	 * C type : l_int32
	 */
	public int nwritten;
	/**
	 * byte array<br>
	 * C type : l_uint8*
	 */
	public Pointer array;
	public L_ByteBuffer() {
		super();
	}
	/**
	 * Gets this Structure's field names in their proper order.
	 * @return list of ordered field names
	 */
	@Override
	protected List<String> getFieldOrder() {
		return Arrays.asList("nalloc", "n", "nwritten", "array");
	}
	/**
	 * @param nalloc size of allocated byte array<br>
	 * C type : l_int32<br>
	 * @param n number of bytes read into to the array<br>
	 * C type : l_int32<br>
	 * @param nwritten number of bytes written from the array<br>
	 * C type : l_int32<br>
	 * @param array byte array<br>
	 * C type : l_uint8*
	 */
	public L_ByteBuffer(int nalloc, int n, int nwritten, Pointer array) {
		super();
		this.nalloc = nalloc;
		this.n = n;
		this.nwritten = nwritten;
		this.array = array;
	}
	public L_ByteBuffer(Pointer peer) {
		super(peer);
                read();
	}
	public static class ByReference extends L_ByteBuffer implements Structure.ByReference {
		
	};
	public static class ByValue extends L_ByteBuffer implements Structure.ByValue {
		
	};
}
